/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import com.huawei.ism.ui.swing.plaf.IsmButtonStyle;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsmTabbedPaneUI
extends BasicTabbedPaneUI {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsmTabbedPaneUI.class);
    private static Set<KeyStroke> managingFocusForwardTraversalKeys;
    private static Set<KeyStroke> managingFocusBackwardTraversalKeys;

    public static ComponentUI createUI(JComponent c) {
        return new IsmTabbedPaneUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void installDefaults() {
        super.installDefaults();
        Class<IsmTabbedPaneUI> clazz = IsmTabbedPaneUI.class;
        synchronized (IsmTabbedPaneUI.class) {
            if (managingFocusForwardTraversalKeys == null) {
                managingFocusForwardTraversalKeys = new HashSet<KeyStroke>(0);
                managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 0));
            }
            if (managingFocusBackwardTraversalKeys == null) {
                managingFocusBackwardTraversalKeys = new HashSet<KeyStroke>(0);
                managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 1));
            }
            this.tabPane.setFocusTraversalKeys(0, managingFocusForwardTraversalKeys);
            this.tabPane.setFocusTraversalKeys(1, managingFocusBackwardTraversalKeys);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected void uninstallDefaults() {
        this.tabPane.setFocusTraversalKeys(0, null);
        this.tabPane.setFocusTraversalKeys(1, null);
        super.uninstallDefaults();
    }

    @Override
    protected void setRolloverTab(int index) {
        int oldRolloverTab = this.getRolloverTab();
        super.setRolloverTab(index);
        Rectangle r1 = null;
        Rectangle r2 = null;
        if (oldRolloverTab >= 0 && oldRolloverTab < this.tabPane.getTabCount()) {
            r1 = this.getTabBounds(this.tabPane, oldRolloverTab);
        }
        if (index >= 0) {
            r2 = this.getTabBounds(this.tabPane, index);
        }
        if (r1 != null) {
            if (r2 != null) {
                this.tabPane.repaint(r1.union(r2));
            } else {
                this.tabPane.repaint(r1);
            }
        } else if (r2 != null) {
            this.tabPane.repaint(r2);
        }
    }

    @Override
    protected void paintContentBorder(Graphics graphics, int tabPlacement, int selectedIndex) {
        Insets insets = this.tabPane.getInsets();
        Insets tabAreaInsets = UIManager.getInsets("TabbedPane.tabAreaInsets");
        int left = insets.left;
        int top = insets.top;
        int ww = this.tabPane.getWidth() - insets.right - insets.left;
        int hh = this.tabPane.getHeight() - insets.top - insets.bottom;
        if (tabPlacement == 2 || tabPlacement == 4) {
            int tabWidth = this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
            if (tabPlacement == 2) {
                left += tabWidth - tabAreaInsets.bottom;
            }
            ww -= tabWidth - tabAreaInsets.bottom;
        } else {
            int tabHeight = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
            if (tabPlacement == 1) {
                top += tabHeight - tabAreaInsets.bottom;
            }
            hh -= tabHeight - tabAreaInsets.bottom;
        }
        graphics.setColor(UIManager.getColor("TabbedPane.tabAreaBackground"));
        graphics.fillRect(left, top, ww, hh);
        this.paintContentBorderTopEdge(graphics, tabPlacement, selectedIndex, left, top, ww, hh);
        this.paintContentBorderLeftEdge(graphics, tabPlacement, selectedIndex, left, top, ww, hh);
        this.paintContentBorderBottomEdge(graphics, tabPlacement, selectedIndex, left, top, ww, hh);
        this.paintContentBorderRightEdge(graphics, tabPlacement, selectedIndex, left, top, ww, hh);
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics graphics, int tabPlacement, int selectedIndex, int xx, int yy, int ww, int hh) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        graphics.setColor(UIManager.getColor("TabbedPane.borderColor"));
        if (null == selRect) {
            LOGGER.error("The selRect parameter is null.");
            return;
        }
        if (tabPlacement != 1 || selectedIndex < 0 || (int)selRect.getY() + selRect.height + 1 < yy || (int)selRect.getX() < xx || (int)selRect.getX() > xx + ww) {
            graphics.drawLine(xx, yy, xx + ww - 2, yy);
        } else {
            int delta = 0;
            graphics.drawLine(xx, yy, (int)selRect.getX() + delta, yy);
            if ((int)selRect.getX() + selRect.width < xx + ww - 2) {
                graphics.drawLine((int)selRect.getX() + selRect.width - delta, yy, xx + ww - 2, yy);
            } else {
                graphics.setColor(this.shadow);
                graphics.drawLine(xx + ww - 2, yy, xx + ww - 2, yy);
            }
        }
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics graphics, int tabPlacement, int selectedIndex, int xx, int yy, int ww, int hh) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        graphics.setColor(UIManager.getColor("TabbedPane.borderColor"));
        if (null == selRect) {
            LOGGER.error("The selRect parameter is null.");
            return;
        }
        if (tabPlacement != 2 || selectedIndex < 0 || (int)selRect.getX() + selRect.width + 1 < xx || (int)selRect.getY() < yy || (int)selRect.getY() > yy + hh) {
            graphics.drawLine(xx, yy, xx, yy + hh - 2);
        } else {
            graphics.drawLine(xx, yy, xx, (int)selRect.getY());
            if ((int)selRect.getY() + selRect.height < yy + hh - 2) {
                graphics.drawLine(xx, (int)selRect.getY() + selRect.height, xx, yy + hh - 2);
            }
        }
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics graphics, int tabPlacement, int selectedIndex, int xx, int yy, int ww, int hh) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        graphics.setColor(UIManager.getColor("TabbedPane.borderColor"));
        if (null == selRect) {
            LOGGER.error("The selRect parameter is null.");
            return;
        }
        if (tabPlacement != 3 || selectedIndex < 0 || (int)selRect.getY() - 1 > hh || (int)selRect.getX() < xx || (int)selRect.getX() > xx + ww) {
            graphics.drawLine(xx, yy + hh - 1, xx + ww - 1, yy + hh - 1);
        } else {
            graphics.drawLine(xx, yy + hh - 1, (int)selRect.getX(), yy + hh - 1);
            if ((int)selRect.getX() + selRect.width < xx + ww - 2) {
                graphics.setColor(UIManager.getColor("TabbedPane.borderColor"));
                graphics.drawLine((int)selRect.getX() + selRect.width, yy + hh - 1, xx + ww - 1, yy + hh - 1);
            }
        }
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics graphics, int tabPlacement, int selectedIndex, int xx, int yy, int ww, int hh) {
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        graphics.setColor(UIManager.getColor("TabbedPane.borderColor"));
        if (null == selRect) {
            LOGGER.error("The selRect parameter is null.");
            return;
        }
        if (tabPlacement != 4 || selectedIndex < 0 || (int)selRect.getX() - 1 > ww || (int)selRect.getY() < yy || (int)selRect.getY() > yy + hh) {
            graphics.drawLine(xx + ww - 1, yy, xx + ww - 1, yy + hh - 1);
        } else {
            graphics.drawLine(xx + ww - 1, yy, xx + ww - 1, (int)selRect.getY());
            if ((int)selRect.getY() + selRect.height < yy + hh - 2) {
                graphics.drawLine(xx + ww - 1, (int)selRect.getY() + selRect.height, xx + ww - 1, yy + hh - 2);
            }
        }
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int tabPlacement, int tabIndex, int xx, int yy, int ww, int hh, boolean isSelected) {
        int gapX = 0;
        int gapY = 0;
        if (UIManager.getBoolean("TabbedPane.roundCorner") && tabPlacement == 1) {
            gapX = 2;
            gapY = 2;
        }
        IsmButtonStyle.ButtonState state = IsmButtonStyle.ButtonState.NORMAL;
        if (isSelected) {
            state = IsmButtonStyle.ButtonState.SELECTED;
        } else if (tabIndex == this.getRolloverTab()) {
            state = IsmButtonStyle.ButtonState.ROLLOVER;
        }
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.translate(xx + gapX, yy + gapY);
        switch (tabPlacement) {
            case 4: {
                g2d.translate(ww, 0);
                g2d.rotate(Math.toRadians(90.0));
                this.paintTabBG(g2d, 0, 0, hh, ww, state, false);
                break;
            }
            case 2: {
                g2d.scale(-1.0, 1.0);
                g2d.rotate(Math.toRadians(90.0));
                this.paintTabBG(g2d, 0, 0, hh, ww, state, false);
                break;
            }
            case 3: {
                g2d.translate(0, hh);
                g2d.scale(-1.0, 1.0);
                g2d.rotate(Math.toRadians(180.0));
                this.paintTabBG(g2d, 0, 0, ww, hh, state, true);
                break;
            }
            default: {
                this.paintTabBG(g2d, 0, 0, ww - 2 * gapX, hh - 2 * gapY, state, true);
            }
        }
        g2d.dispose();
    }

    @Override
    protected void paintTabBorder(Graphics graphics, int tabPlacement, int tabIndex, int xx, int yy, int ww, int hh, boolean isSelected) {
        Color borderColor = UIManager.getColor("TabbedPane.borderColor");
        Color innerBorderColor = UIManager.getColor("TabbedPane.innerBorderColor");
        if (UIManager.getBoolean("TabbedPane.roundCorner") && tabPlacement == 1) {
            Icon cornerULIcon = UIManager.getIcon("TabbedPane.cornerUL");
            Icon cornerURIcon = UIManager.getIcon("TabbedPane.cornerUR");
            int iconW = cornerULIcon.getIconWidth();
            int iconH = cornerULIcon.getIconHeight();
            this.drawLine(graphics, borderColor, xx, yy + hh - 1, xx, yy + iconH);
            this.drawLine(graphics, innerBorderColor, xx + 1, yy + hh - 1, xx + 1, yy + iconH);
            this.drawLine(graphics, borderColor, xx + iconW, yy, xx + ww - iconW, yy);
            this.drawLine(graphics, innerBorderColor, xx + iconW, yy + 1, xx + ww - iconW, yy + 1);
            this.drawLine(graphics, borderColor, xx + ww, yy + iconH, xx + ww, yy + hh - 1);
            this.drawLine(graphics, innerBorderColor, xx + ww - 1, yy + iconH, xx + ww - 1, yy + hh - 1);
            cornerULIcon.paintIcon(this.tabPane, graphics, xx, yy);
            cornerURIcon.paintIcon(this.tabPane, graphics, xx + ww - iconW + 1, yy);
        } else {
            if (tabPlacement != 4) {
                this.drawLine(graphics, borderColor, xx, yy + hh - 1, xx, yy);
            }
            if (tabPlacement != 3) {
                this.drawLine(graphics, borderColor, xx, yy, xx + ww, yy);
            }
            if (tabPlacement != 2) {
                this.drawLine(graphics, borderColor, xx + ww, yy, xx + ww, yy + hh - 1);
            }
            if (tabPlacement != 1) {
                this.drawLine(graphics, borderColor, xx, yy + hh, xx + ww, yy + hh);
            }
        }
    }

    private void paintTabBG(Graphics2D graphics2D, int xx, int yy, int ww, int hh, IsmButtonStyle.ButtonState state, boolean vertical) {
        IsmButtonStyle style = (IsmButtonStyle)UIManager.get("TabbedPane.style");
        if (IsmButtonStyle.ButtonState.SELECTED != state) {
            IsmPlafUtils.drawDualGradient((Component)this.tabPane, (Graphics)graphics2D, style.getGradientUL(state), style.getGradientDR(state), new Rectangle(xx, yy, ww + 1, hh + 3), vertical);
        } else {
            Object selectedBackground = UIManager.get("TabbedPane.selectedBackground");
            if (selectedBackground instanceof Color) {
                graphics2D.setColor((Color)selectedBackground);
                graphics2D.fillRect(xx, yy, ww, hh);
            } else {
                IsmPlafUtils.drawGradient((Component)this.tabPane, (Graphics)graphics2D, (List)selectedBackground, new Rectangle(xx, yy, ww + 1, hh + 1), true);
            }
        }
    }

    private void drawLine(Graphics graphics, Color color, int x1, int y1, int x2, int y2) {
        Color oldColor = graphics.getColor();
        graphics.setColor(color);
        graphics.drawLine(x1, y1, x2, y2);
        graphics.setColor(oldColor);
    }
}

