/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.table;

import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.IsmTableCellRenderer;
import com.huawei.ism.ui.swing.table.VirtualIconCellValueBean;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.Unit;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.Collator;
import java.util.Arrays;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class IsmVirtualTableCell
extends IsmTableCell {
    private static final long serialVersionUID = 1L;

    public abstract void setValue(Object var1);

    public abstract Object getValue();

    public static class VirtualCapacityTextCell<T extends Number>
    extends IsmVirtualTableCell {
        private static final long serialVersionUID = -7433341721604903634L;
        private static TableCellRenderer render = new NumberRenderer();
        private String strVal;
        private Long number;

        public VirtualCapacityTextCell() {
        }

        public VirtualCapacityTextCell(T num, Unit.DataUnit srcUnit) {
            this.number = ((Number)num).longValue();
            this.strVal = Unit.adaptConvert2(num, srcUnit);
        }

        public VirtualCapacityTextCell(T num, Unit.DataUnit srcUnit, boolean needShowOldValue) {
            this.number = ((Number)num).longValue();
            this.strVal = needShowOldValue ? Unit.adaptConvert(num, srcUnit) : Unit.adaptConvert2(num, srcUnit);
        }

        public VirtualCapacityTextCell(T num, Unit.Scaleble srcUnit, Unit.Scaleble targetUnit) {
            this.number = ((Number)num).longValue();
            this.strVal = ((Number)Unit.convert(num, srcUnit, targetUnit)).doubleValue() + " " + targetUnit.toString();
        }

        @Override
        public TableCellRenderer getRender() {
            return render;
        }

        @Override
        public String toString() {
            return this.strVal;
        }

        @Override
        public Object getValue() {
            return this.number;
        }

        @Override
        public void setValue(Object value) {
            Number num = (Number)value;
            this.number = num.longValue();
            this.strVal = Unit.adaptConvert2(num, Unit.DataUnit.BYTE);
        }

        @Override
        public int compareTo(IsmTableCell ismTableCell) {
            if (!(ismTableCell instanceof VirtualCapacityTextCell)) {
                return -1;
            }
            if (this.number != null) {
                Comparable com = CommonUtil.convertObject(this.number, Comparable.class);
                Long comToBe = CommonUtil.convertObject((Object)ismTableCell, VirtualCapacityTextCell.class).number;
                return com.compareTo(comToBe);
            }
            return -1;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof VirtualCapacityTextCell)) {
                return false;
            }
            VirtualCapacityTextCell that = (VirtualCapacityTextCell)obj;
            return this.strVal.equals(that.strVal);
        }

        @Override
        public int hashCode() {
            return this.number.hashCode();
        }

        private static class NumberRenderer
        extends IsmTableCellRenderer {
            private static final long serialVersionUID = 1L;

            private NumberRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component ret;
                this.setHorizontalAlignment(4);
                VirtualCapacityTextCell cell = (VirtualCapacityTextCell)value;
                String txt = "";
                if (null != cell) {
                    txt = cell.strVal;
                    this.setText(txt);
                }
                if ((ret = super.getTableCellRendererComponent(table, txt, isSelected, hasFocus, row, column)) instanceof JLabel) {
                    JLabel label = (JLabel)ret;
                    label.setHorizontalAlignment(4);
                }
                return ret;
            }
        }
    }

    public static class VirtualIconCell
    extends IsmVirtualTableCell {
        private static final long serialVersionUID = -4560831869589051409L;
        private static IconRenderer render = new IconRenderer();
        private VirtualIconCellValueBean bean;
        private int textAlignValue = 11;
        private int cellAlignValue = 2;
        private transient ActionListener actionListener;

        public VirtualIconCell() {
        }

        public VirtualIconCell(ActionListener action, int textAlign) {
            this.actionListener = action;
            this.textAlignValue = textAlign;
        }

        @Override
        public Object getValue() {
            return this.bean;
        }

        @Override
        public void setValue(Object value) {
            this.bean = (VirtualIconCellValueBean)value;
        }

        public void setCellAlign(int align) {
            this.cellAlignValue = align;
        }

        @Override
        public ActionListener getAction() {
            if (null == this.actionListener) {
                return super.getAction();
            }
            return this.actionListener;
        }

        @Override
        public TableCellRenderer getRender() {
            return render;
        }

        @Override
        public String toString() {
            return this.bean.getDesc();
        }

        @Override
        public int compareTo(IsmTableCell ismTableCell) {
            if (!(ismTableCell instanceof VirtualIconCell)) {
                return -1;
            }
            return this.bean.compareTo(((VirtualIconCell)ismTableCell).bean);
        }

        @Override
        public boolean equals(Object obj) {
            if (null == obj) {
                return false;
            }
            if (!(obj instanceof VirtualIconCell)) {
                return false;
            }
            VirtualIconCell cell = (VirtualIconCell)obj;
            return this.bean.equals(cell.bean);
        }

        @Override
        public int hashCode() {
            return this.bean.hashCode();
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
        }

        private static class IconRenderer
        extends IsmTableCellRenderer {
            private static final long serialVersionUID = 2494089635770891199L;

            public IconRenderer() {
                this.setOpaque(true);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel comp = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!(table instanceof IsmTable)) {
                    return comp;
                }
                this.setValue(value, comp);
                return comp;
            }

            private void setValue(Object value, JLabel comp) {
                if (value instanceof VirtualIconCell) {
                    VirtualIconCell cell = (VirtualIconCell)value;
                    Icon icon = cell.bean.getIcon();
                    comp.setIcon(icon);
                    if (null != icon && icon instanceof ImageIcon) {
                        ImageIcon imageIcon = (ImageIcon)icon;
                        imageIcon.setImageObserver(comp);
                    }
                    comp.setText(cell.bean.getDesc());
                    comp.setHorizontalTextPosition(cell.textAlignValue);
                    comp.setHorizontalAlignment(cell.cellAlignValue);
                }
            }
        }
    }

    public static class VirtualComboBoxCell
    extends IsmVirtualTableCell {
        private static final long serialVersionUID = -5299829748480670107L;
        private static TableCellRenderer render = new ComBoxRender();
        private DefaultCellEditor editor = new ComboBoxEditor();
        private Object[] objectValues;
        private Object selectedItem;
        private Object rendererItem;

        public VirtualComboBoxCell(Object[] values) {
            this.objectValues = (Object[])values.clone();
            this.addItems(values);
        }

        private void addItems(Object[] values) {
            JComboBox comboBox = (JComboBox)this.getEditor().getComponent();
            for (Object value : values) {
                comboBox.addItem(value);
            }
        }

        @Override
        public TableCellRenderer getRender() {
            return render;
        }

        @Override
        public DefaultCellEditor getEditor() {
            return this.editor;
        }

        public Object getSelectedItem() {
            return this.selectedItem;
        }

        public void setSelectedItem(Object item) {
            JComboBox comboBox = (JComboBox)this.getEditor().getComponent();
            this.selectedItem = item;
            comboBox.setSelectedItem(item);
        }

        public Object getRendererItem() {
            return this.rendererItem;
        }

        public void setRendererItem(Object item) {
            this.rendererItem = item;
        }

        @Override
        public String toString() {
            return this.selectedItem.toString();
        }

        @Override
        public int compareTo(IsmTableCell ismTableCell) {
            if (!(ismTableCell instanceof VirtualComboBoxCell)) {
                return -1;
            }
            VirtualComboBoxCell that = (VirtualComboBoxCell)ismTableCell;
            if (this.selectedItem instanceof Comparable && that.selectedItem instanceof Comparable) {
                Comparable c1 = (Comparable)this.selectedItem;
                Comparable c2 = (Comparable)that.selectedItem;
                return c1.compareTo(c2);
            }
            return Collator.getInstance().compare(this.selectedItem.toString(), that.selectedItem.toString());
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof VirtualComboBoxCell)) {
                return false;
            }
            VirtualComboBoxCell that = (VirtualComboBoxCell)obj;
            return this.selectedItem.equals(that.selectedItem);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.objectValues);
        }

        @Override
        public void setValue(Object value) {
            this.setSelectedItem(value);
        }

        @Override
        public Object getValue() {
            JComboBox comboBox = (JComboBox)this.getEditor().getComponent();
            return comboBox.getSelectedItem();
        }

        static class ComboBoxEditor
        extends DefaultCellEditor {
            private static final long serialVersionUID = -5472194580313352567L;
            private VirtualComboBoxCell cell;

            public ComboBoxEditor() {
                super(new JComboBox());
            }

            public ComboBoxEditor(JComboBox comboBox) {
                super(comboBox);
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                if (value instanceof VirtualComboBoxCell) {
                    this.cell = (VirtualComboBoxCell)value;
                    Object obj = this.cell.selectedItem;
                    this.addItems(this.cell.objectValues);
                    ((JComboBox)this.getComponent()).setSelectedItem(obj);
                }
                return this.editorComponent;
            }

            private void addItems(Object[] items) {
                JComboBox comboBox = (JComboBox)this.getComponent();
                if (comboBox.getItemCount() > 0) {
                    return;
                }
                for (Object item : items) {
                    comboBox.addItem(item);
                }
            }

            @Override
            public boolean stopCellEditing() {
                boolean isStop = super.stopCellEditing();
                if (null != this.cell && isStop) {
                    JComboBox comboBox = (JComboBox)this.getComponent();
                    this.cell.selectedItem = comboBox.getSelectedItem();
                }
                return isStop;
            }
        }

        static class ComBoxRender
        extends IsmTableCellRenderer {
            private static final long serialVersionUID = 725238083212111020L;
            private JComboBox comboxTemp = new JComboBox();

            ComBoxRender() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (!(value instanceof VirtualComboBoxCell)) {
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
                VirtualComboBoxCell cell = (VirtualComboBoxCell)value;
                if (!isSelected) {
                    if (cell.getRendererItem() == null) {
                        return super.getTableCellRendererComponent(table, cell.getSelectedItem(), isSelected, hasFocus, row, column);
                    }
                    return super.getTableCellRendererComponent(table, cell.getSelectedItem() + cell.getRendererItem().toString(), isSelected, hasFocus, row, column);
                }
                if (cell.getRendererItem() == null) {
                    this.comboxTemp.removeAllItems();
                    this.comboxTemp.addItem(cell.getSelectedItem());
                    this.comboxTemp.setSelectedItem(cell.getSelectedItem());
                } else {
                    this.comboxTemp.removeAllItems();
                    this.comboxTemp.addItem(cell.getSelectedItem() + cell.getRendererItem().toString());
                    this.comboxTemp.setSelectedItem(cell.getSelectedItem() + cell.getRendererItem().toString());
                }
                return this.comboxTemp;
            }
        }
    }

    public static class VirtualTextCell
    extends IsmVirtualTableCell {
        private static final long serialVersionUID = -5299829748480670107L;
        private static TableCellEditor editor = new TextEditor();
        private static TableCellRenderer customRender = new TextFieldRender();
        private int alignment;
        private boolean isEditable;
        private String value;
        private transient Comparable comparable;
        private TableCellEditor customEditor = null;
        private JTextField customTextFieldText;

        public VirtualTextCell(JTextField customTextField) {
            this.isEditable = false;
            this.customTextFieldText = customTextField;
            this.customEditor = new TextEditor(customTextField);
            this.alignment = customTextField.getHorizontalAlignment();
        }

        public VirtualTextCell(String value) {
            this.value = value;
        }

        public Comparable getComparable() {
            return this.comparable;
        }

        public void setComparable(Comparable comparable) {
            this.comparable = comparable;
        }

        public VirtualTextCell(int alignment) {
            this.isEditable = false;
            this.alignment = alignment;
        }

        @Override
        public TableCellRenderer getRender() {
            return customRender;
        }

        @Override
        public TableCellEditor getEditor() {
            if (null != this.customTextFieldText) {
                return this.customEditor;
            }
            if (this.isEditable) {
                return editor;
            }
            return null;
        }

        public void setText(String text) {
            DefaultCellEditor editorTemp;
            this.value = text;
            if (this.getEditor() != null && (editorTemp = (DefaultCellEditor)this.getEditor()) != null) {
                JTextField textField = (JTextField)editorTemp.getComponent();
                textField.setText(text);
            }
        }

        @Override
        public String toString() {
            if (CommonUtil.isNullStr(this.value)) {
                return "--";
            }
            return this.value;
        }

        @Override
        public int compareTo(IsmTableCell ismTableCell) {
            if (!(ismTableCell instanceof VirtualTextCell)) {
                return -1;
            }
            VirtualTextCell that = (VirtualTextCell)ismTableCell;
            if (null == this.comparable || null == ((VirtualTextCell)ismTableCell).comparable) {
                String thatVal = that.value;
                String thisVal = this.value;
                if (null == thatVal || null == thisVal) {
                    return -1;
                }
                return Collator.getInstance().compare(thisVal, thatVal);
            }
            Comparable thisVal = this.comparable;
            Comparable thatVal = that.comparable;
            return thisVal.compareTo(thatVal);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof VirtualTextCell)) {
                return false;
            }
            VirtualTextCell that = (VirtualTextCell)obj;
            return this.value.equals(that.value);
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public void setValue(Object value) {
            this.setText((String)value);
        }

        @Override
        public Object getValue() {
            if (this.customTextFieldText != null) {
                return this.customTextFieldText.getText();
            }
            return this.value;
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
        }

        static class TextEditor
        extends DefaultCellEditor {
            private static final long serialVersionUID = 1L;
            private VirtualTextCell currentCell;

            public TextEditor() {
                super(new JTextField());
            }

            public TextEditor(JTextField textField) {
                super(textField);
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                return true;
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                String val = "";
                if (value instanceof VirtualTextCell) {
                    this.currentCell = (VirtualTextCell)value;
                    val = this.currentCell.value;
                }
                ((JTextField)this.getComponent()).setText(val);
                return this.editorComponent;
            }

            @Override
            public boolean stopCellEditing() {
                boolean success = this.delegate.stopCellEditing();
                if (success) {
                    this.currentCell.value = ((JTextField)this.getComponent()).getText();
                }
                return success;
            }
        }

        static class TextFieldRender
        extends IsmTableCellRenderer {
            private static final long serialVersionUID = 725238083212111020L;

            TextFieldRender() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (!(value instanceof VirtualTextCell)) {
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
                VirtualTextCell cell = (VirtualTextCell)value;
                if (!isSelected || cell.customTextFieldText == null) {
                    Component component = super.getTableCellRendererComponent(table, cell.getValue(), isSelected, hasFocus, row, column);
                    if (component instanceof JLabel) {
                        JLabel label = (JLabel)component;
                        label.setHorizontalAlignment(cell.alignment);
                    }
                    return component;
                }
                return cell.customTextFieldText;
            }
        }
    }
}

