/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.text;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.IsmToolTip;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.swing.text.CallCenterDocument;
import com.huawei.ism.ui.swing.text.LengthDocument;
import com.huawei.ism.ui.swing.text.NameRegexDocument;
import com.huawei.ism.ui.swing.text.NameRegexDocument2;
import com.huawei.ism.ui.swing.text.RegexDocument;
import com.huawei.ism.ui.swing.text.TextComponentsConstants;
import com.huawei.ism.ui.swing.text.validator.InputValidator;
import com.huawei.ism.ui.swing.text.validator.LengthRangeInputValidator;
import com.huawei.ism.ui.swing.text.validator.RegexInputValidator;
import com.huawei.ism.ui.widgets.PopupInform;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.im.InputMethodRequests;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import javax.swing.text.PlainDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsmTextField
extends JTextField {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsmTextField.class);
    private static final long serialVersionUID = 8756891604321410048L;
    private static final int UCD_CONSTRANTS_HIGHT = 22;
    private String msgPrompt = null;
    private int msgOffset = Integer.MAX_VALUE;
    private String inputValueName = null;
    private transient List<InputValidator> validators = new ArrayList<InputValidator>(0);
    private boolean isMergingTooltips = false;
    private boolean isError;
    private String errorToolTip = "";
    private transient PopupInform popManager = null;

    public IsmTextField(PlainDocument doc, String text, int columns) {
        super(doc, text, columns);
        this.setMaximumSize(new Dimension(800, 22));
        SwingUtil.applyKeyBoardLockPatch(this);
        this.popManager = new PopupInform(this);
        this.popManager.addInform(PopupInform.InformType.USER_DEFINE, "", 0, "");
    }

    protected IsmTextField(RegexDocument regexDoc, int columns) {
        this(regexDoc, "", columns);
    }

    public String getInputValueName() {
        return this.inputValueName;
    }

    private void readObject(ObjectInputStream in) {
    }

    public void setInputValueName(String inputValueName) {
        this.inputValueName = inputValueName;
    }

    public void addInputValidator(InputValidator validator) {
        this.validators.add(validator);
    }

    public void removeAllInputValidators() {
        this.validators.clear();
    }

    public String getPoupInfo() {
        ArrayList<String> toolTipList = new ArrayList<String>(0);
        String tip = null;
        FontMetrics fm = null;
        for (InputValidator validator : this.validators) {
            tip = validator.getToolTip();
            if (null == tip || "".equals(tip)) continue;
            fm = this.getFontMetrics(IsmFontFactory.getDialogPlain());
            tip = tip + ResourceManager.getString("punctuation.dot");
            if ((tip = UCD.wrapTextWithBr(fm, tip, 300)) == null || !tip.endsWith("<br>")) continue;
            tip = tip.substring(0, tip.lastIndexOf("<br>"));
            toolTipList.add(tip);
        }
        if (toolTipList.size() == 1) {
            return "<html>" + (String)toolTipList.get(0) + "</html>";
        }
        if (toolTipList.size() > 1) {
            String string = null;
            StringBuffer sb = new StringBuffer("<html>");
            for (int i = 0; i < toolTipList.size(); ++i) {
                string = (String)toolTipList.get(i);
                if (this.isMergingTooltips) {
                    sb.append(string);
                    continue;
                }
                sb.append(i + 1 + ResourceManager.getString("punctuation.other.dot") + string);
                sb.append("<br>");
            }
            sb.append("</html>");
            return sb.toString();
        }
        return null;
    }

    public void enableMergingTooltips(boolean enabled) {
        this.isMergingTooltips = enabled;
    }

    public void setError(boolean isErrors) {
        this.isError = isErrors;
        this.popManager.setErrorTooltip(this.errorToolTip, isErrors);
        this.repaint();
    }

    public boolean isShowErrorToolTip() {
        return this.isError;
    }

    public void setErrorToolTip(String errorToolTip) {
        this.setToolTipText(null);
        this.errorToolTip = errorToolTip;
        this.setError(true);
        this.repaint();
    }

    public String getErrorToolTip() {
        return this.errorToolTip;
    }

    public void setErrorToolTipWithFocus(String errorToolTips) {
        this.setErrorToolTip(errorToolTips);
        this.requestFocus();
    }

    public String validateInput() {
        String input = this.getText();
        String tip = null;
        for (InputValidator validator : this.validators) {
            tip = validator.validateInput(input, this.inputValueName);
            if (null == tip) continue;
            tip = tip + ResourceManager.getString("pattern.validate.not.blank.tooltip");
            return tip;
        }
        return null;
    }

    public void setPromptTip(String prompt) {
        this.msgPrompt = prompt;
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return null;
    }

    public void setPromptTipOffset(int offset) {
        if (offset >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("the offset is illegal.");
        }
        this.msgOffset = offset;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (null == this.msgPrompt || this.msgPrompt.trim().length() == 0) {
            return;
        }
        String text = this.getText();
        if (!(this.hasFocus() || null != text && text.trim().length() != 0)) {
            graphics.setColor(Color.GRAY);
            int xPos = this.msgOffset == Integer.MAX_VALUE ? this.getX() + 1 : this.getX() + this.msgOffset;
            int yPos = this.getY() + this.getHeight() / 2 + 2;
            graphics.drawString(this.msgPrompt, xPos, yPos);
        }
    }

    public static IsmTextField getNameTextField(String regex, String text, int maxContentLength, int fieldLength) {
        NameRegexDocument nameRegexDocument = new NameRegexDocument(regex, maxContentLength);
        IsmTextField ismTextField = new IsmTextField(nameRegexDocument, fieldLength);
        ismTextField.setText(text);
        return ismTextField;
    }

    public static IsmTextField getNameTextField(String regex, String text, int maxContentLength, int fieldLength, boolean isSupportBlank) {
        NameRegexDocument nameRegexDocument = new NameRegexDocument(regex, maxContentLength);
        nameRegexDocument.setSupportBlank(isSupportBlank);
        IsmTextField ismTextField = new IsmTextField(nameRegexDocument, fieldLength);
        ismTextField.setText(text);
        return ismTextField;
    }

    public static IsmTextField getNameTextField(String regex, String text, int maxContentLength, int fieldLength, boolean isInputBlank, boolean isFirstHyphen) {
        NameRegexDocument nameRegexDocument = new NameRegexDocument(regex, maxContentLength, isInputBlank, isFirstHyphen);
        IsmTextField ismTextField = new IsmTextField(nameRegexDocument, fieldLength);
        ismTextField.setText(text);
        return ismTextField;
    }

    public static IsmTextField getNameLengthTextField(String regex, String text, int maxContentLength, int fieldLength) {
        LengthDocument nameRegexDocument = new LengthDocument(regex, maxContentLength);
        IsmTextField ismTextField = new IsmTextField(nameRegexDocument, fieldLength);
        ismTextField.setText(text);
        return ismTextField;
    }

    public static IsmTextField getLengthRangeTextField(String regex, int minValue, int maxValue, int fieldLength) {
        LengthDocument nameRegexDocument = new LengthDocument(regex, maxValue);
        IsmTextField ismTextField = new IsmTextField(nameRegexDocument, fieldLength);
        String tip = ResourceManager.getString("textfield.prompt.length.range");
        String promptInfo = MessageFormat.format(tip, String.valueOf(minValue), String.valueOf(maxValue));
        PopupInform popManager = new PopupInform(ismTextField);
        popManager.addInform(PopupInform.InformType.MIN_VALID_LENGTH, promptInfo, 0, 2);
        ismTextField.addInputValidator(new LengthRangeInputValidator(minValue, maxValue));
        return ismTextField;
    }

    public static IsmTextField getNameTextField(String text, int maxContentLength, int fieldLength) {
        return IsmTextField.getNameTextField(TextComponentsConstants.getComonTextRegex(), text, maxContentLength, fieldLength);
    }

    public static IsmTextField getNameTextField() {
        return IsmTextField.getNameTextField("", 32, 10);
    }

    public static IsmTextField getNameTextField(String text) {
        return IsmTextField.getNameTextField(text, 32, 10);
    }

    public static IsmTextField getCallCenterNumberTextField(int lengthLimit, int columns) {
        String regex = "^\\+\\d*";
        CallCenterDocument callCenterRegexDocument = new CallCenterDocument(regex, lengthLimit);
        IsmTextField ismTextField = new IsmTextField(callCenterRegexDocument, "^\\+\\d+", columns);
        ismTextField.addInputValidator(new RegexInputValidator("^\\+\\d+", ResourceManager.getString("textfield.tooltip.callcenter"), ResourceManager.getString("textfield.validatetip.callcenter")));
        ismTextField.setSelectionStart(ismTextField.getColumns());
        ismTextField.setPromptTip(ResourceManager.getString("ENTER_CENTER_NUMBER_TIP"));
        ismTextField.setPromptTipOffset(-10);
        return ismTextField;
    }

    public static IsmTextField getNumberTextField(long bottom, long top, int lengthLimit, int columns) {
        return IsmTextField.getNumberTextField("[0-9]*", bottom, top, lengthLimit, columns);
    }

    public static IsmTextField getNumberTextField(String regexp, long bottom, long top, int lengthLimit, int columns) {
        return IsmTextField.getNumberTextField(regexp, bottom, top, lengthLimit, columns, false);
    }

    public static IsmTextField getNumberTextField(String regexp, long bottom, long top, int lengthLimit, int columns, boolean isStartWith0) {
        String regex = regexp;
        RegexDocument numberDocument = RegexDocument.createNumberDocument(regex, bottom, top, lengthLimit, isStartWith0);
        IsmTextField ismTextField = new IsmTextField(numberDocument, columns);
        ismTextField.setSelectionStart(ismTextField.getColumns());
        return ismTextField;
    }

    public static IsmTextField getNameTextFieldForArrayProperty() {
        NameRegexDocument2 nameRegexDocument = new NameRegexDocument2(TextComponentsConstants.getArrayNameRegrex(), 32);
        IsmTextField ismTextField = new IsmTextField(nameRegexDocument, 10);
        ismTextField.setText("");
        return ismTextField;
    }

    public static IsmTextField getNameTextFieldForArrayProperty(int columns) {
        NameRegexDocument2 nameRegexDocument = new NameRegexDocument2(TextComponentsConstants.getArrayNameRegrex(), 32);
        IsmTextField ismTextField = new IsmTextField(nameRegexDocument, columns);
        ismTextField.setText("");
        return ismTextField;
    }

    public static IsmTextField getArrayAddressTextField(int columns) {
        NameRegexDocument2 nameRegexDocument = new NameRegexDocument2(TextComponentsConstants.getArrayAddressRegrex(), 32);
        IsmTextField ismTextField = new IsmTextField(nameRegexDocument, columns);
        ismTextField.setText("");
        return ismTextField;
    }

    public static IsmTextField getIPV6AddressTextField(int columns) {
        NameRegexDocument2 nameRegexDocument = new NameRegexDocument2(TextComponentsConstants.getIPv6InputRegrex(), 45);
        IsmTextField ismTextField = new IsmTextField(nameRegexDocument, columns);
        ismTextField.setText("");
        return ismTextField;
    }

    public static IsmTextField getIPV6AddressTextField() {
        NameRegexDocument2 nameRegexDocument = new NameRegexDocument2(TextComponentsConstants.getIPv6InputRegrex(), 45);
        IsmTextField ipfield = new IsmTextField(nameRegexDocument, 10);
        ipfield.setText("");
        ipfield.setColumns(10);
        ipfield.setSize(290, 20);
        ipfield.setPreferredSize(new Dimension(290, 20));
        return ipfield;
    }

    public static IsmTextField getRegexTextField(String regex, int columns) {
        RegexDocument regexDoc = new RegexDocument(regex);
        IsmTextField textField = new IsmTextField(regexDoc, "", columns);
        return textField;
    }

    public PopupInform getTextFieldPopupInfo() {
        return this.popManager;
    }

    public static IsmTextField getNoLimitedTextField(int columns) {
        return new IsmTextField(new PlainDocument(), "", columns);
    }

    @Override
    public IsmToolTip createToolTip() {
        IsmToolTip tip = new IsmToolTip();
        tip.setComponent(this);
        return tip;
    }
}

