/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyledTextPane
extends JTextPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(StyledTextPane.class);
    private static final long serialVersionUID = 1L;
    private StyledDocument document = new DefaultStyledDocument();

    public StyledTextPane(Paragraph ... paragraphs) {
        this.setDocument(this.document);
        this.setParagraph(paragraphs);
    }

    public void setParagraph(Paragraph ... paragraphs) {
        try {
            this.document.remove(0, this.document.getLength());
            if (null == paragraphs) {
                return;
            }
            Paragraph paragraph = null;
            Style style = null;
            Style ls = null;
            for (int i = 0; i < paragraphs.length; ++i) {
                paragraph = paragraphs[i];
                for (Segment segment : paragraph.segments) {
                    style = segment.style;
                    this.document.insertString(this.document.getLength(), segment.content, style);
                }
                ls = paragraph.style;
                this.document.setLogicalStyle(this.document.getLength() - 1, ls);
                if (i < paragraphs.length - 1) {
                    this.document.insertString(this.document.getLength(), "\n", null);
                    continue;
                }
                this.document.insertString(this.document.getLength(), "", null);
            }
        }
        catch (BadLocationException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public static class Segment {
        private Style style;
        private String content;

        public Segment(Style style, String content) {
            this.style = style;
            this.content = content;
        }

        public Style getStyle() {
            return this.style;
        }

        public String getContent() {
            return this.content;
        }
    }

    public static class Paragraph {
        private Style style;
        private List<Segment> segments = new ArrayList<Segment>(0);

        public Paragraph(Style style, Segment ... segments) {
            this.style = style;
            if (null != segments) {
                this.segments.addAll(Arrays.asList(segments));
            }
        }

        public Style getStyle() {
            return this.style;
        }

        public List<Segment> getSegments() {
            return new ArrayList<Segment>(this.segments);
        }
    }
}

