/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets;

import com.huawei.ism.thread.ThreadPoolManager;
import com.huawei.ism.ui.swing.control.TabbedPane;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.templets.DefaultFeaturePane;
import com.huawei.ism.ui2.mainframe.device.FeatureModulePane;
import com.huawei.ism.util.Assert;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public abstract class AssociatedPane
extends JPanel {
    private String deviceIdentifer;
    private TableRow<?, ?> parentSourceRow = null;

    public AssociatedPane(String deviceID) {
        this.deviceIdentifer = deviceID;
        this.setOpaque(false);
    }

    public final void updateProperty(int updateMode, TableRow<?, ?> sourceRow) {
        this.parentSourceRow = sourceRow;
        this.update(updateMode, sourceRow);
    }

    public abstract void update(int var1, TableRow<?, ?> var2);

    public String getDeviceID() {
        return this.deviceIdentifer;
    }

    protected final TableRow<?, ?> getSourceRow() {
        return this.parentSourceRow;
    }

    public static abstract class TabbedAssociatedPane
    extends AssociatedPane {
        private static final String TABNAME = "TabName";
        private JTabbedPane associatedTabbedPane;
        private List<FeatureModulePane> tabPaneList = new ArrayList<FeatureModulePane>(0);

        public TabbedAssociatedPane(String deviceID) {
            super(deviceID);
            this.doLayoutUI();
        }

        private void doLayoutUI() {
            this.associatedTabbedPane = new JTabbedPane();
            TabbedPane tabbedPane = new TabbedPane(this.associatedTabbedPane);
            this.setLayout(new BorderLayout());
            this.add((Component)tabbedPane, "Center");
            this.setBorder(UCD.createEmptyBorder(0));
        }

        @Override
        public void update(int updateMode, TableRow<?, ?> selectedRow) {
            int curTab;
            if (null == selectedRow) {
                this.associatedTabbedPane.removeAll();
                return;
            }
            if (0 == this.associatedTabbedPane.getComponentCount() && !this.tabPaneList.isEmpty()) {
                for (FeatureModulePane pane : this.tabPaneList) {
                    this.associatedTabbedPane.add((String)pane.getClientProperty(TABNAME), pane);
                }
            }
            if ((curTab = this.associatedTabbedPane.getSelectedIndex()) < 0) {
                curTab = 0;
            }
            if (!this.isTabFixed()) {
                this.tabPaneList.clear();
                this.associatedTabbedPane.removeAll();
            }
            if (this.tabPaneList.isEmpty()) {
                this.createTabPane(selectedRow);
            }
            for (FeatureModulePane tabPane : this.tabPaneList) {
                tabPane.updateAssociatedPane(updateMode, selectedRow);
            }
            if (this.tabPaneList.size() > curTab) {
                this.associatedTabbedPane.setSelectedIndex(curTab);
            }
        }

        protected boolean isTabFixed() {
            return true;
        }

        public abstract FeatureModulePane getTabPane(int var1, TableRow var2);

        protected abstract int getTabCount(TableRow<?, ?> var1);

        protected abstract String getTabNameAt(int var1, TableRow var2);

        private void createTabPane(TableRow source) {
            int tabCount = this.getTabCount(source);
            String tabName = null;
            FeatureModulePane tabPane = null;
            for (int tabIndex = 0; tabIndex < tabCount; ++tabIndex) {
                tabName = this.getTabNameAt(tabIndex, source);
                tabPane = this.getTabPane(tabIndex, source);
                if (null == tabPane) continue;
                this.associatedTabbedPane.add(tabName, tabPane);
                tabPane.putClientProperty(TABNAME, tabName);
                this.tabPaneList.add(tabPane);
            }
        }
    }

    public static class TableAssociatedPane
    extends AssociatedPane {
        private static final long serialVersionUID = 3910726817418987063L;
        private DefaultFeaturePane featureTablePane;

        public TableAssociatedPane(String deviceID) {
            super(deviceID);
            this.setLayout(new BorderLayout());
        }

        public void setTablePane(DefaultFeaturePane tablePane) {
            Assert.notNull(tablePane);
            this.featureTablePane = tablePane;
            this.add((Component)tablePane, "Center");
        }

        @Override
        public void update(int updateMode, TableRow<?, ?> sourceRow) {
            if (null == this.featureTablePane) {
                return;
            }
            if (null == sourceRow) {
                this.removeAll();
                this.revalidate();
                this.repaint();
                this.stopDisplay();
                return;
            }
            if (0 == this.getComponentCount()) {
                this.add((Component)this.featureTablePane, "Center");
                this.revalidate();
                this.repaint();
            }
            this.featureTablePane.updateAssociatedPane(updateMode, sourceRow);
        }

        private void stopDisplay() {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    featureTablePane.stopDisplay();
                }
            };
            ThreadPoolManager.getInstance().execute(runnable);
        }
    }
}

