/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets;

import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.service.CommonWorkTaker;
import com.huawei.ism.service.MOsCache;
import com.huawei.ism.ui.swing.control.RefreshButton;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.swing.plaf.unify.UnifyBorders;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableScrollPane;
import com.huawei.ism.ui.swing.table.KeywordFilterField;
import com.huawei.ism.ui.swing.table.TableCountPane;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.templets.AssociatedPane;
import com.huawei.ism.ui.templets.ButtonPane;
import com.huawei.ism.ui.templets.PropertyPaneAction;
import com.huawei.ism.ui.templets.TableMenuHandler;
import com.huawei.ism.ui2.mainframe.device.FeatureModulePane;
import com.huawei.ism.util.Assert;
import com.huawei.ism.util.TimeUtil;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultFeaturePane
extends FeatureModulePane {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFeaturePane.class);
    private static final long serialVersionUID = 1814610886349272639L;
    private IsmTable table;
    private DefaultTableModel tableModel;
    private ButtonPane buttonsPane = new ButtonPane();
    private AtomicBoolean updating = new AtomicBoolean(false);
    private TableRow associatedRow = null;
    private RefreshButton refreshButton = null;
    private AssociatedPane associatedPane;
    private SwingWorker<List<TableRow>, Object> updateWorker;
    private KeywordFilterField filterField;
    private JPanel southPane = null;

    protected DefaultFeaturePane(String deviceID, String[] columnNames) {
        super(deviceID);
        this.tableModel = new DefaultTableModel(columnNames, new int[0]);
        this.tableModel.setVisibleColumns(this.getVisualColumns());
        this.tableModel.setFixedVisableColumns(this.getFixedVisualColumns());
        this.doLayoutUI();
        this.addHandler();
    }

    @Override
    public final void updateProperty(int updateMode) {
        this.beforeUpdate(updateMode);
        this.toUpdate(CommonWorkTaker.EGetDataMode.FromCache, updateMode, null);
        this.afterUpdate(updateMode);
    }

    protected void beforeUpdate(int updateMode) {
    }

    protected void afterUpdate(int updateMode) {
    }

    public final void updateProperty(MOsCache moCache, int updateMode) {
        this.toUpdate(moCache, updateMode);
    }

    @Override
    public final void updateAssociatedPane(int updateMode, TableRow<?, ?> source) {
        this.toUpdate(CommonWorkTaker.EGetDataMode.FromCache, updateMode, source);
    }

    public final TableRow getAssociatedRow() {
        return this.associatedRow;
    }

    public void setSelectRow(Object rowIndentifier) {
        TableRow<?, ?> row = this.tableModel.getTableRowBy(rowIndentifier);
        if (null != row) {
            this.table.clearSelection();
            this.table.markTableRow(row);
        }
    }

    public void addTableMarkableListener(ListSelectionListener selectionListener) {
        this.table.addListSelectionListener(selectionListener);
    }

    public IsmTable getTable() {
        return this.table;
    }

    protected final void addButton(PropertyPaneAction ... actions) {
        this.buttonsPane.addButton(this.getDeviceID(), actions);
        this.addPopupMenuItems(actions);
    }

    protected final void addGroupButton(PropertyPaneAction ... actions) {
        this.buttonsPane.addGroupButton(this.getDeviceID(), actions);
        this.addPopupMenuItems(actions);
    }

    protected final void addPopupMenuItems(PropertyPaneAction ... actions) {
        this.buttonsPane.addMenus(actions);
    }

    protected final void addCustomePane(JComponent component) {
        this.buttonsPane.addCustomPane(component);
    }

    protected final void addSouthPane(JComponent component) {
        this.southPane.add((Component)component, "East");
    }

    protected int[] getVisualColumns() {
        return new int[0];
    }

    public void setVisualColumns(int[] visualColumns) {
        this.tableModel.setVisibleColumns(visualColumns);
    }

    protected int[] getFixedVisualColumns() {
        return new int[]{0};
    }

    protected boolean isMultiSelection() {
        return true;
    }

    protected AssociatedPane getAssociatedPane() {
        return null;
    }

    protected String getAssociatedPaneTitle() {
        return null;
    }

    protected final KeywordFilterField getKeyFilterField() {
        return this.filterField;
    }

    protected abstract List<TableRow> getTableRows(MOsCache var1);

    protected abstract MOsCache retrievePaneData(String var1, CommonWorkTaker.EGetDataMode var2, TableRow<?, ?> var3);

    public void setSelectRows(Object ... rowIndentifiers) {
        Assert.notNullArray(rowIndentifiers);
        this.table.clearSelection();
        this.table.markTableRows(rowIndentifiers);
    }

    private void toUpdate(MOsCache moCache, int updateMode) {
        List<TableRow> topTableRows = this.getTableRows(moCache);
        if (topTableRows != null) {
            this.toUpdate(updateMode, topTableRows);
        }
    }

    private void toUpdate(int updateMode, List<TableRow> topTableRows) {
        if (1 == updateMode) {
            this.tableModel.setTableData(topTableRows);
        } else {
            this.tableModel.reset(topTableRows, this.table);
        }
        this.updateAssociatedPane(updateMode);
        this.buttonsPane.updateActions(this.getDeviceID(), this.table, this.getAssociatedRow());
    }

    private void toUpdate(CommonWorkTaker.EGetDataMode mode, int updateMode, TableRow<?, ?> source) {
        Object previousSrcRowID;
        Object currentSrcRowID;
        boolean cancelUpdateWorker = false;
        boolean notUpdating = this.updating.compareAndSet(false, true);
        if (null != source && null != this.associatedRow && !(currentSrcRowID = source.getIdentifier()).equals(previousSrcRowID = this.associatedRow.getIdentifier()) && !notUpdating) {
            cancelUpdateWorker = true;
        }
        if (null != this.associatedRow && !notUpdating) {
            cancelUpdateWorker = true;
        }
        if (!notUpdating && !cancelUpdateWorker) {
            return;
        }
        if (null != this.updateWorker && cancelUpdateWorker) {
            this.updateWorker.cancel(true);
            this.updateWorker = null;
            this.updating.set(false);
        }
        if (CommonWorkTaker.EGetDataMode.FromDevice == mode) {
            this.refreshButton.setLoadingIcon();
        }
        this.associatedRow = source;
        this.updateWorker = new UpdateWorkTaker(mode, updateMode, source);
        this.updateWorker.execute();
    }

    private void updateAssociatedPane(int updateMode) {
        if (null != this.associatedPane) {
            if (this.table.getSelectedRows().length == 1) {
                int modelIndex = this.table.convertRowIndexToModel(this.table.getSelectedRow());
                TableRow selectRow = this.tableModel.getRow(modelIndex);
                this.associatedPane.update(updateMode, selectRow);
            } else {
                this.associatedPane.update(updateMode, null);
            }
        }
    }

    private void doLayoutUI() {
        this.table = new IsmTable(this.tableModel);
        this.refreshButton = new RefreshButton(new RefreshAction());
        IsmTableScrollPane tableScrollPane = new IsmTableScrollPane(this.table, this.isMultiSelection());
        tableScrollPane.setMinimumSize(new Dimension(100, 80));
        tableScrollPane.setBorder(BorderFactory.createEmptyBorder());
        JPanel tableAndCountPane = UCD.createTransparentPane(new BorderLayout());
        tableAndCountPane.add((Component)tableScrollPane, "Center");
        tableAndCountPane.add((Component)this.createSouthPane(), "South");
        tableAndCountPane.setBorder(UnifyBorders.getScrollPaneBorder());
        JPanel tableArea = UCD.createTransparentPane(new BorderLayout());
        tableArea.add((Component)tableAndCountPane, "Center");
        tableArea.add((Component)this.createNorthPane(), "North");
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.associatedPane = this.getAssociatedPane();
        if (null != this.associatedPane) {
            JPanel bottomPane = UCD.createTransparentPane(new BorderLayout());
            String title = this.getAssociatedPaneTitle();
            if (!Utils.isNullStr(title)) {
                JLabel titleLabel = new JLabel(title);
                titleLabel.setFont(IsmFontFactory.getBold12Font());
                Box titleBox = UCD.buildHBoxLeft(Box.createHorizontalStrut(1), titleLabel);
                titleBox.add(Box.createRigidArea(new Dimension(1, 18)));
                bottomPane.add((Component)titleBox, "North");
            }
            bottomPane.add((Component)this.associatedPane, "Center");
            JSplitPane splitPane = this.createSplitPane();
            splitPane.setTopComponent(tableArea);
            splitPane.setBottomComponent(bottomPane);
            this.add((Component)splitPane, "Center");
        } else {
            this.add((Component)tableArea, "Center");
        }
    }

    private JPanel createSouthPane() {
        TableCountPane tableCountPane = new TableCountPane(this.table);
        this.southPane = UCD.createTransparentPane(new BorderLayout());
        JPanel southPanel = new JPanel();
        southPanel.setBackground(new Color(0xDDDDDD));
        southPanel.setLayout(new BoxLayout(southPanel, 0));
        southPanel.add(tableCountPane);
        southPanel.add(Box.createHorizontalStrut(10));
        southPanel.add(Box.createRigidArea(new Dimension(0, 21)));
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(this.southPane);
        southPanel.add(Box.createHorizontalStrut(10));
        return southPanel;
    }

    private JPanel createNorthPane() {
        this.filterField = new KeywordFilterField(this.table);
        Box northeastBox = Box.createHorizontalBox();
        northeastBox.add(this.filterField);
        northeastBox.add(Box.createHorizontalStrut(15));
        northeastBox.add(this.refreshButton);
        northeastBox.add(Box.createHorizontalStrut(2));
        JPanel northPane = UCD.createBoxLayoutPane(0);
        northPane.add(this.buttonsPane);
        northPane.add(Box.createHorizontalGlue());
        northPane.add(northeastBox);
        northPane.add(Box.createRigidArea(new Dimension(0, 33)));
        return northPane;
    }

    private JSplitPane createSplitPane() {
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setContinuousLayout(true);
        splitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        splitPane.setResizeWeight(0.8);
        splitPane.setDividerLocation(300);
        splitPane.setOpaque(false);
        return splitPane;
    }

    private void addHandler() {
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                TableMenuHandler.popMenu(e, DefaultFeaturePane.this.buttonsPane.getMenuActions());
            }
        });
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (DefaultFeaturePane.this.table.isStructureChanged()) {
                    return;
                }
                DefaultFeaturePane.this.buttonsPane.updateActions(DefaultFeaturePane.this.getDeviceID(), DefaultFeaturePane.this.table, DefaultFeaturePane.this.getAssociatedRow());
                DefaultFeaturePane.this.updateAssociatedPane(0);
            }
        });
    }

    public RefreshButton getRefreshButton() {
        return this.refreshButton;
    }

    private static final class RefreshAction
    extends AbstractAction {
        private static final long serialVersionUID = -2037557017989241358L;

        private RefreshAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (null == e) {
                LOGGER.error("The actionPerformed method in e null.");
                return;
            }
            DefaultFeaturePane sourcePane = (DefaultFeaturePane)SwingUtilities.getAncestorOfClass(DefaultFeaturePane.class, (JButton)e.getSource());
            sourcePane.toUpdate(CommonWorkTaker.EGetDataMode.FromDevice, 1, sourcePane.getAssociatedRow());
        }
    }

    private final class UpdateWorkTaker
    extends SwingWorker<List<TableRow>, Object> {
        private final CommonWorkTaker.EGetDataMode dataGetMode;
        private final int updateMode;
        private TableRow<?, ?> source;

        public UpdateWorkTaker(CommonWorkTaker.EGetDataMode getDataMode, int updateMode, TableRow<?, ?> source) {
            this.dataGetMode = getDataMode;
            this.updateMode = updateMode;
            this.source = source;
        }

        @Override
        protected List<TableRow> doInBackground() {
            MOsCache mosCache = DefaultFeaturePane.this.retrievePaneData(DefaultFeaturePane.this.getDeviceID(), this.dataGetMode, this.source);
            if (null != mosCache) {
                List<TableRow> topTableRows = DefaultFeaturePane.this.getTableRows(mosCache);
                return topTableRows;
            }
            return Collections.emptyList();
        }

        @Override
        protected void done() {
            try {
                List tableRows = (List)this.get();
                if (null == tableRows) {
                    tableRows = Collections.emptyList();
                }
                DefaultFeaturePane.this.toUpdate(this.updateMode, tableRows);
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
                DefaultFeaturePane.this.buttonsPane.updateActions(DefaultFeaturePane.this.getDeviceID(), DefaultFeaturePane.this.table, DefaultFeaturePane.this.getAssociatedRow());
                DefaultFeaturePane.this.updateAssociatedPane(this.updateMode);
            }
            finally {
                DefaultFeaturePane.this.refreshButton.setNormalIcon();
                DefaultFeaturePane.this.updating.set(false);
                if (this.dataGetMode == CommonWorkTaker.EGetDataMode.FromDevice) {
                    String dateNowStr = TimeUtil.gmtToString(new Date().getTime(), LauncherManager.getInstance().getLauncher(DefaultFeaturePane.this.getDeviceID()).getDeviceTimeZone());
                    String head = ResourceManager.getStringWithColon("LAST_REFRESH_TIME") + ' ';
                    DefaultFeaturePane.this.refreshButton.setToolTipText(head + dateNowStr);
                }
            }
        }
    }
}

