/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.perfstat;

import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.bean.ProductSpeciality;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.ui2.perfstat.PerfStatStrategySettingLayout;
import com.huawei.ism.ui2.perfstat.util.DataSourceManager;
import com.huawei.ism.ui2.perfstat.util.PerfStatDataSource;
import com.huawei.ism.ui2.perfstat.util.PerfStatUtil;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PerfStatStrategySettingDialog
extends IsmDialog {
    private static final long serialVersionUID = 6301980290630589864L;
    private PerfStatStrategySettingLayout newLayout;
    private PerfStatStrategySettingLayout oldLayout;
    private boolean closed = false;
    private String deviceID = null;
    private transient PerfStatDataSource dataSource;

    public PerfStatStrategySettingDialog(String deviceID, Window parent, String selectedDeviceID) throws IsmException {
        super(parent, "", IsmDialog.ECommonButton.Close, IsmDialog.ECommonButton.Help);
        this.deviceID = deviceID;
        this.dataSource = DataSourceManager.getDataSource(deviceID);
        this.dataSource.setParentWindow(parent);
        this.doUILayout(selectedDeviceID);
        this.initDatas(selectedDeviceID);
        this.addHandler();
        this.setTitle(ResourceManager.getString("perfstat.strategySettings.title"));
        this.getRootPane().setDefaultButton(this.getButtonBy(IsmDialog.ECommonButton.Close));
        SwingUtil.setName(this);
        this.beforeShow();
    }

    public boolean isPerfStatSwitchOpen() {
        return !this.newLayout.isStartBtn();
    }

    private void addHandler() {
        this.newLayout.addStatusBtnActionListener(this.createStatusBtnListener());
        this.oldLayout.addStatusBtnActionListener(this.createStatusBtnListener());
        this.newLayout.getDeviceComboBox().addItemListener(this.createDeviceComboBoxListener());
        this.oldLayout.getDeviceComboBox().addItemListener(this.createDeviceComboBoxListener());
    }

    private void statusBtnActionPerformed2() {
        Map<Object, Object> strategyAndSwitchStatus = this.newLayout.isVisible() ? this.newLayout.getUISetting() : this.oldLayout.getUISetting();
        strategyAndSwitchStatus.put("isPerformanceSwitchOn", 1L);
        Map<Object, Object> strategy = this.setStatisticStrategyAndSwitch(strategyAndSwitchStatus);
        if (strategy != null) {
            if (this.newLayout.isVisible()) {
                this.newLayout.setData(strategy, this.getDeviceID());
            } else {
                this.oldLayout.setData(strategy, this.getDeviceID());
            }
            DialogUtils.showInfoDialog(this);
        }
    }

    protected void statusBtnActionPerformed() {
        if (this.newLayout.isStartBtn() || this.oldLayout.isStartBtn()) {
            if (!this.isValidInput()) {
                return;
            }
            try {
                this.statusBtnActionPerformed2();
            }
            catch (Exception e) {
                DialogUtils.showErrorDialog((Window)this, (Throwable)e);
            }
        } else {
            try {
                HashMap<Object, Object> switchStatus = new HashMap<Object, Object>(0);
                switchStatus.put("isPerformanceSwitchOn", 0L);
                Map<Object, Object> strategy = this.setSwitchStatus(switchStatus);
                if (strategy != null) {
                    if (this.newLayout.isVisible()) {
                        this.newLayout.setData(strategy, this.getDeviceID());
                    } else {
                        this.oldLayout.setData(strategy, this.getDeviceID());
                    }
                    DialogUtils.showInfoDialog(this);
                }
            }
            catch (Exception e) {
                DialogUtils.showErrorDialog((Window)this, (Throwable)e);
            }
        }
    }

    protected Map<Object, Object> setSwitchStatus(Map<Object, Object> switchStatus) {
        Map<Object, Object> strategy = this.dataSource.setSwitchStatus(switchStatus);
        return strategy;
    }

    protected Map<Object, Object> setStatisticStrategyAndSwitch(Map<Object, Object> strategyAndSwitchStatus) {
        Map<Object, Object> strategy = this.dataSource.setStatisticStrategyAndSwitchStatus(strategyAndSwitchStatus);
        return strategy;
    }

    @Override
    protected void doCloseTask() {
        super.doCloseTask();
        this.closed = true;
    }

    private void doUILayout(String selectedDeviceID) {
        this.newLayout = new PerfStatStrategySettingLayout(this.deviceID, true, selectedDeviceID);
        this.newLayout.setBorder(UCD.createEmptyBorder(20));
        this.oldLayout = new PerfStatStrategySettingLayout(this.deviceID, false, selectedDeviceID);
        this.oldLayout.setBorder(UCD.createEmptyBorder(20));
        Launcher launcher = CommonUtil.getLauncher(this.deviceID);
        if (launcher.isSupportSpeciality(ProductSpeciality.PERFORMANCE_SPLITED_INTERVAL)) {
            this.newLayout.setVisible(true);
            this.oldLayout.setVisible(false);
            this.getDialogContentPane().add(this.newLayout);
        } else {
            this.newLayout.setVisible(false);
            this.oldLayout.setVisible(true);
            this.getDialogContentPane().add(this.oldLayout);
        }
    }

    protected void initDatas(String deviceIdTemp) throws IsmException {
        Map<Object, Object> strategy = this.getPerfStatStrategyAndSwitchStatus(deviceIdTemp);
        if (this.newLayout.isVisible()) {
            this.newLayout.setData(strategy, deviceIdTemp);
            PerfStatUtil.disabledComponentByUser(deviceIdTemp, this.newLayout.getAllComponent());
        } else {
            this.oldLayout.setData(strategy, deviceIdTemp);
            PerfStatUtil.disabledComponentByUser(deviceIdTemp, this.oldLayout.getAllComponent());
        }
    }

    protected ActionListener createStatusBtnListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PerfStatStrategySettingDialog.this.statusBtnActionPerformed();
            }
        };
    }

    protected ItemListener createDeviceComboBoxListener() {
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    int index = PerfStatStrategySettingDialog.this.newLayout.getDeviceComboBox().getSelectedIndex();
                    PerfStatStrategySettingDialog.this.deviceID = (String)((Pair)PerfStatStrategySettingDialog.this.newLayout.getDeviceComboBox().getSelectedItem()).getKey();
                    if (PerfStatStrategySettingDialog.this.oldLayout.isVisible()) {
                        index = PerfStatStrategySettingDialog.this.newLayout.getDeviceComboBox().getSelectedIndex();
                        PerfStatStrategySettingDialog.this.deviceID = (String)((Pair)PerfStatStrategySettingDialog.this.oldLayout.getDeviceComboBox().getSelectedItem()).getKey();
                    }
                    PerfStatStrategySettingDialog.this.changeLayout(PerfStatStrategySettingDialog.this.deviceID, index);
                }
                PerfStatStrategySettingDialog.this.initDatas(PerfStatStrategySettingDialog.this.deviceID);
            }
        };
        return listener;
    }

    private void changeLayout(String deviceIdTemp, int index) {
        Launcher launcher = CommonUtil.getLauncher(deviceIdTemp);
        if (launcher.isSupportSpeciality(ProductSpeciality.PERFORMANCE_SPLITED_INTERVAL)) {
            this.getDialogContentPane().remove(this.oldLayout);
            this.getDialogContentPane().add(this.newLayout);
            this.newLayout.setVisible(true);
            this.oldLayout.setVisible(false);
            if (index != this.newLayout.getDeviceComboBox().getSelectedIndex()) {
                this.newLayout.getDeviceComboBox().setSelectedItem(index);
            }
        } else {
            this.getDialogContentPane().remove(this.newLayout);
            this.getDialogContentPane().add(this.oldLayout);
            this.newLayout.setVisible(false);
            this.oldLayout.setVisible(true);
            if (index != this.oldLayout.getDeviceComboBox().getSelectedIndex()) {
                this.oldLayout.getDeviceComboBox().setSelectedItem(index);
            }
        }
    }

    protected Map<Object, Object> getPerfStatStrategyAndSwitchStatus(String deivceID) {
        Map<Object, Object> strategy = this.dataSource.syncGetStrategyAndSwitchStatus();
        return strategy;
    }

    protected boolean isValidInput() {
        int days;
        ArrayList<IsmTextField> needValidateFields = new ArrayList<IsmTextField>(0);
        if (this.newLayout.isVisible()) {
            this.newLayout.getAutoStopDaysTextField().setError(false);
            days = this.newLayout.getStopDays();
        } else {
            this.oldLayout.getSamplingIntervalTextField().setError(false);
            this.oldLayout.getStatDaysTextField().setError(false);
            needValidateFields.add(this.oldLayout.getSamplingIntervalTextField());
            days = this.oldLayout.getStopDays();
        }
        boolean isValid = SwingUtil.validateInput(needValidateFields);
        if (!isValid) {
            return false;
        }
        if (days <= 0) {
            String errorInfo = ResourceManager.getString("INPUT_DAYS_NULL");
            if (this.newLayout.isVisible()) {
                this.newLayout.getAutoStopDaysTextField().setErrorToolTip(errorInfo);
            } else {
                this.oldLayout.getStatDaysTextField().setErrorToolTip(errorInfo);
            }
            return false;
        }
        return true;
    }

    @Override
    protected String getHelpKey() {
        return "performance_config";
    }

    public String getDeviceID() {
        return this.deviceID;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public PerfStatStrategySettingLayout getNewLayout() {
        return this.newLayout;
    }

    public PerfStatStrategySettingLayout getOldLayout() {
        return this.oldLayout;
    }
}

