/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util;

import com.huawei.ism.tool.base.utils.ContextUtil;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.PlatformAppContext;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolRunningCheckUtil {
    private static final Logger log = LoggerFactory.getLogger(ToolRunningCheckUtil.class);

    public static boolean isToolRunning(String toolId, String flagFile) {
        File flagPath = ToolRunningCheckUtil.getFlagPath(toolId, flagFile);
        if (ApplicationContext.getInstance().isWindowsOS()) {
            return ToolRunningCheckUtil.checkInWindows(flagPath);
        }
        return ToolRunningCheckUtil.checkInLinux(flagPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<FileLock> tryFileLock(File flagFile) {
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(flagFile, "rw");){
            Optional<FileLock> optional = Optional.ofNullable(randomAccessFile.getChannel().tryLock());
            return optional;
        }
        catch (IOException e) {
            log.error("get access file for file :{} failed", (Object)flagFile.getName(), (Object)e);
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkInLinux(File flagFile) {
        if (!flagFile.exists()) {
            return false;
        }
        Optional<FileLock> fileLock = ToolRunningCheckUtil.tryFileLock(flagFile);
        try {
            if (!fileLock.isPresent()) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            fileLock.ifPresent(ToolRunningCheckUtil::releaseLock);
        }
        String flag = flagFile.getName();
        File lockFlagFile = FilePathUtils.checkFile(new File(new File(flagFile.getParent(), "lockfolder"), flag));
        if (!lockFlagFile.exists()) {
            return false;
        }
        fileLock = ToolRunningCheckUtil.tryFileLock(lockFlagFile);
        try {
            if (!fileLock.isPresent()) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            fileLock.ifPresent(ToolRunningCheckUtil::releaseLock);
        }
        return false;
    }

    private static void releaseLock(FileLock fileLock) {
        try {
            fileLock.close();
        }
        catch (IOException e) {
            log.error("close lock for funningFlag failed", (Throwable)e);
        }
    }

    private static File getFlagPath(String toolId, String flagFile) {
        String runPath = PlatformAppContext.getInstance().getFunctionByKey("app.tool.runpath");
        if (!StringUtils.isNULLStr(runPath)) {
            return new File(String.join((CharSequence)File.separator, ContextUtil.getToolBoxPath(), "tools", toolId, runPath, flagFile));
        }
        return new File(String.join((CharSequence)File.separator, ContextUtil.getToolBoxPath(), "tools", toolId, flagFile));
    }

    private static boolean checkInWindows(File flagFile) {
        if (flagFile.exists() && !flagFile.delete()) {
            return true;
        }
        String flag = flagFile.getName();
        File lockFlagFile = FilePathUtils.checkFile(new File(new File(flagFile.getParent(), "lockfolder"), flag));
        return lockFlagFile.exists() && !lockFlagFile.delete();
    }
}

