/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util.parser;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.util.parser.FileOutStreamParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarFileParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(TarFileParser.class);
    private static final String TAR_GZ_SUFFIX = "tar.gz";
    private static final String TGZ_SUFFIX = "tgz";
    private static final String TAR_SUFFIX = "tar";
    private TarInputStream tarInputStream = null;

    public TarFileParser(String fileAbsolutePath) throws IOException {
        this.initializeTgzInputStream(fileAbsolutePath);
    }

    public void close() throws IOException {
        if (null != this.tarInputStream) {
            this.tarInputStream.close();
            LOGGER.info("close tar/tgz file");
        }
    }

    public String decompressionTarEntityToTempFile(String entityPrefix, String entitySuffix) throws IOException {
        FileOutStreamParser fileOutParser = new FileOutStreamParser(entityPrefix, entitySuffix);
        this.treeWalk(entityPrefix + '.' + entitySuffix);
        fileOutParser.writeFileFromStream((InputStream)this.tarInputStream);
        fileOutParser.close();
        return fileOutParser.getAbsolutePath();
    }

    private void initializeTgzInputStream(String filePath) throws IOException {
        InputStream fileInStream = null;
        String tmp = filePath.toLowerCase(ResourceManager.getLocale());
        if (tmp.contains(TAR_GZ_SUFFIX) || tmp.contains(TGZ_SUFFIX)) {
            fileInStream = new GZIPInputStream(new FileInputStream(filePath));
        } else if (tmp.contains(TAR_SUFFIX)) {
            fileInStream = new FileInputStream(filePath);
        } else {
            LOGGER.error("file type error.file:" + filePath);
            throw new IllegalArgumentException("file type error.file:" + filePath);
        }
        this.tarInputStream = new TarInputStream(fileInStream);
    }

    private TarInputStream treeWalk(String enetryName) throws IOException {
        TarEntry tarEn = null;
        String tarEnName = "";
        TarInputStream tmp = null;
        int ind = 0;
        while ((tarEn = this.tarInputStream.getNextEntry()) != null) {
            tarEnName = tarEn.getName().replace('\\', File.separatorChar).replace('/', File.separatorChar);
            if (!enetryName.equals(tarEnName.substring((ind = tarEnName.lastIndexOf(File.separatorChar)) + 1, tarEnName.length()))) continue;
            tmp = this.tarInputStream;
            LOGGER.info("find enetry in tar.gz/tgz/tar file");
            break;
        }
        return tmp;
    }
}

