/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sftp;

import com.google.common.base.Stopwatch;
import com.huawei.ism.common.bean.User;
import com.huawei.ism.exception.IsmException;
import com.huawei.sftp.SftpAccount;
import com.huawei.sftp.SftpTransferProgress;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import org.apache.commons.io.FileUtils;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.apache.sshd.sftp.common.SftpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SftpTransfer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SftpTransfer.class);
    private static final int DEAFLUAT_PORT = 22;
    private SftpClient channelSftp = null;
    private ClientSession session = null;
    private SftpTransferProgress sftpTansferProgress = new SftpTransferProgress();
    private int count = 0;
    private int timeout = 60;
    private int retry = 3;
    private SshClient sshClient;

    public SftpTransfer() {
    }

    public SftpTransfer(String serverIp, User user) {
        SftpAccount account = new SftpAccount(serverIp, user, 22);
        this.createSession(account);
    }

    public static void downloadFile(String localPath, String serverFilePath, SftpClient sftp) throws IOException {
        Path localFilePath = Paths.get(localPath, new String[0]);
        if (new File(localPath).isDirectory()) {
            localFilePath = Paths.get(localPath, new File(serverFilePath).getName());
        }
        try (InputStream inputStream = sftp.read(serverFilePath);){
            Files.copy(inputStream, localFilePath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public synchronized void setRetry(int retry) {
        this.retry = retry;
    }

    public synchronized void setTimeout(int tm) {
        this.timeout = tm;
    }

    public synchronized void closeConnection() {
        try {
            if (this.channelSftp != null) {
                try {
                    this.channelSftp.close();
                }
                catch (Exception e) {
                    LOGGER.error("sftp channel quit failed." + e.getMessage(), (Throwable)e);
                }
            }
            if (null != this.session) {
                try {
                    this.session.close();
                }
                catch (Exception e) {
                    LOGGER.error("session disconnect failed." + e.getMessage(), (Throwable)e);
                }
            }
            if (this.sshClient != null) {
                this.sshClient.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("Close Sftp Error!", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Iterable<SftpClient.DirEntry> ls(String remotepath) {
        if (this.channelSftp == null) {
            throw new IsmException(1073949187L);
        }
        try (SftpClient.CloseableHandle handle = this.channelSftp.open(remotepath);){
            Iterable iterable = this.channelSftp.listDir((SftpClient.Handle)handle);
            return iterable;
        }
        catch (IOException e) {
            throw new IsmException(1073949187L, (Throwable)e);
        }
    }

    public int getCurrentStep() {
        long fileSize = this.sftpTansferProgress.getFileSize();
        long finishSize = this.sftpTansferProgress.getFinishSize();
        if (0L == fileSize) {
            return 0;
        }
        int currentStep = (int)(finishSize * 100L / fileSize);
        long tmp = finishSize * 100L % fileSize;
        if (tmp != 0L) {
            ++currentStep;
        }
        if (currentStep > 100) {
            currentStep = 100;
        }
        return currentStep;
    }

    public void transferFileFromDevice(String arrayId, String serverPath, String localPath) throws IsmException {
        int index;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("transferFileFromDevice,serverPath:*****;localPath" + localPath);
        }
        if (-1 == (index = serverPath.indexOf(":/"))) {
            throw new IsmException(-1L);
        }
        String serverRelativePath = serverPath.substring(index + 1);
        this.transferFile(localPath, serverRelativePath);
        LOGGER.info("SftpTransfer.transferFile over get *****");
        LOGGER.info("transferFileFromDevice over.");
    }

    private synchronized void transferFile(String localPath, String serverRelativePath) {
        if (this.channelSftp == null) {
            throw new IsmException(1073949187L);
        }
        try (InputStream in = this.channelSftp.read(serverRelativePath);){
            FileUtils.copyToFile((InputStream)in, (File)new File(localPath));
            this.sftpTansferProgress.end();
        }
        catch (IOException e) {
            LOGGER.error("transferFile error ! sererPath:***** localPath:" + localPath, (Throwable)e);
            throw new IsmException(1073949187L, (Throwable)e);
        }
    }

    public void transferFileFromDevice(String arrayId, String serverPath, String localPath, User user) throws IsmException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("transferFileFromDevice,serverPath:******;localPath" + localPath);
        }
        int index = serverPath.indexOf(":/");
        String serverIp = serverPath.substring(0, index);
        String serverRelativePath = serverPath.substring(index + 1);
        try {
            SftpAccount account = new SftpAccount(serverIp, user, 22);
            this.transferFile(account, serverRelativePath, localPath, true);
        }
        catch (IsmException e) {
            LOGGER.error("Sftp Fail. serverIp:" + serverIp);
            throw e;
        }
        finally {
            this.closeConnection();
        }
        LOGGER.info("transferFileFromDevice over.");
    }

    public void transferFileToDevice(String arrayId, String localPath, String serverPath, User user) throws IsmException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("transferFileToDevice,serverPath:*****;localPath:" + localPath);
        }
        int index = serverPath.indexOf(":/");
        String serverIp = serverPath.substring(0, index);
        String serverRelativePath = serverPath.substring(index + 1);
        try {
            SftpAccount account = new SftpAccount(serverIp, user, 22);
            this.transferFile(account, serverRelativePath, localPath, false);
        }
        catch (IsmException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("transferFileToDevice error:" + user);
            }
            throw e;
        }
        finally {
            this.closeConnection();
        }
        LOGGER.info("transferFileToDevice over.");
    }

    private synchronized void transferFile(SftpAccount account, String serverRelativePath, String localPath, boolean getOrPut) throws IsmException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("SftpTransfer transferFile.the parameter ---account:" + account);
        }
        try {
            this.createSession(account);
            if (getOrPut) {
                this.transferFile(localPath, serverRelativePath);
            } else {
                this.uploadFile(serverRelativePath, localPath);
            }
        }
        catch (IsmException e) {
            LOGGER.error("Sftp Fail :" + account, (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("transferFile error ! sererPath:***** localPath:" + localPath + " getOrPut:" + getOrPut, (Throwable)e);
            throw new IsmException(1073949187L, (Throwable)e);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("SftpTransfer.transferFile " + (getOrPut ? "get " : "put ") + "***** over");
        }
    }

    private void uploadFile(String serverRelativePath, String localPath) throws IOException {
        SftpTransfer.uploadFile(serverRelativePath, localPath, this.channelSftp);
    }

    public static void uploadFile(String serverPath, String localPath, SftpClient sftp) throws IOException {
        String serverFile = "";
        try {
            serverFile = sftp.lstat(serverPath).isDirectory() ? serverPath + "/" + new File(localPath).getName() : serverPath;
        }
        catch (SftpException e) {
            LOGGER.error("ism ls server file path error. server path is file.", (Throwable)e);
            serverFile = serverPath;
        }
        SftpTransfer.uploadFileViaChannel(sftp, serverFile, Paths.get(localPath, new String[0]));
    }

    private static void uploadFileViaChannel(SftpClient sftpClient, String remoteFile, Path localFile) throws IOException {
        block26: {
            try {
                sftpClient.remove(remoteFile);
            }
            catch (SftpException exception) {
                if (exception.getStatus() == 2) break block26;
                throw exception;
            }
        }
        try (FileChannel remoteChannel = sftpClient.openRemoteFileChannel(remoteFile, new SftpClient.OpenMode[]{SftpClient.OpenMode.Write, SftpClient.OpenMode.Create});
             FileChannel localChannel = FileChannel.open(localFile, new OpenOption[0]);){
            Stopwatch watch = Stopwatch.createStarted();
            remoteChannel.transferFrom(localChannel, 0L, Files.size(localFile));
            LOGGER.info("sftp upload file {} finished, cost: {}", (Object)localFile, (Object)watch.stop());
        }
    }

    private synchronized void createSession(SftpAccount account) throws IsmException {
        block5: {
            if (null != this.session && this.session.isAuthenticated()) {
                this.count = 0;
                return;
            }
            try {
                this.sshClient = SshClient.setUpDefaultClient();
                CoreModuleProperties.NIO_WORKERS.set((PropertyResolver)this.sshClient, (Object)1);
                this.session = ((ConnectFuture)this.sshClient.connect(account.getUserName(), account.getIpAddress(), account.getPort()).verify(new CancelOption[0])).getClientSession();
                this.session.addPasswordIdentity(account.getPassword());
                CoreModuleProperties.IDLE_TIMEOUT.set((PropertyResolver)this.session, (Object)Duration.ofMinutes(30L));
                this.session.auth().verify(new CancelOption[0]);
                this.channelSftp = SftpClientFactory.instance().createSftpClient(this.session);
            }
            catch (Exception e) {
                ++this.count;
                LOGGER.error("try to connect to the sftp server failed, the " + this.count + "th time.", (Throwable)e);
                if (this.count < this.retry) {
                    this.createSession(account);
                }
                if (this.retry != this.count) break block5;
                if (e.getMessage().equals("Auth fail") || e.getMessage().equals("Auth cancel")) {
                    throw new IsmException(1073949186L, (Throwable)e);
                }
                throw new IsmException(1073949187L, (Throwable)e);
            }
        }
    }

    public void s2300TransferFileFromDevice(String arrayId, String serverPath, String localPath, User user) throws IsmException {
        this.transferFileFromDevice(arrayId, serverPath, localPath, user);
    }
}

