/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.connmanage.service;

import com.huawei.ism.common.bean.User;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.connection.ConnectionManager;
import com.huawei.ism.connection.IConnection;
import com.huawei.ism.connection.SocketPool;
import com.huawei.ism.connection.TLVConnection;
import com.huawei.ism.connection.TLVConnectionImpl;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.model.MOType;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tlv.EnumDefine;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tlv.TLVMOMsg;
import com.huawei.ism.tlv.TLVUtils;
import com.huawei.ism.tlv.bean.DataPackage;
import com.huawei.ism.tlv.bean.Param;
import com.huawei.ism.tlv.bean.Record;
import com.huawei.ism.tlv.lang.IsmInteger;
import com.huawei.ism.tlv.lang.UnsignedInt32;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.pwdSecurityResMgr.PwdSecurityResMgr;
import com.huawei.ism.tool.framework.platform.pwdSecurityResMgr.PwdSecurityType;
import com.huawei.ism.tool.framework.platform.pwdSecurityResMgr.PwdSecurityUserScene;
import com.huawei.ism.tool.framework.platform.task.ITask;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.common.IConnectionManage;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.DeviceType;
import com.huawei.ism.tool.framework.pubservice.exception.ConnectionException;
import com.huawei.ism.tool.framework.pubservice.exception.DeviceStatusException;
import com.huawei.ism.tool.framework.pubservice.exception.UserStatusExpection;
import com.huawei.sftp.SftpTransfer;
import java.io.File;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManageImpl
implements IConnectionManage {
    private static final Logger log = LoggerFactory.getLogger(ConnectionManageImpl.class);
    private static final int SOCKET_NUM = 1;
    private static final long ERROR_CODE_WRONG_USER = 1077949057L;
    private static final long ERROR_CODE_PASSWORD_ERR = 1077949061L;
    private static final long ERROR_CODE_PASSWORDNEW_ERR = 1077987870L;
    private static final long ERROR_CODE_USERLOCK_ERR = 1077987871L;
    private static final int CONNECT_THREAD_NUM = 10;
    private static final int POWERON_JUDGE_TIMEOUT = 60;
    private static Map<String, String> deviceUserIdMap = new ConcurrentHashMap<String, String>();

    public ConnectionManageImpl() {
        ResourceManager.init();
        ConnectionManager.getInstance().registerConnectionClass(DeviceType.ALL.toString(), TLVConnectionImpl.class);
    }

    public TLVConnection tlvLogin(DevNode node) throws ConnectionException {
        return this.tlvLogin(node, true, true);
    }

    public TLVConnection getTLVConnection(DevNode node) throws ConnectionException {
        String devId = node.getDeviceSerialNumber();
        TLVConnection conn = (TLVConnection)ConnectionManager.getInstance().getConnection(devId);
        if (null != conn && IConnection.ConnectionState.Connected.equals((Object)conn.getConnectionState())) {
            return conn;
        }
        return this.tlvLogin(node);
    }

    @Override
    public void closeTLVConnetcion(Object connObj) {
        if (null == connObj || !(connObj instanceof IConnection)) {
            return;
        }
        try {
            ((IConnection)connObj).close();
        }
        catch (Exception e) {
            log.error("Not close connection because connection is not connected.");
        }
        deviceUserIdMap.remove(((TLVConnectionImpl)connObj).getDeviceID());
    }

    @Override
    public Object getTLVConnWithoutSn(DevNode node) throws ConnectionException {
        return this.tlvLogin(node, false, false);
    }

    private void initConnManager(DevNode node, ConnectResult loginSuccResult) {
        TLVConnection conn = loginSuccResult.tlvConn;
        String devID = loginSuccResult.tlvConn.getDeviceID();
        String devIp = loginSuccResult.curLoginIp;
        Socket socket = loginSuccResult.socket;
        String port = String.valueOf(node.getTlvPort());
        String useSSL = String.valueOf(conn.getProtocalType());
        SocketPool socketPool = new SocketPool(devIp, Integer.valueOf(port).intValue(), Integer.valueOf(useSSL).intValue(), 1, socket);
        ConnectionManager.getInstance().setSocketPoolByDeviceID(devID, socketPool);
        this.addLocalIp(node);
        List<String> loginIpList = node.getIpList();
        for (String ip : loginIpList) {
            ConnectionManager.getInstance().addDeviceIP(devID, ip);
        }
        node.setActiveIp(devIp);
        ConnectionManager.getInstance().setConnection(devID, (IConnection)conn);
        if (log.isInfoEnabled()) {
            log.info("Socket pool inited for device:" + devID);
        }
    }

    private static Properties buildConnProperties(DevNode node) {
        String userName = node.getLoginUser().getUserName();
        String userPassword = node.getLoginUser().getPassword();
        String userScop = String.valueOf(User.USER_SCOPE.LOCAL.getValue());
        String port = String.valueOf(node.getTlvPort());
        String useSSL = String.valueOf(0);
        String tlvSocket = node.getTlvSocketType();
        if (StringUtils.isNULLStr(tlvSocket)) {
            if (ApplicationContext.getInstance().isDeviceUsingSSL()) {
                useSSL = String.valueOf(1);
            }
        } else if ("SSL".equalsIgnoreCase(tlvSocket)) {
            useSSL = String.valueOf(1);
        }
        Properties properties = new Properties();
        properties.setProperty("USER_NAME", userName);
        properties.setProperty("USER_WORD", userPassword);
        properties.setProperty("USERSCOPE", userScop);
        properties.setProperty("IP_OR_NAME", node.getIp());
        properties.setProperty("PORT", port);
        properties.setProperty("CONN_PROTOCOL", useSSL);
        return properties;
    }

    private User doLogin(Socket socket, TLVConnection conn) throws IsmException {
        User retUser;
        try {
            retUser = conn.authenticate(socket);
        }
        catch (IsmException e) {
            log.error(e.getErrorMessage(), (Throwable)e);
            throw e;
        }
        return retUser;
    }

    private String getDeviceID(TLVConnection conn, Socket socket) {
        try {
            Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), (IsmInteger)new UnsignedInt32(MOType.SYSTEM.getValue()));
            Param moidParam = new Param(TLVMOMsg.ID.getParamIndex(), TLVMOMsg.ID.getParamType(), "");
            DataPackage sendData = TLVUtils.param2DP((long)0xD00000000L, (String)conn.getSessionKey(), (List)TLVUtils.paramList((Param[])new Param[]{moTypeParam, moidParam}));
            DataPackage dataPakage = conn.sendAndReceive(socket, sendData, 30);
            Record record = (Record)dataPakage.getRecordset().get(0);
            return record.getParamStrValue(TLV.SYSTEM.ID.getParamIndex());
        }
        catch (IsmException ie) {
            log.error("Auth Connection Failed: Get device id failed!", (Throwable)ie);
            String msg = ResourceUtil.getString("connection.failed.id");
            throw new IsmException(msg, (Throwable)ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDevicePowerOnErr(TLVConnection conn, DevNode node) {
        log.info("Enter into the power on method. ");
        HashMap<String, Boolean> ipResultMap = new HashMap<String, Boolean>();
        ExecutorService executor = Executors.newFixedThreadPool(10);
        this.addLocalIp(node);
        List<String> ipList = node.getIpList();
        for (String ip : ipList) {
            AsyncExcutor.submit((Runnable)new Thread(new PoweronJudgeTask(ipResultMap, executor, conn, node, ip, this)));
        }
        Iterator iterator = ipResultMap;
        synchronized (iterator) {
            while (ipResultMap.size() < ipList.size()) {
                try {
                    ipResultMap.wait();
                }
                catch (InterruptedException e) {
                    log.error(e.toString(), (Throwable)e);
                }
            }
        }
        executor.shutdown();
        for (Map.Entry entry : ipResultMap.entrySet()) {
            String ip = (String)entry.getKey();
            Boolean hasPoweronFailed = (Boolean)entry.getValue();
            if (!hasPoweronFailed.booleanValue()) continue;
            if (log.isInfoEnabled()) {
                log.info("Poweron failed at ip: " + ip);
            }
            return true;
        }
        return false;
    }

    private boolean existPowerFile(DevNode node, String ip) {
        boolean powerFailed = false;
        String filePath = "/home/permitdir/log/runlog/sys_power_on_record";
        SftpTransfer sftpTransfer = new SftpTransfer();
        if (log.isInfoEnabled()) {
            log.info("start to sftp transfer from ip: " + ip);
        }
        try {
            sftpTransfer.transferFileFromDevice(null, ip + ":" + filePath, ApplicationContext.getInstance().getTmpPath() + File.separator + "sys_power_on_record", new User(node.getLoginUser().getUserName(), node.getLoginUser().getPassword()));
            powerFailed = true;
            if (log.isInfoEnabled()) {
                log.info("success to transfer file from ip: " + ip);
            }
        }
        catch (IsmException e) {
            log.error(e.getErrorMessage(), (Throwable)e);
        }
        catch (StringIndexOutOfBoundsException e1) {
            log.error("SFTP error: " + e1.getMessage());
        }
        return powerFailed;
    }

    private boolean isAuthenticateFail(IsmException exception) {
        long errorId = exception.getErrorId();
        boolean isAuthFail = errorId == 16797700L || errorId == 16806404L || errorId == 0x5000504L || errorId == 83887382L;
        boolean isAuthFail11 = isAuthFail || errorId == 1077949069L || errorId == 1077949057L || errorId == 1077949061L || errorId == 1077949070L;
        return isAuthFail11 || errorId == 1077987870L || errorId == 1077987871L;
    }

    private TLVConnection tlvLogin(DevNode node, boolean needSn, boolean checkUserStatus) throws ConnectionException {
        ApplicationContext.getInstance().addDevSslVersion(node.getIp(), node.getSslVersion());
        this.addLocalIp(node);
        ConnectResult loginSuccResult = this.buildConnectResult(node);
        if (loginSuccResult == null) {
            throw new ConnectionException(ResourceUtil.getString("connection.failed.busy"));
        }
        String curLoginIp = loginSuccResult.curLoginIp;
        boolean logSuccess = this.loginToDev(needSn, checkUserStatus, loginSuccResult, curLoginIp);
        this.checkLoginResult(node, loginSuccResult, logSuccess);
        if (needSn) {
            this.initConnManager(node, loginSuccResult);
            if (log.isInfoEnabled()) {
                log.info("Success to update connection manager using: " + loginSuccResult.tlvConn.getDeviceID());
            }
        }
        log.info("Success to get tlv connection.");
        return loginSuccResult.tlvConn;
    }

    private boolean loginToDev(boolean needSn, boolean checkUserStatus, ConnectResult loginSuccResult, String curLoginIp) {
        boolean logSuccess;
        block6: {
            logSuccess = false;
            try {
                User user = this.doLogin(loginSuccResult.socket, loginSuccResult.tlvConn);
                this.checkUserStatus(checkUserStatus, loginSuccResult.tlvConn, user);
                if (log.isInfoEnabled()) {
                    log.info("Success to authenticate on ip: " + curLoginIp);
                }
                logSuccess = true;
                if (needSn) {
                    String devID = this.getDeviceID(loginSuccResult.tlvConn, loginSuccResult.socket);
                    loginSuccResult.tlvConn.setDeviceID(devID);
                    deviceUserIdMap.put(devID, user.getID());
                    if (log.isInfoEnabled()) {
                        log.info("Success to get device id on ip: " + loginSuccResult.curLoginIp);
                    }
                }
            }
            catch (UserStatusExpection e) {
                log.error(e.toString(), (Throwable)e);
                throw e;
            }
            catch (IsmException e) {
                loginSuccResult.errMsg = e.getErrorMessage();
                log.error(loginSuccResult.errMsg, (Throwable)e);
                if (!this.isAuthenticateFail(e)) break block6;
                log.error("Auth failed to ip: " + curLoginIp);
                throw new ConnectionException(loginSuccResult.errMsg, e);
            }
        }
        return logSuccess;
    }

    private void checkLoginResult(DevNode node, ConnectResult loginSuccResult, boolean logSuccess) {
        if (!logSuccess) {
            if (StringUtils.isNULLStr(loginSuccResult.errMsg)) {
                loginSuccResult.errMsg = ResourceUtil.getString("connection.failed.busy");
            }
            if (this.isDevicePowerOnErr(loginSuccResult.tlvConn, node)) {
                throw new DeviceStatusException(loginSuccResult.errMsg);
            }
            throw new ConnectionException(loginSuccResult.errMsg);
        }
    }

    public void addLocalIp(DevNode node) {
        List<String> loginIpList = node.getIpList();
        if (!node.isIpListAreInnerIp() && !loginIpList.contains(node.getIp())) {
            loginIpList.add(node.getIp());
        }
    }

    private ConnectResult buildConnectResult(DevNode node) {
        log.info("about to build connection for dev {} of ip list {}", (Object)node.getIp(), node.getIpList());
        return node.getIpList().stream().map(ip -> this.tryBuildConnection((String)ip, node)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Nullable
    private ConnectResult tryBuildConnection(String ip, DevNode node) {
        try {
            log.info("try to build connection for {}", (Object)ip);
            Properties properties = ConnectionManageImpl.buildConnProperties(node);
            properties.setProperty("IP_OR_NAME", ip);
            TLVConnection conn = (TLVConnection)ConnectionManager.getInstance().buildConnection(DeviceType.ALL.toString(), properties);
            conn.init(properties);
            Socket socket = conn.getSocket();
            if (socket != null && socket.isConnected()) {
                log.info("success to build connection for {}", (Object)ip);
                return new ConnectResult().setTlvConn(conn).setCurLoginIp(ip).setSocket(socket);
            }
        }
        catch (Exception e) {
            log.error("try to build connection for {} error", (Object)ip, (Object)e);
        }
        return null;
    }

    private void checkUserStatus(boolean checkUserStatus, TLVConnection conn, User user) throws UserStatusExpection {
        if (checkUserStatus && user != null && !this.checkUserStatus(user.getStatus())) {
            if (log.isInfoEnabled()) {
                log.info("user status:" + user.getStatus().name());
            }
            User.Status userStatus = user.getStatus();
            String msg = "";
            if (User.Status.Pwd_initial.name().equals(userStatus.name())) {
                msg = PwdSecurityResMgr.getInstance().getDesc(PwdSecurityType.INIT_PWD_NOT_CHANGE, PwdSecurityUserScene.Tool);
            }
            if (User.Status.Pwd_expired.name().equals(userStatus.name())) {
                msg = PwdSecurityResMgr.getInstance().getDesc(PwdSecurityType.PWD_EXPIRED, PwdSecurityUserScene.Tool);
            }
            if (User.Status.Pwd_expiring.name().equals(userStatus.name())) {
                msg = PwdSecurityResMgr.getInstance().getDesc(PwdSecurityType.PWD_WILL_EXPIRE, PwdSecurityUserScene.Tool);
            }
            if (User.Status.Pwd_unSafe.name().equals(userStatus.name())) {
                msg = PwdSecurityResMgr.getInstance().getDesc(PwdSecurityType.UN_SAFE, PwdSecurityUserScene.Tool);
            }
            this.closeTLVConnetcion(conn);
            throw new UserStatusExpection(msg, user.getID(), userStatus.name());
        }
    }

    private boolean checkUserStatus(User.Status userStatus) {
        return !User.Status.Pwd_expired.equals((Object)userStatus) && !User.Status.Pwd_initial.equals((Object)userStatus) && !User.Status.Pwd_expiring.equals((Object)userStatus) && !User.Status.Pwd_unSafe.equals((Object)userStatus);
    }

    @Override
    public String getUserIdByDeviceId(String deviceId) {
        return deviceUserIdMap.get(deviceId);
    }

    private class PoweronJudgeFutureTask
    implements Callable<Boolean> {
        private TLVConnection tlvConn;
        private String curIp;
        private DevNode devNode;

        public PoweronJudgeFutureTask(TLVConnection tlvConn, String curIp, DevNode devNode) {
            this.tlvConn = tlvConn;
            this.curIp = curIp;
            this.devNode = devNode;
        }

        @Override
        public Boolean call() {
            String oldThreadName = Thread.currentThread().getName();
            Thread.currentThread().setName("PoweronJudgeThread_" + this.curIp);
            List recordList = null;
            if (null != this.tlvConn && null != this.tlvConn.getSessionKey()) {
                try {
                    recordList = this.tlvConn.bacthNext(55847747706L, new ArrayList(), 30);
                }
                catch (IsmException e) {
                    log.error("Ism exception in power on method.", (Throwable)e);
                    return false;
                }
                catch (Exception e) {
                    log.error(e.toString(), (Throwable)e);
                    return false;
                }
            }
            if (recordList != null) {
                Record record = (Record)recordList.get(0);
                int status = record.getParamIntValue(((Param)record.getParams().get(0)).getIndex()).intValue();
                if (log.isInfoEnabled()) {
                    log.info("The sys status is: " + status);
                }
                if ((status == EnumDefine.SYS_STATUS_E.ABNORMAL.getValue() || status == EnumDefine.SYS_STATUS_E.SAFE_MODE.getValue()) && ConnectionManageImpl.this.existPowerFile(this.devNode, this.curIp)) {
                    return true;
                }
            } else if (ConnectionManageImpl.this.existPowerFile(this.devNode, this.curIp)) {
                return true;
            }
            Thread.currentThread().setName(oldThreadName);
            return false;
        }
    }

    private static final class PoweronJudgeTask
    implements Runnable {
        private final Map<String, Boolean> ipResultMap;
        private ExecutorService executor;
        private TLVConnection tlvConn;
        private DevNode devNode;
        private String curIp;
        private ConnectionManageImpl connectionManageImpl;

        public PoweronJudgeTask(Map<String, Boolean> ipResultMap, ExecutorService executor, TLVConnection tlvConn, DevNode devNode, String curIp, ConnectionManageImpl connectionManageImpl) {
            this.ipResultMap = ipResultMap;
            this.executor = executor;
            this.tlvConn = tlvConn;
            this.devNode = devNode;
            this.curIp = curIp;
            this.connectionManageImpl = connectionManageImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConnectionManageImpl connectionManageImpl = this.connectionManageImpl;
            connectionManageImpl.getClass();
            Future<Boolean> future = this.executor.submit(connectionManageImpl.new PoweronJudgeFutureTask(this.tlvConn, this.curIp, this.devNode));
            Boolean hasPoweronFailed = false;
            try {
                hasPoweronFailed = future.get(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.error("This future was interrupted by other thread.", (Throwable)e);
            }
            catch (ExecutionException e) {
                log.error("Future execution exception.", (Throwable)e);
            }
            catch (TimeoutException e) {
                log.error("Future execute timeout in 60s", (Throwable)e);
            }
            finally {
                Map<String, Boolean> e = this.ipResultMap;
                synchronized (e) {
                    this.ipResultMap.put(this.curIp, hasPoweronFailed);
                    this.ipResultMap.notifyAll();
                }
            }
        }
    }

    private static final class ConnectResult
    implements ITask.ITaskResult {
        private Socket socket = null;
        private String curLoginIp = "";
        private TLVConnection tlvConn = null;
        private String errMsg = "";

        private ConnectResult() {
        }

        @Override
        public boolean isTaskSuccess() {
            return this.socket != null && this.socket.isConnected();
        }

        public ConnectResult setSocket(Socket socket) {
            this.socket = socket;
            return this;
        }

        public ConnectResult setCurLoginIp(String curLoginIp) {
            this.curLoginIp = curLoginIp;
            return this;
        }

        public ConnectResult setTlvConn(TLVConnection tlvConn) {
            this.tlvConn = tlvConn;
            return this;
        }

        public ConnectResult setErrMsg(String errMsg) {
            this.errMsg = errMsg;
            return this;
        }
    }
}

