/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.component;

import com.huawei.ism.tool.base.ui.action.HyperLinkAction;
import com.huawei.ism.tool.base.ui.action.ToolAction;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HyperLinkPane
extends JEditorPane {
    private static final long serialVersionUID = 1L;
    private Map<String, HyperLinkAction> actionMap = new HashMap<String, HyperLinkAction>();

    public HyperLinkPane(String htmlText) {
        this.setContentType("text/html;charset=utf-8");
        this.setEditable(false);
        this.setFocusable(false);
        this.setEditable(false);
        this.setOpaque(false);
        htmlText = htmlText.replaceAll("(<a href=((?!</a>).)*</a>)", "<font color='#0000FF' style='text-decoration:none;' face='\u5b8b\u4f53&&arial' size='3'>$0</font>");
        this.setText("<font color='#333333'  size='3'>" + htmlText + "</font>");
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent event) {
                HyperLinkPane.this.processLinkClick(event, HyperLinkPane.this.actionMap);
            }
        });
    }

    private void processLinkClick(HyperlinkEvent event, Map<String, HyperLinkAction> hyperActionMap) {
        if (HyperlinkEvent.EventType.ACTIVATED != event.getEventType()) {
            return;
        }
        String href = event.getDescription();
        ToolAction action = hyperActionMap.get(href);
        if (null != action) {
            action.actionPerformed(null);
        }
    }

    public void addHyperLinkActions(HyperLinkAction ... actions) {
        for (HyperLinkAction ac : actions) {
            this.actionMap.put(ac.getURL(), ac);
        }
    }
}

