/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.task;

import com.huawei.ism.tool.base.ui.task.ServiceTask;
import com.huawei.ism.tool.base.ui.task.TaskResult;
import com.huawei.ism.tool.base.ui.task.ThreadListener;
import com.huawei.ism.tool.base.ui.task.UIListener;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceTaskExecutor
implements ThreadListener {
    private static final int INTERVAL_TIME = 2;
    private static final int TIMEOUT = 52;
    private static UIListener listener = new UIListener();
    private ProgressDialog progressDialog = null;
    private volatile TaskResult result = null;
    private boolean isNeedWait = true;
    private volatile boolean needCloseProgressDialog = false;
    private volatile boolean needShowProgressDialog = true;
    private final Object lock = new Object();
    private int waitTime = 300000;

    public ServiceTaskExecutor(ProgressDialog progressDialog) {
        long currentTime = System.currentTimeMillis();
        long lastTime = listener.getUILastOpertionTime();
        if ((currentTime - lastTime) / 1000L < 2L) {
            this.progressDialog = progressDialog;
        }
    }

    public TaskResult execute(ServiceTask task) {
        this.result = null;
        this.startTask(task);
        return this.result;
    }

    public void setNeedWait(boolean needwait) {
        this.isNeedWait = needwait;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void threadFinished(TaskResult executeResult) {
        this.setResult(executeResult);
        if (null != this.progressDialog) {
            Object object = this.lock;
            synchronized (object) {
                this.needShowProgressDialog = false;
                this.lock.notifyAll();
            }
            if (this.needCloseProgressDialog) {
                this.progressDialog.dispose();
            }
            listener.setTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTask(ServiceTask task) {
        this.needShowProgressDialog = true;
        this.needCloseProgressDialog = false;
        task.addListener(this);
        task.start();
        boolean needWait = this.isNeedWait;
        if (null != this.progressDialog) {
            Object object = this.lock;
            synchronized (object) {
                this.waitForBusyDialog();
                this.needCloseProgressDialog = this.needShowProgressDialog;
            }
            if (this.needCloseProgressDialog) {
                this.progressDialog.setVisible(true);
                needWait = false;
            }
        }
        if (needWait) {
            try {
                task.join();
            }
            catch (InterruptedException e) {
                Logger logger = LoggerFactory.getLogger(this.getClass());
                logger.error(e.getMessage(), (Throwable)e);
                TaskResult taskResult = new TaskResult();
                taskResult.setResult(TaskResult.Result.FAILED);
                this.setResult(taskResult);
            }
        }
    }

    private void waitForBusyDialog() {
        try {
            for (int i = 0; i < 1; ++i) {
                this.lock.wait(52L);
            }
        }
        catch (InterruptedException e) {
            LoggerFactory.getLogger(this.getClass()).error("Interrupted exception!");
        }
    }

    private synchronized void setResult(TaskResult result) {
        if (null == result) {
            return;
        }
        if (null == this.result) {
            this.result = result;
        }
    }
}

