/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.adapter;

import com.huawei.ism.tool.base.scene.utils.SceneDataExchange;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.StorageInfo;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.tool.upgradeevalu.adapter.EvaluationFlow;
import com.huawei.ism.tool.upgradeevalu.adapter.RuleItem;
import com.huawei.ism.tool.upgradeevalu.adapter.worktaker.IAnalyzeMethod;
import com.huawei.ism.tool.upgradeevalu.adapter.worktaker.IFlowAdapter;
import com.huawei.ism.tool.upgradeevalu.adapter.worktaker.IRuleLogic;
import com.huawei.ism.tool.upgradeevalu.adapter.worktaker.impl.FlowAdapter;
import com.huawei.ism.tool.upgradeevalu.adapter.worktaker.impl.RuleLogic;
import com.huawei.ism.tool.upgradeevalu.entity.HostEvalNode;
import com.huawei.ism.tool.upgradeevalu.enums.ItCompatFeautureEnum;
import com.huawei.ism.tool.upgradeevalu.enums.ItEvaluationType;
import com.huawei.ism.tool.upgradeevalu.enums.ItUpgradeKeyEnum;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.model.EvalItemResult;
import com.huawei.ism.tool.upgradeevalu.model.EvalTaskResult;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.parser.XmlItemParser;
import com.huawei.ism.tool.upgradeevalu.report.CompatibilityResourceUtils;
import com.huawei.ism.tool.upgradeevalu.task.EvaluationEngine;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalContext;
import com.huawei.ism.tool.upgradeevalu.utils.CompatibilityContants;
import com.huawei.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class EvalRuleManager
implements IAnalyzeMethod {
    public static final String EEROR_MESSAGE = "err_msg";
    public static final String GRABTHREADHEAD = "GrabThread-";
    public static final int THREAD_LIMIT = 10;
    public static final String PYDEFAULTMETHOD = "execute";
    public static final String HOST_NAME_EN = "host";
    public static final String HOST_NAME_CH = "\u4e3b\u673a";
    public static final String DATABASE_NAME_EN = "DB";
    public static final String DATABASE_NAME_CH = "\u6570\u636e\u5e93";
    public static final String SWITCH_NAME_EN = "Switch";
    public static final String SWITCH_NAME_CH = "\u4ea4\u6362\u673a";
    private static final Logger LOGGER = Logger.getLogger(EvalRuleManager.class);
    private IFlowAdapter flowAdapter;
    private IRuleLogic ruleLogic = RuleLogic.getInstance();
    private Map<ItDeviceType, EvaluationFlow> evaluationTypeFlow;
    private List<Map<String, String>> resultList = Collections.synchronizedList(new ArrayList());
    private List<RuleItem> resultItemList;

    public EvalRuleManager() {
        this.flowAdapter = FlowAdapter.getInstance();
        this.initEvaluationFlowMapByXml();
    }

    private void initEvaluationFlowMapByXml() {
        this.setEvaluationTypeFlow(XmlItemParser.getInstance().createEvaluationFlowByXml());
    }

    @Override
    public void handleRules(RuleItem ruleItem, EvalItemResult evalItemResult, JythonExecuter jythonExecuter) throws ToolException {
        ItemInfo itemInfo = evalItemResult.getItemInfo();
        switch (ruleItem.getEvaluationType()) {
            case COMPATIBILITY_EVAL: {
                this.evalCompatibility(ruleItem, itemInfo, evalItemResult);
                break;
            }
            case UPGRADE_EVAL: {
                this.evalThroughScript(ruleItem, evalItemResult, jythonExecuter, itemInfo);
                break;
            }
            default: {
                LOGGER.warn("no eval type mached:" + (Object)((Object)ruleItem.getEvaluationType()) + " IP: " + itemInfo.getIp());
            }
        }
    }

    private void evalThroughScript(RuleItem ruleItem, EvalItemResult evalItemResult, JythonExecuter jythonExecuter, ItemInfo itemInfo) throws ToolException {
        LOGGER.info(String.format(Locale.ENGLISH, "Start Rules handling...%s", ItEvaluationType.UPGRADE_EVAL.toString()));
        ItUpgradeKeyEnum upgradeEnum = ItUpgradeKeyEnum.getUpgradeTypeByString(ruleItem.getItemTitle());
        EvalFeatureResult evalResult = new EvalFeatureResult();
        if (ruleItem.isUseScriptEval()) {
            evalResult = this.ruleLogic.getRuleLogicByXml(jythonExecuter, evalItemResult.getItemInfo(), ruleItem);
        }
        if (ItUpgradeKeyEnum.MULTI_PATH_STAT.equals((Object)upgradeEnum)) {
            this.evalMultiPath(itemInfo, evalResult);
        } else {
            Map<String, Object> evalContext = this.prepareContext(ruleItem, itemInfo, evalItemResult);
            evalResult = EvaluationEngine.executeEval(evalContext, evalResult);
            LOGGER.info(String.format(Locale.ENGLISH, "eval resault:%s", evalResult));
        }
        this.handleScriptEvalResult(ruleItem, evalResult);
        this.addCheckMethodCriterion2Result(evalResult, itemInfo, (Object)upgradeEnum);
        this.addOriginalInfo2Result(evalResult, itemInfo, (Object)upgradeEnum, evalItemResult);
        evalItemResult.getFeatureResultList().add(evalResult);
        LOGGER.info(String.format(Locale.ENGLISH, "End Rules handling...%s", ItEvaluationType.UPGRADE_EVAL.toString()));
    }

    private void addCheckMethodCriterion2Result(EvalFeatureResult evalResult, ItemInfo itemInfo, Object upgradeEnum) {
        String devType = itemInfo.getDevInfo();
        String osName = itemInfo.getOsName();
        String osFlag = null == osName ? "" : osName.split("\\s+")[0];
        String checkMethodKey = "eval.feature.check.method." + upgradeEnum;
        String checkCriterionKey = "eval.feature.check.criterion." + upgradeEnum;
        String suggestKey = "eval.feature.suggest." + upgradeEnum;
        if (ItCompatFeautureEnum.SWITCH_FEATURE.equals(upgradeEnum)) {
            checkMethodKey = checkMethodKey + "." + osFlag;
            checkCriterionKey = checkCriterionKey + "." + osFlag;
            suggestKey = suggestKey + "." + osFlag;
        } else if (ItCompatFeautureEnum.ORACLE_TIME_OUT.equals(upgradeEnum)) {
            String dbHostType;
            Map<DevNode, DevNode> hostMappedDb = HostEvalContext.getHostMappedDb();
            DevNode devNode = null != hostMappedDb ? hostMappedDb.keySet().toArray(new DevNode[hostMappedDb.size()])[0] : null;
            String string = dbHostType = null != devNode ? devNode.getDeviceName() : "Linux";
            if ("Aix".equalsIgnoreCase(dbHostType)) {
                dbHostType = dbHostType.toUpperCase(Locale.ENGLISH);
            }
            checkMethodKey = checkMethodKey + "." + dbHostType;
            checkCriterionKey = checkCriterionKey + "." + dbHostType;
            suggestKey = suggestKey + "." + dbHostType;
        } else {
            checkMethodKey = checkMethodKey + "." + devType;
            checkCriterionKey = checkCriterionKey + "." + devType;
            suggestKey = suggestKey + "." + devType;
        }
        evalResult.setCheckMethod(CompatibilityResourceUtils.getServiceString(checkMethodKey));
        evalResult.setCheckCriterion(CompatibilityResourceUtils.getServiceString(checkCriterionKey));
        evalResult.setSuggest(CompatibilityResourceUtils.getServiceString(suggestKey));
    }

    private void handleScriptEvalResult(RuleItem ruleItem, EvalFeatureResult evalResult) {
        evalResult.setFeatureId(ruleItem.getItemTitle());
        if (!ruleItem.isUseScriptEval()) {
            return;
        }
        if (!ItemResultEnum.PASS.equals((Object)evalResult.getItemResult())) {
            String reason = evalResult.getFailDesc();
            String[] reasons = reason.split(";");
            reason = reasons[0];
            String params = "";
            if (reasons.length > 1) {
                params = reasons[1];
            }
            evalResult.setFailDesc(ResourceUtil.getStringWithParams((String)reason, (Object[])new Object[]{params}));
        }
    }

    private void evalMultiPath(ItemInfo itemInfo, EvalFeatureResult multiPathResult) {
        for (String str : CompatibilityContants.getNoMultipath()) {
            String multipathInfo = itemInfo.getUpgradeKeyMap().get((Object)ItUpgradeKeyEnum.MULTI_PATH_STAT);
            if (StringUtils.isNULLStr((String)multipathInfo)) {
                LOGGER.info("multipathInfo is null!");
                multiPathResult.setFailDesc("cloudservice.compatibility.compat.nomultipathcheck");
                multiPathResult.setItemResult(ItemResultEnum.CANNOTEVAL);
                break;
            }
            if (!multipathInfo.contains(str)) continue;
            LOGGER.info("No MultiPath,No check!");
            multiPathResult.setItemResult(ItemResultEnum.CANNOTEVAL);
            break;
        }
    }

    private void evalCompatibility(RuleItem ruleItem, ItemInfo itemInfo, EvalItemResult evalItemResult) throws ToolException {
        String featureTypeStr = ruleItem.getItemTitle();
        ItCompatFeautureEnum compatFeaType = ItCompatFeautureEnum.getItCompatFeautureEnum(featureTypeStr);
        EvalFeatureResult evalResult = new EvalFeatureResult();
        LOGGER.info(String.format(Locale.ENGLISH, "Start Rules handling...%s", new Object[]{compatFeaType}));
        Map<String, Object> evalContext = this.prepareContext(ruleItem, itemInfo, evalItemResult);
        evalResult = EvaluationEngine.executeEval(evalContext, evalResult);
        if (!ItCompatFeautureEnum.BASE_CONNECTIVITY.equals((Object)compatFeaType)) {
            evalResult.setFeatureId(featureTypeStr);
            this.addCheckMethodCriterion2Result(evalResult, itemInfo, (Object)compatFeaType);
            this.addOriginalInfo2Result(evalResult, itemInfo, (Object)compatFeaType, evalItemResult);
            String originalStr = evalResult.getOriginalInfo();
            String checkMethod = evalResult.getCheckMethod();
            String checkCriterion = evalResult.getCheckCriterion();
            String suggest = evalResult.getSuggest();
            evalResult.setFeatureId(featureTypeStr);
            evalResult.setOriginalInfo(originalStr);
            evalResult.setCheckMethod(checkMethod);
            evalResult.setCheckCriterion(checkCriterion);
            evalResult.setSuggest(suggest);
            LOGGER.info(String.format(Locale.ENGLISH, "eval resault:%s", evalResult));
        } else {
            evalResult.setFeatureId(featureTypeStr);
            this.addCheckMethodCriterion2Result(evalResult, itemInfo, (Object)compatFeaType);
            this.addOriginalInfo2Result(evalResult, itemInfo, (Object)compatFeaType, evalItemResult);
        }
        evalItemResult.getFeatureResultList().add(evalResult);
        LOGGER.info(String.format(Locale.ENGLISH, "End Rules handling...%s", ItEvaluationType.COMPATIBILITY_EVAL.toString()));
    }

    private void addOriginalInfo2Result(EvalFeatureResult evalResult, ItemInfo itemInfo, Object compatFeaType, EvalItemResult evalItemResult) {
        String originalInfo;
        block5: {
            block9: {
                block8: {
                    block7: {
                        String deviceTypeStr;
                        block6: {
                            block4: {
                                String devType = itemInfo.getDevInfo();
                                deviceTypeStr = devType + " " + itemInfo.getOsName() + " " + itemInfo.getOsNumber();
                                originalInfo = null;
                                if (!ItCompatFeautureEnum.BASE_CONNECTIVITY.equals(compatFeaType)) break block4;
                                originalInfo = this.getOriginalInfoOfBaseConnectivity(itemInfo, deviceTypeStr);
                                break block5;
                            }
                            if (!ItCompatFeautureEnum.SWITCH_FEATURE.equals(compatFeaType)) break block6;
                            originalInfo = this.getOriginalInfoOfSwitch(itemInfo, deviceTypeStr);
                            break block5;
                        }
                        if (!ItUpgradeKeyEnum.HOST_HBA_TIME_OUT.equals(compatFeaType)) break block7;
                        originalInfo = this.getOriginalInfoOfHbaTimeout(itemInfo, deviceTypeStr, null);
                        break block5;
                    }
                    if (!ItUpgradeKeyEnum.AIX_ULTRA_PATH_CHECK.equals(compatFeaType)) break block8;
                    originalInfo = this.getOriginalInfoOfAixUltra(itemInfo);
                    break block5;
                }
                if (!(compatFeaType instanceof ItCompatFeautureEnum)) break block9;
                switch ((ItCompatFeautureEnum)((Object)compatFeaType)) {
                    case DB2_EVAL: 
                    case MYSQL_EVAL: 
                    case SQL_SERVER_EVAL: {
                        originalInfo = this.getOriginalCommonDatabase(itemInfo);
                        break block5;
                    }
                    case ORACLE_TIME_OUT: {
                        originalInfo = this.getOriginalOracleDatabase(itemInfo, evalItemResult);
                        break block5;
                    }
                    default: {
                        return;
                    }
                }
            }
            return;
        }
        evalResult.setOriginalInfo(originalInfo);
    }

    private String getOriginalOracleDatabase(ItemInfo itemInfo, EvalItemResult evalItemResult) {
        String storageSn = evalItemResult.getHostEvalTask().getStorageSn();
        String asmTimeout = itemInfo.getAsmHbeatiowait();
        String asmtype = itemInfo.getAsmDiskGroupType();
        StringBuilder originalInfo = new StringBuilder(this.getOriginalCommonDatabase(itemInfo));
        originalInfo.append(System.lineSeparator()).append(System.lineSeparator());
        originalInfo.append(CompatibilityResourceUtils.getUIString("eval.feature.database.asm.timeout"));
        originalInfo.append(System.lineSeparator());
        originalInfo.append(StringUtils.isNULLStr((String)asmTimeout) ? "--" : asmTimeout);
        originalInfo.append(System.lineSeparator()).append(System.lineSeparator());
        originalInfo.append(CompatibilityResourceUtils.getUIString("eval.feature.database.asm.type"));
        originalInfo.append(System.lineSeparator());
        originalInfo.append(StringUtils.isNULLStr((String)asmtype) ? "--" : asmtype);
        if (StringUtils.isNULLStr((String)storageSn)) {
            return originalInfo.toString();
        }
        String key = storageSn + "_systemInfo";
        String cli = SceneDataExchange.getInstance().loadKV(key);
        originalInfo.append(System.lineSeparator()).append(System.lineSeparator());
        originalInfo.append(key);
        originalInfo.append(cli);
        key = storageSn + "_LUNInfo";
        cli = SceneDataExchange.getInstance().loadKV(key);
        originalInfo.append(System.lineSeparator()).append(System.lineSeparator());
        originalInfo.append(key);
        originalInfo.append(cli);
        this.getHostOriginalInfo(itemInfo, storageSn, originalInfo);
        return originalInfo.toString();
    }

    private void getHostOriginalInfo(ItemInfo itemInfo, String storageSn, StringBuilder originalInfo) {
        Map<DevNode, DevNode> hostMappedDb = HostEvalContext.getHostMappedDb();
        StringBuilder hostOriginalInfo = new StringBuilder();
        ItemInfo itemInfo2 = null;
        EvalTaskResult evalTaskResult = HostEvalContext.getHostRvalResult().get(storageSn);
        List<EvalItemResult> evalItemList = evalTaskResult.getEvalItemList();
        for (DevNode hostDevNode : hostMappedDb.keySet()) {
            if (null != itemInfo.getInfoGrabMetaMsg().get("deviceSerialNumber") && !itemInfo.getInfoGrabMetaMsg().get("deviceSerialNumber").trim().equalsIgnoreCase(hostMappedDb.get(hostDevNode).getDeviceSerialNumber())) continue;
            for (EvalItemResult evalItemResult2 : evalItemList) {
                if (hostDevNode.getDeviceSerialNumber().equalsIgnoreCase(evalItemResult2.getEvalDevNode().getDeviceSerialNumber())) {
                    itemInfo2 = evalItemResult2.getItemInfo();
                    break;
                }
                itemInfo2 = null;
            }
            if (itemInfo2 == null) {
                LOGGER.info(String.format(Locale.ENGLISH, "Failed to get host Item: %s", hostDevNode.getIp()));
                continue;
            }
            String hostIP = hostDevNode.getIp();
            String hostType = hostDevNode.getDeviceName();
            hostOriginalInfo.append(System.lineSeparator() + System.lineSeparator() + hostIP + "_" + hostType + ": " + System.lineSeparator());
            hostOriginalInfo.append("FCInfo: " + System.lineSeparator() + this.getOriginalInfoOfHbaTimeout(itemInfo2, hostType, storageSn) + System.lineSeparator());
            Map<String, String> evalMap = itemInfo2.getInfoGrabMetaMsg();
            String evalResult = evalMap.get(ItUpgradeKeyEnum.ISCSI_TIMEOUT_CHECK.toString());
            if (null == evalResult) continue;
            JSONObject result = new JSONObject(evalResult);
            String iscsiOriginalInfo = this.getJsonString(result, "cliRet");
            if (null != iscsiOriginalInfo) {
                hostOriginalInfo.append(System.lineSeparator() + "ISCSIInfo: " + System.lineSeparator() + iscsiOriginalInfo).append(System.lineSeparator());
            }
            originalInfo.append(System.lineSeparator());
        }
        originalInfo.append((CharSequence)hostOriginalInfo);
    }

    private String getOriginalCommonDatabase(ItemInfo itemInfo) {
        String databaseVersion = itemInfo.getDatabaseVersion();
        String originalInfo = CompatibilityResourceUtils.getUIString("eval.feature.database.version") + System.lineSeparator() + (StringUtils.isNULLStr((String)databaseVersion) ? "--" : databaseVersion);
        return originalInfo;
    }

    private String getOriginalInfoOfHbaTimeout(ItemInfo itemInfo, String deviceTypeStr, String storageSn) {
        String hbaTimeoutStr = itemInfo.getHbaTimeOut();
        String multiSoftVersionStr = itemInfo.getMultiSoftEdition();
        StringBuilder originalInfo = new StringBuilder();
        originalInfo.append(CompatibilityResourceUtils.getUIString("eval.feature.hba.timeout.original.devtype"));
        originalInfo.append(System.lineSeparator());
        originalInfo.append(StringUtils.isNULLStr((String)deviceTypeStr) ? "--" : deviceTypeStr);
        originalInfo.append(System.lineSeparator()).append(System.lineSeparator());
        originalInfo.append(CompatibilityResourceUtils.getUIString("eval.feature.hba.timeout.original.timeout"));
        originalInfo.append(System.lineSeparator());
        originalInfo.append(StringUtils.isNULLStr((String)hbaTimeoutStr) ? "--" : hbaTimeoutStr);
        originalInfo.append(System.lineSeparator()).append(System.lineSeparator());
        originalInfo.append(CompatibilityResourceUtils.getUIString("eval.feature.hba.timeout.original.multipath"));
        originalInfo.append(System.lineSeparator());
        originalInfo.append(StringUtils.isNULLStr((String)multiSoftVersionStr) ? "--" : multiSoftVersionStr);
        originalInfo.append(System.lineSeparator()).append(System.lineSeparator());
        originalInfo.append(CompatibilityResourceUtils.getUIString("eval.feature.hba.timeout.original.storage"));
        originalInfo.append(System.lineSeparator());
        if (org.apache.commons.lang3.StringUtils.isBlank(storageSn)) {
            String storage = itemInfo.getInfoGrabMetaMsg("StorageModel");
            originalInfo.append(StringUtils.isNULLStr((String)storage) ? "--" : storage);
        } else {
            List nodeList;
            StorageInfo curHostStorage = EvaluationEngine.getCurHostStorage(storageSn);
            DevNode storageNode = EvaluationEngine.getStorageNode(curHostStorage, nodeList = DefaultNodeProviderImpl.getInstance().getNodeList());
            String deviceType = storageNode != null ? storageNode.getDeviceType().toString() : "--";
            String productVersion = storageNode != null ? storageNode.getProductVersion() : "--";
            originalInfo.append(StringUtils.isNULLStr((String)productVersion) ? "--" : deviceType + "  " + productVersion);
        }
        return originalInfo.toString();
    }

    private String getOriginalInfoOfBaseConnectivity(ItemInfo itemInfo, String deviceTypeStr) {
        StringBuilder originalInfo = new StringBuilder();
        originalInfo.append(CompatibilityResourceUtils.getUIString("eval.feature.hba.timeout.original.devtype"));
        originalInfo.append('\n');
        originalInfo.append(deviceTypeStr);
        originalInfo.append(System.lineSeparator()).append(System.lineSeparator());
        originalInfo.append(CompatibilityResourceUtils.getUIString("eval.feature.base.connectivity.hba.model"));
        originalInfo.append('\n');
        originalInfo.append(StringUtils.isNULLStr((String)itemInfo.getHbaName()) ? "--" : itemInfo.getHbaName());
        originalInfo.append(System.lineSeparator()).append(System.lineSeparator());
        originalInfo.append(CompatibilityResourceUtils.getUIString("eval.feature.base.connectivity.hba.driver"));
        originalInfo.append('\n');
        originalInfo.append(StringUtils.isNULLStr((String)itemInfo.getHbaDriverNum()) ? "--" : itemInfo.getHbaDriverNum());
        originalInfo.append(System.lineSeparator()).append(System.lineSeparator());
        originalInfo.append(CompatibilityResourceUtils.getUIString("eval.feature.base.connectivity.hba.fw"));
        originalInfo.append('\n');
        originalInfo.append(StringUtils.isNULLStr((String)itemInfo.getHbaFirmwareNum()) ? "--" : itemInfo.getHbaFirmwareNum());
        return originalInfo.toString();
    }

    public String getJsonString(JSONObject result, String key) {
        try {
            return result.getString(key);
        }
        catch (Exception e) {
            LOGGER.warn("paramList is null..");
            return null;
        }
    }

    private String getOriginalInfoOfAixUltra(ItemInfo itemInfo) {
        Map<String, String> evalMap = itemInfo.getInfoGrabMetaMsg();
        return evalMap.get("cmd_disaplay_multipath_hwselfdev_version");
    }

    private String getOriginalInfoOfSwitch(ItemInfo itemInfo, String deviceTypeStr) {
        StringBuilder originalInfo = new StringBuilder();
        String deviceMode = itemInfo.getOsName();
        String firmVersion = itemInfo.getFirmWareVersion();
        originalInfo.append(CompatibilityResourceUtils.getUIString("eval.feature.switch.device.model"));
        originalInfo.append('\n');
        originalInfo.append(StringUtils.isNULLStr((String)deviceMode) ? "--" : deviceMode);
        originalInfo.append(System.lineSeparator()).append(System.lineSeparator());
        originalInfo.append(CompatibilityResourceUtils.getUIString("eval.feature.switch.fw.version"));
        originalInfo.append('\n');
        originalInfo.append(StringUtils.isNULLStr((String)firmVersion) ? "--" : firmVersion);
        if (!StringUtils.isNULLStr((String)deviceMode) && deviceMode.contains("Brocade")) {
            originalInfo.append(System.lineSeparator()).append(System.lineSeparator());
            originalInfo.append(CompatibilityResourceUtils.getUIString("eval.feature.switch.device.type.id"));
            originalInfo.append('\n');
            originalInfo.append(StringUtils.isNULLStr((String)itemInfo.getSwitchDeviceTypeId()) ? "--" : itemInfo.getSwitchDeviceTypeId());
        }
        return originalInfo.toString();
    }

    private Map<String, Object> prepareContext(RuleItem ruleItem, ItemInfo itemInfo, EvalItemResult evalItemResult) {
        HashMap<String, Object> evalContext = new HashMap<String, Object>(3);
        evalContext.put("ruleItem", ruleItem);
        evalContext.put("itemInfo", itemInfo);
        evalContext.put("evalItemResult", evalItemResult);
        HostEvalNode node = evalItemResult.getHostEvalTask();
        evalContext.put("evalStorDevNode", node == null ? null : DefaultNodeProviderImpl.getInstance().findDevNode(node.getStorageSn()));
        return evalContext;
    }

    public List<RuleItem> findCurrentItemFlow(Map<ItDeviceType, EvaluationFlow> evalTypeFlow, ItemInfo itemInfo) {
        List<RuleItem> ruleList = this.flowAdapter.findItemFlow(evalTypeFlow, itemInfo);
        return ruleList;
    }

    public void setEvaluationTypeFlow(Map<ItDeviceType, EvaluationFlow> evaluationTypeFlow) {
        this.evaluationTypeFlow = evaluationTypeFlow;
    }

    public Map<ItDeviceType, EvaluationFlow> getEvaluationTypeFlow() {
        return this.evaluationTypeFlow;
    }

    public void setResultList(List<Map<String, String>> resultList) {
        this.resultList = resultList;
    }

    public List<Map<String, String>> getResultList() {
        return this.resultList;
    }

    public void setResultItemList(List<RuleItem> resultItemList) {
        this.resultItemList = resultItemList;
    }

    public List<RuleItem> getResultItemList() {
        return this.resultItemList;
    }
}

