/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.adapter.worktaker.impl;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.upgradeevalu.adapter.EvaluationFlow;
import com.huawei.ism.tool.upgradeevalu.adapter.RuleItem;
import com.huawei.ism.tool.upgradeevalu.adapter.RuleModule;
import com.huawei.ism.tool.upgradeevalu.adapter.worktaker.IFlowAdapter;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;

public final class FlowAdapter
implements IFlowAdapter {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(FlowAdapter.class);
    private static FlowAdapter instance = new FlowAdapter();
    private List<String> deviceTypefilter = new ArrayList<String>();
    private Map<ItemInfo, List<RuleItem>> nodeFlowMap;
    private Map<ItemInfo, List<String>> nodeSceneMap;

    private FlowAdapter() {
        this.setNodeFlowMap(new HashMap<ItemInfo, List<RuleItem>>());
        this.setNodeSceneMap(new HashMap<ItemInfo, List<String>>());
    }

    public static FlowAdapter getInstance() {
        return instance;
    }

    @Override
    public List<RuleItem> findItemFlow(Map<ItDeviceType, EvaluationFlow> flowMap, ItemInfo currItemNode) {
        if (this.nodeFlowMap.containsKey(currItemNode)) {
            return this.nodeFlowMap.get(currItemNode);
        }
        String properNameKey = this.getItemKeyName(currItemNode);
        ItDeviceType itDeviceType = currItemNode.getDeviceType();
        List<RuleModule> currModuleList = flowMap.get(itDeviceType).getRuleModuleList();
        for (String deviceType : this.deviceTypefilter) {
            if (!deviceType.equalsIgnoreCase(properNameKey)) continue;
            LOGGER.info(String.format(Locale.ENGLISH, "this device is not support to evaluate, the device type is :%s", properNameKey));
            return null;
        }
        for (RuleModule module : currModuleList) {
            if (!module.getTitle().equalsIgnoreCase(properNameKey)) continue;
            List<RuleItem> currListItems = module.getItemList();
            return currListItems;
        }
        for (RuleModule module : currModuleList) {
            if (!module.getTitle().equals("Common")) continue;
            List<RuleItem> currListItems = module.getItemList();
            return currListItems;
        }
        return null;
    }

    private String getItemKeyName(ItemInfo currItemNode) {
        String osName = currItemNode.getDevInfo();
        if (StringUtils.isNULLStr((String)osName)) {
            osName = currItemNode.getOsName();
            osName = null == osName ? "" : osName.split(" ")[0];
        }
        return osName;
    }

    public void setNodeFlowMap(Map<ItemInfo, List<RuleItem>> nodeFlowMap) {
        this.nodeFlowMap = nodeFlowMap;
    }

    public Map<ItemInfo, List<RuleItem>> getNodeFlowMap() {
        return this.nodeFlowMap;
    }

    public void setNodeSceneMap(Map<ItemInfo, List<String>> nodeSceneMap) {
        this.nodeSceneMap = nodeSceneMap;
    }

    public Map<ItemInfo, List<String>> getNodeSceneMap() {
        return this.nodeSceneMap;
    }
}

