/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.adapter.worktaker.impl;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.tool.upgradeevalu.adapter.RuleItem;
import com.huawei.ism.tool.upgradeevalu.adapter.worktaker.IRuleLogic;
import com.huawei.ism.tool.upgradeevalu.enums.ItUpgradeKeyEnum;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.utils.CommonUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RuleLogic
implements IRuleLogic {
    public static final String PYDEFAULTMETHOD = "execute";
    private static final Logger LOGGER = Logger.getLogger(RuleLogic.class);
    private static final RuleLogic INSTANCE = new RuleLogic();

    public static RuleLogic getInstance() {
        return INSTANCE;
    }

    private Map<String, String> prepareParameters(ItemInfo itemInfo, RuleItem ruleItem) {
        HashMap<String, String> context = new HashMap<String, String>();
        String cmd = itemInfo.getUpgradeKeyMap().get((Object)ItUpgradeKeyEnum.getUpgradeTypeByString(ruleItem.getUpgradeKey()));
        context.put(ruleItem.getUpgradeKey(), cmd);
        return context;
    }

    @Override
    public EvalFeatureResult getRuleLogicByXml(JythonExecuter jythonExecuter, ItemInfo itemInfo, RuleItem ruleItem) throws ToolException {
        EvalFeatureResult evalFeatureResult = new EvalFeatureResult();
        String scriptPath = ruleItem.getScriptPath();
        File currPyFile = new File(CommonUtils.fixPath(scriptPath));
        Map<String, String> context = this.prepareParameters(itemInfo, ruleItem);
        try {
            jythonExecuter.compileScript(currPyFile);
            jythonExecuter.simpleInvokeFunction(PYDEFAULTMETHOD, new Object[]{context});
        }
        catch (Exception e) {
            LOGGER.error("exec script error!", e);
            throw new ToolException(ResourceUtil.getString((String)"compatibility.compat.exception.script"), (Throwable)e);
        }
        boolean isPass = "true".endsWith(String.valueOf(context.get("result")));
        String reason = context.get("reason");
        if (!isPass) {
            evalFeatureResult.setItemResult(ItemResultEnum.NOTPASS);
        }
        if (!StringUtils.isBlank(reason)) {
            evalFeatureResult.setFailDesc(reason);
        }
        return evalFeatureResult;
    }
}

