/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.config;

import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.pyengine.jython.JythonCheckItemService;
import com.huawei.ism.tool.pyengine.psdk.bean.CheckConfigItem;
import com.huawei.ism.tool.pyengine.psdk.bean.ExecuteEnv;
import com.huawei.ism.tool.pyengine.psdk.bean.PyTaskResult;
import com.huawei.ism.tool.pyengine.psdk.bean.UpgradeExecuteEnv;
import com.huawei.ism.tool.pyengine.psdk.common.ExecuteEnvConstants;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluItem;
import com.huawei.ism.tool.upgradeevalu.entity.Module;
import com.huawei.ism.tool.upgradeevalu.evalu.ResultFlag;
import com.huawei.ism.tool.upgradeevalu.evalu.ResultItem;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckItemPlatformAdapterInUpgradeEval {
    private static final Logger log = LoggerFactory.getLogger(CheckItemPlatformAdapterInUpgradeEval.class);
    private static final CheckItemPlatformAdapterInUpgradeEval INSTANCE = new CheckItemPlatformAdapterInUpgradeEval();
    private final Map<DevNode, UpgradeExecuteEnv> devExecuteEnvMap = new ConcurrentHashMap<DevNode, UpgradeExecuteEnv>();

    public static CheckItemPlatformAdapterInUpgradeEval getInstance() {
        return INSTANCE;
    }

    private CheckItemPlatformAdapterInUpgradeEval() {
    }

    private void initExecuteEnv(EvaluDevNode dev) {
        UpgradeExecuteEnv env = new UpgradeExecuteEnv(ExecuteEnvConstants.ExecuteTool.UPGRADE_EVALUATION);
        env.setUpgradeMode(dev.getUpgradeMode().toString());
        env.setTargetVersion(dev.getDestVersion());
        env.setUpgPatchPkgVer(dev.getUpgPatchPkgVer());
        this.devExecuteEnvMap.put(dev, env);
    }

    public void addCheckConfigItem(List<Module> allModules, EvaluDevNode dev) {
        this.initExecuteEnv(dev);
        JythonCheckItemService service = new JythonCheckItemService((ExecuteEnv)this.devExecuteEnvMap.get((Object)dev));
        List configItems = service.getCheckItemList((DevNode)dev);
        Map<String, List<CheckConfigItem>> groupedConfigItem = configItems.stream().collect(Collectors.groupingBy(CheckConfigItem::getModule));
        groupedConfigItem.forEach((moduleId, moduleItems) -> {
            List addItems = moduleItems.stream().map(item -> this.transConfigItem((CheckConfigItem)item, dev.getId())).collect(Collectors.toList());
            allModules.stream().filter(module -> module.getId().equals(moduleId)).findAny().ifPresent(moduleItem -> moduleItem.getItems().addAll(addItems));
        });
    }

    private EvaluItem transConfigItem(CheckConfigItem configItem, String devId) {
        EvaluItem item = new EvaluItem();
        item.setDevID(devId);
        item.setCheckConfigItem(configItem);
        item.setId(configItem.getItemId());
        item.setName(configItem.getName());
        return item;
    }

    public void runConfigItem(DevNode dev, CheckConfigItem configItem, ResultItem retItem) {
        log.info("run config item: {}", (Object)configItem.getItemId());
        JythonCheckItemService service = new JythonCheckItemService((ExecuteEnv)this.devExecuteEnvMap.get(dev));
        PyTaskResult taskResult = service.runCheckConfigItem(dev, configItem.getScript());
        retItem.setRetFlag(ResultFlag.findByAlias(taskResult.getStatus()));
        retItem.setErrorInfo(taskResult.getDetail());
        retItem.setSourceInfo(taskResult.getOriginInfo());
    }

    public Map<DevNode, UpgradeExecuteEnv> getDevExecuteEnvMap() {
        return this.devExecuteEnvMap;
    }
}

