/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.config;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.upgradeevalu.config.CheckItemPlatformAdapterInUpgradeEval;
import com.huawei.ism.tool.upgradeevalu.config.ProductParser;
import com.huawei.ism.tool.upgradeevalu.entity.CrossVersionType;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluItem;
import com.huawei.ism.tool.upgradeevalu.entity.Module;
import com.huawei.ism.tool.upgradeevalu.entity.ProductCfg;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ItemParser {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ItemParser.class);
    private static final ItemParser INSTANCE = new ItemParser();
    private static final String SCRIPT_DIR = "sh";
    private static final String SCRIPT_PREFFIX = "check_";
    private static final String SCRIPT_SUFFIX = ".py";
    private static final String INNER_DIR = "innerVerion";
    private static final String EVALU_MODULE = "/evaluation/module";
    private static final String ID = "id";
    private static final String INDEX = "index";
    private static final String ITEM = "item";
    private static final String MODE = "mode";
    private static final String SHOW_ORIGIN = "showorigin";
    private static final String SHOW_METHOD = "showmethod";
    private static final String SHOW_CRITERION = "showcriterion";
    private static final String SCENE_LOGIC = "sceneLogic";
    private static final String SCRIPT_PATH = "scriptPath";
    private static final String DISABLE_SCENE_STEP = "disableSceneStep";
    private static final String VER_REGX = "verRegx";
    private static final String DEV_TYPE_REGX = "devTypeRegx";
    private static final String IS_NEED_LOG = "isNeedLog";
    private EvaluContext evaluContext = EvaluContext.getInstance();

    private ItemParser() {
    }

    public static ItemParser getInstance() {
        return INSTANCE;
    }

    public List<Module> parseModuleByDoc(Document doc, EvaluDevNode dev, ProductCfg productCfg) {
        ArrayList<Module> modules = new ArrayList<Module>();
        NodeList modNondes = XmlUtils.searchNodeByExp((Document)doc, (String)EVALU_MODULE);
        if (null == modNondes) {
            return modules;
        }
        int size = modNondes.getLength();
        for (int i = 0; i < size; ++i) {
            Node modNode = modNondes.item(i);
            if (!(modNode instanceof Element)) continue;
            Element moduleEle = (Element)modNode;
            Module module = new Module();
            module.setId(moduleEle.getAttribute(ID));
            module.setIdentifier(productCfg.getProdcutName() + "." + module.getId());
            String index = moduleEle.getAttribute(INDEX);
            if (StringUtils.isNULLStr((String)index)) {
                index = "0";
                LOGGER.error("module's index is 0, please check.");
            }
            module.setIndex(Integer.parseInt(index));
            module.setName(moduleEle.getAttribute("name"));
            List<EvaluItem> items = this.parseItemByMod(moduleEle, dev);
            module.setItems(items);
            modules.add(module);
        }
        CheckItemPlatformAdapterInUpgradeEval.getInstance().addCheckConfigItem(modules, dev);
        return modules;
    }

    public void setInnerItemByDev(EvaluDevNode dev) {
        ProductCfg innerProd = dev.getProduct(CrossVersionType.INNERVERSION);
        List<Module> innerModules = innerProd.getModules();
        for (Module module : innerModules) {
            List<EvaluItem> innerItems = module.getItems();
            for (EvaluItem evaluItem : innerItems) {
                File prodDir = innerProd.getProductDir();
                StringBuilder buffer = new StringBuilder();
                buffer.append(innerProd.getProdcutName()).append(".").append(evaluItem.getId());
                evaluItem.setIdentifier(buffer.toString());
                evaluItem.setCrossVersionType(CrossVersionType.INNERVERSION);
                this.setPythonFile(innerProd, prodDir, evaluItem);
            }
        }
    }

    private void setPythonFile(ProductCfg prod, File shDir, EvaluItem item) {
        String id = item.getId();
        String pyName = SCRIPT_PREFFIX + id + SCRIPT_SUFFIX;
        String dir = null;
        switch (prod.getDeviceType()) {
            case A800_NODE: 
            case Storage: {
                if (!prod.getCrossVersionType().equals((Object)CrossVersionType.INNERVERSION)) break;
                if (!StringUtils.isNULLStr((String)item.getScriptPath())) {
                    dir = ProductParser.getCommonPackagePath() + File.separator + item.getScriptPath();
                    break;
                }
                dir = shDir + File.separator + INNER_DIR + File.separator + SCRIPT_DIR + File.separator;
                break;
            }
            case Host: 
            case Switch: {
                dir = shDir + File.separator + SCRIPT_DIR + File.separator;
                break;
            }
            default: {
                dir = "--";
            }
        }
        item.setScript(FilePathUtils.checkFile((File)new File(dir, pyName)));
    }

    private List<EvaluItem> parseItemByMod(Element modEle, EvaluDevNode dev) {
        ArrayList<EvaluItem> evaluItems = new ArrayList<EvaluItem>();
        Collection itemEles = XmlUtils.getChildren((Element)modEle, (String)ITEM);
        for (Element itemEle : itemEles) {
            String devTypeRegx;
            String showCriterion;
            String showMethod;
            EvaluItem item = new EvaluItem();
            String id = XmlUtils.getAttribute((Element)itemEle, (String)ID);
            item.setId(id);
            item.setName(id);
            item.setDevID(dev.getId());
            String mode = XmlUtils.getAttribute((Element)itemEle, (String)MODE);
            item.setMode(mode);
            String showOrigin = XmlUtils.getAttribute((Element)itemEle, (String)SHOW_ORIGIN);
            if (!StringUtils.isNULLStr((String)showOrigin)) {
                item.setShowOrigin(Boolean.parseBoolean(showOrigin));
            }
            if (!StringUtils.isNULLStr((String)(showMethod = XmlUtils.getAttribute((Element)itemEle, (String)SHOW_METHOD)))) {
                item.setShowMethod(Boolean.parseBoolean(showMethod));
            }
            if (!StringUtils.isNULLStr((String)(showCriterion = XmlUtils.getAttribute((Element)itemEle, (String)SHOW_CRITERION)))) {
                item.setShowCriterion(Boolean.parseBoolean(showCriterion));
            }
            this.setSceneLogic(itemEle, item);
            this.setScriptPath(itemEle, item);
            this.setDisableSceneStep(itemEle, item);
            String verRegx = XmlUtils.getAttribute((Element)itemEle, (String)VER_REGX);
            if (!StringUtils.isNULLStr((String)verRegx) && !dev.getProductVersion().matches(verRegx) || !StringUtils.isNULLStr((String)(devTypeRegx = XmlUtils.getAttribute((Element)itemEle, (String)DEV_TYPE_REGX))) && !dev.getDeviceModel().matches(devTypeRegx)) continue;
            this.setNeedLog(itemEle, item);
            evaluItems.add(item);
        }
        return evaluItems;
    }

    private void setSceneLogic(Element itemEle, EvaluItem item) {
        String sceneLogic = XmlUtils.getAttribute((Element)itemEle, (String)SCENE_LOGIC);
        if (!StringUtils.isNULLStr((String)sceneLogic)) {
            item.setSceneLogic(Boolean.parseBoolean(sceneLogic));
        }
    }

    private void setScriptPath(Element itemEle, EvaluItem item) {
        String scriptPath = XmlUtils.getAttribute((Element)itemEle, (String)SCRIPT_PATH);
        if (!StringUtils.isNULLStr((String)scriptPath)) {
            item.setScriptPath(scriptPath.replace("\\", File.separator));
        }
    }

    private void setDisableSceneStep(Element itemEle, EvaluItem item) {
        String disableSceneStep = XmlUtils.getAttribute((Element)itemEle, (String)DISABLE_SCENE_STEP);
        if (!StringUtils.isNULLStr((String)disableSceneStep)) {
            item.setDisableSceneStep(Boolean.parseBoolean(disableSceneStep));
        }
    }

    private void setNeedLog(Element itemEle, EvaluItem item) {
        String isNeedLog = XmlUtils.getAttribute((Element)itemEle, (String)IS_NEED_LOG);
        if (!StringUtils.isNULLStr((String)isNeedLog) && "TRUE".equals(isNeedLog)) {
            item.setNeedLog(true);
        }
    }
}

