/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.config;

import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.upgradeevalu.config.Model;
import com.huawei.ism.tool.upgradeevalu.config.ProductParser;
import com.huawei.ism.tool.upgradeevalu.entity.ProductCfg;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;

public class ParseConfCallable
implements Callable<Boolean> {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ParseConfCallable.class);
    private static final String THREAD_NAME = "parse_Conf_Callable";
    private ProductParser productParser = ProductParser.getInstance();
    private EvaluContext evaluContext = EvaluContext.getInstance();

    @Override
    public Boolean call() throws ToolException {
        Thread.currentThread().setName(THREAD_NAME);
        List<ProductCfg> allProductCfg = this.productParser.loadAllProducts();
        if (allProductCfg.isEmpty()) {
            LOGGER.error("there are no prodcut conf in pacakge, please check.");
            return false;
        }
        this.evaluContext.setAllProductCfg(allProductCfg);
        this.evaluContext.setSupportVersionMap(this.getSupportVersionMap());
        List<EvaluContext.VersionPathItem> versionPathItem = this.productParser.loadVersionPath();
        this.evaluContext.setVersionEvalPathList(versionPathItem);
        return true;
    }

    private Map<String, List<String>> getSupportVersionMap() {
        HashMap<String, List<String>> supportVersionMap = new HashMap<String, List<String>>();
        List<ProductCfg> allProductCfg = this.evaluContext.getAllProductCfg();
        for (ProductCfg product : allProductCfg) {
            List<Model> models = product.getModels();
            for (Model model : models) {
                List<String> modelNames = model.getNames();
                for (String name : modelNames) {
                    if (supportVersionMap.containsKey(name)) {
                        ((List)supportVersionMap.get(name)).addAll(model.getSupportVersions());
                        continue;
                    }
                    ArrayList<String> supportVersions = new ArrayList<String>();
                    supportVersions.addAll(model.getSupportVersions());
                    supportVersionMap.put(name, supportVersions);
                }
            }
        }
        return supportVersionMap;
    }
}

