/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.config;

import com.huawei.ism.tool.base.osplatform.OsEnumn;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.SystemEnvUtil;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.parser.FeatureSupportConfig;
import com.huawei.ism.tool.upgradeevalu.config.IProductParser;
import com.huawei.ism.tool.upgradeevalu.config.Model;
import com.huawei.ism.tool.upgradeevalu.config.parser.ArrayProductParser;
import com.huawei.ism.tool.upgradeevalu.entity.CrossVersionCfg;
import com.huawei.ism.tool.upgradeevalu.entity.ProductCfg;
import com.huawei.ism.tool.upgradeevalu.entity.ScriptExecutEnv;
import com.huawei.ism.tool.upgradeevalu.util.EvaluCommUtil;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ProductParser {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ProductParser.class);
    private static final ProductParser INSTANCE = new ProductParser();
    private static final String RES_DIR = "res";
    private static final String INNER_DIR = "innerVerion";
    private static final String RES_NAME = "resource";
    private static EvaluContext evaluContext = EvaluContext.getInstance();
    private static final String TOOL_NAME = "upgradeEvaluation";
    private static final String PACKAGE_PATH = SystemEnvUtil.getDefaultUserDir();
    private static final String EVALUTION_PATH = "packages" + File.separator + "upgradeEvaluation";
    private static final String PRODUCTS_FOLDER = "packages" + File.separator + "upgradeEvaluation" + File.separator + "products";
    private static final String SYSCONF_FILENAME = "sysconf.xml";
    private static final String DOM_PRODUCTS = "/products/product";
    private static final String NODE_PRODUCT_NAME = "name";
    private static final String NODE_CONF_DIR = "config";
    private static final String NODE_PARSERDEVCLASS = "parserdevclass";
    private static final String NODE_DEBUG = "debug";
    private static final String NODE_CHECKMODEL = "checkmodel";
    private static final String NODE_DESTVERSION = "destversion";
    private static final String NODE_INNER_VERSION = "innerverconfig";
    private static final String NODE_CROSS_VERSION = "crossverconfig";
    private static final String NODE_MODEL = "modellist/model";
    private static final String MODELE_NAME = "name";
    private static final String MODELE_VERSION = "version";
    private static final String DYNAMIC_SCRIPT = "checklist";
    private static final String TYPE = "type";
    private static final String SUPPORT_TYPE = "supporttype";
    private static final String ENABLE = "enable";
    private static final String MODEL_TYPE = "modelType";
    private static final String NEED_SFTP = "needSftp";
    private static final String NEEDTLV = "needTlv";
    private static final String REGX = "regex";
    private static final String SHOWTIP = "showtip";
    private static final String CROSS_VERSION_TAG = "crossversion";
    private static final String UNDERLINE = "_";
    private static final String POINT_PROPERTIES = ".properties";
    private String productPath;
    private static final String NEED_OPEN_TLV_PATH = "packages" + File.separator + "upgradeEvaluation" + File.separator + "products" + File.separator + "neededOpenTlvChannel.xml";
    private static final String VERSION_EVAL_PATH = "packages" + File.separator + "upgradeEvaluation" + File.separator + "products" + File.separator + "VersionEvalPath.xml";

    private ProductParser() {
    }

    public static ProductParser getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProductCfg> loadAllProducts() {
        ArrayList<ProductCfg> productCfgs = new ArrayList<ProductCfg>();
        File productsFolder = new File(PACKAGE_PATH, PRODUCTS_FOLDER);
        File[] allProductFolder = productsFolder.listFiles(new InnerFileFilter());
        if (null == allProductFolder) {
            LOGGER.error("load sysconf.xml is null.");
            return productCfgs;
        }
        for (File dir : allProductFolder) {
            File sysconfFile = new File(dir, SYSCONF_FILENAME);
            if (!sysconfFile.exists()) continue;
            InputStream inputStream = null;
            Document doc = null;
            try {
                inputStream = StreamUtils.createInputStream((File)sysconfFile);
                doc = XmlUtils.parseDocument((InputStream)inputStream);
                ProductCfg proudctCfg = this.loadProdByDoc(doc);
                productCfgs.add(proudctCfg);
            }
            catch (Exception e) {
                LOGGER.error("load sysconf failed.", e);
            }
            finally {
                StreamUtils.closeStream(null, (InputStream)inputStream);
            }
        }
        LOGGER.info(String.format(Locale.ENGLISH, "parse %s prodcuts from sysconf.xml.", productCfgs.size()));
        return productCfgs;
    }

    private ProductCfg loadProdByDoc(Document doc) {
        ProductCfg productCfg = new ProductCfg();
        NodeList productNodes = XmlUtils.searchNodeByExp((Document)doc, (String)DOM_PRODUCTS);
        if (null == productNodes) {
            return null;
        }
        int size = productNodes.getLength();
        for (int i = 0; i < size; ++i) {
            Node productNode = productNodes.item(i);
            if (!(productNode instanceof Element)) continue;
            this.analyDocToProduct(productCfg, productNode);
        }
        return productCfg;
    }

    private void analyDocToProduct(ProductCfg productCfg, Node productNode) {
        Element productEle = (Element)productNode;
        String typeStr = XmlUtils.getAttribute((Element)productEle, (String)TYPE);
        if (StringUtils.isNULLStr((String)typeStr)) {
            typeStr = ItDeviceType.Storage.getName();
        }
        ItDeviceType type = ItDeviceType.valueOf((String)typeStr);
        productCfg.setDeviceType(type);
        String supportType = XmlUtils.getAttribute((Element)productEle, (String)SUPPORT_TYPE);
        boolean fastAndRollType = false;
        if (!StringUtils.isNULLStr((String)supportType)) {
            fastAndRollType = true;
        }
        productCfg.setFastAndRollType(fastAndRollType);
        String prodName = XmlUtils.getTextContentOfChild((Element)productEle, (String)"name");
        if (null == prodName) {
            prodName = "--";
        }
        productCfg.setProdcutName(prodName);
        NodeList modelList = XmlUtils.searchNodeByExp((Element)productEle, (String)NODE_MODEL);
        if (modelList == null) {
            ToolLoggerFactory.getLogger(this.getClass()).warn("modelList is null, modellist/model");
            return;
        }
        productCfg.setModels(this.parseModles(modelList));
        String cfgDir = XmlUtils.getTextContentOfChild((Element)productEle, (String)NODE_CONF_DIR);
        this.productPath = PACKAGE_PATH + File.separator + EVALUTION_PATH + File.separator + cfgDir;
        File productDir = new File(this.productPath);
        productCfg.setProductDir(productDir);
        String parserClass = XmlUtils.getTextContentOfChild((Element)productEle, (String)NODE_PARSERDEVCLASS);
        IProductParser parser = this.getParser(parserClass);
        productCfg.setProductParser(parser);
        this.readDebug(productCfg, productEle);
        this.readScriptExecutEnv(productCfg, productEle);
        this.readDestVersion(productCfg, productEle);
        Element chickEle = XmlUtils.getChild((Element)productEle, (String)NODE_INNER_VERSION);
        File file = this.parseDynamicPY(chickEle);
        productCfg.setDynamicPY(file);
        ResourceBundle innerVerResBund = this.loadInnerVerResBund(productCfg);
        productCfg.setResBundle(innerVerResBund);
        Element crossVercfgEle = XmlUtils.getChild((Element)productEle, (String)NODE_CROSS_VERSION);
        if (null != crossVercfgEle) {
            List<CrossVersionCfg> crossVersionCfgList = this.parseCrossVersionCfg(crossVercfgEle);
            productCfg.setCrossVerCfgList(crossVersionCfgList);
        }
    }

    private void readDebug(ProductCfg productCfg, Element productEle) {
        String isDebugStr;
        Element debugEle = XmlUtils.getChild((Element)productEle, (String)NODE_DEBUG);
        if (null != debugEle && null != (isDebugStr = XmlUtils.getAttribute((Element)debugEle, (String)ENABLE))) {
            Boolean isDebug = Boolean.valueOf(isDebugStr);
            productCfg.setDedbug(isDebug);
        }
    }

    private void readDestVersion(ProductCfg productCfg, Element productEle) {
        Element destVersEle = XmlUtils.getChild((Element)productEle, (String)NODE_DESTVERSION);
        if (null != destVersEle) {
            String regex = XmlUtils.getAttribute((Element)destVersEle, (String)REGX);
            productCfg.setDestVerRegex(regex);
            String verStr = destVersEle.getTextContent();
            List<String> destVers = this.splitByComma(verStr);
            productCfg.getDestVers().addAll(destVers);
            String showTipStr = XmlUtils.getAttribute((Element)destVersEle, (String)SHOWTIP);
            if (!StringUtils.isNULLStr((String)showTipStr)) {
                Boolean showTip = Boolean.valueOf(showTipStr);
                productCfg.setShowTip(showTip);
            }
        }
    }

    private void readScriptExecutEnv(ProductCfg productCfg, Element productEle) {
        Element ckModelEle = XmlUtils.getChild((Element)productEle, (String)NODE_CHECKMODEL);
        if (null != ckModelEle) {
            ScriptExecutEnv env = new ScriptExecutEnv();
            env.setScripType(XmlUtils.getAttribute((Element)ckModelEle, (String)MODEL_TYPE));
            String needSftp = XmlUtils.getAttribute((Element)ckModelEle, (String)NEED_SFTP);
            String needTlv = XmlUtils.getAttribute((Element)ckModelEle, (String)NEEDTLV);
            if (!StringUtils.isNULLStr((String)needSftp)) {
                env.setNeedSftp(Boolean.valueOf(needSftp));
            }
            if (!StringUtils.isNULLStr((String)needTlv)) {
                env.setNeedTlv(Boolean.valueOf(needTlv));
            }
            productCfg.setScriptExecutEnv(env);
        }
    }

    private List<Model> parseModles(NodeList modelList) {
        ArrayList<Model> models = new ArrayList<Model>();
        for (int j = 0; j < modelList.getLength(); ++j) {
            Node node = modelList.item(j);
            if (!(node instanceof Element)) continue;
            Element ele = (Element)node;
            Model model = new Model();
            String modelName = XmlUtils.getTextContentOfChild((Element)ele, (String)"name");
            if (!this.isOsSupport(ele)) continue;
            List<String> modelNameList = this.splitByComma(modelName);
            model.getNames().addAll(modelNameList);
            String versions = XmlUtils.getTextContentOfChild((Element)ele, (String)MODELE_VERSION);
            List<String> supportVersionList = this.splitByComma(versions);
            model.getSupportVersions().addAll(supportVersionList);
            models.add(model);
        }
        return models;
    }

    private boolean isOsSupport(Element ele) {
        return XmlUtils.parseSupportOs((Element)ele).contains(OsEnumn.getNowRunningOs());
    }

    private List<String> splitByComma(String str) {
        String[] strArray;
        ArrayList<String> srtList = new ArrayList<String>();
        for (String strr : strArray = str.split(",")) {
            if (StringUtils.isNULLStr((String)strr)) continue;
            srtList.add(strr.trim());
        }
        return srtList;
    }

    private IProductParser getParser(String parser) {
        if (StringUtils.isNULLStr((String)parser)) {
            ArrayProductParser arrayProductParser = new ArrayProductParser();
            return arrayProductParser;
        }
        return null;
    }

    private List<CrossVersionCfg> parseCrossVersionCfg(Element crossVercfgEle) {
        if (null == crossVercfgEle) {
            ToolLoggerFactory.getLogger(this.getClass()).error("crossVercfgEle is null");
            return null;
        }
        NodeList crossVersionList = XmlUtils.searchNodeByExp((Element)crossVercfgEle, (String)CROSS_VERSION_TAG);
        if (crossVersionList == null) {
            ToolLoggerFactory.getLogger(this.getClass()).error("crossVersionList is null");
            return null;
        }
        ArrayList<CrossVersionCfg> crossVersionCfgList = new ArrayList<CrossVersionCfg>();
        for (int i = 0; i < crossVersionList.getLength(); ++i) {
            Node node = crossVersionList.item(i);
            if (!(node instanceof Element)) continue;
            CrossVersionCfg crossVerCfg = new CrossVersionCfg();
            Element ele = (Element)node;
            NodeList modelList = XmlUtils.searchNodeByExp((Element)ele, (String)NODE_MODEL);
            if (modelList == null) {
                ToolLoggerFactory.getLogger(this.getClass()).warn("modelList is null, modellist/model");
                return null;
            }
            crossVerCfg.setModels(this.parseModles(modelList));
            crossVersionCfgList.add(crossVerCfg);
        }
        return crossVersionCfgList;
    }

    private File parseDynamicPY(Element ele) {
        if (null == ele) {
            return null;
        }
        String dymanicPY = XmlUtils.getTextContentOfChild((Element)ele, (String)DYNAMIC_SCRIPT);
        if (!StringUtils.isNULLStr((String)dymanicPY)) {
            return FilePathUtils.checkFile((File)new File(this.productPath + File.separator + dymanicPY));
        }
        ToolLoggerFactory.getLogger(this.getClass()).info("can not parse dymanicPY");
        return null;
    }

    private ResourceBundle loadInnerVerResBund(ProductCfg product) {
        File productDir = product.getProductDir();
        Locale loc = evaluContext.getLoc();
        String currentLanguage = null == loc ? ApplicationContext.getInstance().getCurrentLanguage().getLanguage() : loc.getLanguage();
        File propertiesFile = null;
        File commonResFile = null;
        if (EvaluCommUtil.isStorageOrA800(product.getDeviceType())) {
            propertiesFile = new File(productDir, INNER_DIR + File.separator + RES_DIR + File.separator + RES_NAME + UNDERLINE + currentLanguage + POINT_PROPERTIES);
            commonResFile = new File(ProductParser.getCommonPackagePath(), RES_DIR + File.separator + RES_NAME + UNDERLINE + currentLanguage + POINT_PROPERTIES);
        } else {
            propertiesFile = new File(productDir, RES_DIR + File.separator + RES_NAME + UNDERLINE + currentLanguage + POINT_PROPERTIES);
        }
        if (!propertiesFile.exists()) {
            LOGGER.error("load product resource properties " + propertiesFile + " failed.");
            return null;
        }
        return this.loadResourceBundle(propertiesFile, commonResFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceBundle loadResourceBundle(File propertiesFile, File commonResFile) {
        PropertyResourceBundle bundle;
        block6: {
            bundle = null;
            FileInputStream input = null;
            FileInputStream input2 = null;
            SequenceInputStream sis = null;
            try {
                input = new FileInputStream(propertiesFile);
                ArrayList<FileInputStream> inputList = new ArrayList<FileInputStream>();
                inputList.add(input);
                if (null != commonResFile && commonResFile.exists()) {
                    input2 = new FileInputStream(commonResFile);
                    inputList.add(input2);
                }
                Enumeration inputEnums = Collections.enumeration(inputList);
                sis = new SequenceInputStream(inputEnums);
                bundle = new PropertyResourceBundle(sis);
                StreamUtils.closeStream(null, (InputStream)input);
            }
            catch (Exception e) {
                LOGGER.error("load product properties failed.", e);
                break block6;
            }
            finally {
                StreamUtils.closeStream(null, (InputStream)input);
                StreamUtils.closeStream(null, input2);
                StreamUtils.closeStream(null, sis);
            }
            StreamUtils.closeStream(null, (InputStream)input2);
            StreamUtils.closeStream(null, (InputStream)sis);
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> loadOpenTlvProduct() {
        File file = new File(PACKAGE_PATH, NEED_OPEN_TLV_PATH);
        ArrayList<String> list = new ArrayList<String>();
        if (!file.exists()) {
            LOGGER.info(String.format(Locale.ENGLISH, "not found file %s", file));
            return list;
        }
        FileInputStream fs = null;
        List<String> versions = null;
        try {
            fs = new FileInputStream(file);
            Document doc = XmlUtils.parseDocument((InputStream)fs);
            Element root = doc.getDocumentElement();
            NodeList openTlvNodes = XmlUtils.searchNodeByExp((Element)root, (String)"/Feature/NeedOpenTLVChanenel/Product");
            NodeList shareCardNodes = XmlUtils.searchNodeByExp((Element)root, (String)"/Feature/supportShareCard/supportItem");
            if (openTlvNodes == null || shareCardNodes == null) {
                ArrayList<String> arrayList = list;
                return arrayList;
            }
            List featureSupports = FeatureSupportConfig.parse((NodeList)shareCardNodes);
            EvaluContext.getInstance().setFeatureSupports(featureSupports);
            versions = ProductParser.parseOpenTlv(openTlvNodes);
            list.addAll(versions);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load neededOpenTlvChannel.xml ", e);
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)fs);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EvaluContext.VersionPathItem> loadVersionPath() {
        LOGGER.info(String.format(Locale.ENGLISH, "upgradeEvalu home dir=%s", EvaluContext.getInstance().getHome()));
        File file = new File(PACKAGE_PATH, VERSION_EVAL_PATH);
        ArrayList<EvaluContext.VersionPathItem> list = new ArrayList<EvaluContext.VersionPathItem>();
        if (!file.exists()) {
            LOGGER.info(String.format(Locale.ENGLISH, "not found file %s", file));
            return list;
        }
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(file);
            Document doc = XmlUtils.parseDocument((InputStream)fs);
            Element root = doc.getDocumentElement();
            Element storageProduct = XmlUtils.getChild((Element)root, (String)ItDeviceType.Storage.getName());
            Collection versionItems = XmlUtils.getChildren((Element)storageProduct);
            for (Element versionItem : versionItems) {
                EvaluContext.VersionPathItem item = new EvaluContext.VersionPathItem();
                item.setDevice(XmlUtils.getTextContentOfChild((Element)versionItem, (String)"device"));
                item.setDeviceVersion(XmlUtils.getTextContentOfChild((Element)versionItem, (String)"deviceVersion"));
                item.setDestVersion(XmlUtils.getTextContentOfChild((Element)versionItem, (String)"destVersion"));
                item.setUpgradeMode(XmlUtils.getTextContentOfChild((Element)versionItem, (String)"upgradeMode"));
                list.add(item);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load VersionEvalPath.xml ", e);
            ArrayList<EvaluContext.VersionPathItem> arrayList = list;
            return arrayList;
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)fs);
        }
        return list;
    }

    private static List<String> parseOpenTlv(NodeList openTlvNodes) {
        ArrayList<String> versions = new ArrayList<String>();
        for (int i = 0; i < openTlvNodes.getLength(); ++i) {
            Node node = openTlvNodes.item(i);
            if (!(node instanceof Element)) continue;
            Element ele = (Element)node;
            String version = XmlUtils.getAttribute((Element)ele, (String)MODELE_VERSION);
            versions.add(version);
        }
        return versions;
    }

    public static File getCommonPackagePath() {
        String storageCommonPath = PRODUCTS_FOLDER + File.separator + "StorageCommon";
        File commonPackagePath = new File(PACKAGE_PATH, storageCommonPath);
        return commonPackagePath;
    }

    private static class InnerFileFilter
    implements FileFilter {
        private InnerFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    }
}

