/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.entity;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SftpTransporter;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.upgradeevalu.entity.CrossVersionType;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluItem;
import com.huawei.ism.tool.upgradeevalu.entity.ExtraCheckItem;
import com.huawei.ism.tool.upgradeevalu.entity.ProductCfg;
import com.huawei.ism.tool.upgradeevalu.entity.UpgradeMode;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluService;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluState;
import com.huawei.ism.tool.upgradeevalu.evalu.ResultFlag;
import com.huawei.ism.tool.upgradeevalu.evalu.ResultItem;
import com.huawei.ism.tool.upgradeevalu.util.EvaluResultHelper;
import com.huawei.ism.tool.upgradeevalu.util.EvaluSceneUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluDevNode
extends DevNode {
    private static final Logger log = LoggerFactory.getLogger(EvaluDevNode.class);
    private String id;
    private UpgradeMode upgradeMode = UpgradeMode.ONLINE;
    private UpgradeMode upgradeModeUI = UpgradeMode.ONLINE;
    private UpgradeMode containerUpgradeMode = UpgradeMode.OFFLINE_CONTAINER;
    private UpgradeMode containerUpgradeModeUI = UpgradeMode.OFFLINE_CONTAINER;
    private String currentStrategy = "";
    private String destVersion;
    private String containerDestVersion = "";
    private String containerVersion = "";
    private String targetContainerVersion = "";
    private boolean isSecondaryUpgrade = false;
    private boolean isStorageImageUpgrade = false;
    private String preCheckModel = "";
    private List<String> zoneIds;
    private String executeZoneIp;
    private String upgPatchPkgVer = "";
    private KeyOrderedHashMap<CrossVersionType, ProductCfg> productCfgs = new KeyOrderedHashMap();
    private int evaluProgress;
    private boolean crossVersion = false;
    private EvaluState evaluState = EvaluState.WAIT;
    private Map<String, Object> extraMap = new HashMap<String, Object>();
    private Map<String, EvaluItem> extraEvaluItems = new HashMap<String, EvaluItem>();
    private Calendar startTime;
    private Calendar endTime;
    private ExtraCheckItem extraCheckItem = new ExtraCheckItem();
    private ArrayList<String> hostInfoList = new ArrayList();
    private boolean isFailover = false;
    private String svpIp = "";
    private boolean isHostCompatible = false;
    private boolean needLog = false;
    private ICliConnection ssh = null;
    private SftpTransporter sftp = null;
    private EvaluResultHelper resultHelper = new EvaluResultHelper();
    private boolean finish = false;
    private boolean supportFast = false;
    private boolean fastAndRollType = false;
    private boolean stopHostBusiness = false;
    private boolean supportShareCardUpgrade = false;
    private boolean supportApollo = false;
    private String deviceKernelVersion = "";
    private String targetKernelVersion = "";

    public Map<String, EvaluItem> getExtraEvaluItems() {
        return this.extraEvaluItems;
    }

    public boolean isNeedLog() {
        return this.needLog;
    }

    public void setNeedLog(boolean isNeedLog) {
        this.needLog = isNeedLog;
    }

    public EvaluDevNode(DevNode dev) {
        if (null == dev) {
            return;
        }
        this.setRemoteSNs(dev.getRemoteSNs());
        this.id = dev.getDeviceType().toString() + "_" + dev.getDeviceSerialNumber();
        this.setIp(dev.getIp());
        this.setDeviceName(dev.getDeviceName());
        this.setDeviceSerialNumber(dev.getDeviceSerialNumber());
        this.setDeviceType(dev.getDeviceType());
        this.setDevTypeLevel2(dev.getDevTypeLevel2());
        this.setPort(dev.getPort());
        this.setTlvPort(dev.getTlvPort());
        this.setIpListAreInnerIp(dev.isIpListAreInnerIp());
        this.setProductVersion(dev.getProductVersion());
        this.setHotPatchVersion(dev.getHotPatchVersion());
        this.setUuid(dev.getUuid());
        this.setDeveloperPwd(dev.getDeveloperPwd());
        for (String str : dev.getIpList()) {
            this.addIp(str);
        }
        this.getIpList().addAll(dev.getIpList());
        this.setLoginUser(dev.getLoginUser());
        this.setCreateTime(dev.getCreateTime());
        this.setPeerIp(dev.getPeerIp());
        this.setSocks5Proxy(dev.getSocks5Proxy());
        this.getSshForwardList().addAll(dev.getSshForwardList());
        this.setPriKey(dev.getPriKey());
        this.setItDeviceType(dev.getItDeviceType());
        this.evaluProgress = 0;
        this.setHighDevSVPModuleInfo(dev.getHighDevSVPModuleInfo());
        this.setCanEnterDiagnose(dev.canEnterDiagnose());
        this.setSshHostKey(dev.getSshHostKey());
        this.setVerifySshHostKey(dev.isVerifySshHostKey());
        this.setVerifyCertificate(dev.isVerifyCertificate());
        this.setStorageDeviceType(dev.getStorageDeviceType());
    }

    public ExtraCheckItem getExtraCheckItem() {
        return this.extraCheckItem;
    }

    public UpgradeMode getUpgradeMode() {
        return this.isStorageImageUpgrade && EvaluSceneUtils.isContainerSubScene() ? this.containerUpgradeMode : this.upgradeMode;
    }

    public UpgradeMode getStorageUpgradeMode() {
        return this.upgradeMode;
    }

    public void setUpgradeMode(UpgradeMode upgradeMode) {
        this.upgradeMode = upgradeMode;
    }

    public String getUpgPatchPkgVer() {
        return this.upgPatchPkgVer;
    }

    public void setUpgPatchPkgVer(String upgPatchPkgVer) {
        this.upgPatchPkgVer = upgPatchPkgVer;
    }

    public String getDestVersion() {
        return this.isStorageImageUpgrade && EvaluSceneUtils.isContainerSubScene() ? this.containerDestVersion : this.destVersion;
    }

    public void setDestVersion(String destVersion) {
        this.destVersion = destVersion;
    }

    public int getEvaluProgress() {
        return this.evaluProgress;
    }

    public void setEvaluProgress(int evaluProgress) {
        this.evaluProgress = evaluProgress;
    }

    public boolean isCrossVersion() {
        return this.crossVersion;
    }

    public void setCrossVersion(boolean crossVersion) {
        this.crossVersion = crossVersion;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<ProductCfg> getAllProducts() {
        ArrayList<ProductCfg> prods = new ArrayList<ProductCfg>();
        ProductCfg innerProd = (ProductCfg)this.productCfgs.get((Object)CrossVersionType.INNERVERSION);
        prods.add(innerProd);
        if (this.isCrossVersion()) {
            ProductCfg crossProd = (ProductCfg)this.productCfgs.get((Object)CrossVersionType.CROSSVERSION);
            prods.add(crossProd);
        }
        return prods;
    }

    public ProductCfg getProduct(CrossVersionType crossType) {
        return (ProductCfg)this.productCfgs.get((Object)crossType);
    }

    public void setSupportShareCardUpgrade(boolean supportShareCardUpgrade) {
        this.supportShareCardUpgrade = supportShareCardUpgrade;
    }

    public boolean isSupportShareCardUpgrade() {
        return this.supportShareCardUpgrade;
    }

    public void clearRetItem() {
        List<ProductCfg> prods = this.getAllProducts();
        for (ProductCfg prod : prods) {
            List<EvaluItem> items;
            if (prod.getCrossVersionType().equals((Object)CrossVersionType.INNERVERSION)) {
                items = prod.getInnerItems();
                for (EvaluItem evaluItem : items) {
                    evaluItem.setRetItem(null);
                }
                continue;
            }
            items = prod.getCrossVerCfg().getCrossItems();
            for (EvaluItem evaluItem : items) {
                evaluItem.setRetItem(null);
            }
        }
    }

    public List<EvaluItem> getAllEvaluItem() {
        ArrayList<EvaluItem> allItem = new ArrayList<EvaluItem>();
        List<ProductCfg> prods = this.getAllProducts();
        for (ProductCfg prod : prods) {
            if (null == prod) {
                return allItem;
            }
            if (prod.getCrossVersionType().equals((Object)CrossVersionType.INNERVERSION)) {
                allItem.addAll(prod.getInnerItems());
                continue;
            }
            allItem.addAll(prod.getCrossVerCfg().getCrossItems());
        }
        return allItem;
    }

    public void findAbnormalItem() {
        List<EvaluItem> allItem = this.getAllEvaluItem();
        for (EvaluItem item : allItem) {
            if (item.getRetItem() == null || !ResultFlag.WAITING.equals((Object)item.getRetItem().getRetFlag())) continue;
            item.getRetItem().setRetFlag(ResultFlag.NOCHECK);
        }
    }

    public String getEvaluTime() {
        if (null != this.startTime && null != this.endTime) {
            this.startTime.set(14, 0);
            this.endTime.set(14, 0);
            return StringUtils.millls2FormatString((long)(this.endTime.getTimeInMillis() - this.startTime.getTimeInMillis()));
        }
        return "--";
    }

    public String getModelVersion() {
        String modelVersion = null;
        switch (this.getItDeviceType()) {
            case A800_NODE: 
            case Storage: {
                String vrcVerSion = EvaluService.getInstance().getVRCVersion(this.getProductVersion());
                modelVersion = this.getDeviceType().toString() + " " + vrcVerSion;
                break;
            }
            case Host: 
            case Switch: {
                modelVersion = this.getDeviceType().toString();
                break;
            }
            default: {
                modelVersion = "--";
            }
        }
        return modelVersion;
    }

    public List<File> getClssPath() {
        ArrayList<File> clssPath = new ArrayList<File>();
        ProductCfg innerProd = (ProductCfg)this.productCfgs.get((Object)CrossVersionType.INNERVERSION);
        File innerProdDir = innerProd.getProductDir();
        clssPath.add(innerProdDir);
        return clssPath;
    }

    public KeyOrderedHashMap<CrossVersionType, ProductCfg> getProducts() {
        return this.productCfgs;
    }

    public void setProducts(KeyOrderedHashMap<CrossVersionType, ProductCfg> products) {
        this.productCfgs = products;
    }

    public EvaluState getEvaluState() {
        return this.evaluState;
    }

    public void setEvaluState(EvaluState evaluState) {
        this.evaluState = evaluState;
    }

    public Map<String, Object> getExtraMap() {
        return this.extraMap;
    }

    public void setExtraMap(Map<String, Object> extraMap) {
        this.extraMap = extraMap;
    }

    public Calendar getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Calendar startTime) {
        this.startTime = startTime;
    }

    public Calendar getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Calendar endTime) {
        this.endTime = endTime;
    }

    public void reset() {
        this.clearRetItem();
        this.evaluState = EvaluState.WAIT;
        this.evaluProgress = 0;
        this.startTime = null;
        this.endTime = null;
        this.extraCheckItem.getBeforeCheckItems().clear();
        this.extraCheckItem.getAfterCheckItems().clear();
    }

    public ResultItem getEvaluRet() {
        List<EvaluItem> items = this.getAllEvaluItem();
        ResultItem ret = new ResultItem();
        ret.setRetFlag(ResultFlag.NOTPASS);
        if (items.isEmpty()) {
            return ret;
        }
        for (EvaluItem item : items) {
            ResultItem ri = item.getRetItem();
            if (null == ri || ri.getRetFlag().equals((Object)ResultFlag.PASS) || ri.getRetFlag().equals((Object)ResultFlag.NOSUPPORT)) continue;
            return ret;
        }
        ret.setRetFlag(ResultFlag.PASS);
        return ret;
    }

    public float getPassRate() {
        int pass = 0;
        int count = 0;
        List<ProductCfg> prods = this.getAllProducts();
        for (ProductCfg prod : prods) {
            List<EvaluItem> items = prod.getCrossVersionType().equals((Object)CrossVersionType.INNERVERSION) ? prod.getInnerItems() : prod.getCrossVerCfg().getCrossItems();
            for (EvaluItem item : items) {
                if (item.getRetItem().getRetFlag().equals((Object)ResultFlag.PASS) || item.getRetItem().getRetFlag().equals((Object)ResultFlag.NOSUPPORT)) {
                    ++pass;
                }
                ++count;
            }
        }
        if (count == 0) {
            return 0.0f;
        }
        return (float)Math.floor((float)pass / (float)count * 100.0f);
    }

    public String getDeviceModel() {
        return this.getDeviceType().toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 17;
        result = 31 * result + (null == this.id ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        EvaluDevNode other = (EvaluDevNode)((Object)obj);
        return !(null == this.id ? null != other.id : !this.id.equals(other.id));
    }

    public void clearData() {
        this.reset();
        this.productCfgs.clear();
    }

    public Map<ResultFlag, Integer> getEvaluItemStatistics() {
        int passCount = 0;
        int notPassCount = 0;
        int noCheckCount = 0;
        int noSupportCount = 0;
        int warnCount = 0;
        List<EvaluItem> evaluItems = this.getAllEvaluItem();
        block6: for (EvaluItem item : evaluItems) {
            ResultItem ri = item.getRetItem();
            if (null == ri) continue;
            switch (ri.getRetFlag()) {
                case PASS: {
                    ++passCount;
                    continue block6;
                }
                case NOTPASS: {
                    ++notPassCount;
                    continue block6;
                }
                case NOCHECK: {
                    ++noCheckCount;
                    continue block6;
                }
                case WARN: {
                    ++warnCount;
                    continue block6;
                }
            }
            ++noSupportCount;
        }
        HashMap<ResultFlag, Integer> statistics = new HashMap<ResultFlag, Integer>();
        statistics.put(ResultFlag.PASS, passCount);
        statistics.put(ResultFlag.NOTPASS, notPassCount);
        statistics.put(ResultFlag.NOCHECK, noCheckCount);
        statistics.put(ResultFlag.WARN, warnCount);
        statistics.put(ResultFlag.NOSUPPORT, noSupportCount);
        return statistics;
    }

    public boolean isStorage() {
        return ItDeviceType.Storage.equals((Object)this.getItDeviceType());
    }

    public boolean needShowDetail() {
        List<EvaluItem> items = this.getAllEvaluItem();
        if (items.isEmpty()) {
            return false;
        }
        boolean result = false;
        for (EvaluItem item : items) {
            ResultItem ri = item.getRetItem();
            if (null == ri) continue;
            if (!(ri.getRetFlag().equals((Object)ResultFlag.PASS) || ri.getRetFlag().equals((Object)ResultFlag.NOSUPPORT) || ri.getRetFlag().equals((Object)ResultFlag.NOCHECK))) {
                return false;
            }
            if (!ri.getRetFlag().equals((Object)ResultFlag.NOCHECK)) continue;
            if (item.isSceneLogic()) {
                result = true;
                continue;
            }
            return false;
        }
        return result;
    }

    public boolean isDisableSceneStepRet() {
        List<EvaluItem> items = this.getAllEvaluItem();
        if (items.isEmpty()) {
            return true;
        }
        for (EvaluItem item : items) {
            ResultItem ri;
            if (!item.isDisableSceneStep() || null == (ri = item.getRetItem()) || ri.getRetFlag().equals((Object)ResultFlag.PASS) || ri.getRetFlag().equals((Object)ResultFlag.NOSUPPORT)) continue;
            return false;
        }
        return true;
    }

    public ArrayList<String> getHostInfoList() {
        return this.hostInfoList;
    }

    public void setHostInfoList(ArrayList<String> hostInfoList) {
        this.hostInfoList = hostInfoList;
    }

    public boolean isFailover() {
        return this.isFailover;
    }

    public void setFailover(boolean failoverFlag) {
        this.isFailover = failoverFlag;
    }

    public boolean isHostCompatible() {
        return this.isHostCompatible;
    }

    public void setHostCompatible(boolean hostCompatibleFlag) {
        this.isHostCompatible = hostCompatibleFlag;
    }

    public ICliConnection getSsh() {
        return this.ssh;
    }

    public void setSsh(ICliConnection ssh) {
        this.ssh = ssh;
    }

    public SftpTransporter getSftp() {
        return this.sftp;
    }

    public void setSftp(SftpTransporter sftp) {
        this.sftp = sftp;
    }

    public EvaluResultHelper getResultHelper() {
        return this.resultHelper;
    }

    public void setResultHelper(EvaluResultHelper resultHelper) {
        this.resultHelper = resultHelper;
    }

    public String getSvpIp() {
        return this.svpIp;
    }

    public void setSvpIp(String svpIp) {
        this.svpIp = svpIp;
    }

    public boolean isEvaluFinish() {
        return this.finish;
    }

    public void setEvaluFinish(boolean isFinish) {
        this.finish = isFinish;
    }

    public UpgradeMode getUpgradeModeUI() {
        return this.isStorageImageUpgrade && EvaluSceneUtils.isContainerSubScene() ? this.containerUpgradeModeUI : this.upgradeModeUI;
    }

    public void setUpgradeModeUI(UpgradeMode upgradeModeUI) {
        this.upgradeModeUI = upgradeModeUI;
    }

    public boolean isStopHostBusiness() {
        return this.stopHostBusiness;
    }

    public void setStopHostBusiness(boolean stopHostBusiness) {
        this.stopHostBusiness = stopHostBusiness;
    }

    public boolean isSupportFast() {
        return this.supportFast;
    }

    public void setSupportFast(boolean supportFast) {
        this.supportFast = supportFast;
    }

    public boolean isFastAndRollType() {
        return this.fastAndRollType;
    }

    public void setFastAndRollType(boolean fastAndRollType) {
        this.fastAndRollType = fastAndRollType;
    }

    public boolean isSupportApollo() {
        return this.supportApollo;
    }

    public void setSupportApollo(boolean supportApollo) {
        this.supportApollo = supportApollo;
    }

    public String getDeviceKernelVersion() {
        return this.deviceKernelVersion;
    }

    public void setDeviceKernelVersion(String deviceKernelVersion) {
        this.deviceKernelVersion = deviceKernelVersion;
    }

    public String getTargetKernelVersion() {
        return this.targetKernelVersion;
    }

    public void setTargetKernelVersion(String targetKernelVersion) {
        this.targetKernelVersion = targetKernelVersion;
    }

    public void setContainerUpgradeMode(UpgradeMode containerUpgradeMode) {
        this.containerUpgradeMode = containerUpgradeMode;
    }

    public UpgradeMode getContainerUpgradeMode() {
        return this.containerUpgradeMode;
    }

    public void setContainerUpgradeModeUI(UpgradeMode containerUpgradeModeUI) {
        this.containerUpgradeModeUI = containerUpgradeModeUI;
    }

    public UpgradeMode getContainerUpgradeModeUI() {
        return this.containerUpgradeModeUI;
    }

    public String getCurrentStrategy() {
        return this.currentStrategy;
    }

    public void setCurrentStrategy(String currentStrategy) {
        this.currentStrategy = currentStrategy;
    }

    public void setContainerDestVersion(String containerDestVersion) {
        this.containerDestVersion = containerDestVersion;
    }

    public String getContainerDestVersion() {
        return this.containerDestVersion;
    }

    public void setContainerVersion(String containerVersion) {
        this.containerVersion = containerVersion;
    }

    public String getContainerVersion() {
        return this.containerVersion;
    }

    public void setTargetContainerVersion(String targetContainerVersion) {
        this.targetContainerVersion = targetContainerVersion;
    }

    public String getTargetContainerVersion() {
        return this.targetContainerVersion;
    }

    public void setSecondaryUpgrade(boolean isSecondaryUpgrade) {
        this.isSecondaryUpgrade = isSecondaryUpgrade;
    }

    public boolean isSecondaryUpgrade() {
        return this.isSecondaryUpgrade;
    }

    public void setStorageImageUpgrade(boolean isStorageImageUpgrade) {
        this.isStorageImageUpgrade = isStorageImageUpgrade;
    }

    public boolean isStorageImageUpgrade() {
        return this.isStorageImageUpgrade;
    }

    public String getPreCheckModel() {
        return this.preCheckModel;
    }

    public void setPreCheckModel(String preCheckModel) {
        this.preCheckModel = preCheckModel;
    }

    public List<String> getZoneIds() {
        return this.zoneIds;
    }

    public void setZoneIds(List<String> zoneIds) {
        this.zoneIds = zoneIds;
    }

    public String getExecuteZoneIp() {
        return this.executeZoneIp;
    }

    public void setExecuteZoneIp(String executeZoneIp) {
        this.executeZoneIp = executeZoneIp;
    }
}

