/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.entity;

import com.huawei.ism.tool.obase.utils.IniResourceUtil;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.pyengine.psdk.bean.CheckConfigItem;
import com.huawei.ism.tool.upgradeevalu.entity.CrossVersionType;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.entity.ProductCfg;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluDevManager;
import com.huawei.ism.tool.upgradeevalu.evalu.ResultItem;
import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.Products;

public class EvaluItem
implements Cloneable {
    private static final Logger log = LoggerFactory.getLogger(EvaluItem.class);
    private String identifier;
    private String id;
    private String name;
    private String mode;
    private File script;
    private ResultItem retItem;
    private String devID;
    private boolean needLog = false;
    private boolean showOrigin = true;
    private boolean showMethod = true;
    private boolean showCriterion = true;
    private CrossVersionType crossVersionType = CrossVersionType.INNERVERSION;
    private boolean sceneLogic = false;
    private boolean disableSceneStep = false;
    private String scriptPath = "";
    private String itemType = "";
    private CheckConfigItem checkConfigItem;
    private Object extras = null;
    private List<EvaluItem> childItems = null;

    public Object getExtras() {
        return this.extras;
    }

    public void setExtras(Object extras) {
        this.extras = extras;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public String getDevID() {
        return this.devID;
    }

    public void setDevID(String devID) {
        this.devID = devID;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public File getScript() {
        return this.script;
    }

    public void setScript(File script) {
        this.script = script;
    }

    public ResultItem getRetItem() {
        return this.retItem;
    }

    public void setRetItem(ResultItem retItem) {
        this.retItem = retItem;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Object clone() throws CloneNotSupportedException {
        EvaluItem evaluItem = (EvaluItem)super.clone();
        return evaluItem;
    }

    public boolean isShowOrigin() {
        return this.showOrigin;
    }

    public void setShowOrigin(boolean showOrigin) {
        this.showOrigin = showOrigin;
    }

    public boolean isShowMethod() {
        return this.showMethod;
    }

    public void setShowMethod(boolean showMethod) {
        this.showMethod = showMethod;
    }

    public boolean isShowCriterion() {
        return this.showCriterion;
    }

    public void setShowCriterion(boolean showCriterion) {
        this.showCriterion = showCriterion;
    }

    public CrossVersionType getCrossVersionType() {
        return this.crossVersionType;
    }

    public void setCrossVersionType(CrossVersionType crossVersionType) {
        this.crossVersionType = crossVersionType;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 17;
        result = 31 * result + (null == this.identifier ? 0 : this.identifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EvaluItem other = (EvaluItem)obj;
        return !(null == this.identifier ? null != other.identifier : !this.identifier.equals(other.identifier));
    }

    public boolean isForgeItem() {
        return null == this.id || "pre_check".equals(this.id);
    }

    public boolean isSceneLogic() {
        return this.sceneLogic;
    }

    public void setSceneLogic(boolean sceneLogic) {
        this.sceneLogic = sceneLogic;
    }

    public boolean isDisableSceneStep() {
        return this.disableSceneStep;
    }

    public void setDisableSceneStep(boolean disableSceneStep) {
        this.disableSceneStep = disableSceneStep;
    }

    public void setNeedLog(boolean needLog) {
        this.needLog = needLog;
    }

    public boolean isNeedLog() {
        return this.needLog;
    }

    public List<EvaluItem> getChildItems() {
        return this.childItems;
    }

    public void setChildItems(List<EvaluItem> childItems) {
        this.childItems = childItems;
    }

    public String getString(String key) {
        EvaluDevNode dev = EvaluDevManager.getInstance().getTabDevById(this.getDevID());
        if ("innerCheck".equals(this.getItemType())) {
            String val;
            String devType = dev.getDeviceType().toString().replace("_container", "");
            log.info("dev type:{}", (Object)devType);
            if (Products.isDoradoV6SeriseDev((String)devType) && !"--".equals(val = IniResourceUtil.getString((String)"cbb/res/upgrade", (String)"resource_dorado", (String)key))) {
                return val;
            }
            val = IniResourceUtil.getString((String)key);
            val = "--".equals(val) ? key : val;
            return val;
        }
        if (this.getCheckConfigItem() != null) {
            String[] keys = key.split("\\.");
            return this.getItemResource(keys[keys.length - 1]);
        }
        KeyOrderedHashMap<CrossVersionType, ProductCfg> products = dev.getProducts();
        ResourceBundle bundle = ((ProductCfg)products.get((Object)this.getCrossVersionType())).getResBundle();
        return bundle.getString(key);
    }

    private String getItemResource(String name) {
        switch (name) {
            case "name": {
                return this.getCheckConfigItem().getName();
            }
            case "method": {
                return this.getCheckConfigItem().getMethod();
            }
            case "criterion": {
                return this.getCheckConfigItem().getCriterion();
            }
            case "suggestion": {
                return this.getCheckConfigItem().getSuggestion();
            }
        }
        return "";
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public CheckConfigItem getCheckConfigItem() {
        return this.checkConfigItem;
    }

    public void setCheckConfigItem(CheckConfigItem checkConfigItem) {
        this.checkConfigItem = checkConfigItem;
    }
}

