/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.entity;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.SystemEnvUtil;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluState;
import com.huawei.ism.tool.upgradeevalu.evalu.ResultFlag;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.ism.tool.upgradeevalu.util.EvaluSceneUtils;
import com.huawei.ism.tool.upgradeevalu.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EvaluResultXml {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(EvaluResultXml.class);
    private static final String PROCESS_RESULT = "processResult";
    private static final String END_TIME = "endTime";
    private static final String RESULT_DIR = "resultDir";
    private static final String DEVICE = "device";
    private static final String SN_IP = "SN_IP";
    private static final String RESULT = "Result";
    private static final String PASSED = "Passed";
    private static final String FAILED = "Failed";
    private static final String CURRENT_VERSION = "CurrentVersion";
    private static final String SCENE = "scene";
    private static final String PACKAGE_PATH = "sceneEvalDetails.xml";
    private static final String SCENE_EVAL_XML_PATH = SystemEnvUtil.getDefaultUserDir() + File.separator + "sceneEvalDetails.xml";
    private static final File SCENE_DATA_XML = new File(SCENE_EVAL_XML_PATH);
    private Map<String, Map<String, String>> devEvaluMap = new HashMap<String, Map<String, String>>();
    private static final String JSON_SCENE = "jsonScene";
    private static final EvaluResultXml INSTANCE = new EvaluResultXml();
    private static DocumentBuilder documentBuilder = null;
    private static Document document = null;
    private FileOutputStream fos = null;

    private EvaluResultXml() {
    }

    public static EvaluResultXml getInstance() {
        return INSTANCE;
    }

    public void saveResultXml() {
        try {
            if (this.devEvaluMap.isEmpty()) {
                return;
            }
            this.initXml();
            this.initDocBuilder();
            String processResult = PASSED;
            for (Map<String, String> resultMap : this.devEvaluMap.values()) {
                String result = resultMap.get(RESULT);
                if (!result.contains(FAILED)) continue;
                processResult = FAILED;
            }
            Document newdoc = null;
            newdoc = this.createEvalRestultXML(document, processResult);
            this.tranformerResult(newdoc);
        }
        catch (Exception e) {
            LOGGER.error("write EvaluResultXml error!", e);
        }
    }

    private void initXml() {
        try {
            boolean isSucc;
            if (SCENE_DATA_XML.exists()) {
                this.deleteFile(SCENE_DATA_XML);
            }
            if (isSucc = SCENE_DATA_XML.createNewFile()) {
                this.fos = new FileOutputStream(SCENE_DATA_XML);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Init FileNotFoundException error!");
        }
        catch (IOException e) {
            LOGGER.error("Init IOException error!");
        }
    }

    private void initDocBuilder() {
        try {
            DocumentBuilderFactory builderFactory = XmlUtils.getDocumentBuilderFactory();
            builderFactory.setXIncludeAware(false);
            builderFactory.setExpandEntityReferences(false);
            documentBuilder = builderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("documentBuilder build faild", e);
        }
    }

    private void deleteFile(File file) {
        int retryTimes = 2;
        for (int i = 0; i < retryTimes && !file.delete(); ++i) {
        }
    }

    public void setEvaluRes(EvaluDevNode evaluDevNode) {
        try {
            String devEvalResult = FAILED;
            String ip = evaluDevNode.getIp();
            if (EvaluContext.getInstance().isResetIP()) {
                LOGGER.info("the dev is high");
                ip = EvaluContext.getInstance().getSvpIp();
            }
            String snIP = this.setSnIp(evaluDevNode.getDeviceSerialNumber(), ip);
            EvaluState status = evaluDevNode.getEvaluState();
            ResultFlag retFlag = evaluDevNode.getEvaluRet().getRetFlag();
            String curVersion = evaluDevNode.getProductVersion();
            LOGGER.info(String.format(Locale.ENGLISH, "SN_IP :%s; EvaluState:%s; ResultFlag:%s;ProductVersion:%s", new Object[]{snIP, status, retFlag, curVersion}));
            if (EvaluState.SUCCESS == status && ResultFlag.PASS.equals((Object)retFlag)) {
                devEvalResult = PASSED;
            }
            HashMap<String, String> devEvalResultMap = new HashMap<String, String>();
            devEvalResultMap.put(RESULT, devEvalResult);
            devEvalResultMap.put(CURRENT_VERSION, curVersion);
            this.devEvaluMap.put(snIP, devEvalResultMap);
        }
        catch (Exception e) {
            LOGGER.error("setEvaluRes error.", e);
        }
    }

    private void tranformerResult(Document newdoc) {
        try {
            Transformer transformer = XmlUtils.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.transform(new DOMSource(newdoc), new StreamResult(this.fos));
            LOGGER.info("xml write successed.");
            return;
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("xml write failed,IllegalArgument");
            return;
        }
        catch (TransformerFactoryConfigurationError e) {
            LOGGER.error("xml write failed,TransformerFactoryConfigurationError");
            return;
        }
        catch (Exception e) {
            LOGGER.error("xml write failed,TransformerException", e);
            return;
        }
        finally {
            StreamUtils.closeStream((OutputStream)this.fos, null);
        }
    }

    private Document createEvalRestultXML(Document doc, String result) {
        Element root = doc.createElement(SCENE);
        doc.appendChild(root);
        Element processResult = doc.createElement(PROCESS_RESULT);
        root.appendChild(processResult);
        Text processResultText = doc.createTextNode(result);
        processResult.appendChild(processResultText);
        this.writeSceneDataFinishedTime(doc, root);
        if (new EvaluSceneUtils().isPreUpgradeCheckSubScene()) {
            this.writeResultDir(doc, root);
        }
        this.addDevEvaluResult(doc, root, this.devEvaluMap);
        return doc;
    }

    private void writeSceneDataFinishedTime(Document doc, Element root) {
        Date date = new Date();
        String time = this.getDateString(date);
        Element endTime = doc.createElement(END_TIME);
        root.appendChild(endTime);
        LOGGER.info(String.format(Locale.ENGLISH, "xml.END_TIME endTime :%s", time));
        Text endTimeText = doc.createTextNode(time);
        endTime.appendChild(endTimeText);
    }

    private void writeResultDir(Document doc, Element root) {
        Element resultDir = doc.createElement(RESULT_DIR);
        root.appendChild(resultDir);
        String reportDir = FileUtil.getCanonicalPath(EvaluContext.getInstance().getReportDir());
        LOGGER.info(String.format(Locale.ENGLISH, "xml.RESULT_DIR resultDir :%s", reportDir));
        Text resultDirValue = doc.createTextNode(reportDir);
        resultDir.appendChild(resultDirValue);
    }

    private void addDevEvaluResult(Document doc, Element root, Map<String, Map<String, String>> map) {
        Object devResult = null;
        String snIP = null;
        for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
            snIP = entry.getKey();
            Map<String, String> resultMap = entry.getValue();
            String devEvaluResult = resultMap.get(RESULT);
            String curVersion = resultMap.get(CURRENT_VERSION);
            Element device = doc.createElement(DEVICE);
            device.setAttribute(SN_IP, snIP);
            device.setAttribute(RESULT, devEvaluResult);
            device.setAttribute(CURRENT_VERSION, curVersion);
            root.appendChild(device);
        }
    }

    private String getDateString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    public Map<String, Map<String, String>> getDevEvaluMap() {
        return this.devEvaluMap;
    }

    public String setSnIp(String sn, String ip) {
        return sn + "_" + ip;
    }

    public boolean isScene() {
        String sceneKey = JSON_SCENE;
        String sceneInfo = System.getenv(sceneKey);
        return !StringUtils.isNULLStr((String)sceneInfo);
    }
}

