/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.entity;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.StorageInfo;
import com.huawei.ism.tool.obase.entity.UpgradeHostInfo;
import com.huawei.ism.tool.upgradeevalu.entity.NotAdminUserDeviceInfo;
import com.huawei.ism.tool.upgradeevalu.scene.SceneDataExtendUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class HostEvalNode {
    private String fileName;
    private Date importTime;
    private Date lastEvalTime;
    private int numOfHosts;
    private int progress;
    private boolean taskComplete;
    private String identifier;
    private List<NotAdminUserDeviceInfo> notAdminUserDeviceInfo = new ArrayList<NotAdminUserDeviceInfo>();
    private String storageName;
    private String storageIp;
    private String storageSn;
    private String storageProductVersion;
    private String storageType;
    private String hostNumInfo;
    private int addedHostNumbers;
    private int allHostNumbers;
    private StorageInfo mappedStorage;
    private List<DevNode> storageMappingHosts = new ArrayList<DevNode>();
    private List<DevNode> unAssociateHosts = new ArrayList<DevNode>();
    private List<DevNode> manulAssociatedHosts = new ArrayList<DevNode>();
    private Map<String, Integer> oneVsMultipleLogicalHostMap = new HashMap<String, Integer>();
    private List<DevNode> notAllowAssociatedHosts = new ArrayList<DevNode>();

    public StorageInfo getMappedStorage() {
        return this.mappedStorage;
    }

    public void setMappedStorage(StorageInfo mappedStorage) {
        this.mappedStorage = mappedStorage;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getHostNumInfo() {
        return this.hostNumInfo;
    }

    public void setHostNumInfo(String hostNumInfo) {
        this.hostNumInfo = hostNumInfo;
    }

    public void calcHostNumInfo() {
        if (this.allHostNumbers == -1) {
            this.hostNumInfo = "ERROR";
        }
        this.numOfHosts = this.getAddHostNumberForEvalNode();
        StringBuilder info = new StringBuilder();
        int manulAssociatedHostsCount = this.getAddHostNumberForEvalNode();
        int toAddCount = this.allHostNumbers - this.numOfHosts;
        info.append(toAddCount < 0 ? 0 : toAddCount).append('/');
        info.append(manulAssociatedHostsCount).append('/');
        info.append(this.numOfHosts - manulAssociatedHostsCount);
        this.hostNumInfo = info.toString();
    }

    public String getIdentifier() {
        if (StringUtils.isNULLStr((String)this.identifier) && null != this.storageSn) {
            this.identifier = this.storageSn;
        }
        return null == this.identifier ? "" : this.identifier;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.storageSn == null ? 0 : this.storageSn.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostEvalNode other = (HostEvalNode)obj;
        return this.hashCode() == other.hashCode();
    }

    public Date getLastEvalTime() {
        if (null != this.lastEvalTime) {
            return (Date)this.lastEvalTime.clone();
        }
        return null;
    }

    public void setLastEvalTime(Date lastEvalTime) {
        if (null != lastEvalTime) {
            this.lastEvalTime = (Date)lastEvalTime.clone();
        }
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Date getImportTime() {
        if (null != this.importTime) {
            return (Date)this.importTime.clone();
        }
        return null;
    }

    public void setImportTime(Date importTime) {
        if (null != importTime) {
            this.importTime = (Date)importTime.clone();
        }
    }

    public int getNumOfHosts() {
        return this.numOfHosts;
    }

    public void setNumOfHosts(int numOfHosts) {
        this.numOfHosts = numOfHosts;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public boolean isTaskComplete() {
        return this.taskComplete;
    }

    public void setTaskComplete(boolean taskComplete) {
        this.taskComplete = taskComplete;
    }

    public List<NotAdminUserDeviceInfo> getNotAdminUserDeviceInfo() {
        return this.notAdminUserDeviceInfo;
    }

    public void setNotAdminUserDeviceInfo(List<NotAdminUserDeviceInfo> notAdminUserDeviceInfo) {
        this.notAdminUserDeviceInfo = notAdminUserDeviceInfo;
    }

    public String getStorageName() {
        return this.storageName;
    }

    public void setStorageName(String storageName) {
        this.storageName = storageName;
    }

    public String getStorageIp() {
        return this.storageIp;
    }

    public void setStorageProductVersion(String storageProductVersion) {
        this.storageProductVersion = storageProductVersion;
    }

    public String getStorageProductVersion() {
        return this.storageProductVersion;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public void setStorageIp(String storageIp) {
        this.storageIp = storageIp;
    }

    public String getStorageSn() {
        return this.storageSn;
    }

    public void setStorageSn(String storageSn) {
        this.storageSn = storageSn;
    }

    public int getAddedHostNumbers() {
        return this.addedHostNumbers;
    }

    public void setAddedHostNumbers(int addedHostNumbers) {
        this.addedHostNumbers = addedHostNumbers;
    }

    public int getAllHostNumbers() {
        return this.allHostNumbers;
    }

    public void setAllHostNumbers(int allHostNumbers) {
        this.allHostNumbers = allHostNumbers;
    }

    public String getHostAddedAndNotAddedNumbers() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getAddHostNumberForEvalNode()).append('/').append(this.getMappedStorageInitiatorNum());
        return sb.toString();
    }

    public int getMappedStorageInitiatorNum() {
        if (this.mappedStorage == null || this.mappedStorage.getHostList() == null) {
            return 0;
        }
        HashSet<String> checkedHostIdSet = SceneDataExtendUtil.getInstance().getCheckedHosts(this.storageIp, this.storageSn);
        int num = 0;
        for (UpgradeHostInfo host : this.mappedStorage.getHostList()) {
            if (checkedHostIdSet.contains(Integer.toString(host.getHostId()))) continue;
            num += Integer.parseInt(host.getInitiatorNum());
        }
        return num;
    }

    public int getNotAddedInitNumbers() {
        return this.mappedStorage == null ? 0 : this.mappedStorage.getHostInitize() - this.getAddHostNumberForEvalNode();
    }

    public int getNotAddedNumbers() {
        int notAddedNumber = this.allHostNumbers - this.getAddHostNumberForEvalNode();
        if ((notAddedNumber -= this.getAllOneVsMulNumber()) < 0) {
            notAddedNumber = 0;
        }
        return notAddedNumber;
    }

    private int getAllOneVsMulNumber() {
        int allOneVsMulNumber = 0;
        for (Integer value : this.oneVsMultipleLogicalHostMap.values()) {
            allOneVsMulNumber += value.intValue();
        }
        return allOneVsMulNumber;
    }

    public int getAddHostNumberForEvalNode() {
        if (this.mappedStorage == null || this.mappedStorage.getHostList() == null) {
            return 0;
        }
        int totalNum = 0;
        HashSet<String> checkedHostIdSet = SceneDataExtendUtil.getInstance().getCheckedHosts(this.storageIp, this.storageSn);
        for (UpgradeHostInfo hostInfo : this.mappedStorage.getHostList()) {
            List mapList = hostInfo.getInitList();
            if (mapList == null || checkedHostIdSet.contains(String.valueOf(hostInfo.getHostId()))) continue;
            for (Map map : hostInfo.getInitList()) {
                boolean isInitMapCurStorage;
                boolean bl = isInitMapCurStorage = this.storageSn != null && this.storageSn.equals(map.get("WWN_MAPPED_STORAGE"));
                if (!String.valueOf(true).equals(map.get("WWN_MAPPED")) || !isInitMapCurStorage) continue;
                ++totalNum;
            }
        }
        return totalNum;
    }

    public void modifyAddedHostNumbers(int increasedNumber) {
        if (increasedNumber < 0 && this.addedHostNumbers == 0) {
            return;
        }
        this.addedHostNumbers += increasedNumber;
    }

    public List<DevNode> getStorageMappingHosts() {
        return this.storageMappingHosts;
    }

    public void setStorageMappingHosts(List<DevNode> storageMappingHosts) {
        this.storageMappingHosts = storageMappingHosts;
    }

    public List<DevNode> getUnAssociateHosts() {
        return this.unAssociateHosts;
    }

    public boolean isHostAdded() {
        if (this.isExistsHost(this.storageMappingHosts)) {
            return true;
        }
        if (this.isExistsHost(this.unAssociateHosts)) {
            return true;
        }
        if (this.isExistsHost(this.manulAssociatedHosts)) {
            return true;
        }
        return this.isExistsHost(this.notAllowAssociatedHosts);
    }

    public boolean isExistsHost(List<DevNode> devs) {
        for (DevNode devNode : devs) {
            if (!ItDeviceType.Host.equals((Object)devNode.getItDeviceType())) continue;
            return true;
        }
        return false;
    }

    public void setUnAssociateHosts(List<DevNode> unAssociateHosts) {
        this.unAssociateHosts = unAssociateHosts;
    }

    public List<DevNode> getManulAssociatedHosts() {
        return this.manulAssociatedHosts;
    }

    public void setManulAssociatedHosts(List<DevNode> manulAssociatedHosts) {
        this.manulAssociatedHosts = manulAssociatedHosts;
    }

    public int getAutomaticAssociateHostNumber() {
        return this.getAddHostNumberForEvalNode() - this.manulAssociatedHosts.size();
    }

    public Map<String, Integer> getOneVsMultipleLogicalHostMap() {
        return this.oneVsMultipleLogicalHostMap;
    }

    public void setOneVsMultipleLogicalHostMap(Map<String, Integer> oneVsMultipleLogicalHostMap) {
        this.oneVsMultipleLogicalHostMap = oneVsMultipleLogicalHostMap;
    }

    public List<DevNode> getNotAllowAssociatedHosts() {
        return this.notAllowAssociatedHosts;
    }

    public void setNotAllowAssociatedHosts(List<DevNode> notAllowAssociatedHosts) {
        this.notAllowAssociatedHosts = notAllowAssociatedHosts;
    }
}

