/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.evalu;

import com.google.common.base.Objects;
import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.protocol.tlv.exception.TLVException;
import com.huawei.ism.tool.upgradeevalu.config.CheckItemPlatformAdapterInUpgradeEval;
import com.huawei.ism.tool.upgradeevalu.config.ProductParser;
import com.huawei.ism.tool.upgradeevalu.entity.CrossVersionType;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluItem;
import com.huawei.ism.tool.upgradeevalu.entity.ProductCfg;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluDevCallableOver;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluService;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluState;
import com.huawei.ism.tool.upgradeevalu.evalu.PythonEngine;
import com.huawei.ism.tool.upgradeevalu.evalu.ResultFlag;
import com.huawei.ism.tool.upgradeevalu.evalu.ResultItem;
import com.huawei.ism.tool.upgradeevalu.exception.ConnectException;
import com.huawei.ism.tool.upgradeevalu.exception.JythonException;
import com.huawei.ism.tool.upgradeevalu.exception.PasswordExpiredException;
import com.huawei.ism.tool.upgradeevalu.ui.IUiObserver;
import com.huawei.ism.tool.upgradeevalu.util.A800Utils;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.ism.tool.upgradeevalu.util.FileUtil;
import com.huawei.ism.tool.upgradeevalu.util.ItemProgressUpdateUtil;
import java.io.File;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import utils.Products;

public class EvaluDevCallable
implements Callable<EvaluDevCallableOver> {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(EvaluDevCallable.class);
    private static final int INDEX_0 = 0;
    private static final int INDEX_1 = 1;
    private static final int INDEX_2 = 2;
    private static final String EVALU_TASK = "evauTask_";
    private static final String PRE_CHECK_NAME = "pre_check.py";
    private static final String AFTER_CHECK_NAME = "post_check.py";
    private static final String PREFFIX_FORGE_NAME = "forge.";
    private static final String CMD_TIME_OUT = "TOOLKIT_SEND_CMD_TIME_OUT";
    private static final String CONTAINER = "_container";
    private EvaluDevNode dev;
    private IUiObserver uiObserver;
    private EvaluService evaluService = EvaluService.getInstance();
    private EvaluContext evaluContext = EvaluContext.getInstance();
    private float progressStep = 0.0f;
    private float currGress = 0.0f;
    private int preCheckProcess = 1;
    private PythonEngine pyEngine;
    private Map<String, Object> dic;

    public EvaluDevCallable(EvaluDevNode dev, IUiObserver uiObserver) {
        this.dev = dev;
        this.uiObserver = uiObserver;
    }

    @Override
    public EvaluDevCallableOver call() throws ToolException {
        this.dev.setEvaluFinish(false);
        this.startEvaluDev();
        if (EvaluService.isNeedOpenOrCloseTlv(this.dev)) {
            EvaluService.openTlv(this.dev);
        }
        if (!this.iniPYEngine()) {
            this.setDevEvaluStateAndUpadteUI(EvaluState.FAILURE);
            this.distory();
            this.evaluContext.setUserOpTaskInfo(this.dev);
            return new EvaluDevCallableOver(false, this.dev, null);
        }
        if (!this.preCheck()) {
            this.setDevEvaluStateAndUpadteUI(EvaluState.FAILURE);
            this.afterCheck();
            this.distory();
            this.evaluContext.setUserOpTaskInfo(this.dev);
            return new EvaluDevCallableOver(false, this.dev, null);
        }
        if (!this.evaluDev()) {
            this.setDevEvaluStateAndUpadteUI(EvaluState.FAILURE);
            String error = "dev " + this.dev.getIp() + " evalu failed.";
            ResultItem ret = new ResultItem();
            ret.setErrorInfo(error);
            LOGGER.error(error);
            this.afterCheck();
            this.endExtroItem();
            this.distory();
            this.evaluContext.setUserOpTaskInfo(this.dev);
            return new EvaluDevCallableOver(false, this.dev, ret);
        }
        if (EvaluService.isNeedOpenOrCloseTlv(this.dev)) {
            EvaluService.closeTlv(this.dev);
        }
        this.endEvaluDev();
        this.afterCheck();
        this.distory();
        LOGGER.info(String.format(Locale.ENGLISH, "dev %s evalu has finished.", this.dev.getIp()));
        this.evaluContext.setUserOpTaskInfo(this.dev);
        return new EvaluDevCallableOver(true, this.dev, null);
    }

    private void endExtroItem() {
        EvaluItem repairRemind = this.forgeEvaluItem(MessageFormat.format("<html><span style=\"color:red\",>" + ResourceUtil.getString((String)"evalu.ui.itemDetail.items.end") + "</span></html>", null, null, null), null);
        repairRemind.getRetItem().setRetFlag(ResultFlag.PASS);
        this.dev.getExtraCheckItem().getAfterCheckItems().add(repairRemind);
        this.uiObserver.updateDetailList(repairRemind);
    }

    private void startEvaluDev() {
        String name = EVALU_TASK + this.dev.getDeviceSerialNumber();
        LOGGER.info(String.format(Locale.ENGLISH, "%s start", name));
        Thread.currentThread().setName(name);
        this.setDevEvaluStateAndUpadteUI(EvaluState.RUN);
    }

    private void endEvaluDev() {
        LOGGER.info(String.format(Locale.ENGLISH, "%s%s end", EVALU_TASK, this.dev.getIp()));
        this.setDevEvaluStateAndUpadteUI(EvaluState.SUCCESS);
        this.showEvaluForgeItem();
    }

    private void showEvaluForgeItem() {
        this.showCountTime();
        this.showDevStatistics();
        this.repair();
    }

    private void showCountTime() {
        EvaluItem consumingItem = this.forgeEvaluItem(MessageFormat.format(ResourceUtil.getString((String)"evalu.ui.itemDetail.items.counttime"), this.dev.getIp(), this.dev.getEvaluTime()), null);
        consumingItem.getRetItem().setRetFlag(ResultFlag.PASS);
        this.dev.getExtraCheckItem().getAfterCheckItems().add(consumingItem);
        this.uiObserver.updateDetailList(consumingItem);
    }

    private void showDevStatistics() {
        this.dev.findAbnormalItem();
        Map<ResultFlag, Integer> statistics = this.dev.getEvaluItemStatistics();
        int passCount = statistics.get((Object)ResultFlag.PASS);
        int notPassCount = statistics.get((Object)ResultFlag.NOTPASS);
        int noCheckCount = statistics.get((Object)ResultFlag.NOCHECK);
        int warnCount = statistics.get((Object)ResultFlag.WARN);
        int notSupportCount = statistics.get((Object)ResultFlag.NOSUPPORT);
        String itemContent = MessageFormat.format(ResourceUtil.getString((String)"evalu.ui.itemDetail.items.result"), this.dev.getAllEvaluItem().size(), passCount, notPassCount, noCheckCount, warnCount, notSupportCount);
        EvaluItem statisticsItem = this.forgeEvaluItem(itemContent, null);
        statisticsItem.getRetItem().setRetFlag(ResultFlag.PASS);
        this.dev.getExtraCheckItem().getAfterCheckItems().add(statisticsItem);
        this.uiObserver.updateDetailList(statisticsItem);
    }

    private void repair() {
        if (EvaluContext.getInstance().isCustomerRole() || EvaluContext.getInstance().isGuestRole()) {
            String reportPath = EvaluContext.getInstance().getReportDir().toString();
            String repairStr = ResourceUtil.getString((String)"evalu.ui.itemDetail.items.customer.repair1") + reportPath + " " + ResourceUtil.getString((String)"evalu.ui.itemDetail.items.customer.repair2");
            EvaluItem repairRemind = this.forgeEvaluItem(MessageFormat.format("<html><span style=\"color:red\",>" + repairStr + "</span></html>", null, null, null), null);
            repairRemind.getRetItem().setRetFlag(ResultFlag.PASS);
            this.dev.getExtraCheckItem().getAfterCheckItems().add(repairRemind);
            this.uiObserver.updateDetailList(repairRemind);
            return;
        }
        if (this.dev.getEvaluRet().getRetFlag().equals((Object)ResultFlag.NOTPASS)) {
            EvaluItem repairRemind = this.forgeEvaluItem(MessageFormat.format("<html><span style=\"color:red\",>" + ResourceUtil.getString((String)"evalu.ui.itemDetail.items.repair") + "</span></html>", null, null, null), null);
            repairRemind.getRetItem().setRetFlag(ResultFlag.PASS);
            this.dev.getExtraCheckItem().getAfterCheckItems().add(repairRemind);
            this.uiObserver.updateDetailList(repairRemind);
        }
    }

    private EvaluItem forgeEvaluItem(String name, ResultItem resultItem) {
        EvaluItem forgeItem = new EvaluItem();
        forgeItem.setIdentifier(PREFFIX_FORGE_NAME + name);
        if (null == resultItem) {
            resultItem = new ResultItem();
        }
        if (null == resultItem.getErrorInfo()) {
            resultItem.setErrorInfo("");
        }
        if (null == resultItem.getSourceInfo()) {
            resultItem.setSourceInfo("");
        }
        resultItem.setFinishTime(Calendar.getInstance().getTime());
        forgeItem.setName(name);
        forgeItem.setRetItem(resultItem);
        forgeItem.setDevID(this.dev.getId());
        return forgeItem;
    }

    private boolean preCheck() {
        this.dev.setEvaluProgress(this.preCheckProcess);
        this.uiObserver.updateDevTableRow(this.dev);
        long startTime = DateUtil.toBeiJingTimeMillis((Date)new Date());
        EvaluItem preCheckItem = this.forgeEvaluItem(ResourceUtil.getString((String)"evalu.ui.mainDialog.evaluBefore.check"), null);
        preCheckItem.setId("pre_check");
        this.dev.getExtraCheckItem().getBeforeCheckItems().add(preCheckItem);
        this.uiObserver.updateDetailList(preCheckItem);
        ResultItem preCheckRet = this.executePreCheck();
        preCheckItem.setRetItem(preCheckRet);
        this.uiObserver.updateDetailList(preCheckItem);
        boolean isPass = false;
        preCheckRet.setFinishTime(Calendar.getInstance().getTime());
        this.checkTimeOut(startTime, preCheckItem);
        boolean bl = isPass = ResultFlag.PASS.equals((Object)preCheckRet.getRetFlag());
        if (!isPass) {
            preCheckRet.setRetFlag(ResultFlag.NOTPASS);
            this.uiObserver.updateDetailList(preCheckItem);
            LOGGER.error("dev " + this.dev.getIp() + " preCheck failed.");
            return false;
        }
        return true;
    }

    private boolean afterCheck() {
        long startTime = DateUtil.toBeiJingTimeMillis((Date)new Date());
        ResultItem afterCheckRet = this.executeAfterCheck();
        boolean isPass = false;
        isPass = ResultFlag.PASS.equals((Object)afterCheckRet.getRetFlag());
        EvaluItem afterCheckItem = this.forgeEvaluItem(ResourceUtil.getString((String)"evalu.ui.mainDialog.evaluAfter.check"), afterCheckRet);
        String idetifier = "forge.afterCheck";
        afterCheckItem.setIdentifier(idetifier);
        this.checkTimeOut(startTime, afterCheckItem);
        if (!isPass) {
            afterCheckRet.setRetFlag(ResultFlag.WARN);
            this.dev.getExtraCheckItem().getAfterCheckItems().add(afterCheckItem);
            this.uiObserver.updateDetailList(afterCheckItem);
            LOGGER.error("dev " + this.dev.getIp() + " afterCheck failed.");
            return false;
        }
        return true;
    }

    private boolean iniPYEngine() {
        boolean isException = false;
        EvaluItem connectCheckItem = this.forgeEvaluItem(MessageFormat.format(ResourceUtil.getString((String)"evalu.ui.mainDialog.evaluBefore.connect"), this.dev.getIp()), null);
        ItemProgressUpdateUtil.INS.clear(connectCheckItem.getDevID());
        this.dev.getExtraCheckItem().getBeforeCheckItems().add(connectCheckItem);
        this.uiObserver.updateDetailList(connectCheckItem);
        ResultItem resultItem = connectCheckItem.getRetItem();
        try {
            this.dic = this.evaluService.createPYDic(this.dev, true);
            this.dic.put("progressObserver", this.uiObserver);
            this.dic.put("upgradeMode", (Object)this.dev.getUpgradeMode());
            if (A800Utils.isA800UpgradeCheck()) {
                this.dic.put("isA800Scene", A800Utils.isA800UpgradeCheck());
                if (Objects.equal(this.dev.getPreCheckModel(), "execute")) {
                    this.dic.put("zone_ids", this.dev.getZoneIds());
                }
                this.dic.put("preCheckMode", this.dev.getPreCheckModel());
                this.dic.put("zone_id", this.dev.getUuid());
                this.dic.put("zoneDataMap", EvaluContext.getInstance().getZoneDataMap());
                this.dic.put("execute_ip", this.dev.getExecuteZoneIp());
            }
            List<File> clssPath = this.dev.getClssPath();
            clssPath.add(ProductParser.getCommonPackagePath());
            this.pyEngine = new PythonEngine(clssPath, this.dic);
        }
        catch (PasswordExpiredException e) {
            isException = true;
            if ("cli.connetnum.reachmax".equals(e.getMessage())) {
                resultItem.setErrorInfo(ResourceUtil.getString((String)"cli.connetnum.reachmax"));
            } else {
                resultItem.setErrorInfo(ResourceUtil.getString((String)"evalu.connet.pwd.willexpired.info"));
            }
            LOGGER.error("init pyEngine failed.");
        }
        catch (com.huawei.ism.tool.obase.exception.ToolException e) {
            isException = true;
            resultItem.setErrorInfo(ResourceUtil.getString((String)"evalu.link.error"));
            LOGGER.error("init pyEngine failed.");
        }
        if (isException) {
            resultItem.setRetFlag(ResultFlag.NOTPASS);
            this.uiObserver.updateDetailList(connectCheckItem);
            return false;
        }
        resultItem.setRetFlag(ResultFlag.PASS);
        this.uiObserver.updateDetailList(connectCheckItem);
        return true;
    }

    private int evaluProgressStep(ProductCfg prod) {
        return prod.getInnerItems().size();
    }

    private ResultItem executePreCheck() {
        KeyOrderedHashMap<CrossVersionType, ProductCfg> products = this.dev.getProducts();
        ProductCfg prod = (ProductCfg)products.get((Object)CrossVersionType.INNERVERSION);
        File dir = prod.getProductDir();
        ResultItem retItem = null;
        File python = new File(dir, PRE_CHECK_NAME);
        if (!python.exists()) {
            LOGGER.error("python script " + python + " is not exist.");
            retItem = new ResultItem();
            retItem.setErrorInfo(MessageFormat.format(ResourceUtil.getString((String)"evalu.ui.evaluDevCallable.script.not.exist"), FileUtil.getCanonicalPath(python)));
            return retItem;
        }
        retItem = this.executePreOrAfterCheckItem(python);
        return retItem;
    }

    private ResultItem executeAfterCheck() {
        File dir = ((ProductCfg)this.dev.getProducts().get((Object)CrossVersionType.INNERVERSION)).getProductDir();
        ResultItem retItem = null;
        File python = new File(dir, AFTER_CHECK_NAME);
        if (!python.exists()) {
            retItem = new ResultItem();
            retItem.setErrorInfo(MessageFormat.format(ResourceUtil.getString((String)"evalu.ui.evaluDevCallable.script.not.exist"), FileUtil.getCanonicalPath(python)));
            retItem.setRetFlag(ResultFlag.PASS);
            LOGGER.warn("python script " + python + " is not exist.");
            return retItem;
        }
        retItem = this.executePreOrAfterCheckItem(python);
        return retItem;
    }

    private ResultItem executePreOrAfterCheckItem(File python) {
        ResultItem retItem = new ResultItem();
        try {
            List<Object> rets = this.pyEngine.execute(python);
            String echo = rets.get(1).toString();
            retItem.setSourceInfo(echo);
            retItem.setErrorInfo(rets.get(2).toString());
            String flagStr = rets.get(0).toString();
            int flag = Integer.parseInt(flagStr);
            ResultFlag retFlag = ResultFlag.valueOf(flag);
            retItem.setRetFlag(retFlag);
            return retItem;
        }
        catch (JythonException e) {
            String err = ResourceUtil.getString((String)"evalu.precheck.execute.error");
            retItem.setRetFlag(ResultFlag.NOTPASS);
            retItem.setErrorInfo(err);
            LOGGER.error("execute python " + python + " failed.", e);
        }
        catch (Exception e) {
            String err = ResourceUtil.getString((String)"evalu.precheck.execute.error");
            retItem.setRetFlag(ResultFlag.NOTPASS);
            retItem.setErrorInfo(err);
            LOGGER.error("execute python " + python + " failed.", e);
        }
        return retItem;
    }

    private void setDevEvaluStateAndUpadteUI(EvaluState evaluState) {
        switch (evaluState) {
            case WAIT: {
                break;
            }
            case RUN: {
                this.dev.setEvaluProgress(0);
                this.dev.setStartTime(Calendar.getInstance());
                break;
            }
            case SUCCESS: {
                this.dev.setEvaluProgress(100);
                this.dev.setEndTime(Calendar.getInstance());
                break;
            }
            case FAILURE: {
                this.dev.setEndTime(Calendar.getInstance());
                break;
            }
            default: {
                evaluState = EvaluState.FAILURE;
            }
        }
        this.dev.setEvaluState(evaluState);
        this.uiObserver.updateDevTableRow(this.dev);
    }

    private boolean evaluDev() {
        boolean result = false;
        try {
            LOGGER.info(String.format(Locale.ENGLISH, "start exectue inner evaluItems for dev %s", this.dev.getIp()));
            KeyOrderedHashMap<CrossVersionType, ProductCfg> products = this.dev.getProducts();
            ProductCfg prod = (ProductCfg)products.get((Object)CrossVersionType.INNERVERSION);
            prod.removeInnerModule();
            this.progressStep = 100.0f / (float)this.evaluProgressStep(prod);
            if (Products.Feature.isSupportInnerCheck((String)this.dev.getDeviceModel(), (String)this.dev.getProductVersion())) {
                this.progressStep = 10.0f / (float)this.evaluProgressStep(prod);
                this.currGress = 90.0f;
            }
            result = this.exeItem4Prod(prod);
            return result;
        }
        catch (Exception e) {
            LOGGER.error("evalu dev " + this.dev.getIp() + " failed.", e);
            return result;
        }
    }

    private boolean exeItem4Prod(ProductCfg prod) {
        List<EvaluItem> items = prod.getInnerItems();
        return this.traverItems(items);
    }

    private boolean traverItems(List<EvaluItem> items) {
        long startTime = 0L;
        for (EvaluItem evaluItem : items) {
            ItemProgressUpdateUtil.INS.clear(evaluItem.getDevID());
            startTime = DateUtil.toBeiJingTimeMillis((Date)new Date());
            if (this.evaluContext.isEndEvalu()) {
                LOGGER.info("user halt evaluation process");
                return false;
            }
            ResultItem resultItem = new ResultItem();
            resultItem.setFinishTime(Calendar.getInstance().getTime());
            evaluItem.setRetItem(resultItem);
            this.uiObserver.updateDetailList(evaluItem);
            try {
                ResultItem retItem = this.evaluItem(evaluItem);
                evaluItem.setRetItem(retItem);
                this.updateProgress();
                this.uiObserver.updateDetailList(evaluItem);
                this.dev.getResultHelper().accept(evaluItem);
            }
            catch (ConnectException e) {
                evaluItem.getRetItem().setRetFlag(ResultFlag.NOTPASS);
                this.uiObserver.updateDetailList(evaluItem);
                String err = ResourceUtil.getString((String)"evalu.evaluItem.execute.halt");
                ResultItem retItem = new ResultItem();
                retItem.setSourceInfo(err);
                retItem.setErrorInfo(err);
                ResultFlag flag = ResultFlag.NOCONNECTION;
                retItem.setRetFlag(flag);
                EvaluItem haltItem = this.forgeEvaluItem(err, retItem);
                this.dev.getExtraCheckItem().getAfterCheckItems().add(haltItem);
                this.uiObserver.updateDetailList(haltItem);
                LOGGER.warn("halt evaluation process when execute innerItem, occor ConnectException", e);
                this.checkTimeOut(startTime, evaluItem);
                return false;
            }
            this.checkTimeOut(startTime, evaluItem);
        }
        return true;
    }

    private void checkTimeOut(long startTime, EvaluItem evaluItem) {
        if (this.evaluContext.setUserOpTaskOverTimeInfo(startTime, this.dev, evaluItem)) {
            try {
                LOGGER.info(String.format(Locale.ENGLISH, "Set overtime item: %s for dev: %s success!", evaluItem.toString(), this.dev.getIp()));
            }
            catch (Exception e1) {
                LOGGER.error("Log records failed.", e1);
            }
        }
    }

    private void updateProgress() {
        this.currGress += this.progressStep;
        int progress = Math.round(this.currGress);
        if (progress > 99) {
            progress = 99;
        } else if (progress < this.preCheckProcess) {
            progress = this.preCheckProcess;
        }
        this.dev.setEvaluProgress(progress);
        this.uiObserver.updateDevTableRow(this.dev);
    }

    private ResultItem evaluItem(EvaluItem evaluItem) throws ConnectException {
        ResultItem retItem = new ResultItem();
        retItem.setFinishTime(Calendar.getInstance().getTime());
        if (evaluItem.getCheckConfigItem() != null) {
            CheckItemPlatformAdapterInUpgradeEval.getInstance().runConfigItem(this.dev, evaluItem.getCheckConfigItem(), retItem);
            return retItem;
        }
        File python = evaluItem.getScript();
        List<Object> rets = null;
        try {
            rets = this.pyEngine.execute(python);
            String echo = rets.get(1).toString();
            retItem.setSourceInfo(echo);
            retItem.setErrorInfo(rets.get(2).toString());
            String flag = rets.get(0).toString();
            if (echo.equals(CMD_TIME_OUT)) {
                retItem.setRetFlag(ResultFlag.NOCHECK);
                retItem.setSourceInfo(ResourceUtil.getString((String)"evalu.evaluItem.execute.timeout"));
                retItem.setErrorInfo(ResourceUtil.getString((String)"evalu.evaluItem.execute.timeout"));
                return retItem;
            }
            this.setResultItemFlag(retItem, rets, flag);
        }
        catch (JythonException e) {
            if (null != e.getCause().getCause()) {
                this.connectException(e);
            }
            String err = ResourceUtil.getString((String)"evalu.evaluItem.execute.error");
            retItem.setSourceInfo(err);
            retItem.setErrorInfo(err);
            ResultFlag flag = ResultFlag.NOCHECK;
            retItem.setRetFlag(flag);
            LOGGER.error("execute evluItem " + evaluItem.getId() + " failed.", e);
        }
        return retItem;
    }

    private void connectException(JythonException jythonException) throws ConnectException {
        com.huawei.ism.tool.obase.exception.ToolException sourceException;
        if (jythonException.getCause().getCause().getCause() instanceof com.huawei.ism.tool.obase.exception.ToolException && (sourceException = (com.huawei.ism.tool.obase.exception.ToolException)jythonException.getCause().getCause().getCause()).getErrorId().equals("build.connection.failed")) {
            LOGGER.error(sourceException.getErrorId(), jythonException);
            throw new ConnectException("conection occur exception.", jythonException);
        }
        if (jythonException.getCause().getCause().getCause() instanceof TLVException) {
            TLVException tlvException = (TLVException)jythonException.getCause().getCause().getCause();
            Long errorId = tlvException.getErrorId();
            LOGGER.error(errorId.toString());
            throw new ConnectException(errorId.toString(), jythonException);
        }
    }

    private void setResultItemFlag(ResultItem retItem, List<Object> rets, String flag) {
        int ret = Integer.parseInt(flag);
        ResultFlag retFlag = ResultFlag.valueOf(ret);
        retItem.setRetFlag(retFlag);
        if (retFlag.equals((Object)ResultFlag.NOTPASS)) {
            retItem.setErrorInfo(rets.get(2).toString());
        }
    }

    private void distory() {
        if (null != this.pyEngine) {
            this.pyEngine.clean();
        }
        if (null != this.dic) {
            this.evaluService.distroyDic(this.dic);
        }
    }
}

