/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.evalu;

import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;

public final class EvaluDevManager {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(EvaluDevManager.class);
    private static final EvaluDevManager INSTANCE = new EvaluDevManager();
    private List<EvaluDevNode> tabDevs = new ArrayList<EvaluDevNode>();
    private List<EvaluDevNode> evaluDevs = Collections.synchronizedList(new ArrayList());
    private int originalNum = 0;

    private EvaluDevManager() {
    }

    public static EvaluDevManager getInstance() {
        return INSTANCE;
    }

    public List<EvaluDevNode> getTabDevs() {
        return this.tabDevs;
    }

    public void delTabDevs(List<EvaluDevNode> nodes) {
        if (this.tabDevs.isEmpty()) {
            return;
        }
        if (null == nodes || nodes.isEmpty()) {
            return;
        }
        for (EvaluDevNode node : nodes) {
            if (!this.tabDevs.contains((Object)node)) continue;
            try {
                String msg = "Remove device: " + node.getIp() + " success.";
                ToolLoggerFactory.getLogger(EvaluDevManager.class).info(msg);
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("Log records failed.", e);
            }
            node.clearData();
            this.tabDevs.remove((Object)node);
        }
    }

    public void addTabDevs(List<EvaluDevNode> devs) {
        for (EvaluDevNode dev : devs) {
            if (this.tabDevs.contains((Object)dev)) continue;
            this.tabDevs.add(dev);
        }
    }

    public List<EvaluDevNode> getEvaluDevs() {
        return this.evaluDevs;
    }

    public void setEvaluDevs(List<EvaluDevNode> evaluDevs) {
        this.evaluDevs = evaluDevs;
    }

    public void removeEvaluDev(EvaluDevNode dev) {
        if (null == dev) {
            return;
        }
        for (EvaluDevNode node : this.evaluDevs) {
            if (!node.equals((Object)dev)) continue;
            this.evaluDevs.remove((Object)node);
            return;
        }
    }

    public EvaluDevNode getTabDevById(String id) {
        for (EvaluDevNode dev : this.tabDevs) {
            if (!dev.getId().equals(id)) continue;
            return dev;
        }
        return null;
    }

    public EvaluDevNode getEvaluDevById(String id) {
        for (EvaluDevNode dev : this.evaluDevs) {
            if (!dev.getId().equals(id)) continue;
            return dev;
        }
        return null;
    }

    public void clearEvaluDevs() {
        this.evaluDevs.clear();
        this.originalNum = 0;
    }

    public void setOriginalNum(int originalNum) {
        this.originalNum = originalNum;
    }

    public int getOriginalNum() {
        return this.originalNum;
    }
}

