/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.evalu;

import com.huawei.ism.tool.base.scene.utils.SceneDataExchange;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.bizpack.wizardparse.factory.ConnectorFactory;
import com.huawei.ism.tool.bizpack.wizardparse.factory.SshForwardConnector;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SftpTransporter;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.PwdCLIOverrunException;
import com.huawei.ism.tool.obase.exception.PwdException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.refresh.listenner.IProgressCallback;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.protocol.exception.UserStatusException;
import com.huawei.ism.tool.protocol.tlv.ITLVConnection;
import com.huawei.ism.tool.protocol.tlv.TlvConnectionManager;
import com.huawei.ism.tool.upgradeevalu.config.Model;
import com.huawei.ism.tool.upgradeevalu.config.ProductParser;
import com.huawei.ism.tool.upgradeevalu.entity.CrossVersionType;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluMode;
import com.huawei.ism.tool.upgradeevalu.entity.ProductCfg;
import com.huawei.ism.tool.upgradeevalu.entity.ScriptExecutEnv;
import com.huawei.ism.tool.upgradeevalu.entity.UpgradeMode;
import com.huawei.ism.tool.upgradeevalu.evalu.PythonEngine;
import com.huawei.ism.tool.upgradeevalu.evalu.ResultFlag;
import com.huawei.ism.tool.upgradeevalu.exception.JythonException;
import com.huawei.ism.tool.upgradeevalu.exception.PasswordExpiredException;
import com.huawei.ism.tool.upgradeevalu.util.EnvHelper;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.ism.tool.upgradeevalu.util.EvaluSceneUtils;
import com.huawei.ism.tool.upgradeevalu.util.FileUtil;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalContext;
import com.huawei.ism.tool.upgradeevalu.util.PackageUtils;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public final class EvaluService {
    private static final String PROGRESS_WIPER = "progressWiper";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(EvaluService.class);
    private static final int INDEX_0 = 0;
    private static final int INDEX_1 = 1;
    private static final int INDEX_3 = 3;
    private static final String RESULT_1 = "1";
    private static final String SFTP = "sftp";
    private static final String SSH = "ssh";
    private static final String TLV = "tlv";
    private static final String CPLLECTMANAGEMENT = "collectManagement";
    private static final String TMPDIR = "tmpDir";
    private static final String TOOLDIR = "toolDir";
    private static final String EXTRAMAP = "extraMap";
    private static final String REDULAR = "(.*)\\{(.*)\\}";
    private static final String HTTP = "http:";
    private static final String WWW = "www.";
    private static final String HTTPS = "https:";
    private static final String SSH_FACTORY = "sshFactory";
    private static final EvaluService INSTANCE = new EvaluService();
    private static final String STR_LOGGER = "logger";
    private static final String EVALUMODE = "evaluMode";
    private static final String STR_DEV = "dev";
    private static final String LANG = "lang";
    private static final String DEV_REST = "newDev";
    private EvaluContext evaluContext = EvaluContext.getInstance();
    Map<EvaluMode, String> evalMode = new HashMap<EvaluMode, String>();
    private static final String IS_UPGRADE_SCENE = "isUpgradeScene";
    private static final String IS_PRE_UPGRADE_CHECK_SCENE = "isPreUpgradeCheckScene";
    private static final String SCENE_DATA_EXCHANGE_INSTANCE = "SceneDataExchangeInstance";
    private boolean isInHostEvalu = false;

    private EvaluService() {
    }

    public static EvaluService getInstance() {
        return INSTANCE;
    }

    public ProductCfg matchProdcut(DevNode dev) {
        switch (dev.getItDeviceType()) {
            case Storage: 
            case A800_NODE: {
                return this.matchProdCfg4Storage(dev);
            }
            case Host: 
            case Switch: {
                return this.matchProdCfg4Host(dev);
            }
        }
        return null;
    }

    private ProductCfg matchProdCfg4Storage(DevNode dev) {
        List<ProductCfg> allProductCfg = this.getAllProductCfg();
        for (ProductCfg productCfg : allProductCfg) {
            List<Model> models = productCfg.getModels();
            String currModel = dev.getDeviceType().toString();
            String currVRCVersion = this.getFullVRCVersion(dev.getProductVersion());
            LOGGER.info(String.format(Locale.ENGLISH, "currModel : %s", currModel));
            LOGGER.info(String.format(Locale.ENGLISH, "currVRCVersion : %s", currVRCVersion));
            for (Model model : models) {
                if (!model.getNames().contains(currModel) || !model.getSupportVersions().contains(currVRCVersion)) continue;
                return productCfg;
            }
        }
        return null;
    }

    private ProductCfg matchProdCfg4Host(DevNode dev) {
        List<ProductCfg> allProductCfg = this.getAllProductCfg();
        for (ProductCfg productCfg : allProductCfg) {
            if (!ItDeviceType.Host.equals((Object)productCfg.getDeviceType())) continue;
            List<Model> models = productCfg.getModels();
            String currMod = dev.getDeviceType().toString();
            for (Model model : models) {
                if (!model.getSupportVersions().contains(currMod)) continue;
                return productCfg;
            }
        }
        return null;
    }

    public KeyOrderedHashMap<CrossVersionType, ProductCfg> queryProdcut(EvaluDevNode dev) {
        switch (dev.getItDeviceType()) {
            case Storage: 
            case A800_NODE: {
                return this.queryProdcut4Storage(dev);
            }
            case Host: 
            case Switch: {
                return this.queryProduct4Host(dev);
            }
        }
        return null;
    }

    private KeyOrderedHashMap<CrossVersionType, ProductCfg> queryProduct4Host(EvaluDevNode dev) {
        KeyOrderedHashMap productMap = new KeyOrderedHashMap();
        List<ProductCfg> allProductCfg = this.getAllProductCfg();
        for (ProductCfg productCfg : allProductCfg) {
            if (!ItDeviceType.Host.equals((Object)productCfg.getDeviceType())) continue;
            List<Model> models = productCfg.getModels();
            String currMod = dev.getDeviceModel();
            for (Model model : models) {
                if (!model.getSupportVersions().contains(currMod)) continue;
                try {
                    ProductCfg innerProd = (ProductCfg)productCfg.clone();
                    innerProd.setCrossVersionType(CrossVersionType.INNERVERSION);
                    dev.setCrossVersion(false);
                    productMap.put((Object)CrossVersionType.INNERVERSION, (Object)innerProd);
                }
                catch (CloneNotSupportedException e) {
                    LOGGER.error("clone host product config failed.", e);
                }
            }
        }
        return productMap;
    }

    private KeyOrderedHashMap<CrossVersionType, ProductCfg> queryProdcut4Storage(EvaluDevNode dev) {
        KeyOrderedHashMap productMap = new KeyOrderedHashMap();
        List<ProductCfg> allProductCfg = this.getAllProductCfg();
        for (ProductCfg productCfg : allProductCfg) {
            List<Model> models = productCfg.getModels();
            String currModel = dev.getDeviceModel();
            String currVRCVersion = this.getFullVRCVersion(dev.getProductVersion());
            for (Model model : models) {
                if (!model.getNames().contains(currModel) || !model.getSupportVersions().contains(currVRCVersion)) continue;
                ProductCfg innerProd = null;
                try {
                    innerProd = (ProductCfg)productCfg.clone();
                    innerProd.setCrossVersionType(CrossVersionType.INNERVERSION);
                    dev.setCrossVersion(false);
                    productMap.put((Object)CrossVersionType.INNERVERSION, (Object)innerProd);
                    LOGGER.info("query productCfg matched inner config.");
                }
                catch (CloneNotSupportedException e) {
                    LOGGER.error("clone storage product-config failed.", e);
                    return productMap;
                }
                if (StringUtils.isNULLStr((String)dev.getDestVersion()) || this.checkPathInSysConf(productCfg, dev) || this.checkPathInXml(dev)) {
                    return productMap;
                }
                return null;
            }
        }
        return productMap;
    }

    private boolean checkPathInSysConf(ProductCfg productCfg, EvaluDevNode dev) {
        List<Model> models = productCfg.getModels();
        String currModel = dev.getDeviceModel();
        String destVRCVersion = this.getVRCVersion(dev.getDestVersion());
        for (Model model : models) {
            if (!model.getNames().contains(currModel) || !model.getSupportVersions().contains(destVRCVersion)) continue;
            return true;
        }
        return false;
    }

    private boolean checkPathInXml(EvaluDevNode dev) {
        String currModel = dev.getDeviceModel();
        String destVRCVersion = this.getVRCVersion(dev.getDestVersion());
        String currVRCVersion = this.getVRCVersion(dev.getProductVersion());
        UpgradeMode upgradeMode = dev.getUpgradeMode();
        List<EvaluContext.VersionPathItem> versionEvalPathList = this.evaluContext.getVersionEvalPathList();
        this.evalMode.put(EvaluMode.LINK, "Online");
        this.evalMode.put(EvaluMode.UNLINK, "Offline");
        for (EvaluContext.VersionPathItem versionItem : versionEvalPathList) {
            if (!versionItem.getDestVersion().contains(destVRCVersion) || !versionItem.getDevice().contains(currModel)) continue;
            if (!versionItem.getDeviceVersion().contains(currVRCVersion)) {
                return false;
            }
            if (!versionItem.getUpgradeMode().equalsIgnoreCase("ALL")) {
                return this.checkUpgradeMode(upgradeMode, versionItem);
            }
            return true;
        }
        return false;
    }

    private boolean checkUpgradeMode(UpgradeMode upgradeMode, EvaluContext.VersionPathItem versionItem) {
        String[] upgradeModeStrList;
        for (String upgradeModeStr : upgradeModeStrList = versionItem.getUpgradeMode().split(",")) {
            UpgradeMode mode = UpgradeMode.valueOf(UpgradeMode.class, upgradeModeStr.trim().toUpperCase(Locale.ENGLISH));
            if (!upgradeMode.equals((Object)mode)) continue;
            return true;
        }
        return false;
    }

    private List<ProductCfg> getAllProductCfg() {
        return this.evaluContext.getAllProductCfg();
    }

    public List<String> getSupportModels() {
        ArrayList<String> suppModels = new ArrayList<String>();
        List<ProductCfg> products = this.evaluContext.getAllProductCfg();
        for (ProductCfg product : products) {
            List<Model> models = product.getModels();
            for (Model model : models) {
                for (String modelName : model.getNames()) {
                    if (suppModels.contains(modelName)) continue;
                    suppModels.add(modelName);
                }
            }
        }
        return suppModels;
    }

    public Map<String, Object> createPYDic(EvaluDevNode dev, boolean needConn) throws ToolException {
        HashMap<String, Object> dic = new HashMap<String, Object>();
        EvaluSceneUtils sceneUtils = new EvaluSceneUtils();
        String lan = this.evaluContext.getLoc().getLanguage();
        dic.put(LANG, lan);
        dic.put(STR_DEV, (Object)dev);
        dic.put(EVALUMODE, (Object)this.evaluContext.getEvaluMode());
        dic.put(EXTRAMAP, dev.getExtraMap());
        dic.put(STR_LOGGER, ToolLoggerFactory.getLoggerInStandAlone((String)dev.getDeviceSerialNumber()));
        dic.put(TMPDIR, FileUtil.getCanonicalPath(this.evaluContext.getTmpDir()));
        dic.put(TOOLDIR, ApplicationContext.getInstance().getWorkPath());
        dic.put(DEV_REST, EnvHelper.getDevMapForRest(dev));
        dic.put(IS_UPGRADE_SCENE, sceneUtils.isUpgradeSubScene());
        dic.put(IS_PRE_UPGRADE_CHECK_SCENE, sceneUtils.isPreUpgradeCheckSubScene());
        SceneDataExchange sdecInstance = SceneDataExchange.getInstance();
        File reportDir = HostEvalContext.getInstance().getReportDir();
        sdecInstance.setExchangeDataPath(reportDir);
        dic.put(SCENE_DATA_EXCHANGE_INSTANCE, sdecInstance);
        if (!needConn) {
            return dic;
        }
        PackageUtils collectManagement = new PackageUtils();
        dic.put(CPLLECTMANAGEMENT, collectManagement);
        this.createConStorage(dev, dic);
        return dic;
    }

    private synchronized boolean createConStorage(EvaluDevNode dev, Map<String, Object> dic) throws ToolException {
        ConnectorFactory connFactory = ConnectorFactory.getInstance();
        ITLVConnection oldCon = null;
        dic.put(SSH_FACTORY, connFactory);
        EvaluService.specialConf4Host(dev);
        try {
            ProductCfg innerProd;
            ScriptExecutEnv scriptExecutEnv;
            if (!this.isInHostEvalu && (scriptExecutEnv = (innerProd = dev.getProduct(CrossVersionType.INNERVERSION)).getScriptExecutEnv()).isNeedTlv()) {
                LOGGER.info(String.format(Locale.ENGLISH, "try tlv connect to %s", dev.getIp()));
                com.huawei.ism.tool.obase.entity.DevNode oldDev = EntityUtils.toOldDev((DevNode)dev);
                oldCon = TlvConnectionManager.getConnectionByInnerIp((com.huawei.ism.tool.obase.entity.DevNode)oldDev);
                dic.put(TLV, oldCon);
                LOGGER.info(String.format(Locale.ENGLISH, "successfully tlv connect to ", dev.getIp()));
                dev.setIp(oldDev.getIp());
            }
            SshForwardConnector sshCtr = connFactory.createSshForwardConnector((DevNode)dev);
            ICliConnection sshConn = sshCtr.getConnectionForPwdWillExpireBreak();
            dic.put(SSH, sshConn);
            SftpTransporter.setGlobalRetryTimes((int)3);
            SftpTransporter sftp = new SftpTransporter(sshConn);
            dic.put(SFTP, sftp);
        }
        catch (PwdCLIOverrunException e) {
            String errorMsg = "cli.connetnum.reachmax";
            LOGGER.error(errorMsg, e);
            throw new PasswordExpiredException(errorMsg, e);
        }
        catch (PwdException e) {
            String errorMsg = "ssh connetc password is about to expire";
            LOGGER.error(errorMsg, e);
            throw new PasswordExpiredException(errorMsg, e);
        }
        catch (UserStatusException e) {
            String errorMsg = "tlv connetc password is about to expire";
            LOGGER.error(errorMsg, e);
            throw new PasswordExpiredException(errorMsg, e);
        }
        catch (ToolException e) {
            LOGGER.error("failed to create sftp to " + dev.getIp(), e);
            throw e;
        }
        finally {
            ApplicationContext.getInstance().setHost(false);
        }
        LOGGER.info(String.format(Locale.ENGLISH, "successfully to create connection to dev ", dev.getIp()));
        return true;
    }

    private static void specialConf4Host(DevNode devNode) {
        if (ItDeviceType.Host.equals((Object)devNode.getItDeviceType())) {
            ApplicationContext.getInstance().setHost(true);
        }
    }

    public void distroyDic(Map<String, Object> dic) {
        ITLVConnection tlv;
        SftpTransporter sftp = (SftpTransporter)dic.get(SFTP);
        if (null != sftp) {
            sftp.close();
            ICliConnection sshConn = (ICliConnection)dic.get(SSH);
            sshConn.close();
        }
        if (null != (tlv = (ITLVConnection)dic.get(TLV))) {
            TlvConnectionManager.releaseConnection((ITLVConnection)tlv);
        }
        dic.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getEvaluFile(EvaluDevNode dev, ProductCfg product) {
        Document doc = null;
        Map<String, Object> dic = null;
        PythonEngine pyEngine = null;
        try {
            dic = this.createPYDic(dev, false);
            pyEngine = new PythonEngine(dev.getClssPath(), dic);
            File pyFile = product.getDynamicPY();
            if (null == pyFile) {
                throw new JythonException("getDynamicPY is null");
            }
            List<Object> rets = pyEngine.execute(pyFile);
            String exeRet = rets.get(0).toString();
            if (exeRet.equals(RESULT_1)) {
                LOGGER.error("dynamicly get inner clickList.xml failed.", rets.get(2));
                Document document = null;
                return document;
            }
            String docStr = (String)rets.get(1);
            doc = this.string2Doc(docStr);
        }
        catch (ToolException e) {
            LOGGER.error("connection dev " + dev.getIp() + " failed.", e);
        }
        catch (JythonException e) {
            LOGGER.error("execute python failed.", e);
        }
        finally {
            if (null != pyEngine) {
                pyEngine.clean();
            }
            if (null != dic) {
                this.distroyDic(dic);
            }
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document string2Doc(String xmlStr) {
        try (StringReader stringReader = null;){
            Document document;
            stringReader = new StringReader(xmlStr);
            InputSource inputSource = new InputSource(stringReader);
            Document document2 = document = XmlUtils.newDocumentBuilder().parse(inputSource);
            return document2;
        }
    }

    public Map<String, List<EvaluDevNode>> groupByProductName(List<EvaluDevNode> devs) {
        if (null == devs || devs.isEmpty()) {
            return null;
        }
        HashMap<String, List<EvaluDevNode>> devProdMap = new HashMap<String, List<EvaluDevNode>>();
        ArrayList<String> prodcutList = new ArrayList<String>();
        for (EvaluDevNode dev : devs) {
            ProductCfg prod = (ProductCfg)dev.getProducts().get((Object)CrossVersionType.INNERVERSION);
            String productName = prod.getProdcutName();
            if (prodcutList.contains(productName)) {
                ((List)devProdMap.get(productName)).add(dev);
                continue;
            }
            prodcutList.add(productName);
            ArrayList<EvaluDevNode> devList = new ArrayList<EvaluDevNode>();
            devList.add(dev);
            devProdMap.put(productName, devList);
        }
        return devProdMap;
    }

    public Map<UpgradeMode, Map<ItDeviceType, List<EvaluDevNode>>> groupByUpgradeType(List<EvaluDevNode> devs) {
        Map<UpgradeMode, Map<ItDeviceType, List<EvaluDevNode>>> listByMod = new HashMap<UpgradeMode, Map<ItDeviceType, List<EvaluDevNode>>>();
        if (null == devs || devs.isEmpty()) {
            LOGGER.error("devs list is null or empty");
            return listByMod;
        }
        if (devs.get(0).isSecondaryUpgrade()) {
            devs.forEach(dev -> dev.setProductVersion(dev.getContainerVersion()));
        }
        listByMod = this.genMapByUpgradeType(devs);
        return listByMod;
    }

    private Map<UpgradeMode, Map<ItDeviceType, List<EvaluDevNode>>> genMapByUpgradeType(List<EvaluDevNode> devs) {
        HashMap<UpgradeMode, Map<ItDeviceType, List<EvaluDevNode>>> listByMod = new HashMap<UpgradeMode, Map<ItDeviceType, List<EvaluDevNode>>>();
        ArrayList<EvaluDevNode> fastList = new ArrayList<EvaluDevNode>();
        ArrayList<EvaluDevNode> onlineList = new ArrayList<EvaluDevNode>();
        ArrayList<EvaluDevNode> offineList = new ArrayList<EvaluDevNode>();
        ArrayList<EvaluDevNode> rollList = new ArrayList<EvaluDevNode>();
        ArrayList<EvaluDevNode> parallelList = new ArrayList<EvaluDevNode>();
        ArrayList<EvaluDevNode> apolloList = new ArrayList<EvaluDevNode>();
        ArrayList<EvaluDevNode> offLineContainerList = new ArrayList<EvaluDevNode>();
        ArrayList<EvaluDevNode> patchList = new ArrayList<EvaluDevNode>();
        for (EvaluDevNode dev : devs) {
            UpgradeMode mode = dev.getUpgradeModeUI();
            this.addUprageModeDev(fastList, onlineList, offineList, rollList, parallelList, apolloList, offLineContainerList, patchList, dev, mode);
        }
        this.putListByMod(listByMod, fastList, onlineList, offineList, rollList, parallelList, apolloList, patchList, offLineContainerList);
        return listByMod;
    }

    private void addUprageModeDev(List<EvaluDevNode> fastList, List<EvaluDevNode> onlineList, List<EvaluDevNode> offineList, List<EvaluDevNode> rollList, List<EvaluDevNode> parallelList, List<EvaluDevNode> apolloList, List<EvaluDevNode> offLineContainerList, List<EvaluDevNode> patchList, EvaluDevNode dev, UpgradeMode mode) {
        switch (mode) {
            case FAST: {
                fastList.add(dev);
                break;
            }
            case ONLINE: {
                onlineList.add(dev);
                break;
            }
            case OFFLINE: {
                offineList.add(dev);
                break;
            }
            case ROLL: {
                rollList.add(dev);
                break;
            }
            case PARALLEL: {
                parallelList.add(dev);
                break;
            }
            case APOLLO: {
                apolloList.add(dev);
                break;
            }
            case OFFLINE_CONTAINER: {
                offLineContainerList.add(dev);
                break;
            }
            case PATCH_CONTAINER: {
                patchList.add(dev);
                break;
            }
        }
    }

    private void putListByMod(Map<UpgradeMode, Map<ItDeviceType, List<EvaluDevNode>>> listByMod, List<EvaluDevNode> fastList, List<EvaluDevNode> onlineList, List<EvaluDevNode> offineList, List<EvaluDevNode> rollList, List<EvaluDevNode> parallelList, List<EvaluDevNode> apolloList, List<EvaluDevNode> patchList, List<EvaluDevNode> offLineContainerList) {
        Map<ItDeviceType, List<EvaluDevNode>> mapByType;
        if (!fastList.isEmpty()) {
            mapByType = this.groupByDevType(fastList);
            listByMod.put(UpgradeMode.FAST, mapByType);
        }
        if (!onlineList.isEmpty()) {
            mapByType = this.groupByDevType(onlineList);
            listByMod.put(UpgradeMode.ONLINE, mapByType);
        }
        if (!offineList.isEmpty()) {
            mapByType = this.groupByDevType(offineList);
            listByMod.put(UpgradeMode.OFFLINE, mapByType);
        }
        if (!rollList.isEmpty()) {
            mapByType = this.groupByDevType(rollList);
            listByMod.put(UpgradeMode.ROLL, mapByType);
        }
        if (!parallelList.isEmpty()) {
            mapByType = this.groupByDevType(parallelList);
            listByMod.put(UpgradeMode.PARALLEL, mapByType);
        }
        if (!apolloList.isEmpty()) {
            mapByType = this.groupByDevType(apolloList);
            listByMod.put(UpgradeMode.APOLLO, mapByType);
        }
        if (!patchList.isEmpty()) {
            mapByType = this.groupByDevType(patchList);
            listByMod.put(UpgradeMode.PATCH_CONTAINER, mapByType);
        }
        if (!offLineContainerList.isEmpty()) {
            mapByType = this.groupByDevType(offLineContainerList);
            listByMod.put(UpgradeMode.OFFLINE_CONTAINER, mapByType);
        }
    }

    public Map<ItDeviceType, List<EvaluDevNode>> groupByDevType(List<EvaluDevNode> devs) {
        Map<ItDeviceType, List<EvaluDevNode>> devTypeList = new HashMap<ItDeviceType, List<EvaluDevNode>>();
        if (null == devs || devs.isEmpty()) {
            return devTypeList;
        }
        devTypeList = this.genMapByDevType(devs);
        return devTypeList;
    }

    private Map<ItDeviceType, List<EvaluDevNode>> genMapByDevType(List<EvaluDevNode> devs) {
        HashMap<ItDeviceType, List<EvaluDevNode>> devTypeList = new HashMap<ItDeviceType, List<EvaluDevNode>>();
        ArrayList<EvaluDevNode> storageList = new ArrayList<EvaluDevNode>();
        ArrayList<EvaluDevNode> hostList = new ArrayList<EvaluDevNode>();
        ArrayList<EvaluDevNode> switchList = new ArrayList<EvaluDevNode>();
        for (EvaluDevNode dev : devs) {
            ItDeviceType type = dev.getItDeviceType();
            switch (type) {
                case Storage: 
                case A800_NODE: {
                    storageList.add(dev);
                    devTypeList.put(ItDeviceType.Storage, storageList);
                    break;
                }
                case Host: {
                    hostList.add(dev);
                    devTypeList.put(ItDeviceType.Host, hostList);
                    break;
                }
                case Switch: {
                    switchList.add(dev);
                    devTypeList.put(ItDeviceType.Switch, switchList);
                    break;
                }
            }
        }
        return devTypeList;
    }

    public Map<String, List<EvaluDevNode>> groupByModelVersion(List<EvaluDevNode> devs) {
        if (null == devs || devs.isEmpty()) {
            return null;
        }
        HashMap<String, List<EvaluDevNode>> modelVerMap = new HashMap<String, List<EvaluDevNode>>();
        ArrayList<String> mvList = new ArrayList<String>();
        for (EvaluDevNode dev : devs) {
            String modelVersion = dev.getModelVersion();
            if (mvList.contains(modelVersion)) {
                ((List)modelVerMap.get(modelVersion)).add(dev);
                continue;
            }
            mvList.add(modelVersion);
            ArrayList<EvaluDevNode> devList = new ArrayList<EvaluDevNode>();
            devList.add(dev);
            modelVerMap.put(modelVersion, devList);
        }
        return modelVerMap;
    }

    public boolean isSameType(List<EvaluDevNode> devs) {
        if (devs.size() == 1) {
            return true;
        }
        for (int i = 0; i < devs.size() - 1; ++i) {
            DevNode tmp1 = devs.get(i);
            DevNode tmp2 = devs.get(i + 1);
            if (tmp1.getDeviceType().equals((Object)tmp2.getDeviceType())) continue;
            return false;
        }
        return true;
    }

    public ItDeviceType getSelectDevsType(List<EvaluDevNode> selectDevs) {
        if (selectDevs.isEmpty()) {
            return null;
        }
        return selectDevs.get(0).getItDeviceType();
    }

    public String getVRCVersion(String version) {
        Pattern pattern = Pattern.compile("(V.{3}R.{3}C.{2}|\\d+\\.\\d+)");
        Matcher matcher = pattern.matcher(version);
        String vrcVer = "--";
        if (matcher.find()) {
            vrcVer = matcher.group();
        }
        return vrcVer;
    }

    public String getFullVRCVersion(String version) {
        Pattern pattern = Pattern.compile("(V.{3}R.{3}C.{2}|\\d+\\.\\d+)");
        Matcher matcher = pattern.matcher(version);
        String vrcVer = "--";
        if (matcher.find()) {
            vrcVer = matcher.group();
            if (version.contains("Kunpeng")) {
                vrcVer = vrcVer + " Kunpeng";
            }
        }
        return vrcVer;
    }

    public String replaceLink(String value, String helpHref, String path) {
        if (StringUtils.hasNULLStr((String[])new String[]{value, helpHref})) {
            return value;
        }
        String[] urlKeys = helpHref.split("&&");
        StringBuffer tmpValue = null;
        StringBuffer hrefBuffer = null;
        for (String urlkey : urlKeys) {
            if (StringUtils.hasNULLStr((String[])new String[]{urlkey})) continue;
            String key = StringUtils.findMatchStr((String)urlkey, (String)REDULAR, (int)1);
            String hrefValue = StringUtils.findMatchStr((String)urlkey, (String)REDULAR, (int)2);
            if (StringUtils.hasNULLStr((String[])new String[]{key, hrefValue})) continue;
            tmpValue = new StringBuffer();
            String[] hrefs = hrefValue.split(",");
            int keylocInt = -1;
            String tmp = "";
            for (String href : hrefs) {
                keylocInt = value.indexOf(key);
                if (-1 == keylocInt) break;
                tmp = value.substring(0, keylocInt + key.length());
                value = value.substring(keylocInt + key.length());
                if (StringUtils.hasNULLStr((String[])new String[]{href})) {
                    tmpValue.append(tmp);
                    continue;
                }
                href = this.localLinkDeComp(path, href);
                hrefBuffer = new StringBuffer("<a href=\"");
                hrefBuffer.append(href);
                hrefBuffer.append("\" target=\"_blank\">");
                hrefBuffer.append(key);
                hrefBuffer.append("</a>");
                tmpValue.append(tmp.replace(key, hrefBuffer.toString()));
            }
            tmpValue.append(value);
            value = tmpValue.toString();
        }
        return value;
    }

    private String localLinkDeComp(String path, String href) {
        String realHref = href;
        if (!(href.contains(HTTP) || href.contains(HTTPS) || href.contains(WWW) || new File(realHref = path + href).exists())) {
            String newpath;
            PackageUtils.deCompressResourceFile(path, true);
            if (!(new File(realHref).exists() || path.contains("..") || new File(realHref = (newpath = FileUtil.getCanonicalPath(ProductParser.getCommonPackagePath())) + href).exists())) {
                LOGGER.info("can not find file from common case.");
                return path + href;
            }
        }
        LOGGER.info(String.format(Locale.ENGLISH, "the href path=%s", realHref));
        return realHref;
    }

    public Map<ResultFlag, Integer> getDevsFlagStatistics(List<EvaluDevNode> devs) {
        int passCount = 0;
        int noPassCount = 0;
        for (EvaluDevNode dev : devs) {
            ResultFlag ret = dev.getEvaluRet().getRetFlag();
            if (ResultFlag.PASS.equals((Object)ret)) {
                ++passCount;
                continue;
            }
            ++noPassCount;
        }
        HashMap<ResultFlag, Integer> statistics = new HashMap<ResultFlag, Integer>();
        statistics.put(ResultFlag.PASS, passCount);
        statistics.put(ResultFlag.NOTPASS, noPassCount);
        return statistics;
    }

    public static boolean isNeedOpenOrCloseTlv(EvaluDevNode devNode) {
        String productVersion = devNode.getProductVersion();
        List<String> list = EvaluContext.getInstance().getNeedOpenVersions();
        for (String str : list) {
            if (null == str || 0 != productVersion.indexOf(str.trim())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openTlv(EvaluDevNode devNode) {
        ICliConnection sshConn = null;
        try {
            ConnectorFactory connFactory = ConnectorFactory.getInstance();
            SshForwardConnector sshCtr = connFactory.createSshForwardConnector((DevNode)devNode);
            sshConn = sshCtr.getConnectionForPwdWillExpireBreak();
            String changeModeResult = sshConn.execCmd("change user_mode current_mode user_mode=developer");
            LOGGER.info(String.format(Locale.ENGLISH, "%s developer open %s", devNode.getIp(), changeModeResult));
            String changeTlvResult = sshConn.execCmd("change system external_tlv_channel enabled=yes");
            LOGGER.error(devNode.getIp() + "  change tlv   " + changeTlvResult);
            sshConn.execCmd("y");
            sshConn.execCmd("y");
        }
        catch (Exception e) {
            try {
                LOGGER.error("open tlv failed", e);
            }
            catch (Throwable throwable) {
                EvaluService.releaseSshConnection(sshConn);
                throw throwable;
            }
            EvaluService.releaseSshConnection(sshConn);
        }
        EvaluService.releaseSshConnection(sshConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeTlv(EvaluDevNode devNode) {
        ICliConnection sshConn = null;
        try {
            ConnectorFactory connFactory = ConnectorFactory.getInstance();
            SshForwardConnector sshCtr = connFactory.createSshForwardConnector((DevNode)devNode);
            sshConn = sshCtr.getConnectionForPwdWillExpireBreak();
            String changeModeResult = sshConn.execCmd("change user_mode current_mode user_mode=developer");
            LOGGER.info(String.format(Locale.ENGLISH, "%s  change  mode  %s", devNode.getIp(), changeModeResult));
            String changeTlvResult = sshConn.execCmd("change system external_tlv_channel enabled=no");
            LOGGER.info(String.format(Locale.ENGLISH, "%s  change  tlv  %s", devNode.getIp(), changeTlvResult));
            sshConn.execCmd("y");
            sshConn.execCmd("y");
        }
        catch (Exception e) {
            try {
                LOGGER.error("exits closed tlv failure", e);
            }
            catch (Throwable throwable) {
                EvaluService.releaseSshConnection(sshConn);
                throw throwable;
            }
            EvaluService.releaseSshConnection(sshConn);
        }
        EvaluService.releaseSshConnection(sshConn);
    }

    public static void releaseSshConnection(ICliConnection sshConn) {
        if (sshConn == null || !sshConn.isConnected()) {
            return;
        }
        try {
            SshConnectionManager.releaseConnection((ICliConnection)sshConn);
        }
        catch (Exception e) {
            LOGGER.warn("release ssh failed: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queryStorageInfo4HostEvalu(DevNode devNode, IProgressCallback progressUpdater) {
        this.isInHostEvalu = true;
        EvaluDevNode evaluDevNode = new EvaluDevNode(devNode);
        String storageInfo = "";
        Map<String, Object> dic = null;
        PythonEngine pyEngine = null;
        try {
            dic = this.createPYDic(evaluDevNode, true);
            dic.put(PROGRESS_WIPER, progressUpdater);
            File productsFolder = ProductParser.getCommonPackagePath();
            ArrayList<File> clssPath = new ArrayList<File>();
            clssPath.add(productsFolder);
            pyEngine = new PythonEngine(clssPath, dic);
            String pythonScriptPath = "business" + File.separator + "service" + File.separator + "queryStorageInfo4HostEvalu.py";
            File pythonScript = new File(productsFolder, pythonScriptPath);
            List<Object> rets = pyEngine.execute(pythonScript);
            storageInfo = (String)rets.get(1);
            LOGGER.info(String.format(Locale.ENGLISH, "storageInfo=%s", storageInfo));
        }
        catch (Exception e) {
            LOGGER.error("queryStorageInfo4HostEvalu exception.", e);
            if ("cli.connetnum.reachmax".equals(e.getMessage())) {
                storageInfo = "cli.connetnum.reachmax";
            }
        }
        finally {
            if (null != pyEngine) {
                pyEngine.clean();
            }
            if (null != dic) {
                this.distroyDic(dic);
            }
        }
        return storageInfo;
    }
}

