/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.evalu;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.entity.UpgradeMode;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluDevCallable;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluDevCallableOver;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluDevManager;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluService;
import com.huawei.ism.tool.upgradeevalu.evalu.ResultFlag;
import com.huawei.ism.tool.upgradeevalu.evalu.ResultItem;
import com.huawei.ism.tool.upgradeevalu.evalu.SilenceCollectLog;
import com.huawei.ism.tool.upgradeevalu.report.ReportBuilder;
import com.huawei.ism.tool.upgradeevalu.ui.IUiObserver;
import com.huawei.ism.tool.upgradeevalu.util.A800Utils;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.ism.tool.upgradeevalu.util.FileUtil;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class EvaluTaskManager {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(EvaluTaskManager.class);
    private static final int MAX_EVALU_DEV = 10;
    private List<EvaluDevNode> devList;
    private IUiObserver observer;
    private File resultDir;
    private ExecutorService executorService;
    private CompletionService<EvaluDevCallableOver> completionService;
    private EvaluService evaluService = EvaluService.getInstance();
    private EvaluDevManager devMgr = EvaluDevManager.getInstance();
    private Calendar evaluStartTime = null;
    private Calendar evaluEndTime = null;
    private EvaluContext evaluContext = EvaluContext.getInstance();
    private int evaluFailureNumber = 0;

    public EvaluTaskManager(List<EvaluDevNode> devs, IUiObserver observer, File resultDir) {
        this.devList = devs;
        this.observer = observer;
        this.resultDir = resultDir;
        this.evaluStartTime = Calendar.getInstance();
        this.executorService = Executors.newFixedThreadPool(10);
        this.completionService = new ExecutorCompletionService<EvaluDevCallableOver>(this.executorService);
    }

    private void deleteTmpDir() {
        try {
            String path = this.evaluContext.getHome() + File.separator + "tmp";
            FileUtils.deleteAllInFolder((String)path);
            FileUtils.clearDir((String)FileUtil.getCanonicalPath(this.evaluContext.getHtmlDir()));
        }
        catch (Exception e) {
            LOGGER.error("delete temp file exception. ", e);
            return;
        }
    }

    public void evaluDevs() {
        this.deleteTmpDir();
        this.executorService.submit(new SilenceCollectLog(this.devList));
        if (A800Utils.isA800UpgradeCheck()) {
            List<List<EvaluDevNode>> batchList = this.getBatchList();
            for (List<EvaluDevNode> evalDevs : batchList) {
                this.setPreCheckModel(evalDevs);
                evalDevs.stream().map(evalDev -> this.completionService.submit(new EvaluDevCallable((EvaluDevNode)((Object)evalDev), this.observer))).collect(Collectors.toList()).forEach(this::getEvalDevResult);
            }
        } else {
            this.devList.forEach(dev -> this.completionService.submit(new EvaluDevCallable((EvaluDevNode)((Object)dev), this.observer)));
        }
        boolean exeResult = true;
        exeResult = this.batchEvaluationDevList(exeResult);
        if (!exeResult) {
            this.observer.showTaskErr(ResourceUtil.getString((String)"evalu.ui.mainDialog.execute.report.task.error"));
        }
        try {
            if (this.observer == null) {
                LOGGER.error("EvaluTaskManager observer is null");
                return;
            }
            this.observer.evaluProcessTip(ResourceUtil.getString((String)"evalu.ui.mainDialog.generating.report.tip"));
            ReportBuilder reportBuilder = new ReportBuilder();
            Map<UpgradeMode, Map<ItDeviceType, List<EvaluDevNode>>> devsMap = this.evaluService.groupByUpgradeType(this.devMgr.getEvaluDevs());
            reportBuilder.buildReport4New(devsMap, this.resultDir);
        }
        catch (Exception e) {
            exeResult = false;
            this.observer.showTaskErr(ResourceUtil.getString((String)"evalu.ui.mainDialog.generation.report.task.error"));
            LOGGER.error("build report failed.", e);
        }
        this.observer.evaluProcessTip(this.handleEndMsg(exeResult));
        this.observer.finishAll();
        this.devMgr.clearEvaluDevs();
        this.executorService.shutdown();
    }

    private List<List<EvaluDevNode>> getBatchList() {
        ArrayList<List<EvaluDevNode>> batchList = new ArrayList<List<EvaluDevNode>>();
        int evalSize = this.devList.size();
        int pageSize = 10;
        int totalPages = (int)Math.ceil((double)evalSize / (double)pageSize);
        for (int page = 0; page < totalPages; ++page) {
            int fromIndex = page * pageSize;
            int toIndex = Math.min(fromIndex + pageSize, evalSize);
            List<EvaluDevNode> currentPage = this.devList.subList(fromIndex, toIndex);
            batchList.add(currentPage);
        }
        return batchList;
    }

    private void setPreCheckModel(List<EvaluDevNode> devs) {
        EvaluDevNode minZoneIdDev = devs.stream().min(Comparator.comparing(DevNode::getUuid)).orElse(devs.get(0));
        for (EvaluDevNode devNode : devs) {
            if (Objects.equals(devNode.getIp(), minZoneIdDev.getIp())) {
                devNode.setPreCheckModel("execute");
                List<String> zoneIds = devs.stream().map(DevNode::getUuid).sorted().collect(Collectors.toList());
                devNode.setZoneIds(zoneIds);
                continue;
            }
            devNode.setPreCheckModel("query");
            devNode.setExecuteZoneIp(minZoneIdDev.getIp());
        }
    }

    private Optional<EvaluDevCallableOver> getEvalDevResult(Future<EvaluDevCallableOver> evalFuture) {
        try {
            EvaluDevCallableOver callableOver = evalFuture.get();
            return Optional.of(callableOver);
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("query device node CloudBackup Future failed.", e);
            return Optional.empty();
        }
    }

    private boolean batchEvaluationDevList(boolean exeResult) {
        for (int i = 0; i < this.devList.size(); ++i) {
            EvaluDevNode dev = null;
            try {
                EvaluDevCallableOver tc = this.completionService.take().get();
                dev = tc.getDev();
                if (this.observer != null) {
                    this.observer.updateDevTableRow(dev);
                }
                ResultItem echoInfo = tc.getEchoInfo();
                try {
                    if (!tc.isSuccess() || null != echoInfo) {
                        this.devMgr.removeEvaluDev(dev);
                        ++this.evaluFailureNumber;
                        LOGGER.info(String.format(Locale.ENGLISH, "Evalu device %s upgrade from %s to %s failed.", dev.getIp(), dev.getProductVersion(), dev.getDestVersion()));
                        continue;
                    }
                    LOGGER.info(String.format(Locale.ENGLISH, "Evalu device %s upgrade from %s to %s complete.", dev.getIp(), dev.getProductVersion(), dev.getDestVersion()));
                }
                catch (Exception e) {
                    LOGGER.error(String.format(Locale.ENGLISH, "Log records failed.%s", e));
                }
                continue;
            }
            catch (InterruptedException e) {
                this.devMgr.removeEvaluDev(dev);
                ++this.evaluFailureNumber;
                exeResult = false;
                LOGGER.error("Evalu device failed. wait feture occur InterruptedException", e);
                continue;
            }
            catch (ExecutionException e) {
                this.devMgr.removeEvaluDev(dev);
                ++this.evaluFailureNumber;
                exeResult = false;
                LOGGER.error("Evalu device failed. wait feture occur ExecutionException", e);
                continue;
            }
            catch (Exception e) {
                this.devMgr.removeEvaluDev(dev);
                ++this.evaluFailureNumber;
                exeResult = false;
                LOGGER.error("Evalu device failed. wait feture occur Exception", e);
            }
        }
        return exeResult;
    }

    private String handleEndMsg(boolean exeResult) {
        this.evaluEndTime = Calendar.getInstance();
        String processMsg = "";
        if (!exeResult) {
            processMsg = ResourceUtil.getString((String)"evalu.ui.mainDialog.execute.report.task.or.generation.error");
        } else {
            List<EvaluDevNode> devs = this.devMgr.getEvaluDevs();
            int orinagalDevNum = this.devMgr.getOriginalNum();
            Map<ResultFlag, Integer> statistics = EvaluService.getInstance().getDevsFlagStatistics(devs);
            this.evaluStartTime.set(14, 0);
            this.evaluEndTime.set(14, 0);
            if (!this.evaluContext.isEndEvalu()) {
                processMsg = MessageFormat.format(ResourceUtil.getString((String)"evalu.ui.mainDialog.complete.evalution.dev.tip"), orinagalDevNum, devs.size(), this.evaluFailureNumber, statistics.get((Object)ResultFlag.PASS), statistics.get((Object)ResultFlag.NOTPASS));
                if (!devs.isEmpty()) {
                    processMsg = processMsg + ResourceUtil.getString((String)"evalu.ui.mainDialog.complete.view.report.des");
                }
            }
        }
        return processMsg;
    }
}

