/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.evalu;

import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.tlv.exception.TLVException;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.tool.pyengine.utils.PyJavaUtils;
import com.huawei.ism.tool.upgradeevalu.exception.JythonException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;

public class PythonEngine {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(PythonEngine.class);
    private static final String FUNCTION_NAME = "execute";
    private JythonExecuter jythonExecuter;
    private Map<String, Object> dic;

    public PythonEngine(List<File> clssPath, Map<String, Object> dic) {
        this.jythonExecuter = new JythonExecuter(clssPath);
        this.dic = dic;
    }

    public List<Object> execute(File python) throws JythonException {
        List rets = null;
        try {
            LOGGER.info(String.format(Locale.ENGLISH, "execute Python %s", python.getCanonicalPath()));
            this.jythonExecuter.compileScript(python);
            rets = this.jythonExecuter.invokeFunction(FUNCTION_NAME, this.dic);
        }
        catch (SignException e) {
            String error = "execute Python " + python.getName() + " failed. occur signException.";
            LOGGER.error(error, e);
            throw new JythonException(error, e);
        }
        catch (FileNotFoundException e) {
            String error = "execute Python " + python.getName() + " failed. occur FileNotFoundException.";
            LOGGER.error(error);
            throw new JythonException(error);
        }
        catch (ToolException e) {
            String error = "execute Python " + python.getName() + " failed. occur ToolException." + e.getMessage();
            LOGGER.error(error, e);
            throw new JythonException(error, e);
        }
        catch (TLVException e) {
            String error = "execute Python " + python.getName() + " failed. occur TLVException." + e.getMessage();
            LOGGER.error(error, e);
            throw new JythonException(error, e);
        }
        catch (Exception e) {
            LOGGER.error("execute Python " + python.getName() + " failed. occur Exception.", e);
            throw new JythonException("execute Python " + python.getName() + " failed. occur ToolException", e);
        }
        return rets;
    }

    public void clean() {
        if (null != this.jythonExecuter) {
            PyJavaUtils.releaseRestConnection(this.dic);
            this.jythonExecuter.cleanup();
        }
    }
}

