/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.evalu;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.connection.DefaultSshJudge;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.ISshJudge;
import com.huawei.ism.tool.obase.connection.SftpTransporter;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.pyengine.service.zip.PYZip;
import com.huawei.ism.tool.upgradeevalu.entity.CrossVersionType;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluItem;
import com.huawei.ism.tool.upgradeevalu.entity.ProductCfg;
import com.huawei.ism.tool.upgradeevalu.evalu.PythonEngine;
import com.huawei.ism.tool.upgradeevalu.exception.JythonException;
import com.huawei.ism.tool.upgradeevalu.scene.SceneDataHelper;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.ism.tool.upgradeevalu.util.FileAssistant;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class SilenceCollectLog
implements Runnable {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SilenceCollectLog.class);
    private List<EvaluDevNode> tabDevs;
    private EvaluDevNode oneNeedCollectDev;
    private EvaluContext evaluContext = EvaluContext.getInstance();
    private Map<String, String> collectDataPathMap = SceneDataHelper.getInstance().getCollectToolDataPath();

    public SilenceCollectLog(List<EvaluDevNode> tabDevs) {
        this.tabDevs = tabDevs;
    }

    @Override
    public void run() {
        this.removeNoSystemLogCollectPath();
        this.setCollect2Dev();
        this.silenceCollectLog();
    }

    private void removeNoSystemLogCollectPath() {
        Iterator<Map.Entry<String, String>> it = this.collectDataPathMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> item = it.next();
            boolean existSystemLog = FileAssistant.seachFileFrom7zFile(item.getValue(), "System_log");
            if (existSystemLog) continue;
            it.remove();
        }
    }

    private void setCollect2Dev() {
        block0: for (EvaluDevNode dev : this.tabDevs) {
            List<EvaluItem> evaluItemList = dev.getAllEvaluItem();
            for (EvaluItem item : evaluItemList) {
                if (!item.isNeedLog()) continue;
                if (!this.collectDataPathMap.containsKey(dev.getDeviceSerialNumber())) {
                    dev.setNeedLog(true);
                } else {
                    dev.getExtraMap().put("collectFile", this.collectDataPathMap.get(dev.getDeviceSerialNumber()));
                }
                this.oneNeedCollectDev = dev;
                continue block0;
            }
        }
    }

    private void silenceCollectLog() {
        LOGGER.info("silenceCollectLog call script start.");
        PythonEngine pyEngine = null;
        try {
            this.createDevsConnection();
            if (this.oneNeedCollectDev == null) {
                LOGGER.info("No need collect dev.");
                return;
            }
            pyEngine = new PythonEngine(this.oneNeedCollectDev.getClssPath(), this.createContext());
            pyEngine.execute(this.createScriptFile());
        }
        catch (JythonException e) {
            LOGGER.error("Execute silenceCollectLog failed", e);
        }
        catch (ToolException e) {
            LOGGER.error("Execute silenceCollectLog: {}", (Object)e.getErrorId());
        }
        finally {
            if (null != pyEngine) {
                pyEngine.clean();
            }
            if (null != this.tabDevs) {
                this.closeDevsConnection();
            }
            LOGGER.info("silenceCollectLog call script end.");
        }
    }

    private Map<String, Object> createContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("devs", this.tabDevs);
        context.put("logger", ToolLoggerFactory.getLoggerInStandAlone((String)this.oneNeedCollectDev.getDeviceSerialNumber()));
        context.put("lang", this.evaluContext.getLoc().getLanguage());
        context.put("EntityUtils", EntityUtils.class);
        context.put("PYENGINE.PY_ZIP", new PYZip());
        return context;
    }

    private File createScriptFile() throws ToolException {
        KeyOrderedHashMap<CrossVersionType, ProductCfg> prodMap = this.oneNeedCollectDev.getProducts();
        ProductCfg prod = (ProductCfg)prodMap.get((Object)CrossVersionType.INNERVERSION);
        File dir = prod.getProductDir().getParentFile();
        File scriptFile = new File(dir, "silenceCollectLog.py");
        if (!scriptFile.exists()) {
            throw new ToolException("silenceCollectLog.py file is not exists.");
        }
        return scriptFile;
    }

    private void createDevsConnection() {
        for (EvaluDevNode dev : this.tabDevs) {
            if (dev.getSsh() != null) continue;
            SshConnection sshConnection = new SshConnection(dev.getIp(), dev.getLoginUser().getUserName(), dev.getLoginUser().getPassword(), (ISshJudge)new DefaultSshJudge());
            try {
                sshConnection.connect();
                SftpTransporter.setGlobalRetryTimes((int)3);
                dev.setSsh((ICliConnection)sshConnection);
                SftpTransporter sftp = new SftpTransporter((ICliConnection)sshConnection);
                dev.setSftp(sftp);
            }
            catch (ToolException e) {
                LOGGER.error("create ssh and sftp is failed", e);
                dev.setSftp(null);
                dev.setSsh(null);
            }
        }
    }

    private void closeDevsConnection() {
        for (EvaluDevNode devNode : this.tabDevs) {
            if (devNode.getSftp() != null) {
                devNode.getSftp().close();
            }
            if (devNode.getSsh() != null) {
                devNode.getSsh().close();
            }
            devNode.setSftp(null);
            devNode.setSsh(null);
        }
    }
}

