/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.model;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.upgradeevalu.enums.ItCompatFeautureEnum;
import com.huawei.ism.tool.upgradeevalu.enums.ItElementType;
import com.huawei.ism.tool.upgradeevalu.enums.ItUpgradeKeyEnum;
import com.huawei.json.JSONObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import utils.Products;

public class ItemInfo {
    private static final String EVAL_TXT_SUFFIX = "_foreEval.txt";
    public static final int HUAWEI_AIX_MULTIPATH_VERSION_SEP = 803028;
    public static final int HUAWEI_MULTIPATH_VERSION_SEP = 801000;
    private static final Logger LOGGER = Logger.getLogger(ItemInfo.class);
    private static final String EVAL_META_DATA_DIR_NAME = "EvalMetaData";
    private static final String MESSAGE_SPERATOR = "*********^^^^^^^^^^************^^^^^^^^^^*********";
    private static final String MESSAGE_START_MARKER = "_needEvalCmdRtn:";
    private static final String OS_AIX = "AIX";
    private int itemIndex;
    private ItDeviceType deviceType;
    private String deviceName = "";
    private String superUser;
    private String uuid = ItemInfo.getNoStripUUID();
    private String devInfo = "";
    private String ip = "";
    private String osName = "";
    private String hbaName = "";
    private String clusterName = "";
    private String multiPathName = "";
    private String osNumber = "";
    private String hbaTimeOut = "";
    private String multiPathState = "";
    private String multiSoftEdition = "";
    private String hbaDriverNum = "";
    private String firmWareVersion = "";
    private String hbaFirmwareNum = "";
    private Map<ItElementType, List<String>> eleMap;
    private Map<ItUpgradeKeyEnum, String> upgradeKeyMap;
    private Map<ItCompatFeautureEnum, List<List<String>>> elementStrMap;
    private String iscsiTimeOut = "";
    private String fcNetInfo = "";
    private String databaseVersion = "";
    private String asmHbeatiowait = "";
    private String asmDiskGroupType = "";
    private String missingHBAparamWWPNs = "";
    private String switchDeviceTypeId = "";
    private String packagePath = "";
    private String metaFileName = "";
    private Map<String, String> infoGrabMetaMsg = new HashMap<String, String>();
    private boolean storageCoverTmoParam;
    private List<String> conbineDataList;
    private List<String> conbineHeaderList;

    public ItemInfo() {
        this.setUpgradeKeyMap(new HashMap<ItUpgradeKeyEnum, String>());
        this.setEleMap(new HashMap<ItElementType, List<String>>());
        this.setElementStrMap(new HashMap<ItCompatFeautureEnum, List<List<String>>>());
    }

    public List<String> getConbineHeaderList() {
        return this.conbineHeaderList;
    }

    public void setConbineHeaderList(List<String> conbineHeaderList) {
        this.conbineHeaderList = conbineHeaderList;
    }

    public List<String> getConbineDataList() {
        return this.conbineDataList;
    }

    public void setConbineDataList(List<String> conbineDataList) {
        this.conbineDataList = conbineDataList;
    }

    public ItemInfo(String deviceInfo, String osName) {
        this.devInfo = deviceInfo;
        this.osName = osName;
        this.setUpgradeKeyMap(new HashMap<ItUpgradeKeyEnum, String>());
        this.setEleMap(new HashMap<ItElementType, List<String>>());
        this.setElementStrMap(new HashMap<ItCompatFeautureEnum, List<List<String>>>());
    }

    public boolean isStorageCoverTmoParam() {
        return this.storageCoverTmoParam;
    }

    public void setStorageCoverTmoParam(boolean storageCoverTmoParam) {
        this.storageCoverTmoParam = storageCoverTmoParam;
    }

    public String getInfoGrabMetaMsg(String key) {
        String value = this.infoGrabMetaMsg.get(key);
        return value == null ? "" : value.trim();
    }

    public Map<String, String> getInfoGrabMetaMsg() {
        return this.infoGrabMetaMsg;
    }

    public void setInfoGrabMetaMsg(Map<String, String> infoGrabMetaMsg) {
        this.infoGrabMetaMsg = infoGrabMetaMsg;
    }

    public String getMissingHBAparamWWPNs() {
        return this.missingHBAparamWWPNs;
    }

    public String getMetaFileName() {
        return this.metaFileName;
    }

    public void setMetaFileName(String metaFileName) {
        this.metaFileName = metaFileName;
    }

    public void setMissingHBAparamWWPNs(String missingHBAparamWWPNs) {
        this.missingHBAparamWWPNs = missingHBAparamWWPNs;
    }

    public String getIscsiTimeOut() {
        return this.iscsiTimeOut;
    }

    public String getFirmWareVersion() {
        return this.firmWareVersion;
    }

    public String getFcNetInfo() {
        return this.fcNetInfo;
    }

    public void setFcNetInfo(String fcNetInfo) {
        this.fcNetInfo = fcNetInfo;
    }

    public void setFirmWareVersion(String firmWareVersion) {
        this.firmWareVersion = firmWareVersion;
    }

    public void setIscsiTimeOut(String iscsiTimeOut) {
        this.iscsiTimeOut = iscsiTimeOut;
    }

    private static String getNoStripUUID() {
        UUID uuid = UUID.randomUUID();
        String uuidstr = uuid.toString();
        return uuidstr.replaceAll("-", "");
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setHbaName(String hbaName) {
        this.hbaName = hbaName;
    }

    public String getHbaName() {
        return this.hbaName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setMultiPathName(String multiPathName) {
        this.multiPathName = multiPathName;
    }

    public String getMultiPathName() {
        return this.multiPathName;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getIp() {
        return this.ip;
    }

    public void setDevInfo(String deviceInfo) {
        this.devInfo = deviceInfo;
    }

    public String getDevInfo() {
        return this.devInfo;
    }

    public void setDeviceType(ItDeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public ItDeviceType getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getSuperUser() {
        return this.superUser;
    }

    public void setSuperUser(String superUser) {
        if (null != superUser) {
            this.superUser = superUser;
        }
    }

    public void setHbaTimeOut(String hbaTimeOut) {
        this.hbaTimeOut = hbaTimeOut;
    }

    public String getHbaTimeOut() {
        return this.hbaTimeOut;
    }

    public String getDatabaseVersion() {
        return this.databaseVersion;
    }

    public void setDatabaseVersion(String databaseVersion) {
        this.databaseVersion = databaseVersion;
    }

    public String getAsmHbeatiowait() {
        return this.asmHbeatiowait;
    }

    public void setAsmHbeatiowait(String asmHbeatiowait) {
        this.asmHbeatiowait = asmHbeatiowait;
    }

    public String getAsmDiskGroupType() {
        return this.asmDiskGroupType;
    }

    public void setDatabaseType(String diskGroupType) {
        this.asmDiskGroupType = diskGroupType;
    }

    public void setElementStrMap(Map<ItCompatFeautureEnum, List<List<String>>> elementStrMap) {
        this.elementStrMap = elementStrMap;
    }

    public Map<ItCompatFeautureEnum, List<List<String>>> getElementStrMap() {
        return this.elementStrMap;
    }

    public void setMultiPathState(String multiPathState) {
        this.multiPathState = multiPathState;
    }

    public String getMultiPathState() {
        return this.multiPathState;
    }

    public void setUpgradeKeyMap(Map<ItUpgradeKeyEnum, String> upgradeKeyMap) {
        this.upgradeKeyMap = upgradeKeyMap;
    }

    public Map<ItUpgradeKeyEnum, String> getUpgradeKeyMap() {
        return this.upgradeKeyMap;
    }

    public void setOsNumber(String osNumber) {
        this.osNumber = osNumber;
    }

    public String getOsNumber() {
        return this.osNumber;
    }

    public void setEleMap(Map<ItElementType, List<String>> eleMap) {
        this.eleMap = eleMap;
    }

    public Map<ItElementType, List<String>> getEleMap() {
        return this.eleMap;
    }

    public String getHbaDriverNum() {
        return this.hbaDriverNum;
    }

    public void setHbaDriverNum(String hbaDriverNum) {
        this.hbaDriverNum = hbaDriverNum;
    }

    public String getHbaFirmwareNum() {
        return this.hbaFirmwareNum;
    }

    public void setHbaFirmwareNum(String hbaFirmwareNum) {
        this.hbaFirmwareNum = hbaFirmwareNum;
    }

    public String getSwitchDeviceTypeId() {
        return this.switchDeviceTypeId;
    }

    public void setSwitchDeviceTypeId(String switchDeviceTypeId) {
        this.switchDeviceTypeId = switchDeviceTypeId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clusterName == null ? 0 : this.clusterName.hashCode());
        result = 31 * result + (this.deviceName == null ? 0 : this.deviceName.hashCode());
        result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
        result = 31 * result + this.itemIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemInfo other = (ItemInfo)obj;
        if (this.clusterName == null ? other.clusterName != null : !this.clusterName.equals(other.clusterName)) {
            return false;
        }
        if (this.deviceName == null ? other.deviceName != null : !this.deviceName.equals(other.deviceName)) {
            return false;
        }
        return !(this.ip == null ? other.ip != null : !(this.ip + this.itemIndex).equals(other.ip + other.itemIndex));
    }

    public int getItemIndex() {
        return this.itemIndex;
    }

    public void setItemIndex(int itemIndex) {
        this.itemIndex = itemIndex;
    }

    public String getMultiSoftEdition() {
        return this.multiSoftEdition;
    }

    public void setMultiSoftEdition(String multiSoftEdition) {
        this.multiSoftEdition = multiSoftEdition;
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public void setPackagePath(String packagePath) {
        this.packagePath = packagePath;
    }

    public String getDetails() {
        StringBuilder details = new StringBuilder();
        details.append(this.osName.trim());
        details.append(',');
        details.append(this.hbaName.trim());
        details.append(',');
        details.append(this.hbaDriverNum.trim());
        details.append(',');
        details.append(this.hbaFirmwareNum.trim());
        details.append(',');
        details.append(this.packagePath.trim());
        details.append(',');
        return details.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void initEvalCmdContext() {
        block8: {
            ZipEntry targetEntry;
            BufferedReader br;
            InputStream targetInputStream;
            ZipFile zf;
            block7: {
                zf = null;
                targetInputStream = null;
                br = null;
                zf = new ZipFile(this.getPackagePath());
                Enumeration<? extends ZipEntry> zipEntrys = zf.entries();
                String metaFName = this.replaceSpecChar(this.metaFileName);
                targetEntry = this.findTargetEntry(zipEntrys, metaFName);
                if (targetEntry != null) break block7;
                LOGGER.error("target entry is null");
                StreamUtils.closeResource(null, (Closeable)zf);
                StreamUtils.closeResource(null, (Closeable)targetInputStream);
                StreamUtils.closeResource(null, (Closeable)zf);
                return;
            }
            try {
                targetInputStream = zf.getInputStream(targetEntry);
                br = new BufferedReader(new InputStreamReader(targetInputStream, "UTF-8"));
                this.setInfoGrabMetaMsg(this.initMetaMessage(br));
            }
            catch (IOException e) {
                LOGGER.error("init context IO error.", e);
                StreamUtils.closeResource(null, (Closeable)zf);
                StreamUtils.closeResource(null, targetInputStream);
                StreamUtils.closeResource(null, (Closeable)zf);
                break block8;
            }
            catch (Exception e2) {
                LOGGER.error("init context error.", e2);
                {
                    catch (Throwable throwable) {
                        StreamUtils.closeResource(null, zf);
                        StreamUtils.closeResource(null, targetInputStream);
                        StreamUtils.closeResource(null, (Closeable)zf);
                        throw throwable;
                    }
                }
                StreamUtils.closeResource(null, (Closeable)zf);
                StreamUtils.closeResource(null, targetInputStream);
                StreamUtils.closeResource(null, (Closeable)zf);
            }
            StreamUtils.closeResource(null, (Closeable)zf);
            StreamUtils.closeResource(null, (Closeable)targetInputStream);
            StreamUtils.closeResource(null, (Closeable)zf);
        }
    }

    private Map<String, String> initMetaMessage(BufferedReader br) throws IOException {
        HashMap<String, String> messageMap = new HashMap<String, String>();
        String line = null;
        String messageKey = null;
        boolean messageIsBegin = false;
        StringBuilder messageContent = new StringBuilder();
        while ((line = br.readLine()) != null) {
            if (line.startsWith(MESSAGE_START_MARKER)) {
                messageKey = line.substring(MESSAGE_START_MARKER.length()).trim();
                messageContent = new StringBuilder();
                messageIsBegin = true;
                continue;
            }
            if (line.equals(MESSAGE_SPERATOR) && !org.apache.commons.lang3.StringUtils.isEmpty(messageKey)) {
                messageMap.put(messageKey, messageContent.toString());
                messageContent = new StringBuilder();
                messageIsBegin = false;
            }
            if (!messageIsBegin) continue;
            messageContent.append(line).append(System.lineSeparator());
        }
        return messageMap;
    }

    private ZipEntry findTargetEntry(Enumeration<? extends ZipEntry> zipEntrys, String mFileName) {
        ZipEntry targetEntry = null;
        while (zipEntrys.hasMoreElements()) {
            boolean isCurdevIp;
            ZipEntry zipEntry = zipEntrys.nextElement();
            String zipEntryFileName = zipEntry.getName();
            String fName = this.replaceSpecChar(zipEntryFileName);
            boolean bl = isCurdevIp = fName.toUpperCase(Locale.ENGLISH).contains(this.getOsName().toUpperCase(Locale.ENGLISH) + '_' + this.getIp() + '_') && fName.endsWith(EVAL_TXT_SUFFIX);
            if (!zipEntryFileName.contains(EVAL_META_DATA_DIR_NAME) || zipEntry.isDirectory() || !fName.equals(mFileName) && !isCurdevIp) continue;
            targetEntry = zipEntry;
            break;
        }
        return targetEntry;
    }

    private String replaceSpecChar(String fileNameStr) {
        return fileNameStr == null ? "" : fileNameStr.replaceAll("[/|\\\\]", "");
    }

    public boolean isStorageCoverHostTmo(String devType, String productVer) {
        try {
            if (org.apache.commons.lang3.StringUtils.isEmpty(devType) || org.apache.commons.lang3.StringUtils.isEmpty(productVer)) {
                LOGGER.info("device info is null.");
                return false;
            }
            String hostOsName = this.getOsName();
            String hostOstype = this.getDevInfo();
            String multiPathInfo = this.getMultiSoftEdition();
            JSONObject jo = new JSONObject(multiPathInfo);
            String selfMultiPathVer = jo.getString("SelfMultiPath");
            if (!this.isSelfMultiPathV1R8Newer(selfMultiPathVer, hostOsName, hostOstype)) {
                return false;
            }
            if (this.isAix(hostOsName, hostOstype)) {
                return this.isStorageCanCoverAixTmo(selfMultiPathVer, devType, productVer);
            }
            return this.isStorageCanCoverOtherSysTmo(selfMultiPathVer, devType, productVer);
        }
        catch (Exception e) {
            LOGGER.error("error happened.", e);
            return false;
        }
    }

    private boolean isSelfMultiPathV1R8Newer(String selfMultiPathVer, String hostOsName, String hostOstype) {
        String versionStr = selfMultiPathVer.replaceAll("\\.", "");
        int version = StringUtils.str2Int((String)versionStr);
        if (version < 0) {
            return false;
        }
        if (this.isAix(hostOsName, hostOstype)) {
            return 803028 <= version;
        }
        return 801000 <= version;
    }

    private boolean isStorageCanCoverOtherSysTmo(String selfMultiPathVer, String devType, String productVer) {
        boolean is18V1CanCover;
        boolean isTSeriesCanCover;
        boolean bl = isTSeriesCanCover = devType.contains("t") && productVer.compareTo("v200r002c20spc100") >= 0;
        if (isTSeriesCanCover) {
            return isTSeriesCanCover;
        }
        boolean bl2 = is18V1CanCover = (devType.contains("hvs") || devType.contains("18")) && productVer.contains("v1") && productVer.compareTo("v100r001c20spc100") >= 0;
        if (is18V1CanCover) {
            return is18V1CanCover;
        }
        boolean isHighEndV3CanCover = productVer.compareTo("v300r001c10spc100") >= 0;
        return isHighEndV3CanCover;
    }

    private boolean isStorageCanCoverAixTmo(String selfMultiPathVer, String devType, String productVer) {
        boolean isDoradoNewerVer = devType.contains("dorado") && (productVer.compareTo("v300r001c00") >= 0 || Products.isDigitalVer((String)productVer));
        boolean commonDoradoNewerVer = productVer.compareTo("v300r003c20spc200") >= 0;
        return isDoradoNewerVer || commonDoradoNewerVer;
    }

    private boolean isAix(String hostOsName, String hostOstype) {
        return OS_AIX.equalsIgnoreCase(hostOstype) || hostOsName.contains(OS_AIX);
    }
}

