/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.parser;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.excel.POIUtils;
import com.huawei.ism.tool.upgradeevalu.enums.ItUpgradeKeyEnum;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;

public class CompatibilityXlsParser {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(CompatibilityXlsParser.class);
    private static final String ERROR_CODE = ResourceUtil.getString((String)"eval.excel.read.overlength.info.tip.error.code");
    private static final String ERROR_CODE_ELSE = Locale.CHINA.equals(LanguageManager.getInstance().getCurrentLanguage()) ? ResourceUtil.getString((String)"eval.excel.read.overlength.info.tip.error.code", (Locale)Locale.ENGLISH) : ResourceUtil.getString((String)"eval.excel.read.overlength.info.tip.error.code", (Locale)Locale.CHINESE);
    private static final String ERROR_MESSAGE = ResourceUtil.getString((String)"eval.excel.read.overlength.info.tip.error.message");
    private static final String ERROR_MESSAGE_ELSE = Locale.CHINA.equals(LanguageManager.getInstance().getCurrentLanguage()) ? ResourceUtil.getString((String)"eval.excel.read.overlength.info.tip.error.message", (Locale)Locale.ENGLISH) : ResourceUtil.getString((String)"eval.excel.read.overlength.info.tip.error.message", (Locale)Locale.CHINESE);
    private static final String META_ZH = ResourceUtil.getString((String)"infograb.excel.datafile.name", (Locale)Locale.CHINESE);
    private static final String META_EN = ResourceUtil.getString((String)"infograb.excel.datafile.name", (Locale)Locale.ENGLISH);
    private static final int ERROR_INDEX = -1;
    private String packagePath = "";

    public Map<String, List<ItemInfo>> parseXlsAllHostInfo(InputStream in, String filePath) throws ToolException {
        HSSFWorkbook workbook = null;
        HashMap<String, List<ItemInfo>> xlsHostInfoMap = new HashMap<String, List<ItemInfo>>();
        try {
            workbook = new HSSFWorkbook(in);
            HashMap<String, String> overlengthInfo = new HashMap<String, String>();
            this.parseOverlengthInfo(workbook, overlengthInfo);
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                ArrayList<ItemInfo> devList = new ArrayList<ItemInfo>();
                HSSFSheet devInfoSheet = workbook.getSheetAt(i);
                this.getSingleSheetInfo(devList, devInfoSheet, overlengthInfo);
                if (devList.isEmpty()) continue;
                xlsHostInfoMap.put(devInfoSheet.getSheetName(), devList);
            }
        }
        catch (IOException e) {
            throw new ToolException("compatibility.compat.exception.excelsheet", (Throwable)e);
        }
        finally {
            StreamUtils.closeResource(null, (Closeable)workbook);
        }
        return xlsHostInfoMap;
    }

    private void getSingleSheetInfo(List<ItemInfo> devList, Sheet devInfoSheet, Map<String, String> overlengthInfo) {
        if (devInfoSheet.getSheetName().equals("HostReport")) {
            List<String> excelHeader = this.readDataToList(devInfoSheet, 0, overlengthInfo);
            this.getHostReport(devInfoSheet, overlengthInfo, devList, excelHeader);
        } else if (devInfoSheet.getSheetName().equals("SwitchReport")) {
            this.getSwitchReport(devInfoSheet, overlengthInfo, devList);
        } else if (devInfoSheet.getSheetName().equals("DatabaseReport")) {
            List<String> excelHeader = this.readDataToList(devInfoSheet, 0, overlengthInfo);
            this.getDataReport(devInfoSheet, overlengthInfo, devList, excelHeader);
        }
    }

    private void getDataReport(Sheet devInfoSheet, Map<String, String> overlengthInfo, List<ItemInfo> devList, List<String> excelHeader) {
        int rows = devInfoSheet.getLastRowNum() + 1;
        for (int startLine = 1; startLine < rows; ++startLine) {
            ItemInfo t = this.parseDbline(devInfoSheet, startLine, overlengthInfo);
            t.setPackagePath(this.packagePath);
            t.initEvalCmdContext();
            t.setItemIndex(startLine);
            devList.add(t);
            List<String> dataList = this.readDataToList(devInfoSheet, startLine, overlengthInfo);
            t.setConbineDataList(dataList);
            t.setConbineHeaderList(excelHeader);
        }
    }

    private void getSwitchReport(Sheet devInfoSheet, Map<String, String> overlengthInfo, List<ItemInfo> devList) {
        int rows = devInfoSheet.getLastRowNum() + 1;
        for (int startLine = 1; startLine < rows; ++startLine) {
            ItemInfo t = this.parseSwitchLine(devInfoSheet, startLine, overlengthInfo);
            t.setItemIndex(startLine);
            devList.add(t);
        }
    }

    private void getHostReport(Sheet devInfoSheet, Map<String, String> overlengthInfo, List<ItemInfo> devList, List<String> excelHeader) {
        int rows = devInfoSheet.getLastRowNum() + 1;
        for (int startLine = 1; startLine < rows; ++startLine) {
            ItemInfo t = this.parseHostLine(devInfoSheet, startLine, overlengthInfo);
            t.setConbineHeaderList(excelHeader);
            t.setPackagePath(this.packagePath);
            t.initEvalCmdContext();
            Map<ItUpgradeKeyEnum, String> keyMap = t.getUpgradeKeyMap();
            if (!t.getHbaTimeOut().equals("")) {
                keyMap.put(ItUpgradeKeyEnum.HOST_HBA_TIME_OUT, t.getHbaTimeOut());
            }
            if (!t.getMultiPathState().equals("")) {
                keyMap.put(ItUpgradeKeyEnum.MULTI_PATH_STAT, t.getMultiPathState());
            }
            t.setUpgradeKeyMap(keyMap);
            t.setItemIndex(startLine);
            devList.add(t);
        }
    }

    private ItemInfo parseSwitchLine(Sheet devInfoSheet, int lineNum, Map<String, String> overlengthInfo) {
        ItemInfo currentHostInfo = new ItemInfo();
        currentHostInfo.setDeviceType(ItDeviceType.Switch);
        currentHostInfo.setIp(this.getValueFromCell(devInfoSheet, 0, lineNum, overlengthInfo));
        currentHostInfo.setOsName(this.getValueFromCell(devInfoSheet, 1, lineNum, overlengthInfo));
        currentHostInfo.setFirmWareVersion(this.getValueFromCell(devInfoSheet, 2, lineNum, overlengthInfo));
        currentHostInfo.setSwitchDeviceTypeId(this.getValueFromCell(devInfoSheet, 6, lineNum, overlengthInfo));
        currentHostInfo.setMetaFileName(this.getValueFromCell(devInfoSheet, this.getMetadataKeyIndex(devInfoSheet), lineNum, overlengthInfo));
        return currentHostInfo;
    }

    private ItemInfo parseHostLine(Sheet devInfoSheet, int lineNum, Map<String, String> overlengthInfo) {
        ItemInfo currentHostInfo = new ItemInfo();
        currentHostInfo.setDeviceType(ItDeviceType.Host);
        String value = this.getValueFromCell(devInfoSheet, 0, lineNum, overlengthInfo);
        currentHostInfo.setIp(value);
        currentHostInfo.setDeviceName(this.getValueFromCell(devInfoSheet, 1, lineNum, overlengthInfo));
        value = this.getValueFromCell(devInfoSheet, 3, lineNum, overlengthInfo);
        currentHostInfo.setDevInfo(value);
        currentHostInfo.setOsName(this.getValueFromCell(devInfoSheet, 4, lineNum, overlengthInfo));
        currentHostInfo.setOsNumber(this.getValueFromCell(devInfoSheet, 5, lineNum, overlengthInfo));
        currentHostInfo.setHbaDriverNum(this.getValueFromCell(devInfoSheet, 15, lineNum, overlengthInfo));
        currentHostInfo.setHbaFirmwareNum(this.getValueFromCell(devInfoSheet, 16, lineNum, overlengthInfo));
        currentHostInfo.setHbaName(this.getValueFromCell(devInfoSheet, 14, lineNum, overlengthInfo));
        currentHostInfo.setHbaTimeOut(this.getValueFromCell(devInfoSheet, 17, lineNum, overlengthInfo));
        currentHostInfo.setMultiPathName(this.getValueFromCell(devInfoSheet, 18, lineNum, overlengthInfo));
        currentHostInfo.setMultiPathState(this.getValueFromCell(devInfoSheet, 20, lineNum, overlengthInfo));
        currentHostInfo.setClusterName(this.getValueFromCell(devInfoSheet, 21, lineNum, overlengthInfo));
        currentHostInfo.setIscsiTimeOut(this.getValueFromCell(devInfoSheet, 22, lineNum, overlengthInfo));
        currentHostInfo.setFcNetInfo(this.getValueFromCell(devInfoSheet, 24, lineNum, overlengthInfo));
        currentHostInfo.setMultiSoftEdition(this.getValueFromCell(devInfoSheet, 27, lineNum, overlengthInfo));
        currentHostInfo.setMissingHBAparamWWPNs(this.getValueFromCell(devInfoSheet, 28, lineNum, overlengthInfo));
        currentHostInfo.setSuperUser(this.getValueFromCell(devInfoSheet, 29, lineNum, overlengthInfo));
        currentHostInfo.setMetaFileName(this.getValueFromCell(devInfoSheet, this.getMetadataKeyIndex(devInfoSheet), lineNum, overlengthInfo));
        List<String> excelData = this.readDataToList(devInfoSheet, lineNum, overlengthInfo);
        currentHostInfo.setConbineDataList(excelData);
        return currentHostInfo;
    }

    public List<String> readDataToList(Sheet devInfoSheet, int lineNum, Map<String, String> overlengthInfo) {
        int columns = devInfoSheet.getRow(lineNum).getLastCellNum();
        LinkedList<String> excelData = new LinkedList<String>();
        for (int i = 0; i < columns; ++i) {
            excelData.add(this.getValueFromCell(devInfoSheet, i, lineNum, overlengthInfo));
        }
        return excelData;
    }

    private int getMetadataKeyIndex(Sheet devInfoSheet) {
        int colIndexFromSheet = HostEvalUtils.getColIndexFromSheet(devInfoSheet, META_ZH, META_EN);
        if (-1 == colIndexFromSheet) {
            colIndexFromSheet = HostEvalUtils.getColIndexFromSheet(devInfoSheet, META_ZH, ResourceUtil.getString((String)"infograb.excel.datafile.name.compatible", (Locale)Locale.ENGLISH));
        }
        return colIndexFromSheet;
    }

    private String getCellValue(Sheet devInfoSheet, int cellIndex, int lineNum) {
        try {
            return POIUtils.getStringCellValue((Cell)devInfoSheet.getRow(lineNum).getCell(cellIndex));
        }
        catch (Exception e) {
            LOGGER.error("set param error.", e);
            return "";
        }
    }

    private ItemInfo parseDbline(Sheet devInfoSheet, int lineNum, Map<String, String> overlengthInfo) {
        ItemInfo currentHostInfo = new ItemInfo();
        currentHostInfo.setDeviceType(ItDeviceType.Database);
        currentHostInfo.setIp(this.getValueFromCell(devInfoSheet, 0, lineNum, overlengthInfo));
        currentHostInfo.setOsName(this.getValueFromCell(devInfoSheet, 1, lineNum, overlengthInfo));
        currentHostInfo.setDatabaseVersion(this.getValueFromCell(devInfoSheet, 2, lineNum, overlengthInfo));
        currentHostInfo.setAsmHbeatiowait(this.getValueFromCell(devInfoSheet, 3, lineNum, overlengthInfo));
        currentHostInfo.setDatabaseType(this.getValueFromCell(devInfoSheet, 4, lineNum, overlengthInfo));
        currentHostInfo.setClusterName(this.getValueFromCell(devInfoSheet, 5, lineNum, overlengthInfo));
        currentHostInfo.setMetaFileName(this.getValueFromCell(devInfoSheet, this.getMetadataKeyIndex(devInfoSheet), lineNum, overlengthInfo));
        return currentHostInfo;
    }

    public String getValueFromCell(Sheet devInfoSheet, int colNum, int lineNum, Map<String, String> overlengthInfo) {
        String key;
        String[] values;
        String value = this.getCellValue(devInfoSheet, colNum, lineNum);
        if (overlengthInfo == null) {
            return value;
        }
        if (overlengthInfo != null && (value.contains(ERROR_CODE) && value.contains(ERROR_MESSAGE) || value.contains(ERROR_CODE_ELSE) && value.contains(ERROR_MESSAGE_ELSE)) && 3 == (values = value.split("\n")).length && overlengthInfo.containsKey(key = values[2])) {
            value = overlengthInfo.get(key);
        }
        return value;
    }

    private void parseOverlengthInfo(HSSFWorkbook workbook, Map<String, String> overlengthInfo) {
        HSSFSheet sheet = workbook.getSheet("overlengthInfo");
        if (null == sheet) {
            LOGGER.info("there is no overlength info sheet in the excel .");
            return;
        }
        int rowIndex = 0;
        while (rowIndex < sheet.getLastRowNum() + 1) {
            int colCount = sheet.getRow(rowIndex).getLastCellNum();
            if (2 > colCount) {
                LOGGER.info("this row may be not a valid row .");
                continue;
            }
            String key = POIUtils.getStringCellValue((Cell)sheet.getRow(rowIndex).getCell(0));
            StringBuilder value = new StringBuilder();
            int colIndex = 1;
            while (colIndex < colCount) {
                value.append(POIUtils.getStringCellValue((Cell)sheet.getRow(rowIndex).getCell(colIndex++)));
            }
            ++rowIndex;
            overlengthInfo.put(key, value.toString());
        }
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public void setPackagePath(String packagePath) {
        this.packagePath = packagePath;
    }
}

