/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.parser;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.upgradeevalu.adapter.EvaluationFlow;
import com.huawei.ism.tool.upgradeevalu.adapter.RuleItem;
import com.huawei.ism.tool.upgradeevalu.adapter.RuleModule;
import com.huawei.ism.tool.upgradeevalu.enums.ItEvaluationType;
import com.huawei.ism.tool.upgradeevalu.utils.CommonUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XmlItemParser {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(XmlItemParser.class);
    private static List<Map<String, String>> hbaBlackList = null;
    private static final String EVAL_GUIDE_PATH = "config/wizard/EvaluationFlowGuide.xml";
    private static final String BASECONNECTIVITY_CONFIG_PATH = "config/wizard/baseconnectivityBlacklist.xml";
    private static final String XML_MODULE = "module";
    private static final String XML_RECORD = "RECORD";
    private static final String XML_NAMEKEY = "namekey";
    private static final String XML_LOCATION = "location";
    private static final String XML_ITEM = "item";
    private static final String XML_SCRIPT = "script";
    private static final String XML_COMPAT = "usecompatdb";
    private static final String XML_USE = "use";
    private static final String XML_PROCESSBAR = "processbar";
    private static final String XML_HOST = "host";
    private static final String XML_SWITCH = "switch";
    private static final String XML_DATABASE = "database";
    private static final String XML_UPGRADEKEY = "upgradeKey";
    private static final String XML_KEY = "key";
    private static final String XML_GENERAL_DELIMITER = "\\|\\|";
    private static final String XML_REGION_DELIMITER = "\\-\\-";
    private static final String XML_OPERATING_SYSTEM = "Operating_System";
    private static final String XML_OPERATING_SYS_VER = "Operating_System_version";
    private static final String XML_HOST_BUS_ADAPTER = "Host_Bus_Adapter";
    private static final String XML_HBA_DRIVER_VER = "HBA_driver_version";
    private static final String XML_ALL = "all";
    private static XmlItemParser xmlInstance = null;

    private XmlItemParser() {
    }

    public static XmlItemParser getInstance() {
        if (null == xmlInstance) {
            xmlInstance = new XmlItemParser();
            hbaBlackList = XmlItemParser.createBaseConnectivityByXml();
        }
        return xmlInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document getDoc(String resource) {
        ClassLoader xmlItemParserClass = XmlItemParser.class.getClassLoader();
        if (null == xmlItemParserClass) {
            throw new NullPointerException("[getDoc] XmlItemParserClass is null.");
        }
        InputStream stream = xmlItemParserClass.getResourceAsStream(resource);
        if (null == stream) {
            return null;
        }
        Document doc = null;
        try {
            doc = XmlUtils.parseDocument((InputStream)stream);
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)stream);
        }
        return doc;
    }

    public Map<ItDeviceType, EvaluationFlow> createEvaluationFlowByXml() {
        Document doc = XmlItemParser.getDoc(EVAL_GUIDE_PATH);
        if (null == doc) {
            return null;
        }
        Element root = doc.getDocumentElement();
        HashMap<ItDeviceType, EvaluationFlow> currUniqueFlowMap = new HashMap<ItDeviceType, EvaluationFlow>();
        for (Element moduleElem : XmlUtils.getChildren((Element)root, (String)XML_MODULE)) {
            String moduleNameKey = XmlUtils.getAttribute((Element)moduleElem, (String)XML_NAMEKEY);
            String location = XmlUtils.getAttribute((Element)moduleElem, (String)XML_LOCATION);
            currUniqueFlowMap.put(this.str2ItDeviceType(moduleNameKey), this.hanldeEvaluationFlow(location));
        }
        return currUniqueFlowMap;
    }

    public Map<String, String> checkHbaInBlackList(String hbaName, String hbaDriver, String firmVersion, String systemName) {
        LOGGER.info(String.format(Locale.ENGLISH, "Start to check Hba in BlackList, hbaName:%s hbaDriver:%s firmVersion:%s systemName:", hbaName, hbaDriver, firmVersion, systemName));
        if (StringUtils.isBlank(hbaName) || StringUtils.isBlank(hbaDriver)) {
            LOGGER.error("check Hba in BlackList error, hbaName or hbaDriver is null");
            return null;
        }
        for (Map<String, String> record : hbaBlackList) {
            String sysName = record.get(XML_OPERATING_SYSTEM);
            String[] blackXmlSysVer = record.get(XML_OPERATING_SYS_VER).split(XML_GENERAL_DELIMITER);
            String[] blackHbaModelList = record.get(XML_HOST_BUS_ADAPTER).split(XML_GENERAL_DELIMITER);
            boolean flag = StringUtils.isBlank(systemName) || systemName.contains(sysName) && this.checkBlackList(systemName, blackXmlSysVer);
            if (!flag || !this.checkBlackList(hbaName, blackHbaModelList)) continue;
            LOGGER.info("Start matching version");
            String[] versionRange = record.get(XML_HBA_DRIVER_VER).split(XML_REGION_DELIMITER);
            if (!CommonUtils.compareVersionInRange(hbaDriver, versionRange)) continue;
            LOGGER.info("Successful match to blacklist data.");
            return record;
        }
        return null;
    }

    private boolean checkBlackList(String str, String[] list) {
        if (list.length == 1 && XML_ALL.equals(list[0])) {
            return true;
        }
        return CommonUtils.checkStrContainList(str, list);
    }

    public static List<Map<String, String>> createBaseConnectivityByXml() {
        Document doc = XmlItemParser.getDoc(BASECONNECTIVITY_CONFIG_PATH);
        if (null == doc) {
            LOGGER.error("get XML error, doc is null:config/wizard/baseconnectivityBlacklist.xml");
            return null;
        }
        NodeList recordList = doc.getElementsByTagName(XML_RECORD);
        ArrayList<Map<String, String>> xmlList = new ArrayList<Map<String, String>>();
        for (int i = 0; i < recordList.getLength(); ++i) {
            Node attrs = recordList.item(i);
            XmlItemParser.getElementAttr(xmlList, attrs);
        }
        LOGGER.info(String.format(Locale.ENGLISH, "get XML success,size is :%s", xmlList.size()));
        return xmlList;
    }

    private static void getElementAttr(List<Map<String, String>> xmlList, Node attrs) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NodeList childNodes = attrs.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (item == null || item.getNodeType() != 1 || item.getFirstChild() == null) continue;
            hashMap.put(item.getNodeName(), item.getFirstChild().getNodeValue());
        }
        xmlList.add(hashMap);
    }

    private ItDeviceType str2ItDeviceType(String itDeviceType) {
        if (itDeviceType.equalsIgnoreCase(XML_HOST)) {
            return ItDeviceType.Host;
        }
        if (itDeviceType.equalsIgnoreCase(XML_SWITCH)) {
            return ItDeviceType.Switch;
        }
        if (itDeviceType.equalsIgnoreCase(XML_DATABASE)) {
            return ItDeviceType.Database;
        }
        return null;
    }

    private EvaluationFlow hanldeEvaluationFlow(String location) {
        Document doc = XmlItemParser.getDoc(location);
        if (null == doc) {
            return null;
        }
        Element root = doc.getDocumentElement();
        EvaluationFlow currEvaluationFlow = new EvaluationFlow();
        for (Element moduleElem : XmlUtils.getChildren((Element)root, (String)XML_MODULE)) {
            String moduleNameKey = XmlUtils.getAttribute((Element)moduleElem, (String)XML_NAMEKEY);
            RuleModule currModule = new RuleModule(moduleNameKey);
            currModule.setItemList(this.getItemsByElem(moduleElem));
            currModule.setTitle(moduleNameKey);
            currEvaluationFlow.setSingleModuleList(currModule);
        }
        return currEvaluationFlow;
    }

    private List<RuleItem> getItemsByElem(Element moduleElem) {
        if (moduleElem == null) {
            return null;
        }
        LinkedList<RuleItem> currProcessList = new LinkedList<RuleItem>();
        for (Element item : XmlUtils.getChildren((Element)moduleElem, (String)XML_ITEM)) {
            Boolean enabled = Boolean.valueOf(XmlUtils.getAttribute((Element)item, (String)XML_USE));
            String scriptURL = "";
            Boolean isCompat = Boolean.valueOf(XmlUtils.getAttribute((Element)item, (String)XML_COMPAT));
            String nameKey = XmlUtils.getAttribute((Element)item, (String)XML_NAMEKEY);
            String processBar = XmlUtils.getAttribute((Element)item, (String)XML_PROCESSBAR);
            ArrayList<String> upgradeKeyList = new ArrayList<String>();
            for (Element eleKey : XmlUtils.getChildren((Element)item, (String)XML_UPGRADEKEY)) {
                String str = String.valueOf(XmlUtils.getAttribute((Element)eleKey, (String)XML_KEY));
                upgradeKeyList.add(str);
            }
            RuleItem currItem = new RuleItem(nameKey, nameKey);
            currItem.setEvalService(XmlUtils.getAttribute((Element)item, (String)"serviceInter"));
            if (!isCompat.booleanValue()) {
                scriptURL = XmlUtils.getAttribute((Element)item, (String)XML_SCRIPT);
                currItem.setScriptPath(scriptURL);
                currItem.setEvaluationType(ItEvaluationType.UPGRADE_EVAL);
            } else {
                currItem.setEvaluationType(ItEvaluationType.COMPATIBILITY_EVAL);
            }
            String upgradeKey = "";
            if (!upgradeKeyList.isEmpty()) {
                upgradeKey = (String)upgradeKeyList.get(0);
            }
            currItem.setUpgradeKey(upgradeKey);
            currItem.setDefaultChoose(enabled);
            currItem.setProcessBar(Integer.parseInt(processBar));
            if (!currItem.isDefaultChoose()) continue;
            currProcessList.add(currItem);
        }
        return currProcessList;
    }
}

