/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.report;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.HtmlEnums;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.model.EvalItemResult;
import com.huawei.ism.tool.upgradeevalu.report.CompatibilityResourceUtils;
import com.huawei.ism.tool.upgradeevalu.report.DetailEntry;
import com.huawei.ism.tool.upgradeevalu.report.TemplateFactory;
import com.huawei.ism.tool.upgradeevalu.util.CaseLinkUtils;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import utils.FilesUtil;

public class CompatibilityDetailBuilder {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(CompatibilityDetailBuilder.class);
    private static final String RESULT_HEADER = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"" + HtmlEnums.HTML_TRANSITIONAL.getResourceValue() + "\"><html><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/><link  href=\"css/details_table.css\" type=\"text/css\" rel=\"stylesheet\" /><head><title>Evaluation Result</title><script type=\"text/javascript\" language=\"javascript\" src=\"../../js/compatibilitydetail.js\"></script><script type=\"text/javascript\" language=\"javascript\" src=\"../../js/jquery.min.js\"></script></head><body onload=\"init()\">";
    private static final String RESULT_FOOTER = "</body></html>";
    private static final String TABLE_START = "<table>";
    private static final String TABLE_END = "</table>";
    private static final String TASKS_PATH = "data" + File.separator + "tasks";
    private static final String CASE_PATH = ".." + File.separator + ".." + File.separator + "case" + File.separator;
    private static final String RESOURCE_KEY = "evalu.ui.resultInfoDialog.dev.table.assess.";
    private static final String COMPATIBILITY_HTML_TEMPLATE = "compatibility/detailView.html";
    private static final int STATUS_OK = 0;
    private static final int STATUS_NOTOK = 1;
    private static final int STATUS_CANNOTEVAL = 2;
    private static CompatibilityDetailBuilder instance = new CompatibilityDetailBuilder();
    private EvaluContext evaluContext = EvaluContext.getInstance();

    public static CompatibilityDetailBuilder getInstance() {
        return instance;
    }

    public void buildDetailFile(EvalItemResult deviceResult, String deviceDesc, File repDir, String taskKey) {
        File tmpPath = new File(FilesUtil.getCanonicalPath((File)repDir) + File.separator + TASKS_PATH + File.separator + taskKey.replaceAll(":", "_"));
        File sourceFileName = new File(tmpPath, deviceDesc.replaceAll(":", "_") + ".html");
        FileUtils.createDir((String)sourceFileName.getParent());
        String inspectResult = this.buildResultFile(deviceResult, deviceDesc, sourceFileName.getName(), repDir);
        StreamUtils.writeInfo2File((byte[])inspectResult.getBytes(Charset.forName("UTF-8")), (String)FilesUtil.getCanonicalPath((File)sourceFileName));
        this.copyCssFile(tmpPath);
    }

    private void copyCssFile(File destPath) {
        String srcFile = this.evaluContext.getHome() + File.separator + "packages/upgradeEvaluation/css";
        File destFile = new File(FilesUtil.getCanonicalPath((File)destPath) + File.separator + "css");
        if (!destFile.exists()) {
            LOGGER.info("start copy css file while build device detail html.");
            FileUtils.createDir((File)destFile);
            FileUtils.copyDir((String)srcFile, (String)FilesUtil.getCanonicalPath((File)destFile));
        }
    }

    private List<DetailEntry> getDetails(EvalItemResult deviceResult, File repDir) {
        LOGGER.info("start build data for device.");
        ArrayList<DetailEntry> details = new ArrayList<DetailEntry>();
        List<EvalFeatureResult> allFeatureResults = deviceResult.getFeatureResultList();
        for (EvalFeatureResult feature : allFeatureResults) {
            details.add(this.getDetailList(feature, deviceResult, repDir));
        }
        return details;
    }

    private DetailEntry getDetailList(EvalFeatureResult feature, EvalItemResult deviceResult, File repDir) {
        DetailEntry detailEntry = new DetailEntry();
        ItemResultEnum checkResult = feature.getItemResult();
        detailEntry.setPass(ItemResultEnum.PASS.equals((Object)checkResult));
        String featureID = ResourceUtil.getString((String)(RESOURCE_KEY + feature.getFeatureId()));
        detailEntry.setName(featureID);
        String originalInfo = feature.getOriginalInfo();
        detailEntry.setSourceInfo(this.getHtmlString(originalInfo));
        String checkMethod = feature.getCheckMethod();
        detailEntry.setCheckMethod(this.getHtmlString(checkMethod));
        String checkCriterion = feature.getCheckCriterion();
        detailEntry.setCriterion(this.getHtmlString(checkCriterion));
        detailEntry.setRelateId(feature.getFeatureId());
        String suggestion = "";
        String failDesc = feature.getFailDesc();
        String passTxt = "";
        int status = 1;
        switch (feature.getItemResult()) {
            case PASS: {
                status = 0;
                passTxt = CompatibilityResourceUtils.getUIString("report.detail.view.result." + (Object)((Object)checkResult));
                break;
            }
            case NOTPASS: {
                status = 1;
                suggestion = this.addLink(feature.getSuggest(), feature);
                passTxt = CompatibilityResourceUtils.getUIString("report.detail.view.result." + (Object)((Object)checkResult)) + "<br/><br/>" + this.getHtmlString(failDesc);
                break;
            }
            case CANNOTEVAL: {
                status = 2;
                suggestion = this.addLink(feature.getSuggest(), feature);
                passTxt = CompatibilityResourceUtils.getUIString("report.detail.view.result." + (Object)((Object)checkResult)) + "<br/><br/>" + this.getHtmlString(failDesc);
                break;
            }
        }
        detailEntry.setStatus(status);
        detailEntry.setSuggestion(suggestion);
        detailEntry.setPasstxt(passTxt);
        return detailEntry;
    }

    private String addLink(String suggest, EvalFeatureResult feature) {
        return this.getHtmlString(CaseLinkUtils.getSuggest(feature, suggest, CASE_PATH));
    }

    private String buildResultFile(EvalItemResult deviceResult, String deviceDesc, String sourceFileName, File repDir) {
        StringBuffer resultBuilder = new StringBuffer();
        resultBuilder.append(RESULT_HEADER);
        resultBuilder.append("<div class='title'><div class='txt' align='center'><h1 align='left' style='font-size:35px'>" + CompatibilityResourceUtils.getUIStringWithParam("report.detail.title", deviceDesc) + "</h1></div></div><br/><br/>").append(System.lineSeparator());
        resultBuilder.append("<div align=left><select onchange='isSelected(this.value);' id='select'><option>" + CompatibilityResourceUtils.getUIStringWithParam("report.detail.filter", new Object[0]) + "</option><option value='risk'>" + CompatibilityResourceUtils.getUIStringWithParam("report.detail.show.other.passed", new Object[0]) + "</option><option value='pass'>" + CompatibilityResourceUtils.getUIStringWithParam("report.detail.showpassed", new Object[0]) + "</option><option value='all'>" + CompatibilityResourceUtils.getUIStringWithParam("report.detail.allitem", new Object[0]) + "</option></select></div><br /><br />");
        List<DetailEntry> details = this.getDetails(deviceResult, repDir);
        HashMap<String, List<DetailEntry>> data = new HashMap<String, List<DetailEntry>>();
        data.put("allitems", details);
        String detail = TemplateFactory.processorFtl(COMPATIBILITY_HTML_TEMPLATE, data);
        if (null != deviceResult.getFailedReason()) {
            detail = detail + "<font color='#FF8833'>" + deviceResult.getFailedReason() + "</font>";
        }
        resultBuilder.append(detail);
        return resultBuilder.append(RESULT_FOOTER).toString();
    }

    private String getHtmlString(String desc) {
        if (StringUtils.isNULLStr((String)desc)) {
            return "";
        }
        String value = desc.replaceAll("\r\n|\n|\r", "<br/>");
        return value;
    }
}

