/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.report;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.SystemEnvUtil;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.InfoGrabDirPropertiesUtil;
import com.huawei.ism.tool.upgradeevalu.entity.HostEvalNode;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.iterface.IEvalObserver;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.model.EvalItemResult;
import com.huawei.ism.tool.upgradeevalu.model.EvalTaskResult;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.report.CompatibilityDetailBuilder;
import com.huawei.ism.tool.upgradeevalu.report.CompatibilityEvaluCollectEntity;
import com.huawei.ism.tool.upgradeevalu.report.CompatibilityResourceUtils;
import com.huawei.ism.tool.upgradeevalu.report.EserviceExcelResultBuilder;
import com.huawei.ism.tool.upgradeevalu.report.TemplateFactory;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalContext;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalUtils;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import utils.FilesUtil;

public class CompatibilityReportBuilder {
    private static final String STORAGES_INFO_FILE = "StoragesInfo.txt";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(CompatibilityReportBuilder.class);
    private static final String REPORT_DATA = "packages/upgradeEvaluation/template/data";
    private static final String CASE_PATH = "help";
    private static final String DEVICE_TYPE_RESOURCE_KEY = "eval.host.evaluation.reporter.device.type.";
    private static final String RESOURCE_KEY = "evalu.ui.resultInfoDialog.dev.table.assess.";
    private static final String HUAWEI_LOGO_IMAGE = "huaweilogo.jpg";
    private static final String DEVICE_TREE_TEMPLATE = "compatibility/devsTree.html";
    private static final String EVAL_COLLECT_TMPLATE = "compatibility/evaluCollect.html";
    private static final String ALL_TASK_SUMMARY_TMPLATE = "compatibility/allTasksSummary.html";
    private static final String INDEX_TEMPLATE = "compatibility/index.html";
    private static final String COVER_TEMPLATE = "compatibility/cover.html";
    private static final String INDEX_OUT = "index.html";
    private static final String DEVS_TREE_NAME = "devsTree.html";
    private static final int FEATURE_RESULT_CODE_PASS = 0;
    private static final int FEATURE_RESULT_CODE_NOTPASS = 1;
    private static final int FEATURE_RESULT_CODE_CANNOTEVAL = 2;
    private static final int PREG56 = 56;
    private static final int PREG65 = 65;
    private static final int PREG70 = 70;
    private static final int PREG75 = 75;
    private static final int PREG80 = 80;
    private static final int PREG95 = 95;
    private EvaluContext evaluContext = EvaluContext.getInstance();

    public void buildReport(Map<String, EvalTaskResult> allTaskOld, File resultDir, IEvalObserver progressUpdator) {
        progressUpdator.notifyReportGenStart(10);
        resultDir = FilePathUtils.checkFile((File)new File(resultDir + File.separator + "temp"));
        if (allTaskOld.isEmpty()) {
            LOGGER.info("Report export for upgrade evalu failed. No devs map.");
            return;
        }
        Map<String, EvalTaskResult> allTask = new HashMap<String, EvalTaskResult>();
        this.changeEvalKey(allTaskOld, allTask);
        progressUpdator.notifyReportGenStart(15);
        allTask = this.sortMapByKey(allTask);
        Map<String, List<String>> devsMapStr = this.convert4Tree(allTask, resultDir);
        File devTreeFile = FileUtils.getFile(FilePathUtils.getCanonicalPath((File)resultDir) + File.separator + "data" + File.separator + DEVS_TREE_NAME);
        progressUpdator.notifyReportGenStart(32);
        if (devTreeFile == null) {
            LOGGER.error("Getting tree file is null");
            return;
        }
        this.buildLeftDeviceTree(devsMapStr, devTreeFile);
        progressUpdator.notifyReportGenStart(46);
        this.buildAllTasksSummaryHtml(allTask, resultDir);
        progressUpdator.notifyReportGenStart(56);
        File coverFile = FilePathUtils.checkFile((File)new File(FilePathUtils.getCanonicalPath((File)resultDir) + File.separator + "data" + File.separator + "head" + File.separator + "cover.html"));
        this.buildCover(coverFile);
        progressUpdator.notifyReportGenStart(65);
        this.buildIndexPage(resultDir);
        progressUpdator.notifyReportGenStart(70);
        this.copyReportFile(resultDir);
        progressUpdator.notifyReportGenStart(75);
        this.writeStorageinfo(resultDir, allTask);
        progressUpdator.notifyReportGenStart(80);
        try {
            EserviceExcelResultBuilder eserviceExcelResultBuilder = EserviceExcelResultBuilder.getInstance();
            eserviceExcelResultBuilder.createTitle();
            eserviceExcelResultBuilder.buildSummary(allTask);
            eserviceExcelResultBuilder.writeExcel(FilesUtil.getCanonicalPath((File)resultDir));
            eserviceExcelResultBuilder.writeToolInfo(FilesUtil.getCanonicalPath((File)resultDir));
        }
        catch (Exception exp) {
            LOGGER.error("exception occurred while generating eService excel: " + exp.getMessage());
        }
        this.compressReport(FilesUtil.getCanonicalPath((File)resultDir));
        progressUpdator.notifyReportGenStart(95);
        LOGGER.info("Report export for compatibility evalu success!");
    }

    private void writeStorageinfo(File resultDir, Map<String, EvalTaskResult> allTask) {
        try {
            List storageInfos = (List)HostEvalContext.getStorageMap().get("storageInfo");
            Path storPath = Paths.get(FilesUtil.getCanonicalPath((File)resultDir), "StorageInfo");
            File path = new File(storPath.toString());
            if (!path.exists()) {
                LOGGER.info("new file result:{}", (Object)path.mkdir());
            }
            Files.write(Paths.get(storPath.toString(), STORAGES_INFO_FILE), JSONObject.toJSONBytes((Object)storageInfos, new SerializerFeature[0]), new OpenOption[0]);
            Path hostPath = Paths.get(FilesUtil.getCanonicalPath((File)resultDir), "HostInfo");
            File hostFile = new File(hostPath.toString());
            if (!hostFile.exists()) {
                LOGGER.info("new file result:{}", (Object)hostFile.mkdir());
            }
            this.copyHostEvalFile(allTask, hostPath);
            File tmpFile = resultDir.getParentFile();
            File exchangeData = new File(SystemEnvUtil.getDefaultUserDir() + File.separator + "temp" + File.separator + "exchange");
            com.huawei.ism.tool.base.utils.FileUtils.copyDir((String)FilesUtil.getCanonicalPath((File)exchangeData), (String)storPath.toString());
            File[] fileList = tmpFile.listFiles();
            if (fileList == null) {
                LOGGER.info("no file list!");
            } else {
                for (File file : fileList) {
                    if (!file.isDirectory() || !file.getName().startsWith("EvaluResult_")) continue;
                    LOGGER.info("delete the file is\uff1a{}", (Object)file);
                    com.huawei.ism.tool.base.utils.FileUtils.deleteFile((File)file);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("write storageinfo error", e);
        }
    }

    public void copyHostEvalFile(Map<String, EvalTaskResult> allTask, Path hostPath) {
        if (!SceneUtils.isScene()) {
            for (Map.Entry<String, EvalTaskResult> entry : allTask.entrySet()) {
                if (StringUtils.isNULLStr((String)entry.getValue().getTaskFolderPath())) continue;
                com.huawei.ism.tool.base.utils.FileUtils.copyDir((String)entry.getValue().getTaskFolderPath(), (String)hostPath.toString());
            }
        } else {
            com.huawei.ism.tool.base.utils.FileUtils.copyDir((String)FilePathUtils.checkFile((String)InfoGrabDirPropertiesUtil.getProperty()), (String)hostPath.toString());
        }
    }

    public void changeEvalKey(Map<String, EvalTaskResult> allTaskOld, Map<String, EvalTaskResult> allTask) {
        for (Map.Entry<String, EvalTaskResult> taskEntry : allTaskOld.entrySet()) {
            String taskKey = taskEntry.getKey();
            EvalTaskResult taskResult = taskEntry.getValue();
            HostEvalNode hostEvalTask = taskResult.getHostEvalTask();
            hostEvalTask.calcHostNumInfo();
            taskKey = taskKey + '_' + hostEvalTask.getStorageIp();
            allTask.put(taskKey, taskResult);
        }
    }

    private void buildCover(File coverFile) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("logo", HUAWEI_LOGO_IMAGE);
        data.put("copyright", CompatibilityResourceUtils.getUIString("report.cover.system.copyright.huawei"));
        data.put("company", CompatibilityResourceUtils.getUIString("report.cover.company.huawei"));
        data.put("toolversion", UserOpDataSaveUtil.getViewVersion());
        data.put("date", UserOpDataSaveUtil.getToolIniProp((String)"date"));
        data.put("toolkitversion", UserOpDataSaveUtil.getToolBoxIniProp((String)"app.version"));
        data.put("genneratedate", StringUtils.formatDate((Object)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        this.getOfflineimportdate(data);
        TemplateFactory.processorFtl(COVER_TEMPLATE, data, FilesUtil.getCanonicalPath((File)coverFile));
    }

    private void getOfflineimportdate(Map<String, Object> data) {
        List<String> offImportDates = HostEvalContext.getOffImportDates();
        if ((offImportDates = HostEvalUtils.removeDuplicateWithOrder(offImportDates)).isEmpty()) {
            data.put("offlineimportdate", "");
        } else if (offImportDates.size() == 1 && "--".equals(offImportDates.get(0))) {
            data.put("offlineimportdate", "--");
        } else {
            try {
                if ("--".equals(offImportDates.get(0))) {
                    offImportDates.remove(0);
                }
                Date date = new SimpleDateFormat("yyyyMMdd").parse(offImportDates.get(0));
                data.put("offlineimportdate", StringUtils.formatDate((Object)date, (String)"yyyy-MM-dd"));
            }
            catch (ParseException e) {
                LOGGER.error("time format conversion exception", e);
            }
        }
    }

    private void buildLeftDeviceTree(Map<String, List<String>> tasksMap, File devTreeFile) {
        HashMap<String, Map<String, List<String>>> data = new HashMap<String, Map<String, List<String>>>();
        data.put("tasksMap", tasksMap);
        TemplateFactory.processorFtl(DEVICE_TREE_TEMPLATE, data, FilesUtil.getCanonicalPath((File)devTreeFile));
    }

    private void buildAllTasksSummaryHtml(Map<String, EvalTaskResult> allTask, File resultDir) {
        File tasksSummary = FilePathUtils.checkFile((File)new File(FilePathUtils.getCanonicalPath((File)resultDir) + File.separator + "data" + File.separator + "head" + File.separator + "tasksSummary.html"));
        HashMap<String, Object> data = new HashMap<String, Object>();
        boolean hasHostNotAdded = false;
        boolean hasManuallyAddedHost = false;
        for (Map.Entry<String, EvalTaskResult> entry : allTask.entrySet()) {
            HostEvalNode evaluNode = entry.getValue().getHostEvalTask();
            int manuallyAddedHosts = evaluNode.getManulAssociatedHosts().size();
            int addedInitrs = evaluNode.getAddHostNumberForEvalNode();
            int notAddedInits = evaluNode.getNotAddedInitNumbers();
            hasHostNotAdded = hasHostNotAdded || notAddedInits != 0;
            hasManuallyAddedHost = hasManuallyAddedHost || manuallyAddedHosts > 0;
            int allInitrs = evaluNode.getMappedStorageInitiatorNum();
            evaluNode.setHostNumInfo("" + addedInitrs + "/" + allInitrs);
        }
        data.put("hasHostNotAdded", hasHostNotAdded);
        data.put("hasManuallyAddedHost", hasManuallyAddedHost);
        data.put("allTask", allTask);
        TemplateFactory.processorFtl(ALL_TASK_SUMMARY_TMPLATE, data, FilesUtil.getCanonicalPath((File)tasksSummary));
    }

    private void compressReport(String htmlDirPath) {
        StringBuffer zipName = new StringBuffer();
        zipName.append(File.separator);
        zipName.append("EvaluResult_Host_");
        zipName.append(new SimpleDateFormat("yyyyMMddHHmmss").format(Calendar.getInstance().getTime()));
        zipName.append(".zip");
        String reportDirFile = FilePathUtils.checkFile((String)(HostEvalContext.getInstance().getReportDir() + zipName.toString()));
        this.copyOffLineImportFiles(htmlDirPath);
        ZipUtils.compressFile((String)reportDirFile, (String)htmlDirPath);
        com.huawei.ism.tool.base.utils.FileUtils.setFilePermissions((String)reportDirFile);
        String tempDir = FilePathUtils.checkFile((String)(System.getProperty("java.io.tmpdir") + "CompatibilityEvaluationReport"));
        com.huawei.ism.tool.base.utils.FileUtils.deleteFile((File)new File(tempDir));
        com.huawei.ism.tool.base.utils.FileUtils.copyDir((String)htmlDirPath, (String)tempDir);
        com.huawei.ism.tool.base.utils.FileUtils.deleteFile((File)new File(htmlDirPath));
        HostEvalContext.getInstance().setCurrentEvalReport(tempDir);
    }

    private void copyOffLineImportFiles(String tempDir) {
        List<File> allSuccessOffLineFiles = HostEvalContext.getAllSuccessOffLineFiles();
        if (!new File(tempDir).isDirectory()) {
            return;
        }
        for (File file : allSuccessOffLineFiles) {
            String targetFilePath = tempDir + File.separator + "HostInfo" + File.separator + file.getName();
            File targetFile = new File(targetFilePath);
            StreamUtils.copyFile((File)file, (File)targetFile);
        }
    }

    private void copyReportFile(File reportDir) {
        String srcDir = this.evaluContext.getHome();
        String dataPath = srcDir + File.separator + REPORT_DATA;
        File destDir = new File(FilesUtil.getCanonicalPath((File)reportDir) + File.separator + "data");
        com.huawei.ism.tool.base.utils.FileUtils.copyDir((String)dataPath, (String)FilesUtil.getCanonicalPath((File)destDir));
        String srcCase = srcDir + File.separator + CASE_PATH;
        File destCase = new File(FilesUtil.getCanonicalPath((File)destDir) + File.separator + "case");
        com.huawei.ism.tool.base.utils.FileUtils.copyDir((String)srcCase, (String)FilesUtil.getCanonicalPath((File)destCase));
    }

    private Map<String, List<String>> convert4Tree(Map<String, EvalTaskResult> allTask, File resultDir) {
        TreeMap<String, List<String>> allTasksTree = new TreeMap<String, List<String>>();
        Set<Map.Entry<String, EvalTaskResult>> allTasksEntry = allTask.entrySet();
        for (Map.Entry<String, EvalTaskResult> taskEntry : allTasksEntry) {
            String taskKey = taskEntry.getKey();
            EvalTaskResult taskResult = taskEntry.getValue();
            LOGGER.info("start to create html report with the task :<{}>.", (Object)taskKey);
            TreeSet<String> ipsTemp = new TreeSet<String>();
            HashMap<String, String> repeatKeys = new HashMap<String, String>();
            HashMap<String, EvalItemResult> allDeviceResults = new HashMap<String, EvalItemResult>();
            ArrayList<String> allDevicesTree = new ArrayList<String>();
            ArrayList<String> allHosts = new ArrayList<String>();
            ArrayList<String> allSwitchs = new ArrayList<String>();
            ArrayList<String> allDatabases = new ArrayList<String>();
            allTasksTree.put(taskKey, allDevicesTree);
            List<EvalItemResult> oneTaskDevices = taskResult.getEvalItemList();
            int passCount = 0;
            float totalCount = oneTaskDevices.size();
            passCount = this.forEachOneTaskDevices(resultDir, taskKey, ipsTemp, repeatKeys, allDeviceResults, allHosts, allSwitchs, allDatabases, oneTaskDevices, passCount);
            int passRate = Math.round((float)passCount / totalCount * 100.0f);
            taskResult.setPassRatio(passRate);
            this.sortIpList(allHosts);
            allDevicesTree.addAll(allHosts);
            this.sortIpList(allSwitchs);
            allDevicesTree.addAll(allSwitchs);
            this.sortIpList(allDatabases);
            allDevicesTree.addAll(allDatabases);
            this.buildTaskSummaryFile(taskKey, allDevicesTree, allDeviceResults, resultDir);
        }
        return allTasksTree;
    }

    private int forEachOneTaskDevices(File resultDir, String taskKey, Set<String> ipsTemp, Map<String, String> repeatKeys, Map<String, EvalItemResult> allDeviceResults, List<String> allHosts, List<String> allSwitchs, List<String> allDatabases, List<EvalItemResult> oneTaskDevices, int passCount) {
        for (EvalItemResult deviceResult : oneTaskDevices) {
            ItemInfo deviceInfo = deviceResult.getItemInfo();
            String ip = deviceInfo.getIp();
            ItDeviceType devType = deviceInfo.getDeviceType();
            String originalStr = null;
            if (ItemResultEnum.PASS.equals((Object)deviceResult.getItemResultEnum())) {
                ++passCount;
            }
            String devTypeStr = devType.getName();
            originalStr = ip + devTypeStr;
            if (ipsTemp.contains(originalStr)) {
                LOGGER.info("the repeated ip and device type is :<{}>.", (Object)originalStr);
                String count = repeatKeys.get(originalStr);
                count = null == count ? "0" : count;
                count = StringUtils.str2Int((String)count) + 1 + "";
                repeatKeys.put(originalStr, count);
                originalStr = originalStr + count;
            }
            this.addoriginalStrByDevType(allHosts, allSwitchs, allDatabases, devType, originalStr);
            allDeviceResults.put(originalStr, deviceResult);
            CompatibilityDetailBuilder.getInstance().buildDetailFile(deviceResult, originalStr, resultDir, taskKey);
        }
        return passCount;
    }

    private void addoriginalStrByDevType(List<String> allHosts, List<String> allSwitchs, List<String> allDatabases, ItDeviceType devType, String originalStr) {
        switch (devType) {
            case Host: {
                allHosts.add(originalStr);
                break;
            }
            case Switch: {
                allSwitchs.add(originalStr);
                break;
            }
            case Database: {
                allDatabases.add(originalStr);
                break;
            }
        }
    }

    private void buildTaskSummaryFile(String taskKey, List<String> allDevicesTree, Map<String, EvalItemResult> allDeviceResults, File resultDir) {
        LOGGER.info("start to build task <{}>summary file with :<{}>.", (Object)taskKey, (Object)allDevicesTree);
        ArrayList<CompatibilityEvaluCollectEntity> summarys = new ArrayList<CompatibilityEvaluCollectEntity>();
        CompatibilityEvaluCollectEntity tempEntity = null;
        int index = 1;
        for (String sortedKey : allDevicesTree) {
            EvalItemResult deviceResult = allDeviceResults.get(sortedKey);
            ItemInfo item = deviceResult.getItemInfo();
            String ip = item.getIp();
            String deviceType = CompatibilityResourceUtils.getUIString(DEVICE_TYPE_RESOURCE_KEY + item.getDeviceType().getName());
            List<EvalFeatureResult> allFeatureResults = deviceResult.getFeatureResultList();
            if (null != deviceResult.getFailedReason() && allFeatureResults.isEmpty()) {
                EvalFeatureResult errItem = new EvalFeatureResult();
                errItem.setItemResult(ItemResultEnum.CANNOTEVAL);
                allFeatureResults.add(errItem);
            }
            boolean isSameDevice = false;
            for (EvalFeatureResult featureResult : allFeatureResults) {
                CompatibilityEvaluCollectEntity summary = new CompatibilityEvaluCollectEntity();
                summary.setSingleDeviceName(sortedKey.replace(":", "_"));
                summary.setSerialNo(index++);
                summary.setDeviceType(deviceType);
                summary.setTaskIdentifier(taskKey);
                if (null == tempEntity || !summary.getDeviceType().equals(tempEntity.getDeviceType())) {
                    tempEntity = summary;
                    tempEntity.setDeviceTypeNode(true);
                }
                tempEntity.setDeviceTypeRowsCount(tempEntity.getDeviceTypeRowsCount() + 1);
                isSameDevice = this.checkSameDevice(ip, allFeatureResults, isSameDevice, summary);
                summary.setEvaluItem(ResourceUtil.getString((String)(RESOURCE_KEY + featureResult.getFeatureId())));
                ItemResultEnum result = featureResult.getItemResult();
                summary.setEvaluResult(ResourceUtil.getString((String)result.getDescKey()));
                int status = 0;
                status = this.getStatus(result, status);
                summary.setStatus(status);
                summarys.add(summary);
            }
        }
        this.generateSummaryHtmlFile(taskKey, resultDir, summarys);
    }

    private void generateSummaryHtmlFile(String taskKey, File resultDir, List<CompatibilityEvaluCollectEntity> summarys) {
        File summaryFolder = FileUtils.getFile(FilePathUtils.getCanonicalPath((File)resultDir) + File.separator + "data" + File.separator + "tasks");
        if (summaryFolder == null) {
            LOGGER.error("Getting summary folder is null");
            return;
        }
        com.huawei.ism.tool.base.utils.FileUtils.createDir((File)summaryFolder);
        String resultPath = FilesUtil.getCanonicalPath((File)summaryFolder) + File.separator + taskKey.replaceAll(":", "_") + ".html";
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("summarys", summarys);
        data.put("title", CompatibilityResourceUtils.getUIStringWithParam("report.summary.title", taskKey));
        TemplateFactory.processorFtl(EVAL_COLLECT_TMPLATE, data, resultPath);
    }

    private boolean checkSameDevice(String ip, List<EvalFeatureResult> allFeatureResults, boolean isSameDevice, CompatibilityEvaluCollectEntity summary) {
        if (!isSameDevice) {
            summary.setIp(ip);
            summary.setIpNode(true);
            summary.setIpRowsCount(allFeatureResults.size());
            isSameDevice = true;
        }
        return isSameDevice;
    }

    private int getStatus(ItemResultEnum result, int status) {
        switch (result) {
            case NOTPASS: {
                status = 1;
                break;
            }
            case CANNOTEVAL: {
                status = 2;
                break;
            }
            case PASS: {
                status = 0;
                break;
            }
        }
        return status;
    }

    private void buildIndexPage(File resultFolder) {
        File indexFile = new File(resultFolder, INDEX_OUT);
        TemplateFactory.processorFtl(INDEX_TEMPLATE, new HashMap(0), FilesUtil.getCanonicalPath((File)indexFile));
    }

    private void sortIpList(List<String> ips) {
        LOGGER.info("start to sort ip list :<{}>", (Object)ips);
        TreeSet<String> sortTemp = new TreeSet<String>();
        for (String ip : ips) {
            if (ip.contains(":")) {
                sortTemp.add(ip);
                continue;
            }
            String equilongIp = ip.replaceAll("(\\d+)", "00$1").replaceAll("0*(\\d{3})", "$1");
            sortTemp.add(equilongIp);
        }
        LOGGER.info("sorted ips :<{}>", (Object)sortTemp);
        ips.clear();
        for (String sortedIp : sortTemp) {
            if (sortedIp.contains(":")) {
                ips.add(sortedIp);
                continue;
            }
            ips.add(sortedIp.replaceAll("0*(\\d+)", "$1"));
        }
    }

    private Map<String, EvalTaskResult> sortMapByKey(Map<String, EvalTaskResult> map) {
        if (map == null || map.isEmpty()) {
            return new TreeMap<String, EvalTaskResult>();
        }
        TreeMap<String, EvalTaskResult> sortMap = new TreeMap<String, EvalTaskResult>(new Compara());
        sortMap.putAll(map);
        return sortMap;
    }

    public static class Compara
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(String key1, String key2) {
            return key1.compareTo(key2);
        }
    }
}

