/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.report;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class CompatibilityResourceUtils {
    private static final String RESOURCE_HTML = "config/upgradeevalu/compatibility/uiResource";
    private static final String RESOURCE_SERVICE = "config/upgradeevalu/compatibility/serviceResource";

    private CompatibilityResourceUtils() {
    }

    public static String getUIString(String key) {
        return CompatibilityResourceUtils.getString(key, RESOURCE_HTML);
    }

    public static String getUIStringWithParam(String key, Object ... param) {
        String msg = CompatibilityResourceUtils.getUIString(key);
        return StringUtils.fillValues((String)msg, (Object[])param);
    }

    public static String getServiceString(String key) {
        return CompatibilityResourceUtils.getString(key, RESOURCE_SERVICE);
    }

    public static String getServiceStringWithParam(String key, Object ... param) {
        String msg = CompatibilityResourceUtils.getUIString(key);
        return StringUtils.fillValues((String)msg, (Object[])param);
    }

    private static String getString(String key, String resourcePath) {
        ResourceBundle resource = ResourceBundle.getBundle(resourcePath, EvaluContext.getInstance().getLoc());
        String value = null;
        try {
            value = resource.getString(key);
        }
        catch (MissingResourceException e) {
            ToolLoggerFactory.getLogger(ResourceUtil.class).error("Can not find resource:" + key);
        }
        return null == value ? "--" : value;
    }
}

