/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.report;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.HtmlEnums;
import com.huawei.ism.tool.upgradeevalu.entity.CrossVersionType;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluItem;
import com.huawei.ism.tool.upgradeevalu.entity.ProductCfg;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluDevManager;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluService;
import com.huawei.ism.tool.upgradeevalu.evalu.ResultFlag;
import com.huawei.ism.tool.upgradeevalu.evalu.ResultItem;
import com.huawei.ism.tool.upgradeevalu.report.DetailEntry;
import com.huawei.ism.tool.upgradeevalu.report.TemplateFactory;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.ism.tool.upgradeevalu.util.HtmlResUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import utils.FilesUtil;

public class DetailBuilder {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DetailBuilder.class);
    private static final String ENTER = System.getProperty("line.separator");
    private static final String RESULT_HEADER = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"" + HtmlEnums.HTML_TRANSITIONAL.getResourceValue() + "\"><html><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/><link  href=\"css/details_table.css\" type=\"text/css\" rel=\"stylesheet\" /><head><title>Evaluation Result</title><script type=\"text/javascript\" language=\"javascript\" src=\"../../js/detail.js\"></script><script type=\"text/javascript\" language=\"javascript\" src=\"../../js/jquery.min.js\"></script></head><body onload=\"init()\">";
    private static final String RESULT_FOOTER = "</body></html>";
    private static final String TABLE_START = "<table>";
    private static final String TABLE_END = "</table>";
    private static final String DATA_PATH = "data/devs";
    private static final int STATUS_OK = 0;
    private static final int STATUS_NOTOK = 1;
    private static final int STATUS_NOCHECK = 2;
    private static final int STATUS_NONSUPPORT = 3;
    private static final int STATUS_WARN = 4;
    private String key = "";
    private int status = 1;
    private String errorInfo = "";
    private EvaluContext evaluContext = EvaluContext.getInstance();

    public void buildDetailFile(EvaluDevNode dev, File repDir) {
        File tmpPath = new File(FilesUtil.getCanonicalPath((File)repDir) + File.separator + DATA_PATH + File.separator + dev.getUuid());
        File resultFileName = new File(tmpPath, "index.html");
        File sourceFileName = new File(tmpPath, "detail.html");
        FileUtils.createDir((String)resultFileName.getParent());
        String inspectResult = this.buildResultFile(dev, sourceFileName.getName());
        StreamUtils.writeInfo2File((byte[])inspectResult.getBytes(Charset.forName("UTF-8")), (String)FilesUtil.getCanonicalPath((File)resultFileName));
        this.copyCssFile(tmpPath);
    }

    private void copyCssFile(File destPath) {
        String srcFile = this.evaluContext.getHome() + File.separator + "packages/upgradeEvaluation/css";
        File destFile = new File(FilesUtil.getCanonicalPath((File)destPath) + File.separator + "css");
        FileUtils.createDir((File)destFile);
        FileUtils.copyDir((String)srcFile, (String)FilesUtil.getCanonicalPath((File)destFile));
    }

    protected List<DetailEntry> getDetails(EvaluDevNode evaluDev) {
        ArrayList<DetailEntry> details = new ArrayList<DetailEntry>();
        ProductCfg innerProduct = evaluDev.getProduct(CrossVersionType.INNERVERSION);
        List<EvaluItem> innerItems = innerProduct.getInnerItems();
        ResourceBundle innerBundle = innerProduct.getResBundle();
        for (EvaluItem item : innerItems) {
            details.addAll(this.getDetailList(item, innerBundle));
        }
        if (evaluDev.isCrossVersion()) {
            ProductCfg crossProduct = evaluDev.getProduct(CrossVersionType.CROSSVERSION);
            List<EvaluItem> crossItems = crossProduct.getCrossVerCfg().getCrossItems();
            ResourceBundle crossBundle = crossProduct.getCrossVerCfg().getResBundle();
            for (EvaluItem item : crossItems) {
                details.addAll(this.getDetailList(item, crossBundle));
            }
        }
        return details;
    }

    private List<DetailEntry> getDetailList(EvaluItem item, ResourceBundle bundle) {
        ArrayList<DetailEntry> details = new ArrayList<DetailEntry>();
        DetailEntry detailEntry = new DetailEntry();
        ResultItem retItem = item.getRetItem();
        detailEntry.setPass(ResultFlag.PASS.equals((Object)retItem.getRetFlag()));
        String idPrefix = item.getId() + ".";
        if ("innerCheck".equals(item.getItemType())) {
            detailEntry.setName(this.getString(item, item.getId()));
        } else {
            detailEntry.setName(this.getString(item, idPrefix + "name"));
        }
        if (item.isShowCriterion()) {
            detailEntry.setCriterion(this.getString(item, idPrefix + "criterion"));
        }
        if (item.isShowMethod()) {
            detailEntry.setCheckMethod(this.getString(item, idPrefix + "method"));
        }
        String suggestion = this.getString(item, idPrefix + "suggestion");
        suggestion = this.addLink(bundle, idPrefix, suggestion, item);
        detailEntry.setSuggestion(suggestion);
        this.setKeyAndStatus(item, detailEntry, retItem);
        details.add(detailEntry);
        return details;
    }

    private void setKeyAndStatus(EvaluItem item, DetailEntry detailEntry, ResultItem retItem) {
        this.key = "notPassed";
        this.status = 1;
        detailEntry.setRelateId(item.getId());
        ResultFlag flag = retItem.getRetFlag();
        String error = retItem.getErrorInfo();
        String prix = "<xmp>";
        if (error.startsWith("\n")) {
            prix = "<br/><xmp>";
        }
        this.errorInfo = error = prix + error + ENTER + "</xmp>";
        switch (flag) {
            case PASS: {
                this.key = "passed";
                this.status = 0;
                this.errorInfo = "";
                break;
            }
            case NOTPASS: {
                this.key = "notPassed";
                this.status = 1;
                break;
            }
            case NOCHECK: {
                this.key = "nocheck";
                this.status = 2;
                break;
            }
            case NOSUPPORT: {
                this.key = "nosupport";
                this.status = 3;
                break;
            }
            case WARN: {
                this.key = "warning";
                this.status = 4;
                break;
            }
        }
        this.setSourceInfo(item, detailEntry, retItem);
        detailEntry.setPasstxt(HtmlResUtils.getString("report.detail.view.result." + this.key) + "<br/>" + this.errorInfo);
        detailEntry.setStatus(this.status);
    }

    private void setSourceInfo(EvaluItem item, DetailEntry detailEntry, ResultItem retItem) {
        if (item.isShowOrigin()) {
            String info = null;
            info = retItem.getSourceInfo() + ENTER;
            info = "<xmp>" + info + "</xmp>";
            detailEntry.setSourceInfo(info);
            String timeOutMsg = HtmlResUtils.getStringWithParam("report.evalu.undetected.timeout.msg", new Object[0]);
            if (retItem.getSourceInfo().equals(timeOutMsg)) {
                this.key = "nocheck";
                this.status = 3;
                detailEntry.setSourceInfo(timeOutMsg);
            }
        }
    }

    private String addLink(ResourceBundle bundle, String idPrefix, String suggestion, EvaluItem item) {
        EvaluDevNode evaluDev = EvaluDevManager.getInstance().getEvaluDevById(item.getDevID());
        if (evaluDev == null) {
            LOGGER.warn("dev not found, devID = ", (Object)item.getDevID());
            return suggestion;
        }
        ProductCfg currProd = evaluDev.getProduct(item.getCrossVersionType());
        String sugge = "";
        try {
            String helpHref = this.getString(item, idPrefix + "helphref");
            sugge = EvaluService.getInstance().replaceLink(suggestion, helpHref, ".." + File.separator + ".." + File.separator + currProd.getProdcutName());
        }
        catch (Exception e) {
            sugge = suggestion;
            LOGGER.warn("getter helpHref error", e);
        }
        return sugge;
    }

    public String buildResultFile(EvaluDevNode evaluDev, String sourceFileName) {
        StringBuffer resultBuilder = new StringBuffer();
        resultBuilder.append(RESULT_HEADER);
        resultBuilder.append("<div class='title'><div class='txt' align='center'><h1 align='left' style='font-size:35px'>" + HtmlResUtils.getStringWithParam("report.detail.title", evaluDev.getIp() + "_" + evaluDev.getDeviceSerialNumber()) + "</h1></div></div><br/><br/>").append(System.lineSeparator());
        resultBuilder.append("<div align=left><select onchange='isSelected(this.value);' id='select'><option>" + HtmlResUtils.getStringWithParam("report.detail.filter", new Object[0]) + "</option><option value='none'>" + HtmlResUtils.getStringWithParam("report.detail.showrisk", new Object[0]) + "</option><option value=''>" + HtmlResUtils.getStringWithParam("report.detail.allitem", new Object[0]) + "</option></select></div><br /><br />");
        List<DetailEntry> details = this.getDetails(evaluDev);
        HashMap<String, List<DetailEntry>> data = new HashMap<String, List<DetailEntry>>();
        data.put("allitems", details);
        String detail = TemplateFactory.processorFtl("detailView.html", data);
        resultBuilder.append(detail);
        return resultBuilder.append(RESULT_FOOTER).toString();
    }

    protected String getString(EvaluItem item, String keyVal) {
        String value = null;
        try {
            value = item.getString(keyVal);
            value = value.replaceAll("\n", "<br/>");
            value = value.replaceAll("\\\\n", "<br/>");
        }
        catch (Exception e) {
            LOGGER.error("can't find resource key= " + keyVal);
        }
        return null == value ? "--" : value;
    }
}

