/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.report;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.upgradeevalu.entity.HostEvalNode;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.model.EvalItemResult;
import com.huawei.ism.tool.upgradeevalu.model.EvalTaskResult;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EserviceExcelResultBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(EserviceExcelResultBuilder.class);
    private static HSSFWorkbook workBook = new HSSFWorkbook();
    private static final String RESOURCE_KEY = "evalu.ui.resultInfoDialog.dev.table.assess.";
    private static Sheet storage = null;
    private static CellStyle defaultStyle = null;
    private static CellStyle notPass = null;
    private static CellStyle center = null;
    private static HSSFPalette palette = null;
    private static Font defFont = null;
    private static String fontName = "\u5b8b\u4f53";
    private static short fontSize = (short)10;
    private static final int INT153 = 153;
    private static final String NEWLINE = "\r\n";
    private String[] titleKeys = new String[]{"StorageSn", "devip", "hostOrDbName", "hostIp", "checkitem", "result", "remark", "suggestion"};
    private static String criterionTittle = "";
    private static String methodTittle = "";
    private static String suggestionTittle = "";
    private int indexRow = 0;
    private boolean hasTitle = false;
    private static List<String> processeDevNodes = new ArrayList<String>();
    private static EserviceExcelResultBuilder excelResultBuilder = null;
    private static final Object LOCK = new Object();

    private EserviceExcelResultBuilder() {
    }

    public static synchronized EserviceExcelResultBuilder getInstance() {
        if (null == excelResultBuilder) {
            excelResultBuilder = new EserviceExcelResultBuilder();
        }
        return excelResultBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeExcel(String summaryFile) {
        FileOutputStream fos = null;
        Date currentTime = new Date();
        try {
            File dest = new File(summaryFile + File.separator + "EvaluResult_Host_" + StringUtils.formatDate((Object)currentTime, (String)"yyyyMMddHHmmss") + ".xls");
            if (dest.exists()) {
                LOGGER.info("found destination excel exists,delete it ...");
                dest.deleteOnExit();
            }
            fos = new FileOutputStream(dest);
            workBook.write(fos);
            StreamUtils.closeStream((OutputStream)fos, null);
        }
        catch (Exception e) {
            LOGGER.error("Write Excel fialed!,FilePath : " + summaryFile, e);
        }
        finally {
            StreamUtils.closeStream(fos, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTitle() {
        Object object = LOCK;
        synchronized (object) {
            if (this.hasTitle) {
                return;
            }
            LOGGER.info("Start build Excel Date");
            Row titleRow = storage.createRow(this.indexRow++);
            CellStyle cellStyle = EserviceExcelResultBuilder.newDefaultCellStyle();
            cellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.TEAL.getIndex());
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cellStyle.setFont(EserviceExcelResultBuilder.createFont(fontName, fontSize, HSSFColor.HSSFColorPredefined.WHITE.getIndex()));
            EserviceExcelResultBuilder.setCenter(cellStyle);
            for (int i = 0; i < this.titleKeys.length; ++i) {
                Cell cell = titleRow.createCell(i);
                cell.setCellValue(ResourceUtil.getString((String)("upgradeEnv.excel.title." + this.titleKeys[i])));
                cell.setCellStyle(cellStyle);
            }
            storage.setColumnWidth(0, 7680);
            storage.setColumnWidth(1, 7680);
            storage.setColumnWidth(2, 7680);
            storage.setColumnWidth(3, 7680);
            storage.setColumnWidth(4, 12800);
            storage.setColumnWidth(5, 3840);
            storage.setColumnWidth(6, 12800);
            storage.setColumnWidth(7, 15360);
            this.hasTitle = true;
        }
    }

    private int createCellsWithStyle(Row row, int cellIndex, CellStyle style, Object ... values) {
        for (Object value : values) {
            Cell cell = row.createCell(cellIndex++);
            cell.setCellStyle(style);
            cell.setCellValue(value.toString());
        }
        return cellIndex;
    }

    private int createResultWithStyle(Row row, int index, CellStyle style, ItemResultEnum itemResultEnum, EvalFeatureResult evalFeatureResult) {
        Cell cell = row.createCell(index++);
        cell.setCellValue(ResourceUtil.getString((String)itemResultEnum.getDescKey()));
        cell.setCellStyle(style);
        if (itemResultEnum == ItemResultEnum.NOTPASS || itemResultEnum == ItemResultEnum.STOPED || itemResultEnum == ItemResultEnum.CANNOTEVAL || itemResultEnum == ItemResultEnum.OPTIM_RECOMD || itemResultEnum == ItemResultEnum.EXCEPTION) {
            cell.setCellStyle(notPass);
            row.getCell(index - 2).setCellStyle(notPass);
        }
        Cell resultCell = row.createCell(index++);
        this.setCellStyle(resultCell, itemResultEnum);
        String itemCheckResult = this.clearHtmlTag(evalFeatureResult.getFailDesc());
        if (itemResultEnum == ItemResultEnum.NOTPASS || itemResultEnum == ItemResultEnum.STOPED || itemResultEnum == ItemResultEnum.CANNOTEVAL || itemResultEnum == ItemResultEnum.OPTIM_RECOMD || itemResultEnum == ItemResultEnum.EXCEPTION) {
            resultCell.setCellValue(itemCheckResult);
        }
        Cell suggestionCell = row.createCell(index++);
        this.setCellStyle(suggestionCell, itemResultEnum);
        this.setSuggestInfo(suggestionCell, evalFeatureResult);
        return index;
    }

    private String clearHtmlTag(String passtxt) {
        passtxt = passtxt.replace("<br/>", "\n");
        passtxt = passtxt.replace("<br>", "\n");
        passtxt = passtxt.replace("<b>", " ");
        passtxt = passtxt.replace("</b>", " ");
        passtxt = passtxt.replace("<xmp>", " ");
        passtxt = passtxt.replace("</xmp>", " ");
        return passtxt;
    }

    private void setCellStyle(Cell cell, ItemResultEnum itemResultEnum) {
        if (itemResultEnum == ItemResultEnum.NOTPASS || itemResultEnum == ItemResultEnum.STOPED || itemResultEnum == ItemResultEnum.CANNOTEVAL || itemResultEnum == ItemResultEnum.OPTIM_RECOMD || itemResultEnum == ItemResultEnum.EXCEPTION) {
            cell.setCellStyle(notPass);
        } else {
            cell.setCellStyle(defaultStyle);
        }
    }

    private void setSuggestInfo(Cell cell, EvalFeatureResult evalFeatureResult) {
        try {
            String criterion = criterionTittle + NEWLINE + this.clearHtmlTag(evalFeatureResult.getCheckCriterion());
            String method = methodTittle + NEWLINE + this.clearHtmlTag(evalFeatureResult.getCheckMethod());
            String suggestStr = suggestionTittle + NEWLINE + this.clearHtmlTag(evalFeatureResult.getSuggest());
            cell.setCellValue(method + NEWLINE + NEWLINE + criterion + NEWLINE + NEWLINE + suggestStr);
        }
        catch (Exception e) {
            LOGGER.error("set suggestion failed. ", e);
        }
    }

    private static void addBorder(CellStyle style) {
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
    }

    private static CellStyle newDefaultCellStyle() {
        HSSFCellStyle style = workBook.createCellStyle();
        EserviceExcelResultBuilder.addBorder(style);
        style.setFont(defFont);
        style.setDataFormat(workBook.createDataFormat().getFormat("@"));
        return style;
    }

    private static void setCenter(CellStyle style) {
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
    }

    private static Font createFont(String name, short fontSizez, short color) {
        HSSFFont font = workBook.createFont();
        font.setFontName(name);
        font.setFontHeightInPoints(fontSizez);
        font.setColor(color);
        return font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeToolInfo(String summaryFile) {
        FileOutputStream fos = null;
        try {
            File dest = new File(summaryFile + File.separator + "tool.info");
            if (dest.exists()) {
                LOGGER.info("found destination excel exists,delete it ...");
                dest.deleteOnExit();
            }
            fos = new FileOutputStream(dest);
            byte[] toWrite = ("tool.version=" + UserOpDataSaveUtil.getViewVersion()).getBytes(Charset.defaultCharset());
            fos.write(toWrite);
            StreamUtils.closeStream((OutputStream)fos, null);
        }
        catch (Exception e) {
            LOGGER.error("Write Excel fialed!,FilePath : " + summaryFile, e);
        }
        finally {
            StreamUtils.closeStream(fos, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildSummary(Map<String, EvalTaskResult> allTask) {
        Object object = LOCK;
        synchronized (object) {
            this.buildSummaryInner(allTask);
        }
    }

    public void buildSummaryInner(Map<String, EvalTaskResult> allTask) {
        for (Map.Entry<String, EvalTaskResult> taskResultEntry : allTask.entrySet()) {
            if (processeDevNodes.contains(taskResultEntry.getKey())) {
                LOGGER.info(String.format(Locale.ENGLISH, "has processed dev:  %s", taskResultEntry.getKey()));
                continue;
            }
            HostEvalNode evaluNode = taskResultEntry.getValue().getHostEvalTask();
            EvalTaskResult evalRsResult = taskResultEntry.getValue();
            int index = this.indexRow;
            int dataSize = 0;
            dataSize = this.dealEvalItemResult(evaluNode, evalRsResult, index, dataSize);
            CellStyle style = EserviceExcelResultBuilder.newDefaultCellStyle();
            EserviceExcelResultBuilder.setCenter(style);
            style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIGHT_GREEN.getIndex());
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            if (dataSize > 1) {
                storage.addMergedRegion(new CellRangeAddress(index, index + dataSize - 1, 0, 0));
                storage.addMergedRegion(new CellRangeAddress(index, index + dataSize - 1, 1, 1));
            }
            Cell stgCell = storage.getRow(index).getCell(0);
            stgCell.setCellStyle(style);
            stgCell = storage.getRow(index).getCell(1);
            stgCell.setCellStyle(style);
            processeDevNodes.add(taskResultEntry.getKey());
        }
    }

    private int dealEvalItemResult(HostEvalNode evaluNode, EvalTaskResult evalRsResult, int index, int dataSize) {
        for (EvalItemResult evalItemResult : evalRsResult.getEvalItemList()) {
            List<EvalFeatureResult> checkItemResults = evalItemResult.getFeatureResultList();
            for (int idx = 0; idx < checkItemResults.size(); ++idx) {
                int indexCell = 0;
                Row rowData = storage.createRow(this.indexRow++);
                String strgSn = evaluNode.getStorageSn();
                String strgVer = evaluNode.getStorageIp();
                String hostName = evalItemResult.getEvalDevNode().getDeviceName();
                String hostIp = evalItemResult.getEvalDevNode().getIp();
                String curFeatureId = checkItemResults.get(idx).getFeatureId();
                indexCell = this.createCellsWithStyle(rowData, indexCell, defaultStyle, strgSn, strgVer, hostName, hostIp, null != curFeatureId ? ResourceUtil.getString((String)(RESOURCE_KEY + curFeatureId)) : "all");
                indexCell = this.createResultWithStyle(rowData, indexCell, defaultStyle, checkItemResults.get(idx).getItemResult(), checkItemResults.get(idx));
            }
            CellStyle style = EserviceExcelResultBuilder.newDefaultCellStyle();
            EserviceExcelResultBuilder.setCenter(style);
            style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIGHT_GREEN.getIndex());
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            if (checkItemResults.size() > 1) {
                storage.addMergedRegion(new CellRangeAddress(index + dataSize, index + dataSize + checkItemResults.size() - 1, 2, 2));
                storage.addMergedRegion(new CellRangeAddress(index + dataSize, index + dataSize + checkItemResults.size() - 1, 3, 3));
            }
            Cell hostCell = storage.getRow(index + dataSize).getCell(2);
            hostCell.setCellStyle(style);
            hostCell = storage.getRow(index + dataSize).getCell(3);
            hostCell.setCellStyle(style);
            dataSize += checkItemResults.size();
        }
        return dataSize;
    }

    static {
        palette = workBook.getCustomPalette();
        palette.setColorAtIndex(HSSFColor.HSSFColorPredefined.YELLOW.getIndex(), (byte)-1, (byte)-1, (byte)-103);
        storage = workBook.createSheet(ResourceUtil.getString((String)"upgradeEval.host.excel.sheetname"));
        defFont = EserviceExcelResultBuilder.createFont(fontName, (short)10, HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        defaultStyle = EserviceExcelResultBuilder.newDefaultCellStyle();
        notPass = EserviceExcelResultBuilder.newDefaultCellStyle();
        notPass.setFillForegroundColor(HSSFColor.HSSFColorPredefined.YELLOW.getIndex());
        notPass.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        notPass.setFont(EserviceExcelResultBuilder.createFont(fontName, fontSize, HSSFColor.HSSFColorPredefined.RED.getIndex()));
        center = EserviceExcelResultBuilder.newDefaultCellStyle();
        center.setAlignment(HorizontalAlignment.CENTER);
        center.setVerticalAlignment(VerticalAlignment.CENTER);
        criterionTittle = ResourceUtil.getString((String)"evalu.wizard.detail.criterion");
        methodTittle = ResourceUtil.getString((String)"evalu.wizard.detail.method");
        suggestionTittle = ResourceUtil.getString((String)"evalu.wizard.detail.suggestion");
    }
}

