/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.report;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.report.DetailEntry;
import com.huawei.ism.tool.upgradeevalu.report.ReportBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelResultBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelResultBuilder.class);
    private static HSSFWorkbook workBook = new HSSFWorkbook();
    private static Sheet storage = null;
    private static final int MAX_STR_LEN_IN_SINGLE_CELL = 32000;
    private static CellStyle defaultStyle = null;
    private static CellStyle notPass = null;
    private static CellStyle center = null;
    private static HSSFPalette palette = null;
    private static Font defFont = null;
    private static String fontName = "\u5b8b\u4f53";
    private static short fontSize = (short)10;
    private static final int INT153 = 153;
    private static final String NEWLINE = "\r\n";
    private String[] titleKeys = new String[]{"StorageSn", "StorageVersion", "devip", "destVer", "checkitem", "result", "remark", "suggestion"};
    private static String criterionTittle = "";
    private static String methodTittle = "";
    private static String suggestionTittle = "";
    private int indexRow = 0;
    private boolean hasTitle = false;
    private static List<EvaluDevNode> processeDevNodes = new ArrayList<EvaluDevNode>();
    private static ExcelResultBuilder excelResultBuilder = null;
    private static final Object LOCK = new Object();

    private ExcelResultBuilder() {
    }

    public static synchronized ExcelResultBuilder getInstance() {
        if (null == excelResultBuilder) {
            excelResultBuilder = new ExcelResultBuilder();
        }
        return excelResultBuilder;
    }

    public void buildSummary(List<ReportBuilder.SummaryEntry> summarys, List<EvaluDevNode> devs, String type, Map<EvaluDevNode, List<DetailEntry>> detailsMap) {
        this.createProductSummary(storage, summarys, type, devs, detailsMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeExcel(String summaryFile) {
        FileOutputStream fos = null;
        Date currentTime = new Date();
        try {
            File dest = new File(summaryFile + File.separator + "EvaluResult_Storage_" + StringUtils.formatDate((Object)currentTime, (String)"yyyyMMddHHmmss") + ".xls");
            if (dest.exists()) {
                LOGGER.info("found destination excel exists,delete it ...");
                dest.deleteOnExit();
            }
            fos = new FileOutputStream(dest);
            workBook.write(fos);
            StreamUtils.closeStream((OutputStream)fos, null);
        }
        catch (Exception e) {
            LOGGER.error("Write Excel fialed!,FilePath : " + summaryFile, e);
        }
        finally {
            StreamUtils.closeStream(fos, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeToolInfo(String summaryFile) {
        FileOutputStream fos = null;
        try {
            File dest = new File(summaryFile + File.separator + "tool.info");
            if (dest.exists()) {
                LOGGER.info("found destination excel exists,delete it ...");
                dest.deleteOnExit();
            }
            fos = new FileOutputStream(dest);
            byte[] toWrite = ("tool.version=" + UserOpDataSaveUtil.getViewVersion()).getBytes(Charset.defaultCharset());
            fos.write(toWrite);
            StreamUtils.closeStream((OutputStream)fos, null);
        }
        catch (Exception e) {
            LOGGER.error("Write Excel fialed!,FilePath : " + summaryFile, e);
        }
        finally {
            StreamUtils.closeStream(fos, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createProductSummary(Sheet sheet, List<ReportBuilder.SummaryEntry> summarys, String type, List<EvaluDevNode> devs, Map<EvaluDevNode, List<DetailEntry>> detailsMap) {
        Object object = LOCK;
        synchronized (object) {
            this.createProductSummaryInner(sheet, summarys, type, devs, detailsMap);
        }
    }

    private void createProductSummaryInner(Sheet sheet, List<ReportBuilder.SummaryEntry> summarys, String type, List<EvaluDevNode> devs, Map<EvaluDevNode, List<DetailEntry>> detailsMap) {
        int productSize = summarys.get(0).getResults().size();
        LOGGER.error("indexRow : " + this.indexRow);
        for (int i = 0; i < productSize; ++i) {
            if (processeDevNodes.contains((Object)devs.get(i))) {
                LOGGER.info(String.format(Locale.ENGLISH, "has processed dev:  %s", devs.get(i).getIp()));
                continue;
            }
            List<DetailEntry> detailEntries = detailsMap.get((Object)devs.get(i));
            int index = this.indexRow;
            for (int dataSize = 0; dataSize < summarys.size(); ++dataSize) {
                int indexCell = 0;
                Row rowData = sheet.createRow(this.indexRow++);
                DetailEntry detailEntry = detailEntries.get(dataSize);
                ReportBuilder.SummaryEntry summaryEntry = summarys.get(dataSize);
                LOGGER.info("checkName:{}", (Object)summaryEntry.getCheckName());
                String proIP = devs.get(i).getIp();
                String proName = devs.get(i).getDeviceSerialNumber();
                String destVer = devs.get(i).getDestVersion();
                String devVer = devs.get(i).getProductVersion();
                indexCell = this.createCellsWithStyle(rowData, indexCell, defaultStyle, proName, devVer, proIP, destVer, summaryEntry.getCheckName());
                List<ReportBuilder.RetStatusEntry> rets = summaryEntry.getResults();
                LOGGER.info("devName:{},result_status:{}", (Object)rets.get(i).getDevName(), (Object)rets.get(i).getStaus());
                indexCell = this.createResultWithStyle(rowData, indexCell, defaultStyle, rets.get(i), detailEntry);
            }
            CellStyle style = ExcelResultBuilder.newDefaultCellStyle();
            ExcelResultBuilder.setCenter(style);
            style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIGHT_GREEN.getIndex());
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            sheet.addMergedRegion(new CellRangeAddress(index, index + summarys.size() - 1, 0, 0));
            Cell typeCell = sheet.getRow(index).getCell(0);
            typeCell.setCellStyle(style);
            sheet.addMergedRegion(new CellRangeAddress(index, index + summarys.size() - 1, 1, 1));
            typeCell = sheet.getRow(index).getCell(1);
            typeCell.setCellStyle(style);
            sheet.addMergedRegion(new CellRangeAddress(index, index + summarys.size() - 1, 2, 2));
            typeCell = sheet.getRow(index).getCell(2);
            typeCell.setCellStyle(style);
            sheet.addMergedRegion(new CellRangeAddress(index, index + summarys.size() - 1, 3, 3));
            typeCell = sheet.getRow(index).getCell(3);
            typeCell.setCellStyle(style);
            processeDevNodes.add(devs.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Workbook createTitle() {
        Object object = LOCK;
        synchronized (object) {
            if (this.hasTitle) {
                return workBook;
            }
            LOGGER.info("Start build Excel Date");
            Row titleRow = storage.createRow(this.indexRow++);
            CellStyle cellStyle = ExcelResultBuilder.newDefaultCellStyle();
            cellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.TEAL.getIndex());
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cellStyle.setFont(ExcelResultBuilder.createFont(fontName, fontSize, HSSFColor.HSSFColorPredefined.WHITE.getIndex()));
            ExcelResultBuilder.setCenter(cellStyle);
            for (int i = 0; i < this.titleKeys.length; ++i) {
                Cell cell = titleRow.createCell(i);
                cell.setCellValue(ResourceUtil.getString((String)("upgradeEnv.excel.title." + this.titleKeys[i])));
                cell.setCellStyle(cellStyle);
            }
            storage.setColumnWidth(0, 7680);
            storage.setColumnWidth(1, 7680);
            storage.setColumnWidth(2, 5120);
            storage.setColumnWidth(3, 7680);
            storage.setColumnWidth(4, 12800);
            storage.setColumnWidth(5, 3840);
            storage.setColumnWidth(6, 12800);
            storage.setColumnWidth(7, 10240);
            this.hasTitle = true;
            return workBook;
        }
    }

    private int createCellsWithStyle(Row row, int cellIndex, CellStyle style, Object ... values) {
        for (Object value : values) {
            Cell cell = row.createCell(cellIndex++);
            cell.setCellStyle(style);
            cell.setCellValue(value.toString());
        }
        return cellIndex;
    }

    private int createResultWithStyle(Row row, int index, CellStyle style, ReportBuilder.RetStatusEntry ret, DetailEntry detailEntry) {
        Cell cell = row.createCell(index++);
        switch (ret.getStaus()) {
            case 0: {
                cell.setCellValue(ResourceUtil.getString((String)"evalu.ui.component.detailListRenderer.result.pass"));
                cell.setCellStyle(style);
                break;
            }
            case 1: {
                cell.setCellValue(ResourceUtil.getString((String)"evalu.ui.component.detailListRenderer.result.not.pass"));
                cell.setCellStyle(notPass);
                row.getCell(index - 2).setCellStyle(notPass);
                break;
            }
            case 2: {
                cell.setCellValue(ResourceUtil.getString((String)"evalu.ui.component.detailListRenderer.result.not.check"));
                cell.setCellStyle(style);
                break;
            }
            case 4: {
                cell.setCellValue(ResourceUtil.getString((String)"evalu.ui.component.detailListRenderer.result.warn"));
                cell.setCellStyle(style);
                break;
            }
            default: {
                cell.setCellValue(ResourceUtil.getString((String)"evalu.ui.component.detailListRenderer.result.not.support"));
                cell.setCellStyle(style);
            }
        }
        Cell resultCell = row.createCell(index++);
        this.setCellStyle(resultCell, ret);
        String itemCheckResult = this.clearHtmlTag(detailEntry.getPasstxt());
        if (itemCheckResult.length() > 32000) {
            itemCheckResult = itemCheckResult.substring(0, 32000) + " ......";
        }
        if (ret.getStaus() == 1) {
            resultCell.setCellValue(itemCheckResult);
        }
        Cell suggestionCell = row.createCell(index++);
        this.setCellStyle(suggestionCell, ret);
        this.setSuggestInfo(suggestionCell, detailEntry);
        return index;
    }

    private String clearHtmlTag(String passtxt) {
        passtxt = passtxt.replace("<br/>", "\n");
        passtxt = passtxt.replace("<br>", "\n");
        passtxt = passtxt.replace("<xmp>", " ");
        passtxt = passtxt.replace("</xmp>", " ");
        return passtxt;
    }

    private void setCellStyle(Cell cell, ReportBuilder.RetStatusEntry ret) {
        if (ret.getStaus() == 1) {
            cell.setCellStyle(notPass);
        } else {
            cell.setCellStyle(defaultStyle);
        }
    }

    private void setSuggestInfo(Cell cell, DetailEntry detailEntry) {
        try {
            String criterion = criterionTittle + NEWLINE + this.clearHtmlTag(detailEntry.getCriterion());
            String method = methodTittle + NEWLINE + this.clearHtmlTag(detailEntry.getCheckMethod());
            String suggestStr = suggestionTittle + NEWLINE + this.clearHtmlTag(detailEntry.getSuggestion());
            cell.setCellValue(method + NEWLINE + NEWLINE + criterion + NEWLINE + NEWLINE + suggestStr);
        }
        catch (Exception e) {
            LOGGER.error("set suggestion failed. ", e);
        }
    }

    private static void addBorder(CellStyle style) {
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
    }

    private static CellStyle newDefaultCellStyle() {
        HSSFCellStyle style = workBook.createCellStyle();
        ExcelResultBuilder.addBorder(style);
        style.setDataFormat(workBook.createDataFormat().getFormat("@"));
        style.setFont(defFont);
        return style;
    }

    private static void setCenter(CellStyle style) {
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
    }

    private static Font createFont(String name, short fontSizez, short color) {
        HSSFFont font = workBook.createFont();
        font.setFontName(name);
        font.setFontHeightInPoints(fontSizez);
        font.setColor(color);
        return font;
    }

    static {
        palette = workBook.getCustomPalette();
        palette.setColorAtIndex(HSSFColor.HSSFColorPredefined.YELLOW.getIndex(), (byte)-1, (byte)-1, (byte)-103);
        storage = workBook.createSheet(ResourceUtil.getString((String)"upgradeEval.excel.sheetname"));
        defFont = ExcelResultBuilder.createFont(fontName, (short)10, HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        defaultStyle = ExcelResultBuilder.newDefaultCellStyle();
        notPass = ExcelResultBuilder.newDefaultCellStyle();
        notPass.setFillForegroundColor(HSSFColor.HSSFColorPredefined.YELLOW.getIndex());
        notPass.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        notPass.setFont(ExcelResultBuilder.createFont(fontName, fontSize, HSSFColor.HSSFColorPredefined.RED.getIndex()));
        center = ExcelResultBuilder.newDefaultCellStyle();
        center.setAlignment(HorizontalAlignment.CENTER);
        center.setVerticalAlignment(VerticalAlignment.CENTER);
        criterionTittle = ResourceUtil.getString((String)"evalu.wizard.detail.criterion");
        methodTittle = ResourceUtil.getString((String)"evalu.wizard.detail.method");
        suggestionTittle = ResourceUtil.getString((String)"evalu.wizard.detail.suggestion");
    }
}

