/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.report;

import com.huawei.ism.tool.base.utils.ContextUtil;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.runtime.impl.ServerRuntime;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.impl.AbstractUserOpDataSev;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.upgradeevalu.config.ProductParser;
import com.huawei.ism.tool.upgradeevalu.entity.CrossVersionType;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluItem;
import com.huawei.ism.tool.upgradeevalu.entity.Module;
import com.huawei.ism.tool.upgradeevalu.entity.ProductCfg;
import com.huawei.ism.tool.upgradeevalu.entity.UpgradeMode;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluDevManager;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluService;
import com.huawei.ism.tool.upgradeevalu.evalu.ResultFlag;
import com.huawei.ism.tool.upgradeevalu.evalu.ResultItem;
import com.huawei.ism.tool.upgradeevalu.report.DetailBuilder;
import com.huawei.ism.tool.upgradeevalu.report.DetailEntry;
import com.huawei.ism.tool.upgradeevalu.report.ExcelResultBuilder;
import com.huawei.ism.tool.upgradeevalu.report.TemplateFactory;
import com.huawei.ism.tool.upgradeevalu.util.EvaluCommUtil;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.ism.tool.upgradeevalu.util.HtmlResUtils;
import com.huawei.ism.tool.upgradeevalu.util.PackageUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import utils.FilesUtil;

public class ReportBuilder {
    private static final int STATUS_OK = 0;
    private static final int STATUS_NOTOK = 1;
    private static final int STATUS_NOCHECK = 2;
    private static final int STATUS_NOSUPPORT = 3;
    private static final int STATUS_WARNING = 4;
    private static final String REPORT_DATE = "packages/upgradeEvaluation/template/data";
    private static final String ESERVICE_FILES = "packages/upgradeEvaluation/template/pkginfo";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ReportBuilder.class);
    private EvaluService evaluService = EvaluService.getInstance();
    private EvaluContext evaluContext = EvaluContext.getInstance();
    private EvaluDevManager evaluDevMgr = EvaluDevManager.getInstance();

    public void buildLeftDeviceTree(Map<String, Map<String, Map<String, List<EvaluDevNode>>>> devsMap, File devTreeFile) {
        HashMap<String, Map<String, Map<String, Map<String, List<EvaluDevNode>>>>> data = new HashMap<String, Map<String, Map<String, Map<String, List<EvaluDevNode>>>>>();
        data.put("devsMap", devsMap);
        TemplateFactory.processorFtl(HtmlPathEntity.deviceTreeTmplate, data, FilesUtil.getCanonicalPath((File)devTreeFile));
    }

    public void buildCover(File coverFile) {
        ServerRuntime runtime = new ServerRuntime(ContextUtil.getToolBoxPath());
        LOGGER.info(String.format(Locale.ENGLISH, "Current toolbox's version: !%s", runtime.getAppConfig("app.version")));
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("logo", this.getLogoImageName());
        data.put("copyright", HtmlResUtils.getOEMString("report.cover.system.copyright"));
        data.put("company", HtmlResUtils.getOEMString("report.cover.company"));
        data.put("toolversion", UserOpDataSaveUtil.getViewVersion());
        data.put("date", UserOpDataSaveUtil.getToolIniProp((String)"date"));
        data.put("toolkitversion", UserOpDataSaveUtil.getToolBoxIniProp((String)"app.version"));
        data.put("releasedate", ApplicationContext.getInstance().getReleaseDate());
        data.put("title", HtmlResUtils.getString("report.cover.highlighttitle"));
        data.put("genneratedate", StringUtils.formatDate((Object)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        data.put("showcustomer", false);
        TemplateFactory.processorFtl("cover.html", data, FilesUtil.getCanonicalPath((File)coverFile));
    }

    private String getLogoImageName() {
        return "huaweilogo.jpg";
    }

    private void copyHelpCase(EvaluDevNode dev) {
        List<ProductCfg> allProds = dev.getAllProducts();
        for (ProductCfg productCfg : allProds) {
            File scriptHelpCaseFile;
            String scriptPath = "";
            scriptPath = FilesUtil.getCanonicalPath((File)productCfg.getProductDir());
            PackageUtils.deCompressResourceFile(scriptPath, false);
            String reportData = EvaluContext.getInstance().getHtmlDir() + File.separator + "data";
            String targetDir = reportData + File.separator + productCfg.getProdcutName() + File.separator + "helpCase";
            if (new File(targetDir).exists()) {
                FileUtils.deleteAllInFolder((String)targetDir);
            }
            if ((scriptHelpCaseFile = new File(scriptPath + File.separator + "helpCase")).exists()) {
                try {
                    FileUtils.copyDir((String)FilesUtil.getCanonicalPath((File)scriptHelpCaseFile), (String)targetDir);
                }
                catch (Exception e) {
                    LOGGER.error("copy " + scriptHelpCaseFile + "error", e);
                }
            }
            this.copyCommonHelpCase(targetDir);
        }
    }

    private void copyCommonHelpCase(String targetDir) {
        String scriptPath = FilesUtil.getCanonicalPath((File)ProductParser.getCommonPackagePath());
        File scriptHelpCaseFile = new File(scriptPath + File.separator + "helpCase");
        if (scriptHelpCaseFile.exists()) {
            try {
                FileUtils.copyDir((String)FilesUtil.getCanonicalPath((File)scriptHelpCaseFile), (String)targetDir);
            }
            catch (Exception e) {
                LOGGER.error("copy " + scriptHelpCaseFile + "error", e);
            }
        }
    }

    public void buildReport(Map<UpgradeMode, Map<ItDeviceType, List<EvaluDevNode>>> devsMap, File resultDir) {
        if (devsMap.isEmpty()) {
            LOGGER.info("Report export for upgrade evalu failed. No devs map.");
            return;
        }
        Map<String, Map<String, Map<String, List<EvaluDevNode>>>> devsMapStr = this.convert4Tree(devsMap);
        File devTreeFile = new File(FilePathUtils.getCanonicalPath((File)resultDir) + File.separator + "data" + File.separator + HtmlPathEntity.deviceTreeTmplate);
        this.buildLeftDeviceTree(devsMapStr, devTreeFile);
        this.traverDevs(devsMap, resultDir);
        DetailBuilder db = new DetailBuilder();
        List<EvaluDevNode> devs = this.evaluDevMgr.getEvaluDevs();
        for (EvaluDevNode dev : devs) {
            this.copyHelpCase(dev);
            db.buildDetailFile(dev, resultDir);
        }
        File coverFile = new File(FilePathUtils.getCanonicalPath((File)resultDir) + File.separator + "data" + File.separator + "head" + File.separator + "cover.html");
        this.buildCover(coverFile);
        this.buildIndexPage(resultDir);
        this.copyReportFile(resultDir);
        this.copyFileForEService(resultDir);
        ExcelResultBuilder excel4EserviceBuilder = ExcelResultBuilder.getInstance();
        excel4EserviceBuilder.createTitle();
        try {
            Map<String, List<EvaluDevNode>> sortedDevListMap = this.evaluService.groupByModelVersion(devs);
            if (null != sortedDevListMap) {
                for (Map.Entry<String, List<EvaluDevNode>> sortedDevsEntry : sortedDevListMap.entrySet()) {
                    List<EvaluDevNode> sortedDevs = sortedDevsEntry.getValue();
                    HashMap<EvaluDevNode, List<DetailEntry>> detailsMap = new HashMap<EvaluDevNode, List<DetailEntry>>();
                    for (EvaluDevNode devNode : sortedDevs) {
                        detailsMap.put(devNode, db.getDetails(devNode));
                    }
                    List<SummaryEntry> summarys = this.getSortedDevicesSummaryEntries(sortedDevs);
                    excel4EserviceBuilder.buildSummary(summarys, sortedDevs, sortedDevsEntry.getKey(), detailsMap);
                }
            }
            excel4EserviceBuilder.writeExcel(resultDir.getCanonicalPath());
            excel4EserviceBuilder.writeToolInfo(resultDir.getCanonicalPath());
        }
        catch (Exception ecp) {
            LOGGER.error("exception occurred while generating excel: " + ecp);
        }
        AbstractUserOpDataSev.copyLogInfo((File)resultDir);
        this.compressReport(FilesUtil.getCanonicalPath((File)resultDir));
        LOGGER.info("Report export for upgrade evalu success!");
    }

    public void buildReport4New(Map<UpgradeMode, Map<ItDeviceType, List<EvaluDevNode>>> devsMap, File resultDir) {
        if (devsMap.isEmpty()) {
            LOGGER.info("Report export for upgrade evalu failed. No devs map.");
            return;
        }
        this.setCustomerPath();
        Map<String, Map<String, Map<String, List<EvaluDevNode>>>> devsMapStr = this.convert4Tree(devsMap);
        File devTreeFile4Customer = new File(FilePathUtils.getCanonicalPath((File)resultDir) + File.separator + "data" + File.separator + HtmlPathEntity.deviceTreeOut);
        this.buildLeftDeviceTree(devsMapStr, devTreeFile4Customer);
        this.traverDevs(devsMap, resultDir);
        this.buildIndexPage(resultDir);
        this.setDefaultPath();
        this.buildReport(devsMap, resultDir);
    }

    public void setCustomerPath() {
        HtmlPathEntity.deviceTreeTmplate = "devsTree_sum.html";
        HtmlPathEntity.deviceTreeOut = "resource" + File.separator + "devsTree.html";
        HtmlPathEntity.evalCollectTmplate = "evaluCollect_sum.html";
        HtmlPathEntity.evalCollectOut = "resource";
        HtmlPathEntity.indexTmplate = "summary.html";
        HtmlPathEntity.indexOut = "summary.html";
    }

    public void setDefaultPath() {
        HtmlPathEntity.deviceTreeTmplate = "devsTree.html";
        HtmlPathEntity.deviceTreeOut = "devsTree.html";
        HtmlPathEntity.evalCollectTmplate = "evaluCollect.html";
        HtmlPathEntity.evalCollectOut = "summary";
        HtmlPathEntity.indexTmplate = "index.html";
        HtmlPathEntity.indexOut = "index.html";
    }

    private void compressReport(String htmlDirPath) {
        StringBuffer zipName = new StringBuffer();
        zipName.append(File.separator);
        zipName.append("EvaluResult_Storage_");
        zipName.append(new SimpleDateFormat("yyyyMMddHHmmss").format(Calendar.getInstance().getTime()));
        zipName.append(".zip");
        String tmpPath = this.evaluContext.getHome() + zipName.toString();
        File pathFile = new File(tmpPath);
        File reportDirFile = new File(this.evaluContext.getReportDir() + zipName.toString());
        ZipUtils.compressFile((String)tmpPath, (String)htmlDirPath);
        if (!pathFile.getAbsoluteFile().equals(reportDirFile.getAbsoluteFile())) {
            StreamUtils.copyFile((File)pathFile, (File)reportDirFile);
        }
        FileUtils.setFilePermissions((File)reportDirFile);
        if (!pathFile.getAbsoluteFile().equals(reportDirFile.getAbsoluteFile())) {
            FileUtils.deleteFile((File)pathFile);
        }
    }

    private void copyReportFile(File reportDir) {
        String srcDir = this.evaluContext.getHome() + File.separator + REPORT_DATE;
        File destDir = new File(FilesUtil.getCanonicalPath((File)reportDir) + File.separator + "data");
        FileUtils.copyDir((String)srcDir, (String)FilesUtil.getCanonicalPath((File)destDir));
    }

    private Map<String, Map<String, Map<String, List<EvaluDevNode>>>> convert4Tree(Map<UpgradeMode, Map<ItDeviceType, List<EvaluDevNode>>> origialDevsMap) {
        HashMap<String, Map<String, Map<String, List<EvaluDevNode>>>> devsMapStr = new HashMap<String, Map<String, Map<String, List<EvaluDevNode>>>>();
        Set<Map.Entry<UpgradeMode, Map<ItDeviceType, List<EvaluDevNode>>>> upgradeModeEntrys = origialDevsMap.entrySet();
        for (Map.Entry<UpgradeMode, Map<ItDeviceType, List<EvaluDevNode>>> upgradeModeEntry : upgradeModeEntrys) {
            UpgradeMode upgradeMode = upgradeModeEntry.getKey();
            if (!devsMapStr.containsKey(upgradeMode.toString())) {
                HashMap upgradeModeMapStr = new HashMap();
                devsMapStr.put(upgradeMode.toString(), upgradeModeMapStr);
            }
            Map<ItDeviceType, List<EvaluDevNode>> devTypeMap = origialDevsMap.get((Object)upgradeMode);
            Set<Map.Entry<ItDeviceType, List<EvaluDevNode>>> devTypeEntrys = devTypeMap.entrySet();
            for (Map.Entry<ItDeviceType, List<EvaluDevNode>> devTypeEntry : devTypeEntrys) {
                ItDeviceType devType = devTypeEntry.getKey();
                if (!((Map)devsMapStr.get(upgradeMode.toString())).containsKey(devType.getName())) {
                    HashMap devTypeMapStr = new HashMap();
                    ((Map)devsMapStr.get(upgradeMode.toString())).put(devType.getName(), devTypeMapStr);
                }
                List<EvaluDevNode> devs = devTypeMap.get(devType);
                Map<String, List<EvaluDevNode>> mvMapStr = this.evaluService.groupByModelVersion(devs);
                ((Map)((Map)devsMapStr.get(upgradeMode.toString())).get(devType.getName())).putAll(mvMapStr);
            }
        }
        return devsMapStr;
    }

    private void traverDevs(Map<UpgradeMode, Map<ItDeviceType, List<EvaluDevNode>>> devsMap, File resultDir) {
        ArrayList<CollectEntity> colls = new ArrayList<CollectEntity>();
        Set<Map.Entry<UpgradeMode, Map<ItDeviceType, List<EvaluDevNode>>>> upgradeModeEntrys = devsMap.entrySet();
        for (Map.Entry<UpgradeMode, Map<ItDeviceType, List<EvaluDevNode>>> upgradeModeEntry : upgradeModeEntrys) {
            UpgradeMode upgradeMode = upgradeModeEntry.getKey();
            int grandFatherRow = 0;
            boolean isRenderGrand = true;
            CollectEntity first4Grand = null;
            Map<ItDeviceType, List<EvaluDevNode>> typeMap = upgradeModeEntry.getValue();
            Set<Map.Entry<ItDeviceType, List<EvaluDevNode>>> devTypeEntrys = typeMap.entrySet();
            this.forEachDevType(resultDir, colls, upgradeMode, grandFatherRow, isRenderGrand, first4Grand, devTypeEntrys);
        }
        File collsPage = new File(FilesUtil.getCanonicalPath((File)resultDir) + File.separator + "data" + File.separator + "head" + File.separator + "devsCollect.html");
        HashMap<String, ArrayList<CollectEntity>> data = new HashMap<String, ArrayList<CollectEntity>>();
        data.put("collsLlist", colls);
        TemplateFactory.processorFtl("devsCollect.html", data, FilesUtil.getCanonicalPath((File)collsPage));
    }

    private void forEachDevType(File resultDir, List<CollectEntity> colls, UpgradeMode upgradeMode, int grandFatherRow, boolean isRenderGrand, CollectEntity first4Grand, Set<Map.Entry<ItDeviceType, List<EvaluDevNode>>> devTypeEntrys) {
        for (Map.Entry<ItDeviceType, List<EvaluDevNode>> devTypeEntry : devTypeEntrys) {
            ItDeviceType devType = devTypeEntry.getKey();
            int fatherRow = 0;
            boolean isRenderFather = true;
            CollectEntity first4Father = null;
            List<EvaluDevNode> devs = devTypeEntry.getValue();
            this.traverItems(devs, resultDir, devType, upgradeMode);
            Map<String, List<EvaluDevNode>> mvMap = this.evaluService.groupByModelVersion(devs);
            if (mvMap == null || mvMap.isEmpty()) continue;
            Set<Map.Entry<String, List<EvaluDevNode>>> modleVersionEntrys = mvMap.entrySet();
            for (Map.Entry<String, List<EvaluDevNode>> modleVersionEntry : modleVersionEntrys) {
                String modelVer = modleVersionEntry.getKey();
                List<EvaluDevNode> prodDevs = modleVersionEntry.getValue();
                CollectEntity entityHead = new CollectEntity();
                entityHead.grandFather = upgradeMode.toString();
                entityHead.renderGrand = isRenderGrand;
                if (isRenderGrand) {
                    first4Grand = entityHead;
                }
                isRenderGrand = false;
                entityHead.setFather(devType.getName());
                entityHead.renderFather = isRenderFather;
                if (isRenderFather) {
                    first4Father = entityHead;
                }
                isRenderFather = false;
                entityHead.name = modelVer;
                colls.add(entityHead);
                ++grandFatherRow;
                ++fatherRow;
                for (EvaluDevNode dev : prodDevs) {
                    CollectEntity entity = new CollectEntity();
                    entity.dev = dev;
                    colls.add(entity);
                    ++grandFatherRow;
                    ++fatherRow;
                }
                if (null == first4Father) continue;
                first4Father.setFatherRow(fatherRow);
            }
            if (null == first4Grand) continue;
            first4Grand.setGrandFatherRow(grandFatherRow);
        }
    }

    private void traverItems(List<EvaluDevNode> devs, File resultDir, ItDeviceType devType, UpgradeMode upgradeMode) {
        int index = 0;
        Map<String, List<EvaluDevNode>> mvMap = this.evaluService.groupByModelVersion(devs);
        if (mvMap == null || mvMap.isEmpty()) {
            return;
        }
        Set<Map.Entry<String, List<EvaluDevNode>>> modelVersionEntrys = mvMap.entrySet();
        for (Map.Entry<String, List<EvaluDevNode>> modelVersionEntry : modelVersionEntrys) {
            String mvName = modelVersionEntry.getKey();
            HashMap<String, Object> data = new HashMap<String, Object>();
            List<EvaluDevNode> devList = modelVersionEntry.getValue();
            KeyOrderedHashMap<CrossVersionType, KeyOrderedHashMap<String, List<EvaluItem>>> skipMapFinal = this.mergeItemByProdcut(devList);
            List<SummaryEntry> summarys = this.genSummarys(skipMapFinal, index, devList);
            File summaryFolder = new File(FilePathUtils.getCanonicalPath((File)resultDir) + File.separator + "data" + File.separator + HtmlPathEntity.evalCollectOut);
            FileUtils.createDir((File)summaryFolder);
            String pageName = upgradeMode.toString() + "_" + devType.getName() + "_" + mvName;
            data.put("summarys", summarys);
            data.put("devs", devList);
            data.put("type", mvName);
            String resultPath = FilesUtil.getCanonicalPath((File)summaryFolder) + File.separator + pageName + ".html";
            TemplateFactory.processorFtl(HtmlPathEntity.evalCollectTmplate, data, resultPath);
        }
    }

    private List<SummaryEntry> getSortedDevicesSummaryEntries(List<EvaluDevNode> devs) {
        KeyOrderedHashMap<CrossVersionType, KeyOrderedHashMap<String, List<EvaluItem>>> skipMapFinal = this.mergeItemByProdcut(devs);
        int index = 0;
        List<SummaryEntry> summarys = this.genSummarys(skipMapFinal, index, devs);
        return summarys;
    }

    private List<SummaryEntry> genSummarys(KeyOrderedHashMap<CrossVersionType, KeyOrderedHashMap<String, List<EvaluItem>>> skipMapFinal, int index, List<EvaluDevNode> devList) {
        ArrayList<SummaryEntry> summarys = new ArrayList<SummaryEntry>();
        List crossVersionTypeList = skipMapFinal.keyList();
        this.addsummarys(skipMapFinal, index, devList, summarys, crossVersionTypeList);
        return summarys;
    }

    private void addsummarys(KeyOrderedHashMap<CrossVersionType, KeyOrderedHashMap<String, List<EvaluItem>>> skipMapFinal, int index, List<EvaluDevNode> devList, List<SummaryEntry> summarys, List<CrossVersionType> crossVersionTypeList) {
        for (CrossVersionType crossVersionType : crossVersionTypeList) {
            SummaryEntry first4Grand = null;
            boolean isRenderGrand = true;
            int grandFatherRow = 0;
            KeyOrderedHashMap moduleMapFinal = (KeyOrderedHashMap)skipMapFinal.get((Object)crossVersionType);
            List moduleKeyList = moduleMapFinal.keyList();
            for (String module : moduleKeyList) {
                List items = (List)moduleMapFinal.get((Object)module);
                SummaryEntry first4Father = null;
                boolean isRenderFather = true;
                int fatherRow = 0;
                for (EvaluItem item : items) {
                    SummaryEntry summary = new SummaryEntry();
                    summary.serialNo = ++index;
                    summary.relateId = item.getId();
                    summary.summaryRenderGrand = isRenderGrand;
                    EvaluDevNode devNode = this.getEvaluDevNode(item);
                    if (devNode == null) continue;
                    if (isRenderGrand) {
                        this.summaryGrandFather(summary, crossVersionType, devNode);
                        first4Grand = summary;
                    }
                    isRenderGrand = false;
                    ++grandFatherRow;
                    summary.summaryRenderFather = isRenderFather;
                    if (isRenderFather) {
                        summary.summaryFather = devNode.getProduct(crossVersionType).getResBundle().getString(module);
                        first4Father = summary;
                    }
                    isRenderFather = false;
                    ++fatherRow;
                    this.setSummary(devList, crossVersionType, item, summary, devNode);
                    summarys.add(summary);
                }
                if (null == first4Father) continue;
                first4Father.summaryFatherRow = fatherRow;
            }
            if (null == first4Grand) continue;
            first4Grand.summaryGrandFatherRow = grandFatherRow;
        }
    }

    private void setSummary(List<EvaluDevNode> devList, CrossVersionType crossVersionType, EvaluItem item, SummaryEntry summary, EvaluDevNode devNode) {
        ProductCfg currProd = devNode.getProduct(crossVersionType);
        this.getCheckName(item, summary, currProd);
        summary.results = this.genResult4AllDev(devList, item);
        summary.legalityPercents = this.getLegality(summary.results);
        summary.failedNum = this.getUnNormal(summary.results);
    }

    private EvaluDevNode getEvaluDevNode(EvaluItem item) {
        EvaluDevNode devNode = this.evaluDevMgr.getEvaluDevById(item.getDevID());
        if (null == devNode) {
            LOGGER.warn("evaluDevMgr.getEvaluDevs() is " + this.evaluDevMgr.getEvaluDevs());
            LOGGER.error("devNode is null, create report failed. dev is " + item.getDevID());
            return null;
        }
        return devNode;
    }

    private void getCheckName(EvaluItem item, SummaryEntry summary, ProductCfg currProd) {
        if (currProd.getCrossVersionType().equals((Object)CrossVersionType.INNERVERSION)) {
            if ("innerCheck".equals(item.getItemType())) {
                summary.checkName = item.getName();
            } else if (item.getCheckConfigItem() != null) {
                summary.checkName = item.getCheckConfigItem().getName();
            } else {
                summary.checkName = currProd.getResBundle().getString(item.getId() + ".name");
            }
        }
    }

    private void summaryGrandFather(SummaryEntry summary, CrossVersionType crossVersionType, EvaluDevNode devNode) {
        switch (crossVersionType) {
            case INNERVERSION: {
                String vrcVersion = "";
                vrcVersion = EvaluCommUtil.isStorageOrA800(devNode.getItDeviceType()) ? EvaluService.getInstance().getVRCVersion(devNode.getProductVersion()) : devNode.getDeviceType().toString();
                summary.summaryGrandFather = vrcVersion + " " + HtmlResUtils.getString("report.collect.base.check");
                break;
            }
            case CROSSVERSION: {
                String innerVrcVersion = EvaluService.getInstance().getVRCVersion(devNode.getProductVersion());
                String destVrcVersion = EvaluService.getInstance().getVRCVersion(devNode.getDestVersion());
                summary.summaryGrandFather = innerVrcVersion + " " + HtmlResUtils.getString("report.collect.upgradeto") + " " + destVrcVersion + " " + HtmlResUtils.getString("report.collect.skip.check");
                break;
            }
            default: {
                LOGGER.error("generate summary for GrandFather error. crossVersionType: " + (Object)((Object)crossVersionType) + " is error");
            }
        }
    }

    public KeyOrderedHashMap<CrossVersionType, KeyOrderedHashMap<String, List<EvaluItem>>> mergeItemByProdcut(List<EvaluDevNode> devList) {
        KeyOrderedHashMap crossVersionTypeMap = new KeyOrderedHashMap();
        ArrayList<CrossVersionType> crossVersionListBase = new ArrayList<CrossVersionType>();
        HashMap<CrossVersionType, List<Module>> crossVersionTypeModuleList = new HashMap<CrossVersionType, List<Module>>();
        ArrayList<EvaluItem> itemListBase = new ArrayList<EvaluItem>();
        HashMap crossVersionTypeModuleListBase = new HashMap();
        for (EvaluDevNode dev : devList) {
            KeyOrderedHashMap<CrossVersionType, ProductCfg> crossVersionMap = dev.getProducts();
            List crossVersionTypeList = crossVersionMap.keyList();
            for (CrossVersionType crossVersionType : crossVersionTypeList) {
                if (!crossVersionListBase.contains((Object)crossVersionType)) {
                    crossVersionListBase.add(crossVersionType);
                    KeyOrderedHashMap moduleMapTmp = new KeyOrderedHashMap();
                    crossVersionTypeMap.put((Object)crossVersionType, (Object)moduleMapTmp);
                    ArrayList moduleListBase = new ArrayList();
                    crossVersionTypeModuleListBase.put(crossVersionType, moduleListBase);
                }
                List moduleListBase = (List)crossVersionTypeModuleListBase.get((Object)crossVersionType);
                ProductCfg prod = (ProductCfg)crossVersionMap.get((Object)crossVersionType);
                List<Module> modules = prod.getCrossVersionType().equals((Object)CrossVersionType.INNERVERSION) ? prod.getModules() : prod.getCrossVerCfg().getModules();
                this.traveModules((KeyOrderedHashMap<CrossVersionType, KeyOrderedHashMap<String, List<EvaluItem>>>)crossVersionTypeMap, moduleListBase, itemListBase, crossVersionType, modules);
                crossVersionTypeModuleList.put(crossVersionType, moduleListBase);
            }
        }
        return this.sortModules(crossVersionTypeModuleList, (KeyOrderedHashMap<CrossVersionType, KeyOrderedHashMap<String, List<EvaluItem>>>)crossVersionTypeMap);
    }

    private KeyOrderedHashMap<CrossVersionType, KeyOrderedHashMap<String, List<EvaluItem>>> sortModules(Map<CrossVersionType, List<Module>> crossVersionTypeModuleList, KeyOrderedHashMap<CrossVersionType, KeyOrderedHashMap<String, List<EvaluItem>>> crossVersionTypeMapOld) {
        KeyOrderedHashMap crossVersionTypeMapNew = new KeyOrderedHashMap();
        List crossVersionTypeList = crossVersionTypeMapOld.keyList();
        for (CrossVersionType crossVersionType : crossVersionTypeList) {
            KeyOrderedHashMap moduleMapOld = (KeyOrderedHashMap)crossVersionTypeMapOld.get((Object)crossVersionType);
            List<Module> sortModuleList = crossVersionTypeModuleList.get((Object)crossVersionType);
            Collections.sort(sortModuleList);
            KeyOrderedHashMap moduleMapNew = new KeyOrderedHashMap();
            crossVersionTypeMapNew.put((Object)crossVersionType, (Object)moduleMapNew);
            for (Module module : sortModuleList) {
                List itemListOld = (List)moduleMapOld.get((Object)module.getId());
                moduleMapNew.put((Object)module.getId(), (Object)itemListOld);
            }
        }
        return crossVersionTypeMapNew;
    }

    private void traveModules(KeyOrderedHashMap<CrossVersionType, KeyOrderedHashMap<String, List<EvaluItem>>> crossVersionTypeMap, List<Module> moduleListBase, List<EvaluItem> itemListBase, CrossVersionType crossVersionType, List<Module> modules) {
        for (Module module : modules) {
            if (!moduleListBase.contains(module)) {
                moduleListBase.add(module);
                ArrayList itemList = new ArrayList();
                Map moduelMapTmp = (Map)crossVersionTypeMap.get((Object)crossVersionType);
                moduelMapTmp.put(module.getId(), itemList);
            }
            List<EvaluItem> items = module.getItems();
            for (EvaluItem item : items) {
                if (itemListBase.contains(item)) continue;
                itemListBase.add(item);
                Map moduelMapFinal = (Map)crossVersionTypeMap.get((Object)crossVersionType);
                List itemListFinal = (List)moduelMapFinal.get(module.getId());
                itemListFinal.add(item);
            }
        }
    }

    private void buildIndexPage(File resultFolder) {
        File indexFile = new File(resultFolder, HtmlPathEntity.indexOut);
        TemplateFactory.processorFtl(HtmlPathEntity.indexTmplate, new HashMap(0), FilesUtil.getCanonicalPath((File)indexFile));
    }

    private List<RetStatusEntry> genResult4AllDev(List<EvaluDevNode> devs, EvaluItem mergedItem) {
        ArrayList<RetStatusEntry> results = new ArrayList<RetStatusEntry>();
        for (EvaluDevNode dev : devs) {
            RetStatusEntry statusEntry = new RetStatusEntry();
            statusEntry.dev = dev;
            statusEntry.devName = dev.getDeviceName();
            List<EvaluItem> allItemOfDev = dev.getAllEvaluItem();
            int index = allItemOfDev.indexOf(mergedItem);
            if (index >= 0) {
                EvaluItem originalItem = allItemOfDev.get(index);
                ResultItem ret = originalItem.getRetItem();
                ResultFlag flag = ret.getRetFlag();
                switch (flag) {
                    case PASS: {
                        statusEntry.staus = 0;
                        break;
                    }
                    case NOTPASS: {
                        statusEntry.staus = 1;
                        break;
                    }
                    case NOCHECK: {
                        statusEntry.staus = 2;
                        break;
                    }
                    case NOSUPPORT: {
                        statusEntry.staus = 3;
                        break;
                    }
                    case WARN: {
                        statusEntry.staus = 4;
                        break;
                    }
                }
            } else {
                statusEntry.staus = 3;
            }
            results.add(statusEntry);
        }
        return results;
    }

    private String getLegality(List<RetStatusEntry> rets) {
        return rets.size() - this.getUnNormal(rets) + "/" + rets.size();
    }

    private int getUnNormal(List<RetStatusEntry> rets) {
        int unNormalSize = 0;
        for (RetStatusEntry ret : rets) {
            if (1 != ret.staus && 2 != ret.staus && 4 != ret.staus) continue;
            ++unNormalSize;
        }
        return unNormalSize;
    }

    private void copyFileForEService(File resultDir) {
        try {
            String srcDir = this.evaluContext.getHome() + File.separator + ESERVICE_FILES;
            File destDir = new File(FilesUtil.getCanonicalPath((File)resultDir) + File.separator + "pkginfo");
            FileUtils.copyDir((String)srcDir, (String)FilesUtil.getCanonicalPath((File)destDir));
        }
        catch (Exception e) {
            LOGGER.error("copy eService files occured exception:", e);
        }
    }

    private class BatchEvaluation {
        private int index;
        private SummaryEntry first4Father;

        private BatchEvaluation() {
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public SummaryEntry getFirst4Father() {
            return this.first4Father;
        }

        public void setFirst4Father(SummaryEntry first4Father) {
            this.first4Father = first4Father;
        }
    }

    public static class RetStatusEntry {
        private EvaluDevNode dev;
        private String devName;
        private int staus = 2;

        public EvaluDevNode getDev() {
            return this.dev;
        }

        public void setDev(EvaluDevNode dev) {
            this.dev = dev;
        }

        public String getDevName() {
            return this.devName;
        }

        public void setDevName(String devName) {
            this.devName = devName;
        }

        public int getStaus() {
            return this.staus;
        }

        public void setStaus(int staus) {
            this.staus = staus;
        }
    }

    public static class SummaryEntry {
        private int serialNo;
        private String relateId;
        private String summaryGrandFather;
        private int summaryGrandFatherRow = 0;
        private boolean summaryRenderGrand = true;
        private String summaryFather;
        private int summaryFatherRow = 0;
        private boolean summaryRenderFather = true;
        private String checkName;
        private String legalityPercents;
        private boolean rowSpaning;
        private int failedNum;
        private int rowSpan = 0;
        private List<RetStatusEntry> results;

        public int getSerialNo() {
            return this.serialNo;
        }

        public void setSerialNo(int serialNo) {
            this.serialNo = serialNo;
        }

        public String getRelateId() {
            return this.relateId;
        }

        public void setRelateId(String relateId) {
            this.relateId = relateId;
        }

        public String getSummaryGrandFather() {
            return this.summaryGrandFather;
        }

        public void setSummaryGrandFather(String summaryGrandFather) {
            this.summaryGrandFather = summaryGrandFather;
        }

        public int getSummaryGrandFatherRow() {
            return this.summaryGrandFatherRow;
        }

        public void setSummaryGrandFatherRow(int summaryGrandFatherRow) {
            this.summaryGrandFatherRow = summaryGrandFatherRow;
        }

        public boolean isSummaryRenderGrand() {
            return this.summaryRenderGrand;
        }

        public void setSummaryRenderGrand(boolean summaryRenderGrand) {
            this.summaryRenderGrand = summaryRenderGrand;
        }

        public String getSummaryFather() {
            return this.summaryFather;
        }

        public void setSummaryFather(String summaryFather) {
            this.summaryFather = summaryFather;
        }

        public int getSummaryFatherRow() {
            return this.summaryFatherRow;
        }

        public void setSummaryFatherRow(int summaryFatherRow) {
            this.summaryFatherRow = summaryFatherRow;
        }

        public boolean isSummaryRenderFather() {
            return this.summaryRenderFather;
        }

        public void setSummaryRenderFather(boolean summaryRenderFather) {
            this.summaryRenderFather = summaryRenderFather;
        }

        public String getCheckName() {
            return this.checkName;
        }

        public void setCheckName(String checkName) {
            this.checkName = checkName;
        }

        public String getLegalityPercents() {
            return this.legalityPercents;
        }

        public void setLegalityPercents(String legalityPercents) {
            this.legalityPercents = legalityPercents;
        }

        public boolean isRowSpaning() {
            return this.rowSpaning;
        }

        public void setRowSpaning(boolean rowSpaning) {
            this.rowSpaning = rowSpaning;
        }

        public int getFailedNum() {
            return this.failedNum;
        }

        public void setFailedNum(int failedNum) {
            this.failedNum = failedNum;
        }

        public int getRowSpan() {
            return this.rowSpan;
        }

        public void setRowSpan(int rowSpan) {
            this.rowSpan = rowSpan;
        }

        public List<RetStatusEntry> getResults() {
            return this.results;
        }

        public void setResults(List<RetStatusEntry> results) {
            this.results = results;
        }
    }

    public static class SummaryResultItem {
        private String name;
        private int totalNum;
        private int failedNum;

        public SummaryResultItem() {
        }

        public SummaryResultItem(String name, int totalNum, int failedNun) {
            this.name = name;
            this.totalNum = totalNum;
            this.failedNum = failedNun;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getTotalNum() {
            return this.totalNum;
        }

        public void setTotalNum(int totalNum) {
            this.totalNum = totalNum;
        }

        public int getFailedNum() {
            return this.failedNum;
        }

        public void setFailedNum(int failedNum) {
            this.failedNum = failedNum;
        }

        public String toString() {
            return "SummaryResultItem [failedNum=" + this.failedNum + ", name=" + this.name + ", totalNum=" + this.totalNum + "]";
        }
    }

    public static class SummaryResultEntry {
        private String type;
        private List<SummaryResultItem> summaryResultItems = new ArrayList<SummaryResultItem>();

        public SummaryResultEntry(String type) {
            this.type = type;
        }

        public int getParentItemSize() {
            return this.summaryResultItems.size();
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public List<SummaryResultItem> getSummaryResultItems() {
            return this.summaryResultItems;
        }

        public void setSummaryResultItems(List<SummaryResultItem> summaryResultItems) {
            this.summaryResultItems = summaryResultItems;
        }

        public String toString() {
            return "SummaryResultEntry [summaryResultItems=" + this.summaryResultItems + ", type=" + this.type + "]";
        }

        public int getFailedNum() {
            int ret = 0;
            for (SummaryResultItem summaryResultItem : this.summaryResultItems) {
                ret += summaryResultItem.getFailedNum();
            }
            return ret;
        }

        public int getTotalNum() {
            int ret = 0;
            for (SummaryResultItem summaryResultItem : this.summaryResultItems) {
                ret += summaryResultItem.getTotalNum();
            }
            return ret;
        }
    }

    public static class SummaryTotalResultEntry {
        private List<SummaryResultEntry> summaryResultEntryList;

        public SummaryTotalResultEntry(List<SummaryResultEntry> summaryResultEntryList) {
            this.summaryResultEntryList = summaryResultEntryList;
        }

        public int getTotalFailedNum() {
            int ret = 0;
            if (null != this.summaryResultEntryList && !this.summaryResultEntryList.isEmpty()) {
                for (SummaryResultEntry summaryResultEntry : this.summaryResultEntryList) {
                    ret += summaryResultEntry.getFailedNum();
                }
            }
            return ret;
        }

        public int getTotalNum() {
            int ret = 0;
            if (null != this.summaryResultEntryList && !this.summaryResultEntryList.isEmpty()) {
                for (SummaryResultEntry summaryResultEntry : this.summaryResultEntryList) {
                    ret += summaryResultEntry.getTotalNum();
                }
            }
            return ret;
        }
    }

    public static class CollectEntity {
        private String grandFather;
        private int grandFatherRow = 0;
        private boolean renderGrand = true;
        private String father;
        private int fatherRow = 0;
        private boolean renderFather = true;
        private EvaluDevNode dev;
        private String name;

        public String getGrandFather() {
            return this.grandFather;
        }

        public int getGrandFatherRow() {
            return this.grandFatherRow;
        }

        public void setGrandFatherRow(int grandFatherRow) {
            this.grandFatherRow = grandFatherRow;
        }

        public boolean isRenderGrand() {
            return this.renderGrand;
        }

        public void setRenderGrand(boolean renderGrand) {
            this.renderGrand = renderGrand;
        }

        public String getFather() {
            return this.father;
        }

        public void setFather(String father) {
            this.father = father;
        }

        public int getFatherRow() {
            return this.fatherRow;
        }

        public void setFatherRow(int fatherRow) {
            this.fatherRow = fatherRow;
        }

        public boolean isRenderFather() {
            return this.renderFather;
        }

        public void setRenderFather(boolean renderFather) {
            this.renderFather = renderFather;
        }

        public EvaluDevNode getDev() {
            return this.dev;
        }

        public void setDev(EvaluDevNode dev) {
            this.dev = dev;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class HtmlPathEntity {
        private static String deviceTreeTmplate = "devsTree.html";
        private static String deviceTreeOut = "devsTree.html";
        private static String evalCollectTmplate = "evaluCollect.html";
        private static String evalCollectOut = "summary";
        private static String indexTmplate = "index.html";
        private static String indexOut = "index.html";
    }
}

