/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.report;

import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.MruCacheStorage;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.TemplateClassResolver;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Locale;

public final class TemplateFactory {
    private static final String UTF8ENCODE = "UTF-8";
    private static final String TEMPLATE_DICTIONARY = "/config/template/";
    private static final Configuration CONFIGURATION = new Configuration();
    private static final int MAX = 200;

    private TemplateFactory() {
    }

    public static String processorFtl(String ftlPath, Object data) {
        CharArrayWriter arrayWriter = new CharArrayWriter();
        try {
            Template template = CONFIGURATION.getTemplate(ftlPath, UTF8ENCODE);
            template.process(data, arrayWriter);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(TemplateFactory.class).error("build freemarker template faild. path is :" + ftlPath, e);
        }
        arrayWriter.flush();
        return arrayWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean processorFtl(String ftlPath, Object data, String outHtmlFilePath) {
        boolean flag = false;
        BufferedWriter writer = null;
        try {
            File file = new File(outHtmlFilePath);
            FileUtils.createDir((String)file.getParent());
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outHtmlFilePath), ApplicationContext.APP_CHARSET));
            Template template = CONFIGURATION.getTemplate(ftlPath, UTF8ENCODE);
            template.process(data, writer);
            flag = true;
            StreamUtils.closeResource((Flushable)writer, (Closeable)writer);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(TemplateFactory.class).error("build freemarker template faild. path is :" + ftlPath, e);
        }
        finally {
            StreamUtils.closeResource(writer, writer);
        }
        return flag;
    }

    static {
        ClassTemplateLoader classTemplateLoader = new ClassTemplateLoader(TemplateFactory.class, TEMPLATE_DICTIONARY);
        MultiTemplateLoader loader = new MultiTemplateLoader(new TemplateLoader[]{classTemplateLoader});
        CONFIGURATION.setNewBuiltinClassResolver(TemplateClassResolver.SAFER_RESOLVER);
        CONFIGURATION.setCacheStorage(new MruCacheStorage(10, 200));
        CONFIGURATION.setLocale(Locale.getDefault());
        CONFIGURATION.clearEncodingMap();
        CONFIGURATION.setEncoding(Locale.CHINESE, UTF8ENCODE);
        CONFIGURATION.setTemplateLoader(loader);
    }
}

