/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.scene;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.scene.utils.SceneDataExchange;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicemanager.ui.dialog.HyperMetroDevTipsDialog;
import com.huawei.ism.tool.devicemanager.ui.former.XmlFormer;
import com.huawei.ism.tool.devicemanager.ui.listener.ConfirmAction;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneDataSerialize;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneXmlData;
import com.huawei.ism.tool.framework.pubservice.scenedata.UpgradeSceneData;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.entity.UpgradeMode;
import com.huawei.ism.tool.upgradeevalu.scene.PreUpgradeSceneSettingDialogLayout;
import com.huawei.ism.tool.upgradeevalu.scene.SceneDataExtendUtil;
import com.huawei.ism.tool.upgradeevalu.scene.SceneDataHelper;
import com.huawei.ism.tool.upgradeevalu.ui.LoadEvaluItemCallable;
import com.huawei.ism.tool.upgradeevalu.ui.LoadEvaluItemCallableOver;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.ism.tool.upgradeevalu.util.EvaluSceneUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreUpgradeSceneSettingConfirm
implements ActionListener {
    private static final String SRC = "_src";
    private static final String DEST = "_dest";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(PreUpgradeSceneSettingConfirm.class);
    private JDialog dialog = EvaluContext.getInstance().getMainDialog();
    private PreUpgradeSceneSettingDialogLayout layout;

    public PreUpgradeSceneSettingConfirm(PreUpgradeSceneSettingDialogLayout dialogLayout) {
        this.layout = dialogLayout;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.doConfirm();
        }
        catch (Exception e1) {
            LOGGER.error("sceneXml prepared failed", e1);
        }
    }

    private void doConfirm() {
        List<EvaluDevNode> evaluDevs = this.layout.getSelectDevs();
        SceneDataHelper.getInstance().setEvaluDevs(evaluDevs);
        if (this.checkEvaluDevs(evaluDevs)) {
            return;
        }
        List<EvaluDevNode> allDevs = this.layout.getAllDev();
        if (this.checkNotSelectAllDevice(evaluDevs, allDevs)) {
            return;
        }
        ArrayList<DevNode> devs = new ArrayList<DevNode>();
        HashMap<String, UpgradeSceneData> upgradeSettings = new HashMap<String, UpgradeSceneData>();
        HashMap<String, Map<String, String>> sceneDataExtMap = new HashMap<String, Map<String, String>>();
        if (!this.checkUpgradePath(evaluDevs)) {
            LOGGER.error("can not match product package.");
            return;
        }
        this.sceneUpgradeEvalu(evaluDevs, devs, upgradeSettings, sceneDataExtMap);
        LOGGER.info(String.format(Locale.ENGLISH, "Scene Upgrade evaluation: upgradeSettings :%s", upgradeSettings));
        SceneDataSerialize dataOperate = new SceneDataSerialize();
        dataOperate.serialize(upgradeSettings);
        SceneDataExtendUtil.getInstance().saveSceneDataExt(sceneDataExtMap);
        LOGGER.info(String.format(Locale.ENGLISH, "Scene Upgrade evaluation: sceneDataExtMap:%s", sceneDataExtMap));
        HashMap data = new HashMap();
        if (this.openHyperMetroDevTipsDialog(devs)) {
            return;
        }
        if (EvaluContext.isDisableModifySetting()) {
            LoggerFactory.getLogger(this.getClass()).info("not need modify device info");
            EvaluContext.getInstance().fireToolStopped();
            EvaluContext.getInstance().getMainDialog().dispose();
            return;
        }
        XmlFormer xmlFormer = new XmlFormer();
        List listMap = xmlFormer.injectDeviceData(devs);
        TaskResult result = SceneXmlData.getInstance().writeDevData2File(devs, listMap);
        LOGGER.info("call finishedSceneTask");
        try {
            LOGGER.info("initSceneEnvir");
            new EvaluSceneUtils().finishedSceneTask(evaluDevs);
        }
        catch (Exception e) {
            LOGGER.error("write scene data error.");
        }
        this.dealResult(result);
    }

    private void dealResult(TaskResult result) {
        if (result.getResult() == TaskResult.Result.SUCCESS) {
            EvaluContext.getInstance().getMainDialog().dispose();
            LoggerFactory.getLogger(this.getClass()).info("scene prepared ok.");
            EvaluContext.getInstance().fireToolStopped();
        } else {
            LOGGER.error("scene prepared failed");
            DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"scene.remind.writeData.failed"));
        }
    }

    private boolean openHyperMetroDevTipsDialog(List<DevNode> devs) {
        try {
            HyperMetroDevTipsDialog hydevTipsdialog;
            Map data;
            if (this.checkMethodExist() && !(data = ConfirmAction.needOpenHyperMetroDevTipsDialog(devs, new ArrayList())).isEmpty() && null != (hydevTipsdialog = ConfirmAction.openHyperMetroDevTipsDialog((Map)data, new HashMap())) && !hydevTipsdialog.isOkPerformed()) {
                EvaluSceneUtils.setHyperMetro(true);
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("needOpenHyperMetroDevTipsDialog and openHyperMetroDevTipsDialog method are not exist.");
        }
        return false;
    }

    private boolean checkNotSelectAllDevice(List<EvaluDevNode> evaluDevs, List<EvaluDevNode> allDevs) {
        WarningDialog wd;
        int userChoice;
        if (allDevs.size() != evaluDevs.size() && 0 != (userChoice = (wd = DialogUtils.showYesNoDialog((Window)this.dialog, (String)ResourceUtil.getString((String)"arrayupgrade.scene.notselectalldevice"))).getValue())) {
            LOGGER.info("has no selected devices, cancel the operation.");
            return true;
        }
        return false;
    }

    private boolean checkEvaluDevs(List<EvaluDevNode> evaluDevs) {
        if (null == evaluDevs || evaluDevs.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"arrayupgrade.scene.selectnodevice"));
            return true;
        }
        if (this.existMutexAllUpgrade(evaluDevs)) {
            DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"secondaryupgrade.scene.existAllUpgrade"));
            return true;
        }
        if (this.existOnlyContainerUpgradeMode(evaluDevs)) {
            DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"secondaryupgrade.scene.existContainerUpgradeModel"));
            return true;
        }
        if (this.existMutexUpgradeMode(evaluDevs)) {
            DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"arrayupgrade.scene.existMutexUpgradeModel"));
            return true;
        }
        return false;
    }

    private void sceneUpgradeEvalu(List<EvaluDevNode> evaluDevs, List<DevNode> devs, Map<String, UpgradeSceneData> upgradeSettings, Map<String, Map<String, String>> sceneDataExtMap) {
        for (EvaluDevNode evaluDev : evaluDevs) {
            UpgradeSceneData data = new UpgradeSceneData();
            data.setTargetVersion(evaluDev.getDestVersion());
            data.setUpgradeMode(evaluDev.getUpgradeModeUI().name());
            if (evaluDev.isStorageImageUpgrade()) {
                data.setContainerUpgradeMode(evaluDev.getContainerUpgradeModeUI().name());
                data.setContainerDestVersion(evaluDev.getContainerDestVersion());
                data.setStorageImageUpgrade(true);
            }
            if (ApplicationContext.getInstance().isSpecificDeviceMode() && !StringUtils.isNULLStr((String)evaluDev.getSvpIp())) {
                evaluDev.setIp(evaluDev.getSvpIp());
            }
            String key = evaluDev.getIp() + "_" + evaluDev.getDeviceSerialNumber();
            upgradeSettings.put(key, data);
            devs.add(evaluDev);
            String keySn = evaluDev.getDeviceSerialNumber();
            SceneDataExchange.getInstance().saveKV(keySn + DEST, evaluDev.getDestVersion());
            SceneDataExchange.getInstance().saveKV(keySn + SRC, evaluDev.getProductVersion());
            HashMap<String, String> devSceneDataExtMap = new HashMap<String, String>();
            devSceneDataExtMap.put("isFastAndRollType", String.valueOf(evaluDev.isFastAndRollType()));
            devSceneDataExtMap.put("supportFast", String.valueOf(evaluDev.isSupportFast()));
            devSceneDataExtMap.put("stopBusiness", String.valueOf(evaluDev.isStopHostBusiness()));
            devSceneDataExtMap.put("supportShareCard", String.valueOf(evaluDev.isSupportShareCardUpgrade()));
            devSceneDataExtMap.put("currentKernelVersion", String.valueOf(evaluDev.getDeviceKernelVersion()));
            devSceneDataExtMap.put("targetKernelVersion", String.valueOf(evaluDev.getTargetKernelVersion()));
            devSceneDataExtMap.put("supportApollo", String.valueOf(evaluDev.isSupportApollo()));
            devSceneDataExtMap.put("containerVersion", evaluDev.getContainerVersion());
            devSceneDataExtMap.put("containerDestVersion", evaluDev.getContainerDestVersion());
            devSceneDataExtMap.put("isSecondaryUpgrade", String.valueOf(evaluDev.isSecondaryUpgrade()));
            devSceneDataExtMap.put("isAllUpgrade", String.valueOf(evaluDev.isStorageImageUpgrade()));
            sceneDataExtMap.put(key, devSceneDataExtMap);
        }
    }

    private boolean checkMethodExist() throws NoSuchMethodException {
        return ConfirmAction.class.getMethod("needOpenHyperMetroDevTipsDialog", List.class, List.class) != null && ConfirmAction.class.getMethod("openHyperMetroDevTipsDialog", Map.class, Map.class) != null;
    }

    private boolean checkUpgradePath(EvaluDevNode evaluDev) {
        List retList = AsyncExcutor.execute((Window)this.dialog, (boolean)true, (long)50000L, (Callable[])new Callable[]{new LoadEvaluItemCallable(evaluDev)});
        if (retList.isEmpty()) {
            DialogUtils.showErrorDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"evalu.ui.card.addStrategy.execute.timeout"));
            return false;
        }
        if (!((LoadEvaluItemCallableOver)retList.get(0)).getSuccess().booleanValue()) {
            String resultId = ((LoadEvaluItemCallableOver)retList.get(0)).getResult().getResultId();
            DialogUtils.showErrorDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)resultId));
            return false;
        }
        return true;
    }

    private boolean checkUpgradePath(List<EvaluDevNode> evaluDevs) {
        List retList = AsyncExcutor.execute((Window)this.dialog, (boolean)true, (long)50000L, (Callable[])new Callable[]{new LoadEvaluItemCallable(evaluDevs)});
        if (retList.isEmpty()) {
            DialogUtils.showErrorDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"evalu.ui.card.addStrategy.execute.timeout"));
            return false;
        }
        if (!((LoadEvaluItemCallableOver)retList.get(0)).getSuccess().booleanValue()) {
            String resultId = ((LoadEvaluItemCallableOver)retList.get(0)).getResult().getResultId();
            DialogUtils.showErrorDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)resultId));
            return false;
        }
        return true;
    }

    private boolean existMutexUpgradeMode(List<EvaluDevNode> evaluDevs) {
        boolean existFast = false;
        boolean existOther = false;
        for (EvaluDevNode evaluDev : evaluDevs) {
            if (evaluDev.getUpgradeModeUI() == UpgradeMode.FAST) {
                existFast = true;
                continue;
            }
            existOther = true;
        }
        return existFast && existOther;
    }

    private boolean existOnlyContainerUpgradeMode(List<EvaluDevNode> evaluDevs) {
        boolean existFast = false;
        boolean existOther = false;
        for (EvaluDevNode evaluDev : evaluDevs) {
            if (evaluDev.getUpgradeModeUI() == UpgradeMode.PATCH_CONTAINER || evaluDev.getUpgradeModeUI() == UpgradeMode.OFFLINE_CONTAINER) {
                existFast = true;
                continue;
            }
            existOther = true;
        }
        return existFast && existOther;
    }

    private boolean existMutexAllUpgrade(List<EvaluDevNode> evaluDevs) {
        boolean existAll = false;
        boolean existOther = false;
        for (EvaluDevNode evaluDevNode : evaluDevs) {
            if (evaluDevNode.isStorageImageUpgrade()) {
                existAll = true;
                continue;
            }
            existOther = true;
        }
        return existAll && existOther;
    }
}

