/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.scene;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicemanager.ui.listener.DirSetupButtonListener;
import com.huawei.ism.tool.devicemanager.ui.listener.ScenePreparedMainJDialogListener;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.ui.tablecompositer.IpAddressStrategy;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.tool.upgradeevalu.config.ParseConfCallable;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluItem;
import com.huawei.ism.tool.upgradeevalu.entity.UpgradeMode;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluDevManager;
import com.huawei.ism.tool.upgradeevalu.scene.PreUpgradeSceneSettingConfirm;
import com.huawei.ism.tool.upgradeevalu.scene.PreUpgradeSceneSettingDialogLayout;
import com.huawei.ism.tool.upgradeevalu.scene.SceneDataHelper;
import com.huawei.ism.tool.upgradeevalu.ui.DevModifyOperationDialog;
import com.huawei.ism.tool.upgradeevalu.ui.IUiObserver;
import com.huawei.ism.tool.upgradeevalu.ui.LoadEvaluItemCallable;
import com.huawei.ism.tool.upgradeevalu.ui.action.AddDeviceAction;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.ism.tool.upgradeevalu.util.EvaluSceneUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreUpgradeSceneSettingDialog
extends JDialog {
    private static final long serialVersionUID = -6813033382538360074L;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(PreUpgradeSceneSettingDialog.class);
    private static final Dimension WIZARD_SIZE_1100X685 = new Dimension(1100, 585);
    private EvaluContext evaluContext = EvaluContext.getInstance();
    private PreUpgradeSceneSettingDialogLayout dialogLayout;
    private transient DeviceTableAction deviceTableAction;
    private SceneDataHelper sceneDataHelper = SceneDataHelper.getInstance();
    private transient EvaluDevManager devMgr = EvaluDevManager.getInstance();

    public PreUpgradeSceneSettingDialog(Window parentFrame) {
        super(parentFrame);
        this.evaluContext.setMainDialog(this);
        this.evaluContext.setUiObserver(new UpdateUIObserver());
        if (EvaluContext.isDisableModifySetting()) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"arrayupgrade.scene.add.device.tip"));
        }
        this.initUI();
        this.initListener();
    }

    public void loadCfg() {
        List<EvaluDevNode> sceneDevs = this.sceneDataHelper.loadSceneData();
        LOGGER.info(String.format(Locale.ENGLISH, "init sceneDevs size=%s", sceneDevs.size()));
        for (EvaluDevNode evaluDev : sceneDevs) {
            this.deviceTableAction.addDevNodeToTable(evaluDev);
        }
        EvaluDevManager.getInstance().getTabDevs().clear();
        EvaluDevManager.getInstance().getTabDevs().addAll(sceneDevs);
        AsyncExcutor.execute((Window)this, (boolean)false, (long)50000L, (Callable[])new Callable[]{new ParseConfCallable(), new LoadEvaluItemCallable(sceneDevs)});
    }

    private void initUI() {
        UiMethod.setComponentSize((Dimension)WIZARD_SIZE_1100X685, (Component[])new Component[]{this});
        this.dialogLayout = new PreUpgradeSceneSettingDialogLayout();
        this.deviceTableAction = new DeviceTableAction();
        this.add(this.dialogLayout);
        this.setTitle(ResourceUtil.getString((String)"arrayupgrade.scenesetting.funcitem.name"));
        this.setModal(true);
        this.pack();
        this.setDefaultCloseOperation(0);
        SwingUtil.putScreenCenter((Window)this);
        this.setIconImage(ResourceUtil.getImage((String)"upgradeEvaluation.png").getImage());
    }

    private void initListener() {
        this.addWindowListener((WindowListener)new ScenePreparedMainJDialogListener(this){

            public void okCallback() {
                EvaluContext.getInstance().fireToolStopped();
            }

            public void cancelCallback() {
                PreUpgradeSceneSettingDialog.this.setDefaultCloseOperation(0);
            }
        });
        this.dialogLayout.getAddDeviceBtn().addActionListener(new AddDeviceAction());
        this.dialogLayout.getSetPathButton().addActionListener((ActionListener)new DirSetupButtonListener(this, this.dialogLayout.getSavePathText().getText()){

            public void callback(String path) {
                PreUpgradeSceneSettingDialog.this.dialogLayout.getSavePathText().setText(path);
                PreUpgradeSceneSettingDialog.this.dialogLayout.getSavePathText().setToolTipText(path);
                ApplicationContext.getInstance().setFilePath(path);
            }
        });
        this.dialogLayout.getOkBtn().addActionListener(new PreUpgradeSceneSettingConfirm(this.dialogLayout));
        this.dialogLayout.getCancleBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EvaluContext.getInstance().fireToolStopped();
                PreUpgradeSceneSettingDialog.this.dispose();
                LoggerFactory.getLogger(this.getClass()).info("scene tool exit.");
            }
        });
    }

    public class UpdateUIObserver
    implements IUiObserver {
        @Override
        public void updateDevTableRow(EvaluDevNode dev) {
            PreUpgradeSceneSettingDialog.this.deviceTableAction.updateTableRow(dev);
        }

        @Override
        public void updateDetailList(EvaluItem item) {
        }

        @Override
        public void addDev2Table(List<EvaluDevNode> evaludevs) {
            for (EvaluDevNode evaluDev : evaludevs) {
                PreUpgradeSceneSettingDialog.this.deviceTableAction.addDevNodeToTable(evaluDev);
            }
            PreUpgradeSceneSettingDialog.this.devMgr.addTabDevs(evaludevs);
        }

        @Override
        public void finishAll() {
        }

        @Override
        public void refreshDetailList(boolean isRewriteDetail) {
        }

        @Override
        public void showTaskErr(String errMsg) {
        }

        @Override
        public void evaluProcessTip(String msg) {
        }

        @Override
        public void refreshLoadingPic() {
        }

        @Override
        public void updateItemProgress(EvaluDevNode dev, int progress, String itemId) {
        }

        @Override
        public void updateItemProgress(EvaluDevNode dev, int progress, String timeLeft, String itemId) {
        }

        @Override
        public void updateChildItems(EvaluDevNode evaluDev, String itemId, Map<String, Object> jsonMsg) {
        }
    }

    public class DeviceTableAction {
        private IsmTable deviceTable;
        DefaultTableModel tableModel;

        public DeviceTableAction() {
            this.deviceTable = PreUpgradeSceneSettingDialog.this.dialogLayout.getDeviceTable();
            this.tableModel = (DefaultTableModel)this.deviceTable.getModel();
        }

        private void tableRowRender(TableRow row, EvaluDevNode evaluDev) {
            row.setValueAt(0, (Object)evaluDev.getDeviceName());
            if (evaluDev.isHyperMetro()) {
                IsmTableCell.TextIconCell cell = new IsmTableCell.TextIconCell(evaluDev.getDeviceType().toString(), (Icon)ResourceUtil.getImage((String)"hyperMetroIcon.png"));
                String sns = evaluDev.getRemoteSNs().toString();
                sns = sns.substring(sns.indexOf(91) + 1, sns.indexOf(93));
                sns = EvaluSceneUtils.cutTooLongSns2Lines(sns);
                cell.setTips(ResourceUtil.getStringWithParams((String)"devicemanager.layout.hypermetro.device.tips", (Object[])new Object[]{sns}));
                row.setValueAt(1, (Object)cell);
            } else {
                row.setValueAt(1, (Object)evaluDev.getDeviceType());
            }
            if (ApplicationContext.getInstance().isSpecificDeviceMode() && !StringUtils.isNULLStr((String)evaluDev.getSvpIp())) {
                row.setValueAt(2, (Object)new IpAddressStrategy(evaluDev.getSvpIp()));
            } else {
                row.setValueAt(2, (Object)new IpAddressStrategy(evaluDev.getIp()));
            }
            row.setValueAt(3, (Object)evaluDev.getDeviceSerialNumber());
            String currentVersion = evaluDev.getProductVersion();
            String targetVersion = evaluDev.getDestVersion();
            if (evaluDev.getUpgradeMode() == UpgradeMode.APOLLO) {
                currentVersion = currentVersion + String.format(Locale.ROOT, ResourceUtil.getString((String)"evalu.ui.mainWindow.table.content.kernelversion"), evaluDev.getDeviceKernelVersion());
                targetVersion = targetVersion + String.format(Locale.ROOT, ResourceUtil.getString((String)"evalu.ui.mainWindow.table.content.kernelversion"), evaluDev.getTargetKernelVersion());
            } else if (evaluDev.getUpgradeMode() == UpgradeMode.PATCH_CONTAINER || evaluDev.getUpgradeMode() == UpgradeMode.OFFLINE_CONTAINER) {
                currentVersion = evaluDev.getContainerVersion();
            }
            row.setValueAt(4, (Object)currentVersion);
            row.setValueAt(5, (Object)targetVersion);
            row.setValueAt(6, (Object)evaluDev.getUpgradeModeUI().getDesc());
            row.setValueAt(7, this.upgradeSetColumnRender(evaluDev));
        }

        private Object upgradeSetColumnRender(EvaluDevNode evaluDevNode) {
            String cellName = ResourceUtil.getString((String)"evalu.ui.tabel.row.update");
            IsmTableCell.HyperlinkCell modifyCell = new IsmTableCell.HyperlinkCell(cellName, (ActionListener)new ModifyConfigActionListener(evaluDevNode));
            return modifyCell;
        }

        public void createTableRow(EvaluDevNode upgradeDev) {
            DefaultTableRow row = new DefaultTableRow(8, (Object)upgradeDev, (Object)upgradeDev);
            this.tableRowRender((TableRow)row, upgradeDev);
            this.tableModel.addRow(new TableRow[]{row});
        }

        public void updateTableRow(EvaluDevNode upgradeDev) {
            TableRow row = this.tableModel.getTableRowBy((Object)upgradeDev);
            if (row == null) {
                return;
            }
            this.tableRowRender(row, upgradeDev);
            this.deviceTable.repaint();
        }

        public void addDevNodeToTable(EvaluDevNode devNodeInfo) {
            this.createTableRow(devNodeInfo);
            int rowNum = this.deviceTable.getRowCount() - 1;
            this.deviceTable.addRowSelectionInterval(rowNum, rowNum);
        }

        public List<EvaluDevNode> getAllDev() {
            ArrayList<EvaluDevNode> devs = new ArrayList<EvaluDevNode>();
            List rows = this.deviceTable.getAllRows();
            for (TableRow row : rows) {
                devs.add((EvaluDevNode)((Object)row.getUserObject()));
            }
            return devs;
        }

        private class ModifyConfigActionListener
        implements ActionListener {
            private EvaluDevNode evaluDevNode;

            public ModifyConfigActionListener(EvaluDevNode evaluDevNode) {
                this.evaluDevNode = evaluDevNode;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                DevModifyOperationDialog devModeifyOper = new DevModifyOperationDialog(PreUpgradeSceneSettingDialog.this, this.evaluDevNode, new UpdateUIObserver());
                SwingUtil.putParentCenter((Window)devModeifyOper, (Window)PreUpgradeSceneSettingDialog.this);
                devModeifyOper.setVisible(true);
            }
        }
    }
}

