/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.scene;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.SystemEnvUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.scenedata.ScenePrepareProxyRequest;
import com.huawei.ism.tool.framework.pubservice.scenedata.ScenePrepareProxyResponse;
import com.huawei.ism.tool.service.common.ToolThreadFactory;
import com.huawei.ism.tool.upgradeevalu.config.ProductParser;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluMode;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluDevManager;
import com.huawei.ism.tool.upgradeevalu.scene.PreUpgradeSceneSettingDialog;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import java.awt.Window;
import java.io.File;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Locale;
import org.slf4j.Logger;

public class PreUpgradeSceneSettingStart {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(PreUpgradeSceneSettingStart.class);
    private EvaluContext evaluContext = EvaluContext.getInstance();
    private PreUpgradeSceneSettingDialog mainDialog = null;
    private static final String TOOLKIT_PATH = ApplicationContext.getInstance().getWorkPath();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScenePrepareProxyResponse open(ScenePrepareProxyRequest request) {
        LOGGER.info("begin to open scene setting dialog in upgradeEvalu.jar");
        URL url = null;
        try {
            StringBuilder workDir = new StringBuilder().append(TOOLKIT_PATH).append(File.separator).append("tools").append(File.separator).append("upgradeEvaluation").append(File.separator);
            String jarPath = this.getJarPath(workDir + File.separator + "lib", "pyframe.jar");
            url = new URL("jar:file:" + File.separator + jarPath + "!/");
            this.loadJar(url);
            this.initTool();
            this.evaluContext.setProxyResponse(new ScenePrepareProxyResponse());
            this.initNeedOpenVersions();
            this.evaluContext.setEvaluMode(EvaluMode.LINK);
            EvaluContext.setAutoAddDevice(true);
            EvaluContext.setDisableModifySetting(request.isTaskInRuning());
            this.initUpgradeEval(request.getParent());
            if (null != url) {
                this.uninstallJar(url);
            }
        }
        catch (Exception e) {
            LOGGER.error("open preupgrade scene setting dialog exception.", e);
        }
        finally {
            if (null != url) {
                this.uninstallJar(url);
            }
        }
        return this.evaluContext.getProxyResponse();
    }

    private void loadJar(URL url) {
        try {
            LOGGER.info("load jar");
            URLClassLoader urlLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Class<URLClassLoader> sysclass = URLClassLoader.class;
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)urlLoader, url);
        }
        catch (Exception e) {
            LOGGER.error("load jar error.", e);
        }
    }

    private String getJarPath(String workDir, String jarName) {
        String sourceFile = workDir + File.separator + jarName;
        String targetFile = TOOLKIT_PATH + File.separator + "tmp" + File.separator + jarName;
        LOGGER.info(String.format(Locale.ENGLISH, "sourceFile=%s,targetFile=%s", sourceFile, targetFile));
        StreamUtils.copyFile((File)new File(sourceFile), (File)new File(targetFile));
        if (new File(targetFile).exists()) {
            LOGGER.info("copy upgradeEvalu jar file success.");
            return targetFile;
        }
        return sourceFile;
    }

    private void uninstallJar(URL url) {
        try {
            LOGGER.info("begin to uninstall jar.");
            URLConnection uc = url.openConnection();
            LOGGER.info(String.format(Locale.ENGLISH, "actual type=%s", uc.getClass().getName()));
            if (uc instanceof JarURLConnection) {
                LOGGER.info("is jarurlconnection.");
                uc.setUseCaches(true);
                ((JarURLConnection)uc).getManifest();
                ((JarURLConnection)uc).getJarFile().close();
            }
        }
        catch (Exception e) {
            LOGGER.error("uninstall jar error.", e);
        }
    }

    private void initTool() {
        File tmpDir = new File(this.evaluContext.getHome() + File.separator + "tmp");
        FileUtils.createDir((File)tmpDir);
        this.evaluContext.setTmpDir(tmpDir);
        File tempDir = new File(SystemEnvUtil.getDefaultUserDir() + File.separator + "temp");
        FileUtils.createDir((File)tempDir);
        File reportDir = this.evaluContext.getReportDir();
        FileUtils.createDir((File)reportDir);
        File htmlDir = this.evaluContext.getHtmlDir();
        FileUtils.createDir((File)htmlDir);
        EvaluDevManager.getInstance().getTabDevs().clear();
    }

    private void initNeedOpenVersions() {
        EvaluContext.getInstance().setNeedOpenVersions(ProductParser.getInstance().loadOpenTlvProduct());
    }

    private void initUpgradeEval(Window parent) {
        this.mainDialog = new PreUpgradeSceneSettingDialog(parent);
        UiMethod.putScreenCenter((Window)this.mainDialog);
        ToolThreadFactory.newDefaultThread((Runnable)new LoadProductConfig(this.mainDialog)).start();
        this.mainDialog.setVisible(true);
    }

    private static final class LoadProductConfig
    implements Runnable {
        private final PreUpgradeSceneSettingDialog mainDialog;

        private LoadProductConfig(PreUpgradeSceneSettingDialog mainDialog) {
            this.mainDialog = mainDialog;
        }

        @Override
        public void run() {
            Thread.currentThread().setName("load-product-config");
            this.mainDialog.loadCfg();
        }
    }
}

