/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.scene;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.base.utils.XmlWriter;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.upgradeevalu.utils.ToolConstants;
import java.io.File;
import java.io.FileNotFoundException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SceneDataExtendUtil {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SceneDataExtendUtil.class);
    private static final SceneDataExtendUtil INSTANCE = new SceneDataExtendUtil();
    private static final String DEVICE_INFO = "deviceInfo";
    private static final String DEVICE_ID = "id";
    private static final String UPDATE_TIME = "updateTime";
    private static String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final long TIME_0UT_DAYS = 1L;
    private static final String SCENE_DATA_EXT_PATH = SceneUtils.getSceneFilePath((String)"sceneSettingDataExtend.xml");
    private static DocumentBuilder documentBuilder = null;

    private SceneDataExtendUtil() {
    }

    public static SceneDataExtendUtil getInstance() {
        return INSTANCE;
    }

    private String getDateTimeString() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DATETIME_PATTERN);
        return formatter.format(LocalDateTime.now());
    }

    private LocalDateTime parseDateTimeString(String dateTimeString) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DATETIME_PATTERN);
        return LocalDateTime.parse(dateTimeString, formatter);
    }

    private Boolean isTimeOut(String dateTimeString) {
        try {
            return Duration.between(this.parseDateTimeString(dateTimeString), LocalDateTime.now()).toDays() >= 1L;
        }
        catch (Exception e) {
            return true;
        }
    }

    public boolean saveSceneDataExt(Map<String, Map<String, String>> sceneDataExtMap) {
        try {
            Document sceneDataExtDoc = XmlWriter.createNewDocument();
            Element dataRoot = XmlWriter.createTagElement((Document)sceneDataExtDoc, (String)"root");
            for (Map.Entry<String, Map<String, String>> devSceneData : sceneDataExtMap.entrySet()) {
                Element deviceElem = XmlWriter.createTagElement((Document)sceneDataExtDoc, (String)DEVICE_INFO);
                deviceElem.setAttribute(DEVICE_ID, devSceneData.getKey());
                deviceElem.setAttribute(UPDATE_TIME, this.getDateTimeString());
                for (Map.Entry<String, String> sceneData : devSceneData.getValue().entrySet()) {
                    Element testElem = XmlWriter.createTagElement((Document)sceneDataExtDoc, (String)sceneData.getKey(), (String)sceneData.getValue());
                    deviceElem.appendChild(testElem);
                }
                dataRoot.appendChild(deviceElem);
            }
            sceneDataExtDoc.appendChild(dataRoot);
            XmlWriter.writeDomToXmlFile((Document)sceneDataExtDoc, (String)SCENE_DATA_EXT_PATH, (boolean)true);
        }
        catch (ToolException e) {
            LOGGER.error("write dom to xml file exception:", e);
            return false;
        }
        return true;
    }

    public Map<String, String> getCheckedHostIdResultMap(String ip, String sn) {
        HashMap<String, String> hostResultMap = new HashMap<String, String>();
        Map<String, Map<String, String>> parseData = this.parseSceneDataExt(true);
        if (parseData == null) {
            return hostResultMap;
        }
        Map<String, String> hostExtData = parseData.get(ip + "_" + sn);
        for (ToolConstants.CheckResultE resE : ToolConstants.CheckResultE.values()) {
            for (String hostId : hostExtData.get(resE.getFieldKey()).split(",")) {
                if (StringUtils.isNULLStr((String)hostId)) continue;
                hostResultMap.put(hostId, resE.getStatusValue());
            }
        }
        return hostResultMap;
    }

    public HashSet<String> getCheckedHosts(String ip, String sn) {
        HashSet<String> set = new HashSet<String>();
        Map<String, Map<String, String>> parseData = this.parseSceneDataExt(true);
        if (parseData == null) {
            return set;
        }
        Map<String, String> hostExtData = parseData.get(ip + "_" + sn);
        LOGGER.info("getCheckedHosts hostExtData:{}", (Object)hostExtData);
        if (hostExtData == null) {
            return set;
        }
        for (String hostId : hostExtData.get(ToolConstants.CheckResultE.SUCCESS.getFieldKey()).split(",")) {
            if (StringUtils.isNULLStr((String)hostId)) continue;
            set.add(hostId);
        }
        for (String hostId : hostExtData.get(ToolConstants.CheckResultE.FAIL.getFieldKey()).split(",")) {
            if (StringUtils.isNULLStr((String)hostId)) continue;
            set.add(hostId);
        }
        LOGGER.info("getCheckedHosts ret:{}, ip:{}, sn:{}", set.toString(), ip, sn);
        return set;
    }

    public Map<String, Map<String, String>> parseSceneDataExt() {
        return this.parseSceneDataExt(true);
    }

    private Map<String, Map<String, String>> parseSceneDataExt(Boolean judgeTimeOut) {
        HashMap<String, Map<String, String>> sceneDataExtMap = new HashMap<String, Map<String, String>>();
        Document doc = this.getDoc();
        if (null == doc) {
            LOGGER.error("Could not found file.");
            return null;
        }
        Element root = doc.getDocumentElement();
        NodeList deviceInfoData = root.getElementsByTagName(DEVICE_INFO);
        for (int i = 0; i < deviceInfoData.getLength(); ++i) {
            String updateTimeString;
            Node deviceinfoNode = deviceInfoData.item(i);
            HashMap<String, String> deviceInfoMap = new HashMap<String, String>();
            if (!(deviceinfoNode instanceof Element)) continue;
            for (Element infoData : XmlUtils.getChildren((Element)((Element)deviceinfoNode))) {
                String infoKey = infoData.getTagName();
                String infoValue = infoData.getTextContent();
                deviceInfoMap.put(infoKey, infoValue);
            }
            String key = ((Element)deviceinfoNode).getAttribute(DEVICE_ID);
            sceneDataExtMap.put(key, deviceInfoMap);
            if (judgeTimeOut.booleanValue() && this.isTimeOut(updateTimeString = ((Element)deviceinfoNode).getAttribute(UPDATE_TIME)).booleanValue()) {
                LOGGER.info("SceneDataExt timeout. DEVICE_ID:{}", (Object)DEVICE_ID);
                this.clearHostCheckData(deviceInfoMap);
            }
            this.initHostCheckDataIfAbsent(deviceInfoMap);
        }
        return sceneDataExtMap;
    }

    private void initHostCheckDataIfAbsent(Map<String, String> deviceInfoMap) {
        for (ToolConstants.CheckResultE itemE : ToolConstants.CheckResultE.values()) {
            deviceInfoMap.putIfAbsent(itemE.getFieldKey(), "");
        }
    }

    private void clearHostCheckData(Map<String, String> deviceInfoMap) {
        for (ToolConstants.CheckResultE itemE : ToolConstants.CheckResultE.values()) {
            deviceInfoMap.put(itemE.getFieldKey(), "");
        }
    }

    private Document getDoc() {
        try {
            documentBuilder = XmlUtils.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LoggerFactory.getLogger(XmlUtils.class).error("documentBuilder build faild", e);
        }
        Document doc = null;
        try {
            File file = new File(SCENE_DATA_EXT_PATH);
            doc = documentBuilder.parse(file);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("File sceneSettingDataExtend.xml not found.");
        }
        catch (Exception e) {
            LOGGER.error("Could not found the file.", e);
        }
        return doc;
    }
}

