/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.scene;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.DeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.ToolSceneData;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneDataSerialize;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneXmlData;
import com.huawei.ism.tool.framework.pubservice.scenedata.UpgradeSceneData;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.entity.UpgradeMode;
import com.huawei.ism.tool.upgradeevalu.scene.SceneDataExtendUtil;
import com.huawei.ism.tool.upgradeevalu.util.EvaluCommUtil;
import com.huawei.ism.tool.upgradeevalu.util.EvaluSceneUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;

public class SceneDataHelper
implements Serializable {
    private static final long serialVersionUID = 2605192776217772677L;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SceneDataHelper.class);
    public static final String IS_FAST_AND_ROLL_TYPE = "isFastAndRollType";
    public static final String SUPPORT_FAST = "supportFast";
    public static final String STOP_BUSINESS = "stopBusiness";
    public static final String CURRENT_KERNEL_VERSION = "currentKernelVersion";
    public static final String TARGET_KERNEL_VERSION = "targetKernelVersion";
    public static final String SUPPORT_APOLLO = "supportApollo";
    public static final String CONTAINER_VERSION = "containerVersion";
    public static final String CONTAINER_DEST_VERSION = "containerDestVersion";
    public static final String IS_SECONDARY_UPGRADE = "isSecondaryUpgrade";
    public static final String IS_ALL_UPGRADE = "isAllUpgrade";
    public static final String SUPPORT_SHARE_CARD = "supportShareCard";
    public static final String SCENE_UP_ARRAY_EVALUATION = "array";
    public static final String SCENE_UP_CONTAINER_EVALUATION = "container";
    private static SceneDataHelper instance;
    private List<EvaluDevNode> evaluDevs = new ArrayList<EvaluDevNode>();
    private static final String COLLECT_TOOL_NAME = "collect";

    public static SceneDataHelper getInstance() {
        if (null == instance) {
            instance = new SceneDataHelper();
        }
        return instance;
    }

    private SceneDataHelper() {
    }

    public List<EvaluDevNode> getEvaluDevs() {
        return this.evaluDevs;
    }

    public void setEvaluDevs(List<EvaluDevNode> evaluDevs) {
        this.evaluDevs = evaluDevs;
    }

    public List<EvaluDevNode> loadSceneData() {
        ArrayList<EvaluDevNode> evaludevs = new ArrayList<EvaluDevNode>();
        try {
            List devsXML = SceneXmlData.getInstance().loadSceneFromFile();
            SceneDataSerialize dataOperate = new SceneDataSerialize();
            Map upgradeSettings = (Map)dataOperate.deserialize();
            Map<String, Map<String, String>> sceneDataExtMap = SceneDataExtendUtil.getInstance().parseSceneDataExt();
            if (null == devsXML || devsXML.isEmpty() || null == upgradeSettings) {
                LOGGER.info("the scenedata is empty.");
                return evaludevs;
            }
            String sceneArg = EvaluSceneUtils.getSceneArg();
            for (DevNode devNode : devsXML) {
                Map<String, String> devSceneDataExt;
                String key = devNode.getIp() + "_" + devNode.getDeviceSerialNumber();
                UpgradeSceneData data = (UpgradeSceneData)upgradeSettings.get(key);
                if (null == data) {
                    LOGGER.info(String.format(Locale.ENGLISH, "scenedata can not find the key=%s", key));
                    continue;
                }
                EvaluDevNode evaluDev = new EvaluDevNode(devNode);
                if (ApplicationContext.getInstance().isSpecificDeviceMode()) {
                    evaluDev.setSvpIp(devNode.getIp());
                    evaluDev.setIp((String)devNode.getIpList().get(0));
                }
                this.saveUpgradeSceneData(sceneArg, devNode, data, evaluDev);
                evaludevs.add(evaluDev);
                if (null == sceneDataExtMap || null == (devSceneDataExt = sceneDataExtMap.get(key))) continue;
                this.saveSceneDataExt(evaluDev, devSceneDataExt, sceneArg);
            }
        }
        catch (Exception e) {
            LOGGER.error("load scene data exception.", e);
        }
        return evaludevs;
    }

    private void saveSceneDataExt(EvaluDevNode evaluDev, Map<String, String> devSceneDataExt, String sceneArg) {
        boolean isAllUpgrade = Boolean.parseBoolean(devSceneDataExt.get(IS_ALL_UPGRADE));
        evaluDev.setFastAndRollType(Boolean.parseBoolean(devSceneDataExt.get(IS_FAST_AND_ROLL_TYPE)));
        evaluDev.setSupportFast(Boolean.parseBoolean(devSceneDataExt.get(SUPPORT_FAST)));
        evaluDev.setStopHostBusiness(Boolean.parseBoolean(devSceneDataExt.get(STOP_BUSINESS)));
        evaluDev.setDeviceKernelVersion(devSceneDataExt.get(CURRENT_KERNEL_VERSION));
        evaluDev.setTargetKernelVersion(devSceneDataExt.get(TARGET_KERNEL_VERSION));
        evaluDev.setSupportApollo(Boolean.parseBoolean(devSceneDataExt.get(SUPPORT_APOLLO)));
        evaluDev.setContainerVersion(devSceneDataExt.get(CONTAINER_VERSION));
        evaluDev.setSecondaryUpgrade(Boolean.parseBoolean(devSceneDataExt.get(IS_SECONDARY_UPGRADE)));
        evaluDev.setStorageImageUpgrade(isAllUpgrade);
        if (isAllUpgrade) {
            evaluDev.setContainerDestVersion(devSceneDataExt.get(CONTAINER_DEST_VERSION));
            this.modifyArraySceneInfo(evaluDev, sceneArg);
        }
    }

    private void modifyArraySceneInfo(EvaluDevNode evaluDev, String sceneArg) {
        if (SCENE_UP_ARRAY_EVALUATION.equals(sceneArg)) {
            evaluDev.setSecondaryUpgrade(false);
            evaluDev.setContainerVersion("");
        }
    }

    private void saveUpgradeSceneData(String sceneArg, DevNode devNode, UpgradeSceneData data, EvaluDevNode evaluDev) {
        evaluDev.setUpgradeMode(UpgradeMode.valueOf(EvaluCommUtil.getActualMode(data.getUpgradeMode())));
        evaluDev.setUpgradeModeUI(UpgradeMode.valueOf(data.getUpgradeMode()));
        if (data.isStorageImageUpgrade()) {
            evaluDev.setContainerUpgradeMode(UpgradeMode.valueOf(data.getContainerUpgradeMode()));
            evaluDev.setContainerUpgradeModeUI(UpgradeMode.valueOf(data.getContainerUpgradeMode()));
            evaluDev.setContainerDestVersion(data.getContainerDestVersion());
        }
        evaluDev.setDestVersion(data.getTargetVersion());
        evaluDev.setDeviceType(this.getDeviceType(sceneArg, devNode.getDeviceType(), data));
    }

    private String getDestVersion(UpgradeSceneData data, String sceneArg) {
        return this.isContainerEvaluation(data, sceneArg) ? data.getContainerDestVersion() : data.getTargetVersion();
    }

    private String getUpgradeMode(UpgradeSceneData data, String sceneArg) {
        return this.isContainerEvaluation(data, sceneArg) ? data.getContainerUpgradeMode() : data.getUpgradeMode();
    }

    private boolean isContainerEvaluation(UpgradeSceneData data, String sceneArg) {
        return data.isStorageImageUpgrade() && SCENE_UP_CONTAINER_EVALUATION.equals(sceneArg);
    }

    private DeviceType getDeviceType(String sceneArg, DeviceType deviceType, UpgradeSceneData data) {
        return this.isContainerEvaluation(data, sceneArg) ? DeviceType.valueOf((String)String.join((CharSequence)"_", deviceType.toString(), SCENE_UP_CONTAINER_EVALUATION)) : deviceType;
    }

    public Map<String, String> getCollectToolDataPath() {
        HashMap<String, String> collectDataPathMap = new HashMap<String, String>();
        try {
            Map dataVarMap = SceneEnvironmentImpl.getInstance().getDataVarMap(COLLECT_TOOL_NAME);
            for (Map.Entry entry : dataVarMap.entrySet()) {
                ToolSceneData toolSceneData = (ToolSceneData)entry.getValue();
                String fileName = (String)toolSceneData.getDeviceMap().get("fileName");
                if (StringUtils.isNULLStr((String)fileName)) continue;
                collectDataPathMap.put((String)entry.getKey(), fileName);
            }
        }
        catch (ToolException e) {
            LOGGER.error("load collect tool data exception.", e);
        }
        return collectDataPathMap;
    }
}

