/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.service;

import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.scene.utils.SceneDataExchange;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.infograb.entity.SelfMultiPathInfo;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.upgradeevalu.adapter.RuleItem;
import com.huawei.ism.tool.upgradeevalu.adapter.worktaker.impl.ICompservice;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.model.EvalItemResult;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.report.CompatibilityResourceUtils;
import com.huawei.ism.tool.upgradeevalu.service.multipath.HostMultiPathEvalResult;
import com.huawei.ism.tool.upgradeevalu.service.multipath.ISCSIEvalService;
import com.huawei.ism.util.CommonUtil;
import com.huawei.json.JSONArray;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractCompService
implements ICompservice {
    private static final String DISK_NAME = "diskName";
    private static final String IS_REDUNDANT = "isRedundant";
    private static final String NETWORK_TYPE = "networkType";
    private static final String NETWORK_ISCSI = "ISCSI";
    private static final String NOT_PASSED = "Failed";
    private static final String HYBRID_NETWORK = "HybridNetwork";
    public static final String MULTIPATH_CHECK = "multipath_check";
    public static final String MULTI_PATH_EVAL_RESULT = "multiPathEvalResult";
    public static final String MULTI_PATH_STATUS = "multiPathStatus";
    private static final String SEPRATOR = ".";
    private static final String SPACE = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    private static final String COMMA = ",";
    private static final String[] MULTIPATH_GLOBAL_IDX = new String[]{"1&nbsp;", "2&nbsp;", "3&nbsp;"};
    private static final String TRUE = "true";
    private static final String MESSAGE_KEY = "messageKey:";
    private static final Logger LOGGER = Logger.getLogger(AbstractCompService.class);

    public EvalFeatureResult parseCheckResult(Map<String, String> evalMap, Map<String, Object> evalContext) throws ToolException {
        String selfMultiPathInfoStr;
        DevNode devNode = (DevNode)evalContext.get("evalStorDevNode");
        String storageSN = devNode.getDeviceSerialNumber();
        String evalResult = null != evalMap.get(MULTIPATH_CHECK) ? evalMap.get(MULTIPATH_CHECK) : evalMap.get(MULTI_PATH_STATUS);
        LOGGER.info(String.format(Locale.ENGLISH, "evalResultInfo:%s", evalResult));
        com.huawei.json.JSONObject result = new com.huawei.json.JSONObject(evalResult);
        String evalResultCode = this.getJsonString(result, "erorCode");
        String evalMessage = this.getJsonString(result, "evalMessage");
        String originalInfo = this.getJsonString(result, "cliRet");
        Object[] paramList = this.getJsonArrayStr(result);
        int paramListLth = paramList.length;
        paramList = this.singleMultiFilterLunDiskByWwnSn(storageSN, paramList);
        if (paramListLth != paramList.length && paramList.length == 1) {
            evalMessage = "";
            evalResultCode = "Passed";
        }
        List<SelfMultiPathInfo> selfMultiPathInfos = (selfMultiPathInfoStr = this.getJsonString(result, "selfMultiPathInfo")) == null ? null : JSONObject.parseArray(selfMultiPathInfoStr, SelfMultiPathInfo.class);
        StringBuilder notPassPaths = this.evalIscsiWithStorage(selfMultiPathInfos, "", evalContext, originalInfo);
        EvalFeatureResult evalFeatureResult = new EvalFeatureResult();
        evalFeatureResult.setOriginalInfo(originalInfo);
        String networkTip = this.getFcIscsiTip(selfMultiPathInfos);
        evalResultCode = StringUtils.isNULLStr((String)networkTip) && StringUtils.isNULLStr((String)notPassPaths.toString()) ? evalResultCode : NOT_PASSED;
        this.setFailDesc(evalMessage, paramList, notPassPaths, evalFeatureResult, networkTip);
        this.setOriginalInfo(storageSN, evalFeatureResult);
        switch (evalResultCode) {
            case "Failed": {
                evalFeatureResult.setItemResult(ItemResultEnum.NOTPASS);
                break;
            }
            case "Optimization recommended": {
                evalFeatureResult.setItemResult(ItemResultEnum.OPTIM_RECOMD);
                break;
            }
            case "Passed": {
                return evalFeatureResult;
            }
            default: {
                evalFeatureResult.setItemResult(ItemResultEnum.CANNOTEVAL);
            }
        }
        return evalFeatureResult;
    }

    private void setOriginalInfo(String storageSN, EvalFeatureResult evalFeatureResult) {
        try {
            String key = storageSN + "_storageControllerInfo";
            String cli = SceneDataExchange.getInstance().loadKV(key);
            if (!StringUtils.isNULLStr((String)cli)) {
                LOGGER.info(String.format(Locale.ENGLISH, "the storage port info is:%s", cli));
                evalFeatureResult.setOriginalInfo(evalFeatureResult.getOriginalInfo() + System.lineSeparator() + cli);
            }
        }
        catch (Exception e) {
            LOGGER.error("get the storage port info error" + e);
        }
    }

    private void setFailDesc(String evalMessage, Object[] paramList, StringBuilder notPassPaths, EvalFeatureResult evalFeatureResult, String networkTip) {
        evalMessage = StringUtils.isNULLStr((String)evalMessage) ? this.getSuggestInfoWithNotEvalMessage(notPassPaths, networkTip) : this.getSuggestInfoWithEvalMsg(ResourceUtil.getStringWithParams((String)evalMessage, (Object[])paramList), notPassPaths, networkTip);
        evalFeatureResult.setFailDesc(evalMessage);
    }

    private Object[] singleMultiFilterLunDiskByWwnSn(String storageSN, Object[] paramList) {
        Object[] paramListNew = null;
        if (paramList.length > 1) {
            String paramStr = this.dealNeedFilterSystem(storageSN, paramList[1].toString());
            paramListNew = !StringUtils.isNULLStr((String)paramStr) ? new String[]{paramList[0], paramStr} : new String[]{paramList[0]};
        } else {
            return paramList;
        }
        return paramListNew;
    }

    private String dealNeedFilterSystem(String storageSN, String paramStr) {
        String[] paramArray;
        ArrayList<String> lunWwnInfoList = new ArrayList();
        String paramNoPathStr = "";
        boolean isNeedFilter = false;
        for (String string : paramArray = paramStr.split(COMMA)) {
            if (!string.contains("WWN_") && !string.contains("SN_") && !string.startsWith("naa.")) continue;
            isNeedFilter = true;
            break;
        }
        if (isNeedFilter) {
            lunWwnInfoList = this.queryLunWwnList(storageSN);
            paramNoPathStr = AbstractCompService.filterLunDiskByWwnSn(paramArray, storageSN, lunWwnInfoList);
        } else {
            paramNoPathStr = paramStr;
        }
        return paramNoPathStr;
    }

    private List<String> queryLunWwnList(String storageSN) {
        String key = storageSN + "_LUNInfo";
        String cli = SceneDataExchange.getInstance().loadKV(key);
        ArrayList<String> lunWwnList = new ArrayList<String>();
        boolean isStart = false;
        int index = 0;
        if (StringUtils.isNULLStr((String)cli)) {
            LOGGER.warn("the cli is null. the key is:" + key);
            return lunWwnList;
        }
        block0: for (String line : cli.split("\\n")) {
            String[] arr = line.trim().split("\\s\\s+");
            if (line.contains("------")) continue;
            if (line.toLowerCase(Locale.ENGLISH).contains("wwn") && line.toLowerCase(Locale.ENGLISH).contains("id") && line.toLowerCase(Locale.ENGLISH).contains("health status")) {
                for (String string : arr) {
                    if (string.equalsIgnoreCase("WWN")) {
                        isStart = true;
                        continue block0;
                    }
                    ++index;
                }
                continue;
            }
            if (!isStart || arr.length <= index + 1) continue;
            lunWwnList.add(arr[index]);
        }
        return lunWwnList;
    }

    private String getSuggestInfoWithEvalMsg(String evalMessage, StringBuilder notPassPaths, String networkTip) {
        if (!StringUtils.isNULLStr((String)networkTip) || !StringUtils.isNULLStr((String)notPassPaths.toString())) {
            String suggestInfo;
            String evalMessageSuggest = "";
            String evalMessageCause = "";
            String suggestInfoCause = "";
            String suggestFlag = CompatibilityResourceUtils.getUIString("feature.eval.detail.dialog.suggest.flag");
            String activeFlag = CompatibilityResourceUtils.getUIString("feature.eval.detail.dialog.actions.flag");
            if (evalMessage.contains(suggestFlag) || evalMessage.contains(activeFlag)) {
                int evalSuggestIndex = -1 == evalMessage.indexOf(suggestFlag) ? evalMessage.indexOf(activeFlag) : evalMessage.indexOf(suggestFlag);
                evalMessageSuggest = evalMessage.substring(evalSuggestIndex);
                evalMessageCause = evalMessage.substring(0, evalSuggestIndex - 1);
            }
            if ((suggestInfo = this.getSuggestInfoWithNotEvalMessage(notPassPaths, networkTip)).contains(suggestFlag) || suggestInfo.contains(activeFlag)) {
                int suggestInfoIndex = -1 == suggestInfo.indexOf(suggestFlag) ? suggestInfo.indexOf(activeFlag) : suggestInfo.indexOf(suggestFlag);
                String temp = suggestInfo.substring(0, suggestInfoIndex);
                suggestInfoCause = temp.substring(Normalizer.normalize(temp, Normalizer.Form.NFKC).indexOf(":") + 2);
            }
            evalMessage = evalMessageCause + suggestInfoCause + evalMessageSuggest;
        }
        return evalMessage;
    }

    private String getSuggestInfoWithNotEvalMessage(StringBuilder notPassPaths, String networkTip) {
        String suggestInfo = "";
        if (!StringUtils.isNULLStr((String)networkTip) && !StringUtils.isNULLStr((String)notPassPaths.toString())) {
            suggestInfo = ResourceUtil.getStringWithParams((String)"upgrade.eval.host.link.fc&iscsi.exists.noRedundantPath.tip", (Object[])new Object[]{notPassPaths, networkTip});
        } else if (!StringUtils.isNULLStr((String)notPassPaths.toString())) {
            suggestInfo = ResourceUtil.getStringWithParams((String)"upgrade.eval.host.link.iscsi.exists.noRedundantPath.tip", (Object[])new Object[]{notPassPaths});
        } else if (!StringUtils.isNULLStr((String)networkTip)) {
            suggestInfo = ResourceUtil.getStringWithParams((String)"upgrade.eval.host.link.fc&iscsi.exists.tip", (Object[])new Object[]{networkTip});
        }
        return suggestInfo;
    }

    private String getFcIscsiTip(List<SelfMultiPathInfo> selfMultiPathInfos) {
        if (selfMultiPathInfos == null || selfMultiPathInfos.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (SelfMultiPathInfo info : selfMultiPathInfos) {
            if (!HYBRID_NETWORK.equals(info.getNetworkType())) continue;
            sb.append(info.getDiskName()).append(',');
        }
        if (sb.length() == 0) {
            return "";
        }
        return sb.substring(0, sb.length() - 1);
    }

    public EvalFeatureResult parseCheckResultByItemKey(String itemKey, Map<String, String> evalMap) {
        String evalResult = evalMap.get(itemKey);
        com.huawei.json.JSONObject result = new com.huawei.json.JSONObject(evalResult);
        String evalResultCode = this.getJsonString(result, "erorCode");
        String evalMessage = this.getJsonString(result, "evalMessage");
        String originalInfo = this.getJsonString(result, "cliRet");
        Object[] paramListStr = this.getJsonArrayStr(result);
        EvalFeatureResult evalFeatureResult = new EvalFeatureResult();
        evalFeatureResult.setOriginalInfo(originalInfo);
        String evalMsg = StringUtils.isNULLStr((String)evalMessage) ? "" : ResourceUtil.getStringWithParams((String)evalMessage, (Object[])paramListStr);
        evalFeatureResult.setFailDesc(evalMsg);
        switch (evalResultCode) {
            case "Failed": {
                evalFeatureResult.setItemResult(ItemResultEnum.NOTPASS);
                break;
            }
            case "Optimization recommended": {
                evalFeatureResult.setItemResult(ItemResultEnum.OPTIM_RECOMD);
                break;
            }
            case "Passed": {
                return evalFeatureResult;
            }
            default: {
                evalFeatureResult.setItemResult(ItemResultEnum.CANNOTEVAL);
            }
        }
        return evalFeatureResult;
    }

    public String[] getJsonArrayStr(com.huawei.json.JSONObject result) {
        if (result == null) {
            return new String[0];
        }
        try {
            JSONArray paramArray = result.getJSONArray("paramList");
            String[] arrays = new String[paramArray.length()];
            for (int i = 0; i < paramArray.length(); ++i) {
                String parmInfo = paramArray.getString(i);
                if (!StringUtils.isNULLStr((String)parmInfo) && parmInfo.startsWith(MESSAGE_KEY)) {
                    parmInfo = ResourceUtil.getString((String)parmInfo.replace(MESSAGE_KEY, ""));
                }
                arrays[i] = parmInfo;
            }
            return arrays;
        }
        catch (RuntimeException e) {
            LOGGER.warn("paramList is null..");
            return new String[0];
        }
        catch (Exception e) {
            LOGGER.warn("paramList is null..");
            return new String[0];
        }
    }

    public String getJsonString(com.huawei.json.JSONObject result, String key) {
        try {
            return result.getString(key);
        }
        catch (Exception e) {
            LOGGER.warn("paramList is null..");
            return null;
        }
    }

    public com.huawei.json.JSONObject parseToJsonObj(String jsonStr) {
        if (jsonStr == null) {
            return null;
        }
        try {
            return new com.huawei.json.JSONObject(jsonStr);
        }
        catch (Exception e) {
            LOGGER.warn("paramList is null..");
            return null;
        }
    }

    public EvalFeatureResult parseCheckResultNew(Map<String, String> evalMap, Map<String, Object> evalContext) throws ToolException {
        DevNode devNode = (DevNode)evalContext.get("evalStorDevNode");
        String storageSN = devNode.getDeviceSerialNumber();
        String resultJson = evalMap.get(MULTI_PATH_EVAL_RESULT);
        HostMultiPathEvalResult multiPathInfo = AbstractCompService.parseJSONstrToObj(resultJson, HostMultiPathEvalResult.class);
        LOGGER.info(String.format(Locale.ENGLISH, "multipath eval result:%s", resultJson));
        EvalFeatureResult result = new EvalFeatureResult(ItemResultEnum.PASS);
        if (null == multiPathInfo) {
            result.setItemResult(ItemResultEnum.NOTPASS);
            result.setFailDesc(ResourceUtil.getString((String)"eval.host.multipath.reduntpath.qry.multipath.failed"));
            return result;
        }
        result.setOriginalInfo(!StringUtils.isNULLStr((String)multiPathInfo.getCliRet()) ? multiPathInfo.getCliRet() : multiPathInfo.getSelfMultiPath().getCliRet() + System.lineSeparator() + multiPathInfo.getHuaweiMultipath().getCliRet());
        HostMultiPathEvalResult.MultiPathEvalResult huaweiMultipath = multiPathInfo.getHuaweiMultipath();
        HostMultiPathEvalResult.MultiPathEvalResult selfMultiPath = multiPathInfo.getSelfMultiPath();
        String coexistence = multiPathInfo.getCoexistence();
        if (!TRUE.equalsIgnoreCase(coexistence)) {
            throw new NullPointerException("failed read multipath eval result error.");
        }
        if (huaweiMultipath == null || selfMultiPath == null) {
            throw new NullPointerException("failed read multipath eval result error.");
        }
        this.evaluAndUpdateResult(multiPathInfo, evalContext, result.getOriginalInfo());
        String fcIscsiExistenceDisk = this.getFcIscsiTip(multiPathInfo.getSelfMultiPathInfo());
        this.coexistenceFilterLunDiskByWwnSn(huaweiMultipath, selfMultiPath, storageSN);
        if (this.isPathInManage(huaweiMultipath, selfMultiPath) && this.isPathNormal(multiPathInfo) && StringUtils.isNULLStr((String)fcIscsiExistenceDisk)) {
            return result;
        }
        EvalItemResult evalItemResult = (EvalItemResult)evalContext.get("evalItemResult");
        com.huawei.ism.tool.framework.pubservice.entity.DevNode hostDevNode = evalItemResult.getEvalDevNode();
        if (!(StringUtils.isNULLStr((String)huaweiMultipath.getFailCommand()) && StringUtils.isNULLStr((String)selfMultiPath.getFailCommand()) && StringUtils.isNULLStr((String)huaweiMultipath.getNoRedundantPath()) && StringUtils.isNULLStr((String)selfMultiPath.getNoRedundantPath()) && StringUtils.isNULLStr((String)fcIscsiExistenceDisk))) {
            result.setItemResult(ItemResultEnum.NOTPASS);
            result.setFailDesc(this.buildAllExistsFailDesc(multiPathInfo, hostDevNode.getIp(), evalContext, fcIscsiExistenceDisk));
            this.setOriginalInfo(storageSN, result);
            return result;
        }
        result.setFailDesc(ResourceUtil.getStringWithParams((String)"eval.host.multipath.reduntpath.self&buildin.donot.take.over.luns", (Object[])new Object[]{hostDevNode.getIp()}));
        result.setItemResult(ItemResultEnum.NOTPASS);
        return result;
    }

    private String buildAllExistsFailDesc(HostMultiPathEvalResult multiPathInfo, String hostIp, Map<String, Object> evalContext, String fcIscsiExistenceDisk) {
        String iscsiAndFcLinkExistsTip = "";
        HostMultiPathEvalResult.MultiPathEvalResult huaweiMultipath = multiPathInfo.getHuaweiMultipath();
        HostMultiPathEvalResult.MultiPathEvalResult selfMultiPath = multiPathInfo.getSelfMultiPath();
        StringBuilder result = new StringBuilder();
        result.append(ResourceUtil.getStringWithParams((String)"eval.host.multipath.reduntpath.self&buildin.allexist.head", (Object[])new Object[]{hostIp}));
        result.append(System.lineSeparator());
        if (!StringUtils.isNULLStr((String)fcIscsiExistenceDisk)) {
            iscsiAndFcLinkExistsTip = ResourceUtil.getStringWithParams((String)"upgrade.eval.host.link.fc&iscsi.exists.selfdev&buildinmultipath.tip", (Object[])new Object[]{fcIscsiExistenceDisk});
        }
        int globalIdx = this.appendSelfMultipathResult(multiPathInfo, result, evalContext, iscsiAndFcLinkExistsTip);
        this.appendHwMultipathResult(huaweiMultipath, result, globalIdx);
        result.append(ResourceUtil.getString((String)"eval.host.multipath.reduntpath.self&buildin.allexist.fixtip.head"));
        result.append(System.lineSeparator());
        int fixTip = 0;
        if (!StringUtils.isNULLStr((String)huaweiMultipath.getFailCommand()) || !StringUtils.isNULLStr((String)selfMultiPath.getFailCommand())) {
            result.append(ResourceUtil.getStringWithParams((String)"eval.host.multipath.reduntpath.self&buildin.allexist.cmdfail.fixtip", (Object[])new Object[]{MULTIPATH_GLOBAL_IDX[fixTip++], this.buildTipFormat(String.valueOf(fixTip)), this.buildTipFormat(String.valueOf(fixTip))}));
            result.append(System.lineSeparator());
        }
        if (!StringUtils.isNULLStr((String)huaweiMultipath.getNoRedundantPath()) || !StringUtils.isNULLStr((String)selfMultiPath.getNoRedundantPath())) {
            result.append(ResourceUtil.getStringWithParams((String)"eval.host.multipath.reduntpath.self&buildin.allexist.multipathfail.fixtip", (Object[])new Object[]{MULTIPATH_GLOBAL_IDX[fixTip++]}));
            result.append(System.lineSeparator());
        }
        if (!StringUtils.isNULLStr((String)iscsiAndFcLinkExistsTip)) {
            result.append(ResourceUtil.getStringWithParams((String)"upgrade.eval.host.link.fc&iscsi.exists.selfdev&buildinmultipath.recover.tip", (Object[])new Object[]{MULTIPATH_GLOBAL_IDX[fixTip]}));
            result.append(System.lineSeparator());
        }
        return result.toString();
    }

    private int appendSelfMultipathResult(HostMultiPathEvalResult multiPathInfo, StringBuilder result, Map<String, Object> evalContext, String iscsiAndFcLinkExistsTip) {
        int globalIdx = 0;
        int hwIdx = 1;
        HostMultiPathEvalResult.MultiPathEvalResult selfMultiPath = multiPathInfo.getSelfMultiPath();
        if (!StringUtils.isNULLStr((String)selfMultiPath.getFailCommand()) || !StringUtils.isNULLStr((String)selfMultiPath.getNoRedundantPath())) {
            result.append(ResourceUtil.getStringWithParams((String)"eval.host.multipath.reduntpath.self&buildin.allexist.selfhead", (Object[])new Object[]{MULTIPATH_GLOBAL_IDX[globalIdx++]}));
            result.append(System.lineSeparator());
        }
        if (!StringUtils.isNULLStr((String)selfMultiPath.getFailCommand())) {
            result.append(ResourceUtil.getStringWithParams((String)"eval.host.multipath.reduntpath.self&buildin.allexist.cmdfail.head", (Object[])new Object[]{this.buildTipFormat(globalIdx + SEPRATOR + hwIdx++), ResourceUtil.getString((String)selfMultiPath.getFailDescribe())}));
            String[] cmds = selfMultiPath.getFailCommand().split(COMMA);
            result.append(System.lineSeparator());
            for (int i = 0; i < cmds.length; ++i) {
                result.append(SPACE);
                result.append(cmds[i]);
                result.append(i == cmds.length - 1 ? "" : COMMA);
                result.append(System.lineSeparator());
            }
        }
        if (!StringUtils.isNULLStr((String)selfMultiPath.getNoRedundantPath())) {
            String noRedundantPaths = selfMultiPath.getNoRedundantPath();
            result.append(ResourceUtil.getStringWithParams((String)"eval.host.multipath.reduntpath.self&buildin.allexist.self.NoRedundantPath.content", (Object[])new Object[]{this.buildTipFormat(globalIdx + SEPRATOR + hwIdx++), noRedundantPaths}));
            result.append(System.lineSeparator());
        }
        if (!StringUtils.isNULLStr((String)iscsiAndFcLinkExistsTip)) {
            result.append(this.buildTipFormat(globalIdx + SEPRATOR + hwIdx)).append("&nbsp;").append(iscsiAndFcLinkExistsTip);
            result.append(System.lineSeparator());
        }
        return globalIdx;
    }

    private void evaluAndUpdateResult(HostMultiPathEvalResult multiPathInfo, Map<String, Object> evalContext, String cliRet) throws ToolException {
        HostMultiPathEvalResult.MultiPathEvalResult result = multiPathInfo.getSelfMultiPath();
        StringBuilder noRedundantPath = this.evalIscsiWithStorage(multiPathInfo.getSelfMultiPathInfo(), result.getNoRedundantPath(), evalContext, cliRet);
        result.setNoRedundantPath(noRedundantPath.toString());
    }

    private void coexistenceFilterLunDiskByWwnSn(HostMultiPathEvalResult.MultiPathEvalResult huaweiMultipath, HostMultiPathEvalResult.MultiPathEvalResult selfMultiPath, String storageSN) {
        String huaweiMultipathNoR = huaweiMultipath.getNoRedundantPath();
        String selfMultiPathNoR = selfMultiPath.getNoRedundantPath();
        if (StringUtils.isNULLStr((String)huaweiMultipathNoR) && StringUtils.isNULLStr((String)selfMultiPathNoR)) {
            LOGGER.warn("huaweiMultipathNoR and selfMultiPathNoR is null.");
            return;
        }
        String huaweiMultipathNoRNew = this.dealNeedFilterSystem(storageSN, huaweiMultipathNoR);
        String selfMultiPathNoRNew = this.dealNeedFilterSystem(storageSN, selfMultiPathNoR);
        huaweiMultipath.setNoRedundantPath(huaweiMultipathNoRNew);
        selfMultiPath.setNoRedundantPath(selfMultiPathNoRNew);
    }

    private static String filterLunDiskByWwnSn(String[] paramArray, String storageSN, List<String> wwnList) {
        if (wwnList.isEmpty()) {
            LOGGER.warn("the wwnList is empty.");
            return Arrays.toString(paramArray);
        }
        LOGGER.info(String.format(Locale.ENGLISH, "before filter, the filterLunDsikStr is:%s", Arrays.toString(paramArray)));
        String filterLunDsikStr = "";
        block0: for (String paramStr : paramArray) {
            if (!(paramStr.contains("WWN_") || paramStr.contains("SN_") || paramStr.startsWith("naa."))) {
                filterLunDsikStr = filterLunDsikStr + paramStr + COMMA;
                continue;
            }
            for (String wwnStr : wwnList) {
                if ((paramStr.startsWith("naa.") || paramStr.contains("WWN_")) && paramStr.toLowerCase(Locale.ENGLISH).contains(wwnStr.toLowerCase(Locale.ENGLISH))) {
                    filterLunDsikStr = filterLunDsikStr + paramStr + COMMA;
                    continue block0;
                }
                if (!paramStr.contains("SN_") || !paramStr.toLowerCase(Locale.ENGLISH).contains(storageSN.toLowerCase(Locale.ENGLISH))) continue;
                filterLunDsikStr = filterLunDsikStr + paramStr + COMMA;
                continue block0;
            }
        }
        LOGGER.info(String.format(Locale.ENGLISH, "after filter, the filterLunDsikStr is:%s", filterLunDsikStr));
        if (!StringUtils.isNULLStr((String)filterLunDsikStr)) {
            filterLunDsikStr = filterLunDsikStr.substring(0, filterLunDsikStr.length() - 1);
        }
        return filterLunDsikStr;
    }

    public StringBuilder evalIscsiWithStorage(List<SelfMultiPathInfo> SelfMultiPathInfos, String initNotPassPath, Map<String, Object> evalContext, String cliRet) throws ToolException {
        StringBuilder noRedundantPath = new StringBuilder(initNotPassPath);
        if (SelfMultiPathInfos == null || SelfMultiPathInfos.isEmpty()) {
            return noRedundantPath;
        }
        DevNode devNode = (DevNode)evalContext.get("evalStorDevNode");
        ISCSIEvalService evalInatance = ISCSIEvalService.getInstance();
        List<Map<String, String>> evaluResult = evalInatance.evaluPath(SelfMultiPathInfos, devNode, cliRet);
        if (evaluResult == null) {
            return noRedundantPath;
        }
        for (Map<String, String> resultMap : evaluResult) {
            if (!NETWORK_ISCSI.equals(resultMap.get(NETWORK_TYPE)) || !String.valueOf(false).equalsIgnoreCase(resultMap.get(IS_REDUNDANT))) continue;
            if (noRedundantPath.length() == 0) {
                noRedundantPath.append(resultMap.get(DISK_NAME));
                continue;
            }
            noRedundantPath.append(',').append(resultMap.get(DISK_NAME));
        }
        return noRedundantPath;
    }

    private int appendHwMultipathResult(HostMultiPathEvalResult.MultiPathEvalResult huaweiMultipath, StringBuilder result, int globalIdx) {
        int hwIdx = 1;
        if (!StringUtils.isNULLStr((String)huaweiMultipath.getFailCommand()) || !StringUtils.isNULLStr((String)huaweiMultipath.getNoRedundantPath())) {
            result.append(ResourceUtil.getStringWithParams((String)"eval.host.multipath.reduntpath.self&buildin.allexist.hwhead", (Object[])new Object[]{MULTIPATH_GLOBAL_IDX[globalIdx++]}));
            result.append(System.lineSeparator());
        }
        if (!StringUtils.isNULLStr((String)huaweiMultipath.getFailCommand())) {
            result.append(ResourceUtil.getStringWithParams((String)"eval.host.multipath.reduntpath.self&buildin.allexist.cmdfail.head", (Object[])new Object[]{this.buildTipFormat(globalIdx + SEPRATOR + hwIdx++), ResourceUtil.getString((String)huaweiMultipath.getFailDescribe())}));
            String[] cmds = huaweiMultipath.getFailCommand().split(COMMA);
            result.append(System.lineSeparator());
            for (int i = 0; i < cmds.length; ++i) {
                result.append(SPACE);
                result.append(cmds[i]);
                result.append(i == cmds.length - 1 ? "" : COMMA);
                result.append(System.lineSeparator());
            }
        }
        if (!StringUtils.isNULLStr((String)huaweiMultipath.getNoRedundantPath())) {
            String noRedundantPaths = huaweiMultipath.getNoRedundantPath();
            result.append(ResourceUtil.getStringWithParams((String)"eval.host.multipath.reduntpath.self&buildin.allexist.hw.NoRedundantPath.content", (Object[])new Object[]{this.buildTipFormat(globalIdx + SEPRATOR + hwIdx), noRedundantPaths}));
            result.append(System.lineSeparator());
        }
        return globalIdx;
    }

    private String buildTipFormat(String tips) {
        return "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + tips;
    }

    private boolean isPathNormal(HostMultiPathEvalResult multiPathInfo) {
        HostMultiPathEvalResult.MultiPathEvalResult huaweiMultipath = multiPathInfo.getHuaweiMultipath();
        HostMultiPathEvalResult.MultiPathEvalResult selfMultiPath = multiPathInfo.getSelfMultiPath();
        boolean selfPassed = StringUtils.isNULLStr((String)huaweiMultipath.getFailCommand()) && StringUtils.isNULLStr((String)huaweiMultipath.getNoRedundantPath());
        boolean hwPassed = StringUtils.isNULLStr((String)selfMultiPath.getFailCommand()) && StringUtils.isNULLStr((String)selfMultiPath.getNoRedundantPath());
        return selfPassed && hwPassed;
    }

    private boolean isPathInManage(HostMultiPathEvalResult.MultiPathEvalResult huaweiMultipath, HostMultiPathEvalResult.MultiPathEvalResult selfMultiPath) {
        return TRUE.equalsIgnoreCase(huaweiMultipath.getControl()) || TRUE.equalsIgnoreCase(selfMultiPath.getControl());
    }

    public static <T> T parseJSONstrToObj(String jsonStr, Class<T> obj) {
        if (jsonStr == null || obj == null) {
            LOGGER.error("param is null " + jsonStr);
            return null;
        }
        try {
            jsonStr = jsonStr.replace("u'", "'");
            jsonStr = jsonStr.replace("u\"", "'");
            return JSONObject.parseObject(jsonStr, obj);
        }
        catch (Exception e) {
            LOGGER.error("parse to Object error.", e);
            return null;
        }
    }

    protected static class EvalCommParams {
        private RuleItem ruleItem;
        private ItemInfo itemInfo;
        private String storageSn;

        public EvalCommParams(Map<String, Object> evalContext) {
            Object ruleItemObj = evalContext.get("ruleItem");
            this.ruleItem = (RuleItem)CommonUtil.convertObject((Object)ruleItemObj, RuleItem.class);
            Object itemInfoObj = evalContext.get("itemInfo");
            this.itemInfo = (ItemInfo)CommonUtil.convertObject((Object)itemInfoObj, ItemInfo.class);
            this.storageSn = null != evalContext.get("StorageSN") ? evalContext.get("StorageSN").toString() : "";
        }

        public RuleItem getRuleItem() {
            return this.ruleItem;
        }

        public void setRuleItem(RuleItem ruleItem) {
            this.ruleItem = ruleItem;
        }

        public ItemInfo getItemInfo() {
            return this.itemInfo;
        }

        public void setItemInfo(ItemInfo itemInfo) {
            this.itemInfo = itemInfo;
        }

        public String getStorageSn() {
            return this.storageSn;
        }

        public void setStorageSn(String storageSn) {
            this.storageSn = storageSn;
        }
    }
}

