/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.service;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.service.AbstractCompService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class AixUltraAndFWCheck
extends AbstractCompService {
    private static final String MULTI_PATH_REG_EXP = ".+:\\s+\\d+\\.\\d{2}\\.\\d{3}";
    private static final String NO_PLUG_INS_STRING = "upadm:";
    private static final String CMD_LSMCDOE = "lsmcode -A | grep";
    private static final int AIX_NOT_PASS_MULTIPATH_VERSION = 803021;
    private static final String HBA_FW_VERSION_DEFICT = "00011000020021100021";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(AixUltraAndFWCheck.class);
    private List<String> fcsNameList = new ArrayList<String>();
    private List<String> fwVersionList = new ArrayList<String>();
    public static final String MULTIPATH_KEY = "cmd_disaplay_multipath_hwselfdev_version";
    public static final String FCSINFOS_KEY = "cmd_display_hba_card_lscfg";
    public static final String FWVERSION_KEY = "cmd_display_hba_card_info_fc_";

    @Override
    public <T extends EvalFeatureResult> T evalate(Map<String, Object> evalContext) {
        AbstractCompService.EvalCommParams params = new AbstractCompService.EvalCommParams(evalContext);
        EvalFeatureResult result = new EvalFeatureResult();
        ItemInfo itemInfo = params.getItemInfo();
        Map<String, String> evalMap = itemInfo.getInfoGrabMetaMsg();
        String aixMultiPath = evalMap.get(MULTIPATH_KEY);
        StringBuilder originalInfo = new StringBuilder();
        originalInfo.append(aixMultiPath);
        result.setOriginalInfo(originalInfo.toString());
        if (StringUtils.isNULLStr((String)aixMultiPath)) {
            LOGGER.info("this Host :{} multiPath get error", (Object)itemInfo.getIp());
            result.setItemResult(ItemResultEnum.CANNOTEVAL);
            result.setFailDesc(ResourceUtil.getString((String)"multipath.aix.get.version.failed"));
            return (T)result;
        }
        Pattern pattern = Pattern.compile(MULTI_PATH_REG_EXP);
        Matcher multiPathMatcher = pattern.matcher(aixMultiPath);
        String multiPathVersion = null;
        if (multiPathMatcher.find()) {
            multiPathVersion = multiPathMatcher.group().trim();
            LOGGER.info("get multiPath success:{}", (Object)multiPathVersion);
        }
        if (this.checkMultiPathVersion(result, itemInfo, aixMultiPath, multiPathVersion)) {
            return (T)result;
        }
        if (this.checkmultiPathVersion2Int(result, itemInfo, multiPathVersion)) {
            return (T)result;
        }
        String fcsInfo = evalMap.get(FCSINFOS_KEY);
        if (this.checkFcsInfo(result, itemInfo, fcsInfo)) {
            return (T)result;
        }
        originalInfo.append(fcsInfo);
        result.setOriginalInfo(originalInfo.toString());
        this.analyHbaName(fcsInfo);
        if (this.checkFcsNameList(result, itemInfo)) {
            return (T)result;
        }
        this.querryFwVersion(result, originalInfo, evalMap);
        if (this.fwVersionList.size() < 1) {
            LOGGER.info("this Host :{} fw_version is null.", (Object)itemInfo.getIp());
            result.setItemResult(ItemResultEnum.PASS);
            return (T)result;
        }
        if (this.checkFwVersion(result)) {
            return (T)result;
        }
        result.setItemResult(ItemResultEnum.PASS);
        return (T)result;
    }

    private <T extends EvalFeatureResult> boolean checkFcsNameList(EvalFeatureResult result, ItemInfo itemInfo) {
        if (this.fcsNameList.size() < 1) {
            LOGGER.info("this Host :{} fcs_version get error", (Object)itemInfo.getIp());
            result.setFailDesc(ResourceUtil.getString((String)"cloudservice.compatibility.compat.baseConnectivity.HbaFirmw.error"));
            result.setItemResult(ItemResultEnum.CANNOTEVAL);
            return true;
        }
        return false;
    }

    private <T extends EvalFeatureResult> boolean checkFcsInfo(EvalFeatureResult result, ItemInfo itemInfo, String fcsInfo) {
        if (StringUtils.isNULLStr((String)fcsInfo) || fcsInfo.contains("TOOLKIT_SEND_CMD_TIME_OUT") || fcsInfo.contains("TOOLKIT_EXE_CMD_FAILED")) {
            LOGGER.info("this Host :{} fcs_version get error", (Object)itemInfo.getIp());
            result.setFailDesc(ResourceUtil.getString((String)"cloudservice.compatibility.compat.baseConnectivity.HbaFirmw.error"));
            result.setItemResult(ItemResultEnum.CANNOTEVAL);
            return true;
        }
        return false;
    }

    private <T extends EvalFeatureResult> boolean checkmultiPathVersion2Int(EvalFeatureResult result, ItemInfo itemInfo, String multiPathVersion) {
        int version = this.getVersion2Int(multiPathVersion);
        if (-1 == version) {
            LOGGER.info("this Host :{} analysis ulpath version is error", (Object)itemInfo.getIp());
            result.setFailDesc(ResourceUtil.getString((String)"multipath.aix.get.version.failed"));
            result.setItemResult(ItemResultEnum.CANNOTEVAL);
            return true;
        }
        if (version < 803021) {
            result.setItemResult(ItemResultEnum.PASS);
            return true;
        }
        return false;
    }

    private <T extends EvalFeatureResult> boolean checkMultiPathVersion(EvalFeatureResult result, ItemInfo itemInfo, String aixMultiPath, String multiPathVersion) {
        if (multiPathVersion == null) {
            if (org.apache.commons.lang3.StringUtils.contains((CharSequence)aixMultiPath, NO_PLUG_INS_STRING)) {
                LOGGER.info("this Host :{} has no multiPath plug-ins", (Object)itemInfo.getIp());
                result.setItemResult(ItemResultEnum.PASS);
                return true;
            }
            LOGGER.info("this Host :{} multiPath get error", (Object)itemInfo.getIp());
            result.setItemResult(ItemResultEnum.CANNOTEVAL);
            result.setFailDesc(ResourceUtil.getString((String)"multipath.aix.get.version.failed"));
            return true;
        }
        return false;
    }

    private <T extends EvalFeatureResult> boolean checkFwVersion(EvalFeatureResult result) {
        for (String fwVersion : this.fwVersionList) {
            if (!fwVersion.contains(HBA_FW_VERSION_DEFICT)) continue;
            result.setFailDesc(ResourceUtil.getString((String)"multipath.aix.check.hbafw.defict"));
            result.setItemResult(ItemResultEnum.NOTPASS);
            return true;
        }
        return false;
    }

    private void querryFwVersion(EvalFeatureResult result, StringBuilder originalInfo, Map<String, String> evalMap) {
        block0: for (String fcsName : this.fcsNameList) {
            String[] fwVersions;
            String feVersionInfo = evalMap.get(FWVERSION_KEY + fcsName);
            originalInfo.append(feVersionInfo);
            result.setOriginalInfo(originalInfo.toString());
            if (StringUtils.isNULLStr((String)feVersionInfo) || feVersionInfo.contains("TOOLKIT_SEND_CMD_TIME_OUT") || feVersionInfo.contains("TOOLKIT_EXE_CMD_FAILED")) {
                LOGGER.info("Get Hba FW version is error: {}", (Object)fcsName);
                continue;
            }
            boolean flag = false;
            for (String fwLine : fwVersions = feVersionInfo.split(System.lineSeparator())) {
                if (flag) {
                    if (StringUtils.isNULLStr((String)fwLine)) continue;
                    LOGGER.info("Get Fw version ehco is : {}", (Object)fwLine);
                    String[] fws = fwLine.split("\\.");
                    if (fws.length < 1) {
                        LOGGER.info("Ananly Fw version is error. : {}", (Object)fcsName);
                        continue;
                    }
                    this.fwVersionList.add(fws[fws.length - 1]);
                    LOGGER.info("Ananly Fw version is : {}", (Object)fws[fws.length - 1]);
                    continue block0;
                }
                if (!fwLine.contains(CMD_LSMCDOE)) continue;
                flag = true;
            }
        }
    }

    private void analyHbaName(String fcsInfo) {
        String[] fcsInfos;
        for (String fcsIf : fcsInfos = fcsInfo.split("\\r\\n")) {
            String[] strs;
            if (!fcsIf.trim().toLowerCase(Locale.ENGLISH).startsWith("fcs")) continue;
            for (String str : strs = fcsIf.split("\\s\\s+")) {
                if (!str.contains("fcs")) continue;
                this.fcsNameList.add(str.trim());
                LOGGER.info("Get fcs name success:{}", (Object)str);
                break;
            }
            LOGGER.info("Get fcs name faile:{}", (Object)fcsIf);
        }
    }

    private int getVersion2Int(String multiPathVersion) {
        String ultraPath = multiPathVersion;
        if (multiPathVersion.contains(":")) {
            ultraPath = multiPathVersion.split(":")[1].trim();
        }
        String versionStr = ultraPath.replaceAll("\\.", "");
        int version = com.huawei.ism.tool.base.utils.StringUtils.str2Int((String)versionStr);
        return version;
    }
}

