/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.service;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.service.AbstractCompService;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class AixUltraPathCheck
extends AbstractCompService {
    private static final String MULTI_PATH_REG_EXP = ".+:\\s+\\d+\\.\\d{2}\\.\\d{3}";
    private static final String NO_PLUG_INS_STRING = "upadm:";
    private static final int AIX_NOT_PASS_MULTIPATH_VERSION = 801029;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(AixUltraPathCheck.class);
    public static final String MULTIPATH_KEY = "cmd_disaplay_multipath_hwselfdev_version";

    @Override
    public <T extends EvalFeatureResult> T evalate(Map<String, Object> evalContext) {
        AbstractCompService.EvalCommParams params = new AbstractCompService.EvalCommParams(evalContext);
        EvalFeatureResult result = new EvalFeatureResult();
        ItemInfo itemInfo = params.getItemInfo();
        Map<String, String> evalMap = itemInfo.getInfoGrabMetaMsg();
        String aixMultiPath = evalMap.get(MULTIPATH_KEY);
        if (StringUtils.isNULLStr((String)aixMultiPath)) {
            LOGGER.info(String.format(Locale.ENGLISH, "this Host :%s multiPath get error", itemInfo.getIp()));
            result.setItemResult(ItemResultEnum.NOTPASS);
            result.setFailDesc(ResourceUtil.getString((String)"multipath.aix.get.version.failed"));
            return (T)result;
        }
        Pattern pattern = Pattern.compile(MULTI_PATH_REG_EXP);
        Matcher multiPathMatcher = pattern.matcher(aixMultiPath);
        String multiPathVersion = null;
        if (multiPathMatcher.find()) {
            multiPathVersion = multiPathMatcher.group().trim();
            LOGGER.info(String.format(Locale.ENGLISH, "get multiPath success:%s", multiPathVersion));
        }
        if (multiPathVersion == null) {
            if (org.apache.commons.lang3.StringUtils.contains((CharSequence)aixMultiPath, NO_PLUG_INS_STRING)) {
                LOGGER.info(String.format(Locale.ENGLISH, "this Host :%s has no multiPath plug-ins", itemInfo.getIp()));
                result.setItemResult(ItemResultEnum.PASS);
                return (T)result;
            }
            LOGGER.info(String.format(Locale.ENGLISH, "this Host :%s multiPath get error", itemInfo.getIp()));
            result.setItemResult(ItemResultEnum.NOTPASS);
            result.setFailDesc(ResourceUtil.getString((String)"multipath.aix.get.version.failed"));
            return (T)result;
        }
        int version = this.getVersion2Int(multiPathVersion);
        if (-1 != version) {
            if (version == 801029) {
                result.setFailDesc(ResourceUtil.getString((String)"multipath.aix.check.version.failed"));
                result.setItemResult(ItemResultEnum.NOTPASS);
            } else {
                result.setItemResult(ItemResultEnum.PASS);
            }
        } else {
            result.setFailDesc(ResourceUtil.getString((String)"multipath.aix.get.version.failed"));
            result.setItemResult(ItemResultEnum.NOTPASS);
        }
        return (T)result;
    }

    public int getVersion2Int(String multiPathVersion) {
        String ultraPath = multiPathVersion;
        if (multiPathVersion.contains(":")) {
            ultraPath = multiPathVersion.split(":")[1].trim();
        }
        String versionStr = ultraPath.replaceAll("\\.", "");
        int version = com.huawei.ism.tool.base.utils.StringUtils.str2Int((String)versionStr);
        return version;
    }
}

