/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.service;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.scene.utils.SceneDataExchange;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.entity.Launcher;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceInfo;
import com.huawei.ism.tool.obase.entity.InitiatorEnttiy;
import com.huawei.ism.tool.obase.entity.StorageInfo;
import com.huawei.ism.tool.obase.entity.UpgradeHostInfo;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.model.EvalItemResult;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.service.AbstractCompService;
import com.huawei.ism.tool.upgradeevalu.service.CommonResultConvert;
import com.huawei.ism.tool.upgradeevalu.task.EvaluationEngine;
import com.huawei.ism.util.CommonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;

public class AluaRiskCheck
extends AbstractCompService {
    private static final String NO_BUSINESS = "noBusiness";
    private static final String QUERY_ALUA_KEY = "aluaStatus";
    private static final String WWN_KEY = "queryWwnSuccess";
    private static final String ALUA_NOT_ENABLED = "not enabled";
    private static final String UNKNOWN = "unknown";
    private static final String NOT_VALID_CFG = "default";
    private static final String SELF_MULTI_PATH_INFO = "SelfMultiPath";
    private static final String HW_MULTIPATH_VERSION = "HuaweiMultipathVersion";
    private static final String HWMULTIPATH_NA = "NA";
    private static final String SELFMULTIPATH_DISABLED = "disabled";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(CommonResultConvert.class);
    private static final String MULTIPATH_TYPE_DEFAULT = "0";
    private DevNode curHostStorageDev = null;

    @Override
    public <T extends EvalFeatureResult> T evalate(Map<String, Object> evalContext) {
        EvalFeatureResult result = new EvalFeatureResult();
        Object evalItemResult = evalContext.get("evalItemResult");
        EvalItemResult evalItemResultInfo = (EvalItemResult)CommonUtil.convertObject((Object)evalItemResult, EvalItemResult.class);
        StorageInfo storageInfo = EvaluationEngine.getCurHostStorage(evalItemResultInfo);
        if (storageInfo == null) {
            result.setItemResult(ItemResultEnum.NOTPASS);
            result.setOriginalInfo("Query the storage information of the current host.");
            return (T)result;
        }
        AbstractCompService.EvalCommParams params = new AbstractCompService.EvalCommParams(evalContext);
        this.curHostStorageDev = EvaluationEngine.getCurHostStorageDev(evalContext);
        if (this.curHostStorageDev == null) {
            result.setItemResult(ItemResultEnum.NOTPASS);
            result.setOriginalInfo("getCurHostStorage is filed");
            return (T)result;
        }
        if (this.isCurStorageDevNoAluaFeatureRisk(result, storageInfo)) {
            return (T)result;
        }
        ItemInfo itemInfo = params.getItemInfo();
        String multiPath = itemInfo.getMultiSoftEdition();
        com.huawei.json.JSONObject multiPathInfo = this.parseToJsonObj(multiPath);
        String hwMultiPathVer = this.getJsonVal(multiPathInfo, HW_MULTIPATH_VERSION, HWMULTIPATH_NA);
        String buildInMultiPath = this.getJsonVal(multiPathInfo, SELF_MULTI_PATH_INFO, SELFMULTIPATH_DISABLED);
        Map<String, String> evalMap = params.getItemInfo().getInfoGrabMetaMsg();
        String aluaInfo = evalMap.get("aluaLauncher");
        Launcher launcher = this.setCliRet(result, aluaInfo);
        if (null == launcher) {
            LOGGER.error("the launcher is null.");
            return (T)result;
        }
        if (this.isSelfMultiPathInControl(hwMultiPathVer, buildInMultiPath)) {
            return (T)result;
        }
        String checkItemKey = params.getRuleItem().getItemTitle();
        LOGGER.info(String.format(Locale.ENGLISH, "the check item is :%s", checkItemKey));
        if (evalMap.containsKey(checkItemKey)) {
            result = this.evalALUARisk(checkItemKey, evalMap, launcher, result, storageInfo);
        } else {
            result.setItemResult(ItemResultEnum.NOTPASS);
            result.setFailDesc(ResourceUtil.getString((String)"eval.host.evaluation.item.alua.cfg.check.notin.secene"));
        }
        return (T)result;
    }

    private boolean isCurStorageDevNoAluaFeatureRisk(EvalFeatureResult result, StorageInfo storageInfo) {
        String pdtVer = this.curHostStorageDev.getProductVersion();
        String devType = this.curHostStorageDev.getDeviceType().toString();
        String originInfo = "Product Model:" + devType + System.lineSeparator() + "Product Version:" + pdtVer + System.lineSeparator();
        result.setOriginalInfo(originInfo);
        if (devType.toLowerCase(Locale.ENGLISH).contains("dorado")) {
            return true;
        }
        return pdtVer.contains("V100") || pdtVer.contains("V200");
    }

    public boolean isSelfMultiPathInControl(String hwMultiPathVer, String buildInMultiPath) {
        return !HWMULTIPATH_NA.equalsIgnoreCase(hwMultiPathVer) && SELFMULTIPATH_DISABLED.equalsIgnoreCase(buildInMultiPath);
    }

    private String getJsonVal(com.huawei.json.JSONObject multiPathInfo, String key, String defaultVal) {
        try {
            return multiPathInfo.getString(key);
        }
        catch (Exception e) {
            LOGGER.error("getJsonValue error:" + multiPathInfo);
            return defaultVal;
        }
    }

    private EvalFeatureResult evalALUARisk(String checkItemKey, Map<String, String> evalMap, Launcher launcher, EvalFeatureResult result, StorageInfo storageInfo) {
        try {
            if (null != this.checkGrabStatus(launcher, result)) {
                return result;
            }
            String devSn = this.curHostStorageDev.getDeviceSerialNumber();
            String upgradeSrc = SceneDataExchange.getInstance().loadKV(devSn + "_src");
            String upgradeDest = SceneDataExchange.getInstance().loadKV(devSn + "_dest");
            if (StringUtils.isNULLStr((String)upgradeSrc) || StringUtils.isNULLStr((String)upgradeDest)) {
                LOGGER.info(String.format(Locale.ENGLISH, "upgradeSrc or upgradeDest is null, sn:%s", devSn));
                throw new ToolException("must-input message miss.");
            }
            if (upgradeSrc.compareTo("V300R003C20") < 0) {
                if (upgradeDest.compareTo("V300R003C20") >= 0) {
                    return this.checkALUACfg(launcher, result, storageInfo);
                }
            } else if (upgradeSrc.indexOf("V300R005") > -1 || upgradeSrc.indexOf("V300R006C00") > -1) {
                if (upgradeDest.compareTo("V300R006C00SPC100") >= 0) {
                    return this.checkALUACfg(launcher, result, storageInfo);
                }
            } else {
                result.setItemResult(ItemResultEnum.PASS);
            }
        }
        catch (JSONException e) {
            result.setItemResult(ItemResultEnum.NOTPASS);
            String failMsg = ResourceUtil.getString((String)"eval.host.evaluation.item.alua.cfg.check.mustinput.miss");
            result.setFailDesc(failMsg);
        }
        catch (Exception e) {
            result.setItemResult(ItemResultEnum.NOTPASS);
            String failMsg = ResourceUtil.getString((String)"eval.host.evaluation.item.alua.cfg.check.mustinput.miss");
            result.setFailDesc(failMsg);
        }
        return result;
    }

    public Launcher setCliRet(EvalFeatureResult result, String aluaInfo) {
        Launcher launcher = null;
        try {
            launcher = JSONObject.parseObject(aluaInfo, Launcher.class);
            if (launcher == null) {
                return null;
            }
            LOGGER.info(String.format(Locale.ENGLISH, "launcher port:%s", launcher.getJsonString()));
            LOGGER.info(String.format(Locale.ENGLISH, "launcher getOtherDataMap:%s", launcher.getOtherDataMap()));
            String cliRets = launcher.getOtherDataMap().get("cliRets").toString();
            result.setOriginalInfo(cliRets);
        }
        catch (Exception e) {
            LOGGER.error("execute ALUA RISK error.", e);
        }
        return launcher;
    }

    private EvalFeatureResult checkALUACfg(Launcher launcher, EvalFeatureResult result, StorageInfo storageInfo) {
        List<String> fcWWNs = launcher.getFcWwns();
        List<String> iscsiWWNs = launcher.getiSCSIWwns();
        List<String> ibWWNs = launcher.getIBWwns();
        List<String> nVMEWWNs = launcher.getNVMEWwns();
        if (this.allCrrspndInitrsOnStrgAluaIsNotDefault(storageInfo, fcWWNs = this.convertAllStringListToUpperCase(fcWWNs), iscsiWWNs = this.convertAllStringListToUpperCase(iscsiWWNs), ibWWNs = this.convertAllStringListToUpperCase(ibWWNs), nVMEWWNs = this.convertAllStringListToUpperCase(nVMEWWNs))) {
            LOGGER.info("No initiators' multipath type  on remote storage device are default.");
            return result;
        }
        if (null != this.checkGrabAluaStatus(launcher, result)) {
            return result;
        }
        StringBuilder fcNotValidInitWwn = new StringBuilder();
        StringBuilder iscsiNotValidInitWwn = new StringBuilder();
        StringBuilder ibcsiNotValidInitWwn = new StringBuilder();
        StringBuilder bodyMsg = new StringBuilder();
        List hostInfos = storageInfo.getHostList();
        for (UpgradeHostInfo hostInfo : hostInfos) {
            List initrInfos = hostInfo.getInitList();
            for (Map initrInfo : initrInfos) {
                String wwn = (String)initrInfo.get("ID");
                if (StringUtils.isNULLStr((String)wwn)) continue;
                wwn = wwn.toUpperCase(Locale.ENGLISH);
                String multiPathPolicy = (String)initrInfo.get("MULTIPATHTYPE");
                if (null != multiPathPolicy && fcWWNs.indexOf(wwn) > -1 && multiPathPolicy.contains(MULTIPATH_TYPE_DEFAULT)) {
                    fcNotValidInitWwn.append(wwn).append(',');
                }
                if (null != multiPathPolicy && iscsiWWNs.indexOf(wwn) > -1 && multiPathPolicy.contains(MULTIPATH_TYPE_DEFAULT)) {
                    iscsiNotValidInitWwn.append(wwn).append(',');
                }
                if (null == multiPathPolicy || ibWWNs.indexOf(wwn) <= -1 || !multiPathPolicy.contains(MULTIPATH_TYPE_DEFAULT)) continue;
                ibcsiNotValidInitWwn.append(wwn).append(',');
            }
        }
        if (this.checkController(result, storageInfo, fcNotValidInitWwn, iscsiNotValidInitWwn, ibcsiNotValidInitWwn, bodyMsg)) {
            return result;
        }
        return result;
    }

    private boolean checkController(EvalFeatureResult result, StorageInfo storageInfo, StringBuilder fcNotValidInitWwn, StringBuilder iscsiNotValidInitWwn, StringBuilder ibcsiNotValidInitWwn, StringBuilder bodyMsg) {
        if (fcNotValidInitWwn.length() != 0 || iscsiNotValidInitWwn.length() != 0 || ibcsiNotValidInitWwn.length() != 0) {
            StringBuilder resultStr = new StringBuilder();
            String devIp = storageInfo.getStorageIp();
            StringBuilder wwnNotValid = new StringBuilder();
            wwnNotValid.append(this.makeErrorMsg(fcNotValidInitWwn, "FC"));
            wwnNotValid.append(this.makeErrorMsg(iscsiNotValidInitWwn, "iSCSI"));
            wwnNotValid.append(this.makeErrorMsg(ibcsiNotValidInitWwn, "IB"));
            resultStr.append(ResourceUtil.getStringWithParams((String)"eval.host.evaluation.item.alua.cfg.check.controller.body", (Object[])new Object[]{storageInfo.getStorageSn(), devIp, this.getCtrollerNumber(storageInfo.getStorageSn()), wwnNotValid.toString()}));
            bodyMsg.append((CharSequence)resultStr).append(',');
            String headMsg = ResourceUtil.getString((String)"eval.host.evaluation.item.alua.cfg.check.controller.head");
            String tailMsg = ResourceUtil.getString((String)"eval.host.evaluation.item.alua.cfg.check.controller.tail");
            String body = bodyMsg.toString();
            String failMsg = headMsg + body.substring(0, body.length() - 1) + tailMsg;
            result.setFailDesc(failMsg);
            result.setItemResult(ItemResultEnum.NOTPASS);
            return true;
        }
        return false;
    }

    private List<String> convertAllStringListToUpperCase(List<String> wwns) {
        ArrayList<String> wwnsUpper = new ArrayList<String>();
        for (String wwn : wwns) {
            wwnsUpper.add(wwn.toUpperCase(Locale.ENGLISH));
        }
        return wwnsUpper;
    }

    private boolean allCrrspndInitrsOnStrgAluaIsNotDefault(StorageInfo storageInfo, List<String> fcWWNs, List<String> iscsiWWNs, List<String> ibWWNs, List<String> NVMeWWNs) {
        List hostInfos = storageInfo.getHostList();
        for (UpgradeHostInfo hostInfo : hostInfos) {
            List initrInfos = hostInfo.getInitList();
            for (Map initrInfo : initrInfos) {
                String wwn = ((String)initrInfo.get("ID")).toUpperCase(Locale.ENGLISH);
                String multiPathPolicy = (String)initrInfo.get("MULTIPATHTYPE");
                if (null == wwn || null == multiPathPolicy || fcWWNs.indexOf(wwn) <= -1 && iscsiWWNs.indexOf(wwn) <= -1 && ibWWNs.indexOf(wwn) <= -1 && NVMeWWNs.indexOf(wwn) <= -1 || !multiPathPolicy.contains(MULTIPATH_TYPE_DEFAULT)) continue;
                return false;
            }
        }
        LOGGER.info("storage multipathtype is ok\u3002\u3002\u3002");
        return true;
    }

    public EvalFeatureResult checkGrabAluaStatus(Launcher launcher, EvalFeatureResult result) {
        Object queryAluaSuccess = launcher.getOtherDataMap().get(QUERY_ALUA_KEY);
        if (queryAluaSuccess == null || UNKNOWN.equalsIgnoreCase(queryAluaSuccess.toString())) {
            result.setItemResult(ItemResultEnum.NOTPASS);
            result.setFailDesc(ResourceUtil.getString((String)"eval.host.evaluation.item.alua.cfg.check.controller.alua.qry.fail"));
            return result;
        }
        if (NO_BUSINESS.equalsIgnoreCase(queryAluaSuccess.toString())) {
            result.setItemResult(ItemResultEnum.NOTPASS);
            result.setFailDesc(ResourceUtil.getString((String)"eval.host.evaluation.item.alua.cfg.check.controller.alua.qry.fail"));
            return result;
        }
        return null;
    }

    public EvalFeatureResult checkGrabStatus(Launcher launcher, EvalFeatureResult result) {
        Object queryAluaSuccess = launcher.getOtherDataMap().get(QUERY_ALUA_KEY);
        if (ALUA_NOT_ENABLED.equalsIgnoreCase(queryAluaSuccess.toString())) {
            return result;
        }
        Object queryWwnSuccess = launcher.getOtherDataMap().get(WWN_KEY);
        if (queryWwnSuccess == null || UNKNOWN.equalsIgnoreCase(queryWwnSuccess.toString())) {
            result.setItemResult(ItemResultEnum.NOTPASS);
            result.setFailDesc(ResourceUtil.getString((String)"eval.host.evaluation.item.alua.cfg.check.controller.wwn.qry.fail"));
            return result;
        }
        String storageInfoStatus = SceneDataExchange.getInstance().loadKV("storageInfoStatus");
        if (storageInfoStatus != null && UNKNOWN.equalsIgnoreCase(queryWwnSuccess.toString())) {
            result.setItemResult(ItemResultEnum.NOTPASS);
            result.setFailDesc(ResourceUtil.getString((String)"eval.host.evaluation.item.alua.cfg.check.controller.storage.qry.fail"));
            return result;
        }
        return null;
    }

    private String getCtrollerNumber(String deviceSn) {
        String ctrollerInfo = SceneDataExchange.getInstance().loadKV(deviceSn + "_controllerInfo");
        if (StringUtils.isNULLStr((String)ctrollerInfo)) {
            return UNKNOWN;
        }
        return String.valueOf(ctrollerInfo.split("Controller\\s+:").length - 1);
    }

    public String makeErrorMsg(StringBuilder notValidInitWwn, String initType) {
        StringBuilder resultStr = new StringBuilder();
        if (notValidInitWwn.length() != 0) {
            String notValidWwn = notValidInitWwn.toString();
            resultStr.append(initType).append(':').append(notValidWwn.substring(0, notValidWwn.length() - 1));
            resultStr.append(';');
        }
        return resultStr.toString();
    }

    public void appendNotValidWwn(List<String> fcWWNs, DeviceInfo devInfo, StringBuilder fcNotValidInitWwn) {
        for (String wwn : fcWWNs) {
            InitiatorEnttiy init = (InitiatorEnttiy)devInfo.getWwnInitMap().get(wwn);
            init = init == null ? (InitiatorEnttiy)devInfo.getWwnInitMap().get(wwn.toLowerCase(Locale.ENGLISH)) : init;
            if ((init = init == null ? (InitiatorEnttiy)devInfo.getWwnInitMap().get(wwn.toUpperCase(Locale.ENGLISH)) : init) == null || !NOT_VALID_CFG.equalsIgnoreCase(init.getMultiPathType()) || "--".equalsIgnoreCase(init.getHostId())) continue;
            fcNotValidInitWwn.append(wwn).append(',');
        }
    }
}

